/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtil {
    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not be null");
        }
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(element);
            ExceptionUtil.addExceptions(array, exceptions);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiClassType> getThrownExceptions(@NotNull PsiElement element) {
        List<PsiClassType> list;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not be null");
        }
        if (element instanceof PsiClass) {
            PsiExpressionList argumentList;
            if (!(element instanceof PsiAnonymousClass && (argumentList = ((PsiAnonymousClass)element).getArgumentList()) != null ? (list = ExceptionUtil.getThrownExceptions(argumentList)) != null : (list = Collections.emptyList()) != null)) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodRef = ((PsiMethodCallExpression)element).getMethodExpression();
            JavaResolveResult result = methodRef.advancedResolve(false);
            list = ExceptionUtil.getExceptionsByMethodAndChildren(element, result);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiNewExpression) {
            JavaResolveResult result = ((PsiNewExpression)element).resolveMethodGenerics();
            list = ExceptionUtil.getExceptionsByMethodAndChildren(element, result);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiThrowStatement) {
            PsiExpression expr = ((PsiThrowStatement)element).getException();
            if (expr == null) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
                return list;
            } else {
                List<PsiType> types = ExceptionUtil.getPreciseThrowTypes(expr);
                List<PsiClassType> classTypes = ContainerUtil.mapNotNull(types, new NullableFunction<PsiType, PsiClassType>(){

                    @Override
                    public PsiClassType fun(PsiType type) {
                        return type instanceof PsiClassType ? (PsiClassType)type : null;
                    }
                });
                ExceptionUtil.addExceptions(classTypes, ExceptionUtil.getThrownExceptions(expr));
                list = classTypes;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
                return list;
            }
        }
        if (element instanceof PsiTryStatement) {
            list = ExceptionUtil.getTryExceptions((PsiTryStatement)element);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        if (element instanceof PsiResourceVariable) {
            PsiResourceVariable variable = (PsiResourceVariable)element;
            ArrayList<PsiClassType> types = ContainerUtil.newArrayList();
            ExceptionUtil.addExceptions(types, ExceptionUtil.getCloserExceptions(variable));
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                ExceptionUtil.addExceptions(types, ExceptionUtil.getThrownExceptions(initializer));
            }
            if ((list = types) == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
            return list;
        }
        list = ExceptionUtil.getThrownExceptions(element.getChildren());
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getThrownExceptions must not return null");
    }

    private static List<PsiClassType> getTryExceptions(PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            for (PsiResourceVariable variable : resourceList.getResourceVariables()) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(variable, resourceList));
            }
        }
        if ((tryBlock = tryStatement.getTryBlock()) != null) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(tryBlock));
        }
        for (PsiParameter psiParameter : tryStatement.getCatchBlockParameters()) {
            PsiType exception = psiParameter.getType();
            for (int j = array.size() - 1; j >= 0; --j) {
                PsiClassType exception1 = (PsiClassType)array.get(j);
                if (!exception.isAssignableFrom(exception1)) continue;
                array.remove(exception1);
            }
        }
        for (PsiElement psiElement : tryStatement.getCatchBlocks()) {
            ExceptionUtil.addExceptions(array, ExceptionUtil.getThrownExceptions(psiElement));
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            try {
                ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
                List<PsiClassType> list = ExceptionUtil.getThrownExceptions(finallyBlock);
                if ((completionReasons & 1) == 0) {
                    array = ContainerUtil.newArrayList(list);
                } else {
                    ExceptionUtil.addExceptions(array, list);
                }
            }
            catch (AnalysisCanceledException analysisCanceledException) {
                // empty catch block
            }
        }
        return array;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethodAndChildren(PsiElement element, JavaResolveResult resolveResult) {
        ArrayList<PsiClassType> result = ContainerUtil.newArrayList();
        PsiMethod method = (PsiMethod)resolveResult.getElement();
        if (method != null) {
            ExceptionUtil.addExceptions(result, ExceptionUtil.getExceptionsByMethod(method, resolveResult.getSubstitutor()));
        }
        ExceptionUtil.addExceptions(result, ExceptionUtil.getThrownExceptions(element.getChildren()));
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getExceptionsByMethodAndChildren must not return null");
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiClassType> getExceptionsByMethod(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        PsiClassType[] referenceTypes;
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getExceptionsByMethod must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.getExceptionsByMethod must not be null");
        }
        ArrayList<PsiClassType> result = ContainerUtil.newArrayList();
        for (PsiType type : referenceTypes = method.getThrowsList().getReferencedTypes()) {
            if (!((type = substitutor.substitute(type)) instanceof PsiClassType)) continue;
            result.add((PsiClassType)type);
        }
        ArrayList<PsiClassType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getExceptionsByMethod must not return null");
        }
        return arrayList;
    }

    private static void addExceptions(List<PsiClassType> array, Collection<PsiClassType> exceptions) {
        for (PsiClassType exception : exceptions) {
            ExceptionUtil.addException(array, exception);
        }
    }

    private static void addException(List<PsiClassType> array, PsiClassType exception) {
        if (exception == null) {
            return;
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            PsiClassType exception1 = array.get(i);
            if (exception1.isAssignableFrom(exception)) {
                return;
            }
            if (!exception.isAssignableFrom(exception1)) continue;
            array.remove(i);
        }
        array.add(exception);
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not be null");
        }
        Collection<PsiClassType> collection = ExceptionUtil.collectUnhandledExceptions(element, topElement, true);
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not return null");
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not be null");
        }
        Set<PsiClassType> set = ExceptionUtil.collectUnhandledExceptions(element, topElement, null, includeSelfCalls);
        Collection<Object> collection = set == null ? Collections.emptyList() : set;
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not return null");
        }
        return collection;
    }

    @Nullable
    private static Set<PsiClassType> collectUnhandledExceptions(@NotNull PsiElement element, @Nullable PsiElement topElement, @Nullable Set<PsiClassType> foundExceptions, boolean includeSelfCalls) {
        List<PsiClassType> unhandled;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.collectUnhandledExceptions must not be null");
        }
        Collection<PsiClassType> unhandledExceptions = null;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression, topElement, includeSelfCalls);
        } else if (element instanceof PsiMethodReferenceExpression) {
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions((PsiMethodReferenceExpression)element, topElement);
        } else if (element instanceof PsiThrowStatement) {
            PsiThrowStatement statement = (PsiThrowStatement)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
        } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && !ExceptionUtil.firstStatementIsConstructorCall((PsiCodeBlock)element)) {
            PsiMethod constructor = (PsiMethod)element.getParent();
            PsiClass aClass = constructor.getContainingClass();
            PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
            PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
            HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
            for (PsiMethod superConstructor : superConstructors) {
                PsiClassType[] exceptionTypes;
                if (superConstructor.hasModifierProperty("private") || superConstructor.getParameterList().getParametersCount() != 0) continue;
                for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                    if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.isHandled(element, exceptionType, topElement)) continue;
                    unhandled2.add(exceptionType);
                }
                break;
            }
            if (aClass != null) {
                PsiClassInitializer[] initializers = aClass.getInitializers();
                THashSet<PsiClassType> thrownByInitializer = new THashSet<PsiClassType>();
                for (PsiClassInitializer initializer : initializers) {
                    if (initializer.hasModifierProperty("static")) continue;
                    thrownByInitializer.clear();
                    ExceptionUtil.collectUnhandledExceptions(initializer.getBody(), initializer, thrownByInitializer, includeSelfCalls);
                    for (PsiClassType thrown : thrownByInitializer) {
                        if (ExceptionUtil.isHandled(constructor.getBody(), thrown, topElement)) continue;
                        unhandled2.add(thrown);
                    }
                }
            }
            unhandledExceptions = unhandled2;
        }
        if (element instanceof PsiResourceVariable && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceVariable)element, topElement)).isEmpty()) {
            if (unhandledExceptions == null) {
                unhandledExceptions = ContainerUtil.newArrayList(unhandled);
            } else {
                unhandledExceptions.addAll(unhandled);
            }
        }
        if (unhandledExceptions != null) {
            if (foundExceptions == null) {
                foundExceptions = new THashSet<PsiClassType>();
            }
            foundExceptions.addAll(unhandledExceptions);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            foundExceptions = ExceptionUtil.collectUnhandledExceptions(child, topElement, foundExceptions, includeSelfCalls);
        }
        return foundExceptions;
    }

    private static Collection<PsiClassType> getUnhandledExceptions(PsiMethodReferenceExpression methodReferenceExpression, PsiElement topElement) {
        JavaResolveResult resolveResult = methodReferenceExpression.advancedResolve(false);
        PsiElement resolve = resolveResult.getElement();
        if (resolve instanceof PsiMethod) {
            return ExceptionUtil.getUnhandledExceptions((PsiMethod)resolve, methodReferenceExpression, topElement, resolveResult.getSubstitutor());
        }
        return Collections.emptyList();
    }

    private static boolean firstStatementIsConstructorCall(PsiCodeBlock constructorBody) {
        PsiStatement[] statements = constructorBody.getStatements();
        if (statements.length == 0) {
            return false;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return false;
        }
        PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethod method = (PsiMethod)((PsiMethodCallExpression)expression).getMethodExpression().resolve();
        return method != null && method.isConstructor();
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiElement[] elements) {
        final ArrayList<PsiClassType> array = ContainerUtil.newArrayList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitCallExpression(PsiCallExpression expression) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                this.visitElement(expression);
            }

            @Override
            public void visitThrowStatement(PsiThrowStatement statement) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(statement, null));
                this.visitElement(statement);
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledExceptions(expression, null));
                this.visitElement(expression);
            }

            @Override
            public void visitResourceVariable(PsiResourceVariable resourceVariable) {
                ExceptionUtil.addExceptions(array, ExceptionUtil.getUnhandledCloserExceptions(resourceVariable, null));
                this.visitElement(resourceVariable);
            }
        };
        for (PsiElement element : elements) {
            element.accept(visitor);
        }
        ArrayList<PsiClassType> arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiElement element) {
        List<PsiClassType> list;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression = (PsiCallExpression)element;
            list = ExceptionUtil.getUnhandledExceptions(expression, null);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        }
        if (element instanceof PsiThrowStatement) {
            PsiThrowStatement throwStatement = (PsiThrowStatement)element;
            list = ExceptionUtil.getUnhandledExceptions(throwStatement, null);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        }
        if (element instanceof PsiResourceVariable) {
            list = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceVariable)element, null);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        }
        list = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{element});
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiCallExpression methodCall, @Nullable PsiElement topElement) {
        List<PsiClassType> list = ExceptionUtil.getUnhandledExceptions(methodCall, topElement, true);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiCallExpression methodCall, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        List<PsiClassType> list;
        final JavaResolveResult result = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        if (!includeSelfCalls && method == PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        }
        PsiSubstitutor substitutor = ApplicationManager.getApplication().runReadAction(new Computable<PsiSubstitutor>(){

            @Override
            public PsiSubstitutor compute() {
                return result.getSubstitutor();
            }
        });
        list = ExceptionUtil.getUnhandledExceptions(method, methodCall, topElement, substitutor);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
    }

    @NotNull
    public static List<PsiClassType> getCloserExceptions(PsiResourceVariable resource) {
        PsiMethod method = PsiUtil.getResourceCloserMethod(resource);
        List<PsiClassType> list = method != null ? ExceptionUtil.getExceptionsByMethod(method, PsiSubstitutor.EMPTY) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getCloserExceptions must not return null");
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledCloserExceptions(PsiResourceVariable resource, @Nullable PsiElement topElement) {
        PsiMethod method = PsiUtil.getResourceCloserMethod(resource);
        List<PsiClassType> list = method != null ? ExceptionUtil.getUnhandledExceptions(method, resource, topElement, PsiSubstitutor.EMPTY) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledCloserExceptions must not return null");
        }
        return list;
    }

    @NotNull
    public static List<PsiClassType> getUnhandledExceptions(PsiThrowStatement throwStatement, @Nullable PsiElement topElement) {
        SmartList<PsiClassType> unhandled = new SmartList<PsiClassType>();
        for (PsiType type : ExceptionUtil.getPreciseThrowTypes(throwStatement.getException())) {
            List<PsiType> types = type instanceof PsiDisjunctionType ? ((PsiDisjunctionType)type).getDisjunctions() : Collections.singletonList(type);
            for (PsiType subType : types) {
                PsiClassType classType;
                if (!(subType instanceof PsiClassType) || ExceptionUtil.isUncheckedException(classType = (PsiClassType)subType) || ExceptionUtil.isHandled(throwStatement, classType, topElement)) continue;
                unhandled.add(classType);
            }
        }
        SmartList<PsiClassType> smartList = unhandled;
        if (smartList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
        }
        return smartList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<PsiType> getPreciseThrowTypes(@Nullable PsiExpression expression) {
        PsiType type;
        List<PsiType> list;
        PsiElement target;
        if (expression instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)expression).resolve()) != null && PsiUtil.isCatchParameter(target)) {
            list = ((PsiCatchSection)target.getParent()).getPreciseCatchTypes();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getPreciseThrowTypes must not return null");
            return list;
        }
        if (expression != null && (type = expression.getType()) != null) {
            list = Arrays.asList(type);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getPreciseThrowTypes must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getPreciseThrowTypes must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<PsiClassType> getUnhandledExceptions(PsiMethod method, PsiElement element, PsiElement topElement, PsiSubstitutor substitutor) {
        List<PsiClassType> list;
        if (method == null || ExceptionUtil.isArrayClone(method, element)) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
            return list;
        } else {
            PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
            if (referencedTypes.length <= 0) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
                return list;
            } else {
                ArrayList result = ContainerUtil.newArrayList();
                for (PsiClassType referencedType : referencedTypes) {
                    PsiType type = substitutor.substitute(referencedType);
                    if (!(type instanceof PsiClassType)) continue;
                    PsiClassType classType = (PsiClassType)type;
                    PsiClass exceptionClass = ((PsiClassType)type).resolve();
                    if (exceptionClass == null || ExceptionUtil.isUncheckedException(classType) || ExceptionUtil.isHandled(element, classType, topElement)) continue;
                    result.add((PsiClassType)type);
                }
                list = result;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/ExceptionUtil.getUnhandledExceptions must not return null");
                return list;
            }
        }
    }

    private static boolean isArrayClone(PsiMethod method, PsiElement element) {
        if (!method.getName().equals("clone")) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodCallExpression = (PsiMethodReferenceExpression)element;
            PsiExpression qualifierExpression = methodCallExpression.getQualifierExpression();
            return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
        }
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
        return qualifierExpression != null && qualifierExpression.getType() instanceof PsiArrayType;
    }

    public static boolean isUncheckedException(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.isUncheckedException must not be null");
        }
        return InheritanceUtil.isInheritor(type, "java.lang.RuntimeException") || InheritanceUtil.isInheritor(type, "java.lang.Error");
    }

    public static boolean isUncheckedExceptionOrSuperclass(@NotNull PsiClassType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.isUncheckedExceptionOrSuperclass must not be null");
        }
        return ExceptionUtil.isGeneralExceptionType(type) || ExceptionUtil.isUncheckedException(type);
    }

    public static boolean isGeneralExceptionType(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.isGeneralExceptionType must not be null");
        }
        String canonicalText = type.getCanonicalText();
        return "java.lang.Throwable".equals(canonicalText) || "java.lang.Exception".equals(canonicalText);
    }

    private static boolean isHandled(PsiElement element, PsiClassType exceptionType, PsiElement topElement) {
        if (element == null || element.getParent() == topElement || element.getParent() == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            return ExceptionUtil.isHandledByMethodThrowsClause(method, exceptionType);
        }
        if (parent instanceof PsiClass) {
            return parent instanceof PsiAnonymousClass && ExceptionUtil.isHandled(parent, exceptionType, topElement);
        }
        if (parent instanceof PsiLambdaExpression) {
            PsiType interfaceType = ((PsiLambdaExpression)parent).getFunctionalInterfaceType();
            return ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType);
        }
        if (element instanceof PsiMethodReferenceExpression) {
            PsiType interfaceType = ((PsiMethodReferenceExpression)element).getFunctionalInterfaceType();
            return ExceptionUtil.isDeclaredBySAMMethod(exceptionType, interfaceType);
        }
        if (parent instanceof PsiClassInitializer) {
            if (((PsiClassInitializer)parent).hasModifierProperty("static")) {
                return false;
            }
            if (!(parent.getParent() instanceof PsiAnonymousClass)) {
                PsiClass aClass = ((PsiClassInitializer)parent).getContainingClass();
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        } else if (parent instanceof PsiTryStatement) {
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            if (tryStatement.getTryBlock() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            if (tryStatement.getResourceList() == element && ExceptionUtil.isCaught(tryStatement, exceptionType)) {
                return true;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (element instanceof PsiCatchSection && finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
                return true;
            }
        } else {
            PsiClass aClass;
            if (parent instanceof JavaCodeFragment) {
                JavaCodeFragment codeFragment = (JavaCodeFragment)parent;
                JavaCodeFragment.ExceptionHandler exceptionHandler = codeFragment.getExceptionHandler();
                return exceptionHandler != null && exceptionHandler.isHandledException(exceptionType);
            }
            if (PsiImplUtil.isInServerPage(parent) && parent instanceof PsiFile) {
                return true;
            }
            if (parent instanceof PsiFile) {
                return false;
            }
            if (parent instanceof PsiField && ((PsiField)parent).getInitializer() == element && (aClass = ((PsiField)parent).getContainingClass()) != null && !(aClass instanceof PsiAnonymousClass) && !((PsiField)parent).hasModifierProperty("static")) {
                return ExceptionUtil.areAllConstructorsThrow(aClass, exceptionType);
            }
        }
        return ExceptionUtil.isHandled(parent, exceptionType, topElement);
    }

    private static boolean isDeclaredBySAMMethod(PsiClassType exceptionType, PsiType interfaceType) {
        PsiMethod interfaceMethod;
        if (interfaceType != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(interfaceType)) != null) {
            return ExceptionUtil.isHandledByMethodThrowsClause(interfaceMethod, exceptionType);
        }
        return true;
    }

    private static boolean areAllConstructorsThrow(PsiClass aClass, PsiClassType exceptionType) {
        if (aClass == null) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        boolean thrown = constructors.length != 0;
        for (PsiMethod constructor : constructors) {
            if (ExceptionUtil.isHandledByMethodThrowsClause(constructor, exceptionType)) continue;
            thrown = false;
            break;
        }
        return thrown;
    }

    private static boolean isCaught(PsiTryStatement tryStatement, PsiClassType exceptionType) {
        PsiParameter[] catchBlockParameters;
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null && ExceptionUtil.blockCompletesAbruptly(finallyBlock)) {
            return true;
        }
        for (PsiParameter parameter : catchBlockParameters = tryStatement.getCatchBlockParameters()) {
            PsiType paramType = parameter.getType();
            if (!paramType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static boolean blockCompletesAbruptly(PsiCodeBlock finallyBlock) {
        try {
            ControlFlow flow = ControlFlowFactory.getInstance(finallyBlock.getProject()).getControlFlow(finallyBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
            int completionReasons = ControlFlowUtil.getCompletionReasons(flow, 0, flow.getSize());
            if ((completionReasons & 1) == 0) {
                return true;
            }
        }
        catch (AnalysisCanceledException e) {
            return true;
        }
        return false;
    }

    private static boolean isHandledByMethodThrowsClause(PsiMethod method, PsiClassType exceptionType) {
        PsiClassType[] referencedTypes = method.getThrowsList().getReferencedTypes();
        return ExceptionUtil.isHandledBy(exceptionType, referencedTypes);
    }

    public static boolean isHandledBy(PsiClassType exceptionType, @NotNull PsiClassType[] referencedTypes) {
        if (referencedTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/ExceptionUtil.isHandledBy must not be null");
        }
        for (PsiClassType classType : referencedTypes) {
            if (!classType.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }
}

