/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js.ast;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsNodeImpl;
import com.google.dart.compiler.backend.js.ast.JsNumberLiteral;
import com.google.dart.compiler.backend.js.ast.JsProgramFragment;
import com.google.dart.compiler.backend.js.ast.JsRootScope;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import gnu.trove.TDoubleObjectHashMap;
import gnu.trove.THashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class JsProgram
extends JsNodeImpl {
    private final JsEmpty emptyStmt;
    private JsProgramFragment[] fragments;
    private final TDoubleObjectHashMap<JsNumberLiteral.JsDoubleLiteral> doubleLiteralMap = new TDoubleObjectHashMap();
    private final TIntObjectHashMap<JsNumberLiteral.JsIntLiteral> intLiteralMap = new TIntObjectHashMap();
    private final JsRootScope rootScope;
    private final Map<String, JsStringLiteral> stringLiteralMap = new THashMap<String, JsStringLiteral>();
    private final JsScope topScope;

    public JsProgram(String unitId) {
        this.rootScope = new JsRootScope(this);
        this.topScope = new JsScope(this.rootScope, "Global", unitId);
        this.setFragmentCount(1);
        this.emptyStmt = new JsEmpty();
    }

    public JsEmpty getEmptyStmt() {
        return this.emptyStmt;
    }

    public JsBlock getFragmentBlock(int fragment) {
        if (fragment < 0 || fragment >= this.fragments.length) {
            throw new IllegalArgumentException("Invalid fragment: " + fragment);
        }
        return this.fragments[fragment].getGlobalBlock();
    }

    public JsBlock getGlobalBlock() {
        return this.getFragmentBlock(0);
    }

    public JsNumberLiteral getNumberLiteral(double value) {
        JsNumberLiteral.JsDoubleLiteral literal = this.doubleLiteralMap.get(value);
        if (literal == null) {
            literal = new JsNumberLiteral.JsDoubleLiteral(value);
            this.doubleLiteralMap.put(value, literal);
        }
        return literal;
    }

    public JsNumberLiteral getNumberLiteral(int value) {
        JsNumberLiteral.JsIntLiteral literal = this.intLiteralMap.get(value);
        if (literal == null) {
            literal = new JsNumberLiteral.JsIntLiteral(value);
            this.intLiteralMap.put(value, literal);
        }
        return literal;
    }

    public JsRootScope getRootScope() {
        return this.rootScope;
    }

    public JsScope getScope() {
        return this.topScope;
    }

    public JsStringLiteral getStringLiteral(String value) {
        JsStringLiteral literal = this.stringLiteralMap.get(value);
        if (literal == null) {
            literal = new JsStringLiteral(value);
            this.stringLiteralMap.put(value, literal);
        }
        return literal;
    }

    public void setFragmentCount(int fragments) {
        this.fragments = new JsProgramFragment[fragments];
        for (int i = 0; i < fragments; ++i) {
            this.fragments[i] = new JsProgramFragment();
        }
    }

    @Override
    public void traverse(JsVisitor v, @Nullable JsContext ctx) {
        if (v.visit(this, ctx)) {
            for (JsProgramFragment fragment : this.fragments) {
                v.accept(fragment);
            }
        }
        v.endVisit(this, ctx);
    }
}

