/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.backend.js;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsBreak;
import com.google.dart.compiler.backend.js.ast.JsContext;
import com.google.dart.compiler.backend.js.ast.JsDoWhile;
import com.google.dart.compiler.backend.js.ast.JsEmpty;
import com.google.dart.compiler.backend.js.ast.JsExprStmt;
import com.google.dart.compiler.backend.js.ast.JsFor;
import com.google.dart.compiler.backend.js.ast.JsIf;
import com.google.dart.compiler.backend.js.ast.JsReturn;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.google.dart.compiler.backend.js.ast.JsThrow;
import com.google.dart.compiler.backend.js.ast.JsTry;
import com.google.dart.compiler.backend.js.ast.JsVars;
import com.google.dart.compiler.backend.js.ast.JsVisitor;
import com.google.dart.compiler.backend.js.ast.JsWhile;

public class JsRequiresSemiVisitor
extends JsVisitor {
    private boolean needsSemicolon = false;

    public static boolean exec(JsStatement lastStatement) {
        JsRequiresSemiVisitor visitor = new JsRequiresSemiVisitor();
        visitor.accept(lastStatement);
        return visitor.needsSemicolon;
    }

    private JsRequiresSemiVisitor() {
    }

    @Override
    public boolean visit(JsBlock x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsBreak x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsDoWhile x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsEmpty x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsExprStmt x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsFor x, JsContext ctx) {
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
        return false;
    }

    @Override
    public boolean visit(JsIf x, JsContext ctx) {
        JsStatement thenStmt = x.getThenStatement();
        JsStatement elseStmt = x.getElseStatement();
        JsStatement toCheck = thenStmt;
        if (elseStmt != null) {
            toCheck = elseStmt;
        }
        if (toCheck instanceof JsEmpty) {
            this.needsSemicolon = true;
        } else {
            this.accept(toCheck);
        }
        return false;
    }

    @Override
    public boolean visit(JsReturn x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsThrow x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsTry x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsVars x, JsContext ctx) {
        return false;
    }

    @Override
    public boolean visit(JsWhile x, JsContext ctx) {
        if (x.getBody() instanceof JsEmpty) {
            this.needsSemicolon = true;
        }
        return false;
    }
}

