/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/utils/MessageCollectorForCompilerTests;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "errStream", "Ljava/io/PrintStream;", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "<init>", "(Ljava/io/PrintStream;Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;)V", "printingCollector", "Lorg/jetbrains/kotlin/cli/common/messages/PrintingMessageCollector;", "hasErrors", "", "_nonSourceMessages", "", "", "nonSourceMessages", "", "getNonSourceMessages", "()Ljava/util/List;", "report", "", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "message", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "clear", "tests-common-new_test"})
public final class MessageCollectorForCompilerTests
implements MessageCollector {
    @NotNull
    private final MessageRenderer messageRenderer;
    @NotNull
    private final PrintingMessageCollector printingCollector;
    private boolean hasErrors;
    @NotNull
    private final List<String> _nonSourceMessages;

    public MessageCollectorForCompilerTests(@NotNull PrintStream errStream, @NotNull MessageRenderer messageRenderer) {
        Intrinsics.checkNotNullParameter((Object)errStream, (String)"errStream");
        Intrinsics.checkNotNullParameter((Object)messageRenderer, (String)"messageRenderer");
        this.messageRenderer = messageRenderer;
        this.printingCollector = new PrintingMessageCollector(errStream, this.messageRenderer, false);
        this._nonSourceMessages = new ArrayList();
    }

    @NotNull
    public final List<String> getNonSourceMessages() {
        return this._nonSourceMessages;
    }

    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = this.hasErrors = this.hasErrors || severity.isError();
        if (location == null && severity.compareTo((Enum)CompilerMessageSeverity.WARNING) <= 0) {
            String string = this.messageRenderer.render(severity, message, location);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
            this._nonSourceMessages.add(string);
        }
        this.printingCollector.report(severity, message, location);
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void clear() {
        this._nonSourceMessages.clear();
        this.printingCollector.clear();
    }
}

