/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryForDeprecation;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactoryToRendererMap;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters1Renderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters2Renderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters3Renderer;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticWithParameters4Renderer;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.junit.Assert;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"verifyMessages", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactoryToRendererMap;", "objectWithErrors", "", "messageParameterRegex", "Lkotlin/text/Regex;", "lastCharRegex", "lastCharExclusions", "", "", "verifyMessageForFactory", "factory", "Lorg/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "property", "Lkotlin/reflect/KProperty;", "tests-common-new_test"})
public final class FirErrorsDefaultMessagesHelperKt {
    @NotNull
    private static final Regex messageParameterRegex = new Regex("\\{\\d.*?}");
    @NotNull
    private static final Regex lastCharRegex = new Regex("[.}\\d]");
    @NotNull
    private static final List<String> lastCharExclusions;

    public static final void verifyMessages(@NotNull KtDiagnosticFactoryToRendererMap $this$verifyMessages, @NotNull Object objectWithErrors) {
        Intrinsics.checkNotNullParameter((Object)$this$verifyMessages, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)objectWithErrors, (String)"objectWithErrors");
        List errors = new ArrayList();
        for (KProperty1 property : KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(objectWithErrors.getClass()))) {
            Object[] objectArray = new Object[]{objectWithErrors};
            Object factory = property.getGetter().call(objectArray);
            if (factory instanceof AbstractKtDiagnosticFactory) {
                CollectionsKt.addAll((Collection)errors, (Iterable)FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory($this$verifyMessages, (AbstractKtDiagnosticFactory)factory, (KProperty)property));
                continue;
            }
            if (!(factory instanceof KtDiagnosticFactoryForDeprecation)) continue;
            CollectionsKt.addAll((Collection)errors, (Iterable)FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory($this$verifyMessages, ((KtDiagnosticFactoryForDeprecation)factory).getWarningFactory(), (KProperty)property));
            CollectionsKt.addAll((Collection)errors, (Iterable)FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory($this$verifyMessages, ((KtDiagnosticFactoryForDeprecation)factory).getErrorFactory(), (KProperty)property));
        }
        if (!((Collection)errors).isEmpty()) {
            Assert.fail((String)CollectionsKt.joinToString$default((Iterable)errors, (CharSequence)"\n\n", null, (CharSequence)"\n\nSee https://youtrack.jetbrains.com/articles/KT-A-610 for the style guide.\n\n", (int)0, null, null, (int)58, null));
        }
    }

    @NotNull
    public static final List<String> verifyMessageForFactory(@NotNull KtDiagnosticFactoryToRendererMap $this$verifyMessageForFactory, @NotNull AbstractKtDiagnosticFactory factory, @NotNull KProperty<?> property) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$verifyMessageForFactory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter(property, (String)"property");
        List $this$verifyMessageForFactory_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (!$this$verifyMessageForFactory.containsKey(factory)) {
            $this$verifyMessageForFactory_u24lambda_u241.add("No default diagnostic renderer is provided for " + property.getName());
        } else {
            KtDiagnosticRenderer renderer;
            KtDiagnosticRenderer ktDiagnosticRenderer = $this$verifyMessageForFactory.get(factory);
            Intrinsics.checkNotNull((Object)ktDiagnosticRenderer);
            KtDiagnosticRenderer ktDiagnosticRenderer2 = renderer = ktDiagnosticRenderer;
            int parameterCount = ktDiagnosticRenderer2 instanceof KtDiagnosticWithParameters4Renderer ? 4 : (ktDiagnosticRenderer2 instanceof KtDiagnosticWithParameters3Renderer ? 3 : (ktDiagnosticRenderer2 instanceof KtDiagnosticWithParameters2Renderer ? 2 : (ktDiagnosticRenderer2 instanceof KtDiagnosticWithParameters1Renderer ? 1 : 0)));
            String message = renderer.getMessage();
            Object[] objectArray = Regex.findAll$default((Regex)messageParameterRegex, (CharSequence)message, (int)0, (int)2, null).iterator();
            while (objectArray.hasNext()) {
                MatchResult parameter = (MatchResult)objectArray.next();
                String string = parameter.getValue().substring(1, 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int index = Integer.parseInt(string);
                if (index < parameterCount) continue;
                $this$verifyMessageForFactory_u24lambda_u241.add("Message for " + property.getName() + " references wrong parameter {" + index + '}');
            }
            if (parameterCount > 0 && new Regex("(?<!')'(?!')").containsMatchIn((CharSequence)(objectArray = (CharSequence)message))) {
                $this$verifyMessageForFactory_u24lambda_u241.add("Renderer for " + property.getName() + " has parameters and contains a single quote. Text inside single quotes is not formatted in MessageFormat. Use double quotes instead.");
            }
            if (parameterCount == 0 && new Regex("(?<!')''(?!')").containsMatchIn((CharSequence)(objectArray = (CharSequence)message))) {
                $this$verifyMessageForFactory_u24lambda_u241.add("Renderer for " + property.getName() + " has no parameters and contains double quote. Single quotes should be used.");
            }
            if (!lastCharExclusions.contains(property.getName()) && !lastCharRegex.matches((CharSequence)String.valueOf(StringsKt.last((CharSequence)message)))) {
                $this$verifyMessageForFactory_u24lambda_u241.add("Renderer for " + property.getName() + " should end with a full stop. If this error is a false positive, add the name of the diagnostic to the list of exclusions.");
            }
            FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory$lambda$1$checkRule$default($this$verifyMessageForFactory_u24lambda_u241, property, message, new Regex("\\b(colour|favour|realise|analyse|centre|defence|offence|licence|cancelled|metre|tonne|cheque|catalogue|neighbour|grey|programme)\\b", RegexOption.IGNORE_CASE), "uses British spelling. Use American spelling instead", null, 16, null);
            objectArray = new String[]{FirErrors.INSTANCE.getCONTEXT_RECEIVERS_DEPRECATED().getName(), FirErrors.INSTANCE.getNO_TYPE_ARGUMENTS_ON_RHS().getName(), "PARCELABLE_TYPE_NOT_SUPPORTED"};
            FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory$lambda$1$checkRule($this$verifyMessageForFactory_u24lambda_u241, property, message, new Regex("\\b(?:we|us|you(?!\\s+have))\\b", RegexOption.IGNORE_CASE), "uses 'we', 'us' or 'you'.", SetsKt.setOf((Object[])objectArray));
            objectArray = new String[]{FirErrors.INSTANCE.getCONTEXT_RECEIVERS_DEPRECATED().getName(), FirErrors.INSTANCE.getERROR_SUPPRESSION().getName()};
            FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory$lambda$1$checkRule($this$verifyMessageForFactory_u24lambda_u241, property, message, new Regex("\\bplease\\b", RegexOption.IGNORE_CASE), "uses overly polite tone", SetsKt.setOf((Object[])objectArray));
            FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory$lambda$1$checkRule$default($this$verifyMessageForFactory_u24lambda_u241, property, message, new Regex("\\b(?:probably|likely|maybe|certainly|possibly|undoubtedly|presumably|apparently|hopefully)\\b", RegexOption.IGNORE_CASE), "uses adverb of probability (likely, maybe, ...)", null, 16, null);
            objectArray = new String[]{FirErrors.INSTANCE.getVERSION_REQUIREMENT_DEPRECATION().getName(), FirErrors.INSTANCE.getNON_PUBLIC_INLINE_CALL_FROM_PUBLIC_INLINE().getName()};
            FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory$lambda$1$checkRule($this$verifyMessageForFactory_u24lambda_u241, property, message, new Regex("\\b(?:could|should|would|shall)\\b", RegexOption.IGNORE_CASE), "uses modal verb (could, should, ...) with uncertainty", SetsKt.setOf((Object[])objectArray));
            FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory$lambda$1$checkRule$default($this$verifyMessageForFactory_u24lambda_u241, property, message, new Regex("\\b(?:must|ca|is|wo|do)n''?t\\b", RegexOption.IGNORE_CASE), "uses contraction", null, 16, null);
            FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory$lambda$1$checkRule$default($this$verifyMessageForFactory_u24lambda_u241, property, message, new Regex("\\bmust not\\b", RegexOption.IGNORE_CASE), "uses 'must not'. Replace with 'cannot'", null, 16, null);
        }
        return CollectionsKt.build((List)list);
    }

    private static final CharSequence verifyMessageForFactory$lambda$1$checkRule$lambda$0(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        return "[[" + matchResult.getValue() + "]]";
    }

    private static final void verifyMessageForFactory$lambda$1$checkRule(List<String> $this$verifyMessageForFactory_u24lambda_u241_u24checkRule, KProperty<?> $property, String message, Regex regex, String hasProblem, Set<String> exclusions) {
        if (!exclusions.contains($property.getName()) && regex.containsMatchIn((CharSequence)message)) {
            CharSequence charSequence = message;
            Function1 function1 = FirErrorsDefaultMessagesHelperKt::verifyMessageForFactory$lambda$1$checkRule$lambda$0;
            String updatedMessage = regex.replace(charSequence, function1);
            $this$verifyMessageForFactory_u24lambda_u241_u24checkRule.add("Message of " + $property.getName() + ' ' + hasProblem + ":\n" + updatedMessage + "\nIf this error is a false positive, add the name of the diagnostic to the list of exclusions.");
        }
    }

    static /* synthetic */ void verifyMessageForFactory$lambda$1$checkRule$default(List list, KProperty kProperty, String string, Regex regex, String string2, Set set, int n, Object object) {
        if ((n & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        FirErrorsDefaultMessagesHelperKt.verifyMessageForFactory$lambda$1$checkRule(list, kProperty, string, regex, string2, set);
    }

    static {
        Object[] objectArray = new String[]{FirErrors.INSTANCE.getDATA_CLASS_COPY_VISIBILITY_WILL_BE_CHANGED().getName(), FirErrors.INSTANCE.getERROR_SUPPRESSION().getName(), FirErrors.INSTANCE.getNOT_A_MULTIPLATFORM_COMPILATION().getName(), FirErrors.INSTANCE.getSAFE_CALL_WILL_CHANGE_NULLABILITY().getName()};
        lastCharExclusions = CollectionsKt.listOf((Object[])objectArray);
    }
}

