/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.util;

import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorProcessor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

public class DescriptorValidator {
    public static void validate(@NotNull ValidationVisitor validationStrategy, DeclarationDescriptor descriptor) {
        if (validationStrategy == null) {
            DescriptorValidator.$$$reportNull$$$0(0);
        }
        DiagnosticCollectorForTests collector = new DiagnosticCollectorForTests();
        DescriptorValidator.validate(validationStrategy, descriptor, collector);
        collector.done();
    }

    public static void validate(@NotNull ValidationVisitor validator, @NotNull DeclarationDescriptor descriptor, @NotNull DiagnosticCollector collector) {
        if (validator == null) {
            DescriptorValidator.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            DescriptorValidator.$$$reportNull$$$0(2);
        }
        if (collector == null) {
            DescriptorValidator.$$$reportNull$$$0(3);
        }
        RecursiveDescriptorProcessor.process(descriptor, collector, validator);
    }

    private static void report(@NotNull DiagnosticCollector collector, @NotNull DeclarationDescriptor descriptor, @NotNull String message) {
        if (collector == null) {
            DescriptorValidator.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            DescriptorValidator.$$$reportNull$$$0(5);
        }
        if (message == null) {
            DescriptorValidator.$$$reportNull$$$0(6);
        }
        collector.report(new ValidationDiagnostic(descriptor, message));
    }

    private DescriptorValidator() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationStrategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/test/util/DescriptorValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DiagnosticCollectorForTests
    implements DiagnosticCollector {
        private boolean errorsFound = false;

        private DiagnosticCollectorForTests() {
        }

        @Override
        public void report(@NotNull ValidationDiagnostic diagnostic) {
            if (diagnostic == null) {
                DiagnosticCollectorForTests.$$$reportNull$$$0(0);
            }
            diagnostic.printStackTrace(System.err);
            this.errorsFound = true;
        }

        public void done() {
            if (this.errorsFound) {
                throw new AssertionError((Object)"Descriptor validation failed (see messages above)");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/test/util/DescriptorValidator$DiagnosticCollectorForTests", "report"));
        }
    }

    public static class ValidationDiagnostic {
        private final DeclarationDescriptor descriptor;
        private final String message;
        private final Throwable stackTrace;

        private ValidationDiagnostic(@NotNull DeclarationDescriptor descriptor, @NotNull String message) {
            if (descriptor == null) {
                ValidationDiagnostic.$$$reportNull$$$0(0);
            }
            if (message == null) {
                ValidationDiagnostic.$$$reportNull$$$0(1);
            }
            this.descriptor = descriptor;
            this.message = message;
            this.stackTrace = new Throwable();
        }

        @NotNull
        public DeclarationDescriptor getDescriptor() {
            DeclarationDescriptor declarationDescriptor = this.descriptor;
            if (declarationDescriptor == null) {
                ValidationDiagnostic.$$$reportNull$$$0(2);
            }
            return declarationDescriptor;
        }

        @NotNull
        public String getMessage() {
            String string = this.message;
            if (string == null) {
                ValidationDiagnostic.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public Throwable getStackTrace() {
            Throwable throwable = this.stackTrace;
            if (throwable == null) {
                ValidationDiagnostic.$$$reportNull$$$0(4);
            }
            return throwable;
        }

        public void printStackTrace(@NotNull PrintStream out) {
            if (out == null) {
                ValidationDiagnostic.$$$reportNull$$$0(5);
            }
            out.println(this.descriptor);
            out.println(this.message);
            this.stackTrace.printStackTrace(out);
        }

        public String toString() {
            return this.descriptor + " > " + this.message;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ValidationDiagnostic";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ValidationDiagnostic";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStackTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "printStackTrace";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ScopeValidatorVisitor
    implements DeclarationDescriptorVisitor<Void, MemberScope> {
        private final DiagnosticCollector collector;

        public ScopeValidatorVisitor(DiagnosticCollector collector) {
            this.collector = collector;
        }

        private void report(DeclarationDescriptor expected, String message) {
            DescriptorValidator.report(this.collector, expected, message);
        }

        private void assertFound(@NotNull MemberScope scope, @NotNull DeclarationDescriptor expected, @Nullable DeclarationDescriptor found, boolean shouldBeSame) {
            if (scope == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(0);
            }
            if (expected == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(1);
            }
            if (found == null) {
                this.report(expected, "Not found in " + scope);
            }
            if (shouldBeSame ? expected != found : !expected.equals(found)) {
                this.report(expected, "Lookup error in " + scope + ": " + found);
            }
        }

        private void assertFound(@NotNull MemberScope scope, @NotNull DeclarationDescriptor expected, @NotNull Collection<? extends DeclarationDescriptor> found) {
            if (scope == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(2);
            }
            if (expected == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(3);
            }
            if (found == null) {
                ScopeValidatorVisitor.$$$reportNull$$$0(4);
            }
            if (!found.contains(expected)) {
                this.report(expected, "Not found in " + scope + ": " + found);
            }
        }

        public Void visitPackageFragmentDescriptor(PackageFragmentDescriptor descriptor, MemberScope scope) {
            return null;
        }

        public Void visitPackageViewDescriptor(PackageViewDescriptor descriptor, MemberScope scope) {
            return null;
        }

        public Void visitVariableDescriptor(VariableDescriptor descriptor, MemberScope scope) {
            this.assertFound(scope, (DeclarationDescriptor)descriptor, scope.getContributedVariables(descriptor.getName(), (LookupLocation)NoLookupLocation.FROM_TEST));
            return null;
        }

        public Void visitFunctionDescriptor(FunctionDescriptor descriptor, MemberScope scope) {
            this.assertFound(scope, (DeclarationDescriptor)descriptor, scope.getContributedFunctions(descriptor.getName(), (LookupLocation)NoLookupLocation.FROM_TEST));
            return null;
        }

        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, MemberScope scope) {
            this.assertFound(scope, (DeclarationDescriptor)descriptor, (DeclarationDescriptor)scope.getContributedClassifier(descriptor.getName(), (LookupLocation)NoLookupLocation.FROM_TEST), true);
            return null;
        }

        public Void visitClassDescriptor(ClassDescriptor descriptor, MemberScope scope) {
            this.assertFound(scope, (DeclarationDescriptor)descriptor, (DeclarationDescriptor)scope.getContributedClassifier(descriptor.getName(), (LookupLocation)NoLookupLocation.FROM_TEST), true);
            return null;
        }

        public Void visitTypeAliasDescriptor(TypeAliasDescriptor descriptor, MemberScope data) {
            return null;
        }

        public Void visitModuleDeclaration(ModuleDescriptor descriptor, MemberScope scope) {
            this.report((DeclarationDescriptor)descriptor, "Module found in scope: " + scope);
            return null;
        }

        public Void visitConstructorDescriptor(ConstructorDescriptor descriptor, MemberScope scope) {
            this.report((DeclarationDescriptor)descriptor, "Constructor found in scope: " + scope);
            return null;
        }

        public Void visitScriptDescriptor(ScriptDescriptor descriptor, MemberScope scope) {
            this.report((DeclarationDescriptor)descriptor, "Script found in scope: " + scope);
            return null;
        }

        public Void visitPropertyDescriptor(PropertyDescriptor descriptor, MemberScope scope) {
            return this.visitVariableDescriptor((VariableDescriptor)descriptor, scope);
        }

        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor, MemberScope scope) {
            return this.visitVariableDescriptor((VariableDescriptor)descriptor, scope);
        }

        public Void visitPropertyGetterDescriptor(PropertyGetterDescriptor descriptor, MemberScope scope) {
            this.report((DeclarationDescriptor)descriptor, "Getter found in scope: " + scope);
            return null;
        }

        public Void visitPropertySetterDescriptor(PropertySetterDescriptor descriptor, MemberScope scope) {
            this.report((DeclarationDescriptor)descriptor, "Setter found in scope: " + scope);
            return null;
        }

        public Void visitReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor, MemberScope scope) {
            this.report((DeclarationDescriptor)descriptor, "Receiver parameter found in scope: " + scope);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expected";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "found";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ScopeValidatorVisitor";
            objectArray[2] = "assertFound";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ValidationVisitor
    implements DeclarationDescriptorVisitor<Boolean, DiagnosticCollector> {
        private boolean allowErrorTypes = false;
        private Predicate<DeclarationDescriptor> recursiveFilter = descriptor -> true;

        public static ValidationVisitor errorTypesForbidden() {
            return new ValidationVisitor();
        }

        public static ValidationVisitor errorTypesAllowed() {
            return new ValidationVisitor().allowErrorTypes();
        }

        @NotNull
        public ValidationVisitor withStepIntoFilter(@NotNull Predicate<DeclarationDescriptor> filter) {
            if (filter == null) {
                ValidationVisitor.$$$reportNull$$$0(0);
            }
            this.recursiveFilter = filter;
            ValidationVisitor validationVisitor = this;
            if (validationVisitor == null) {
                ValidationVisitor.$$$reportNull$$$0(1);
            }
            return validationVisitor;
        }

        @NotNull
        public ValidationVisitor allowErrorTypes() {
            this.allowErrorTypes = true;
            ValidationVisitor validationVisitor = this;
            if (validationVisitor == null) {
                ValidationVisitor.$$$reportNull$$$0(2);
            }
            return validationVisitor;
        }

        protected void validateScope(DeclarationDescriptor scopeOwner, @NotNull MemberScope scope, @NotNull DiagnosticCollector collector) {
            if (scope == null) {
                ValidationVisitor.$$$reportNull$$$0(3);
            }
            if (collector == null) {
                ValidationVisitor.$$$reportNull$$$0(4);
            }
            for (DeclarationDescriptor descriptor : DescriptorUtils.getAllDescriptors((MemberScope)scope)) {
                if (!this.recursiveFilter.test(descriptor)) continue;
                descriptor.accept((DeclarationDescriptorVisitor)new ScopeValidatorVisitor(collector), (Object)scope);
            }
        }

        private void validateType(@NotNull DeclarationDescriptor descriptor, @Nullable KotlinType type, @NotNull DiagnosticCollector collector) {
            if (descriptor == null) {
                ValidationVisitor.$$$reportNull$$$0(5);
            }
            if (collector == null) {
                ValidationVisitor.$$$reportNull$$$0(6);
            }
            if (type == null) {
                DescriptorValidator.report(collector, descriptor, "No type");
                return;
            }
            if (!this.allowErrorTypes && KotlinTypeKt.isError((KotlinType)type)) {
                DescriptorValidator.report(collector, descriptor, "Error type: " + type);
                return;
            }
            this.validateScope(descriptor, type.getMemberScope(), collector);
        }

        private void validateReturnType(CallableDescriptor descriptor, DiagnosticCollector collector) {
            this.validateType((DeclarationDescriptor)descriptor, descriptor.getReturnType(), collector);
        }

        private static void validateTypeParameters(DiagnosticCollector collector, List<TypeParameterDescriptor> parameters) {
            for (int i = 0; i < parameters.size(); ++i) {
                TypeParameterDescriptor typeParameterDescriptor = parameters.get(i);
                if (typeParameterDescriptor.getIndex() == i) continue;
                DescriptorValidator.report(collector, (DeclarationDescriptor)typeParameterDescriptor, "Incorrect index: " + typeParameterDescriptor.getIndex() + " but must be " + i);
            }
        }

        private static void validateValueParameters(DiagnosticCollector collector, List<ValueParameterDescriptor> parameters) {
            for (int i = 0; i < parameters.size(); ++i) {
                ValueParameterDescriptor valueParameterDescriptor = parameters.get(i);
                if (valueParameterDescriptor.getIndex() == i) continue;
                DescriptorValidator.report(collector, (DeclarationDescriptor)valueParameterDescriptor, "Incorrect index: " + valueParameterDescriptor.getIndex() + " but must be " + i);
            }
        }

        private void validateTypes(DeclarationDescriptor descriptor, DiagnosticCollector collector, Collection<KotlinType> types) {
            for (KotlinType type : types) {
                this.validateType(descriptor, type, collector);
            }
        }

        private void validateCallable(CallableDescriptor descriptor, DiagnosticCollector collector) {
            this.validateReturnType(descriptor, collector);
            ValidationVisitor.validateTypeParameters(collector, descriptor.getTypeParameters());
            ValidationVisitor.validateValueParameters(collector, descriptor.getValueParameters());
        }

        private static <T> void assertEquals(DeclarationDescriptor descriptor, DiagnosticCollector collector, String name, T expected, T actual) {
            if (!expected.equals(actual)) {
                DescriptorValidator.report(collector, descriptor, "Wrong " + name + ": " + actual + " must be " + expected);
            }
        }

        private static <T> void assertEqualTypes(DeclarationDescriptor descriptor, DiagnosticCollector collector, String name, KotlinType expected, KotlinType actual) {
            if (KotlinTypeKt.isError((KotlinType)expected) && KotlinTypeKt.isError((KotlinType)actual)) {
                ValidationVisitor.assertEquals(descriptor, collector, name, expected.toString(), actual.toString());
            } else if (!expected.equals((Object)actual)) {
                DescriptorValidator.report(collector, descriptor, "Wrong " + name + ": " + actual + " must be " + expected);
            }
        }

        private static void validateAccessor(PropertyDescriptor descriptor, DiagnosticCollector collector, PropertyAccessorDescriptor accessor, String name) {
            ValidationVisitor.assertEquals((DeclarationDescriptor)accessor, collector, "corresponding property", descriptor, accessor.getCorrespondingProperty());
        }

        public Boolean visitPackageFragmentDescriptor(PackageFragmentDescriptor descriptor, DiagnosticCollector collector) {
            this.validateScope((DeclarationDescriptor)descriptor, descriptor.getMemberScope(), collector);
            return true;
        }

        public Boolean visitPackageViewDescriptor(PackageViewDescriptor descriptor, DiagnosticCollector collector) {
            if (!this.recursiveFilter.test((DeclarationDescriptor)descriptor)) {
                return false;
            }
            this.validateScope((DeclarationDescriptor)descriptor, descriptor.getMemberScope(), collector);
            return true;
        }

        public Boolean visitVariableDescriptor(VariableDescriptor descriptor, DiagnosticCollector collector) {
            this.validateReturnType((CallableDescriptor)descriptor, collector);
            return true;
        }

        public Boolean visitFunctionDescriptor(FunctionDescriptor descriptor, DiagnosticCollector collector) {
            this.validateCallable((CallableDescriptor)descriptor, collector);
            return true;
        }

        public Boolean visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, DiagnosticCollector collector) {
            this.validateTypes((DeclarationDescriptor)descriptor, collector, descriptor.getUpperBounds());
            this.validateType((DeclarationDescriptor)descriptor, (KotlinType)descriptor.getDefaultType(), collector);
            return true;
        }

        public Boolean visitClassDescriptor(ClassDescriptor descriptor, DiagnosticCollector collector) {
            ClassDescriptor companionObjectDescriptor;
            ClassConstructorDescriptor primaryConstructor;
            ValidationVisitor.validateTypeParameters(collector, descriptor.getDeclaredTypeParameters());
            Collection supertypes = descriptor.getTypeConstructor().getSupertypes();
            if (supertypes.isEmpty() && descriptor.getKind() != ClassKind.INTERFACE && !KotlinBuiltIns.isSpecialClassWithNoSupertypes((ClassDescriptor)descriptor)) {
                DescriptorValidator.report(collector, (DeclarationDescriptor)descriptor, "No supertypes for non-trait");
            }
            this.validateTypes((DeclarationDescriptor)descriptor, collector, supertypes);
            this.validateType((DeclarationDescriptor)descriptor, (KotlinType)descriptor.getDefaultType(), collector);
            this.validateScope((DeclarationDescriptor)descriptor, descriptor.getUnsubstitutedInnerClassesScope(), collector);
            ArrayList primary = Lists.newArrayList();
            for (ConstructorDescriptor constructorDescriptor : descriptor.getConstructors()) {
                if (!constructorDescriptor.isPrimary()) continue;
                primary.add(constructorDescriptor);
            }
            if (primary.size() > 1) {
                DescriptorValidator.report(collector, (DeclarationDescriptor)descriptor, "Many primary constructors: " + primary);
            }
            if ((primaryConstructor = descriptor.getUnsubstitutedPrimaryConstructor()) != null && !descriptor.getConstructors().contains(primaryConstructor)) {
                DescriptorValidator.report(collector, (DeclarationDescriptor)primaryConstructor, "Primary constructor not in getConstructors() result: " + descriptor.getConstructors());
            }
            if ((companionObjectDescriptor = descriptor.getCompanionObjectDescriptor()) != null && !companionObjectDescriptor.isCompanionObject()) {
                DescriptorValidator.report(collector, (DeclarationDescriptor)companionObjectDescriptor, "Companion object should be marked as such");
            }
            return true;
        }

        public Boolean visitTypeAliasDescriptor(TypeAliasDescriptor descriptor, DiagnosticCollector data) {
            return true;
        }

        public Boolean visitModuleDeclaration(ModuleDescriptor descriptor, DiagnosticCollector collector) {
            return true;
        }

        public Boolean visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, DiagnosticCollector collector) {
            this.visitFunctionDescriptor((FunctionDescriptor)constructorDescriptor, collector);
            ValidationVisitor.assertEqualTypes((DeclarationDescriptor)constructorDescriptor, collector, "return type", (KotlinType)constructorDescriptor.getContainingDeclaration().getDefaultType(), constructorDescriptor.getReturnType());
            return true;
        }

        public Boolean visitScriptDescriptor(ScriptDescriptor scriptDescriptor, DiagnosticCollector collector) {
            return true;
        }

        public Boolean visitPropertyDescriptor(PropertyDescriptor descriptor, DiagnosticCollector collector) {
            PropertySetterDescriptor setter;
            this.validateCallable((CallableDescriptor)descriptor, collector);
            PropertyGetterDescriptor getter = descriptor.getGetter();
            if (getter != null) {
                ValidationVisitor.assertEqualTypes((DeclarationDescriptor)getter, collector, "getter return type", descriptor.getType(), getter.getReturnType());
                ValidationVisitor.validateAccessor(descriptor, collector, (PropertyAccessorDescriptor)getter, "getter");
            }
            if ((setter = descriptor.getSetter()) != null) {
                ValidationVisitor.assertEquals((DeclarationDescriptor)setter, collector, "setter parameter count", 1, setter.getValueParameters().size());
                ValidationVisitor.assertEqualTypes((DeclarationDescriptor)setter, collector, "setter parameter type", descriptor.getType(), ((ValueParameterDescriptor)setter.getValueParameters().get(0)).getType());
                ValidationVisitor.assertEquals((DeclarationDescriptor)setter, collector, "corresponding property", descriptor, setter.getCorrespondingProperty());
            }
            return true;
        }

        public Boolean visitValueParameterDescriptor(ValueParameterDescriptor descriptor, DiagnosticCollector collector) {
            return this.visitVariableDescriptor((VariableDescriptor)descriptor, collector);
        }

        public Boolean visitPropertyGetterDescriptor(PropertyGetterDescriptor descriptor, DiagnosticCollector collector) {
            return this.visitFunctionDescriptor((FunctionDescriptor)descriptor, collector);
        }

        public Boolean visitPropertySetterDescriptor(PropertySetterDescriptor descriptor, DiagnosticCollector collector) {
            return this.visitFunctionDescriptor((FunctionDescriptor)descriptor, collector);
        }

        public Boolean visitReceiverParameterDescriptor(ReceiverParameterDescriptor descriptor, DiagnosticCollector collector) {
            this.validateType((DeclarationDescriptor)descriptor, descriptor.getType(), collector);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ValidationVisitor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collector";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/test/util/DescriptorValidator$ValidationVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withStepIntoFilter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowErrorTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withStepIntoFilter";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "validateScope";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "validateType";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface DiagnosticCollector {
        public void report(@NotNull ValidationDiagnostic var1);
    }
}

