/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.test.frontend.classic.ModuleDescriptorProviderKt;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.KotlinTestInfoKt;
import org.jetbrains.kotlin.test.services.LibraryProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\bf\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J$\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J*\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00130\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/KlibBasedEnvironmentConfiguratorUtils;", "", "getKlibArtifactSimpleName", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "moduleName", "getKlibArtifactFile", "Ljava/io/File;", "getKlibOutputDir", "getAllRecursiveLibrariesFor", "", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "getAllRecursiveDependenciesFor", "", "getAllDependenciesMappingFor", "", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nKlibBasedEnvironmentConfiguratorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibBasedEnvironmentConfiguratorUtils.kt\norg/jetbrains/kotlin/test/services/configuration/KlibBasedEnvironmentConfiguratorUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,66:1\n1208#2,2:67\n1236#2,4:69\n1285#2,2:77\n1299#2,2:79\n774#2:81\n865#2,2:82\n1563#2:84\n1634#2,3:85\n1302#2:88\n1869#2,2:89\n126#3:73\n153#3,3:74\n*S KotlinDebug\n*F\n+ 1 KlibBasedEnvironmentConfiguratorUtils.kt\norg/jetbrains/kotlin/test/services/configuration/KlibBasedEnvironmentConfiguratorUtils\n*L\n34#1:67,2\n34#1:69,4\n56#1:77,2\n56#1:79,2\n58#1:81\n58#1:82,2\n58#1:84\n58#1:85,3\n56#1:88\n40#1:89,2\n54#1:73\n54#1:74,3\n*E\n"})
public interface KlibBasedEnvironmentConfiguratorUtils {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.test.services.configuration.KlibBasedEnvironmentConfiguratorUtils$Companion.$$INSTANCE;

    @NotNull
    default public String getKlibArtifactSimpleName(@NotNull TestServices testServices, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        String testName = CapitalizeDecapitalizeKt.decapitalizeAsciiOnly((String)StringsKt.removePrefix((String)KotlinTestInfoKt.getTestInfo(testServices).getMethodName(), (CharSequence)"test"));
        String outputFileSuffix = Intrinsics.areEqual((Object)moduleName, (Object)"main") ? "" : '-' + moduleName;
        return testName + outputFileSuffix;
    }

    @NotNull
    default public File getKlibArtifactFile(@NotNull TestServices testServices, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return FilesKt.resolve((File)this.getKlibOutputDir(testServices), (String)this.getKlibArtifactSimpleName(testServices, moduleName));
    }

    @NotNull
    default public File getKlibOutputDir(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        return TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(testServices).getOrCreateTempDirectory("outputKlibDir");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<KotlinLibrary, ModuleDescriptorImpl> getAllRecursiveLibrariesFor(@NotNull TestModule module, @NotNull TestServices testServices) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Set<ModuleDescriptorImpl> dependencies = this.getAllRecursiveDependenciesFor(module, testServices);
        Iterable $this$associateBy$iv = dependencies;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ModuleDescriptorImpl moduleDescriptorImpl = (ModuleDescriptorImpl)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(LibraryProviderKt.getLibraryProvider(testServices).getCompiledLibraryByDescriptor((ModuleDescriptor)it), element$iv$iv);
        }
        return destination$iv$iv;
    }

    @NotNull
    default public Set<ModuleDescriptorImpl> getAllRecursiveDependenciesFor(@NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Set visited = new LinkedHashSet();
        KlibBasedEnvironmentConfiguratorUtils.getAllRecursiveDependenciesFor$getRecursive(visited, ModuleDescriptorProviderKt.getModuleDescriptorProvider(testServices).getModuleDescriptor(module));
        return visited;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<KotlinLibrary, List<KotlinLibrary>> getAllDependenciesMappingFor(@NotNull TestModule module, @NotNull TestServices testServices) {
        KotlinLibrary it;
        Object object;
        void $this$mapTo$iv$iv;
        Map<KotlinLibrary, ModuleDescriptorImpl> allRecursiveLibraries;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Map<KotlinLibrary, ModuleDescriptorImpl> $this$map$iv = allRecursiveLibraries = this.getAllRecursiveLibrariesFor(module, testServices);
        boolean $i$f$map = false;
        Map<KotlinLibrary, ModuleDescriptorImpl> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(TuplesKt.to(it.getValue(), it.getKey()));
        }
        Map m2l = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable $this$associateWith$iv = allRecursiveLibraries.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Map.Entry element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            ModuleDescriptor it2;
            void $this$filterTo$iv$iv;
            ModuleDescriptor descriptor;
            void m;
            it = (KotlinLibrary)element$iv$iv;
            Map.Entry entry = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            if ((ModuleDescriptor)allRecursiveLibraries.get(m) == null) {
                throw new IllegalStateException(("No descriptor found for library " + m.getLibraryName()).toString());
            }
            Iterable $this$filter$iv = descriptor.getAllDependencyModules();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                it2 = (ModuleDescriptor)element$iv$iv2;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it2, (Object)descriptor))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it2 = (ModuleDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add((KotlinLibrary)MapsKt.getValue((Map)m2l, (Object)it2));
            }
            List list = (List)destination$iv$iv2;
            object.put(entry, list);
        }
        return result$iv;
    }

    private static void getAllRecursiveDependenciesFor$getRecursive(Set<ModuleDescriptorImpl> visited, ModuleDescriptor descriptor) {
        Iterable $this$forEach$iv = descriptor.getAllDependencyModules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleDescriptor it = (ModuleDescriptor)element$iv;
            boolean bl = false;
            if (!(it instanceof ModuleDescriptorImpl) || visited.contains(it)) continue;
            ((Collection)visited).add(it);
            KlibBasedEnvironmentConfiguratorUtils.getAllRecursiveDependenciesFor$getRecursive(visited, it);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/KlibBasedEnvironmentConfiguratorUtils$Companion;", "", "<init>", "()V", "OUTPUT_KLIB_DIR_NAME", "", "tests-common-new_test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String OUTPUT_KLIB_DIR_NAME = "outputKlibDir";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

