/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeysKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.HmppCliModule;
import org.jetbrains.kotlin.config.HmppCliModuleStructure;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.test.FirParser;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CliBasedFacadesMarkerKt;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TargetPlatformProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.CommonEnvironmentConfiguratorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u000b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/CommonEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "provideAdditionalAnalysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "configureCompilerConfiguration", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "setupK2CliConfiguration", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nCommonEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/CommonEnvironmentConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1285#2,2:104\n1299#2,2:106\n1563#2:108\n1634#2,3:109\n1302#2:112\n1563#2:113\n1634#2,3:114\n*S KotlinDebug\n*F\n+ 1 CommonEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/CommonEnvironmentConfigurator\n*L\n68#1:104,2\n68#1:106,2\n72#1:108\n72#1:109,3\n68#1:112\n79#1:113\n79#1:114,3\n*E\n"})
public final class CommonEnvironmentConfigurator
extends EnvironmentConfigurator {
    public CommonEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)ConfigurationDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public Map<AnalysisFlag<?>, Object> provideAdditionalAnalysisFlags(@NotNull RegisteredDirectives directives, @NotNull LanguageVersion languageVersion) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Map $this$provideAdditionalAnalysisFlags_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$provideAdditionalAnalysisFlags_u24lambda_u240.put(AnalysisFlags.getAllowFullyQualifiedNameInKClass(), true);
        if (directives.contains(ConfigurationDirectives.INSTANCE.getDISABLE_TYPEALIAS_EXPANSION())) {
            $this$provideAdditionalAnalysisFlags_u24lambda_u240.put(AnalysisFlags.getExpandTypeAliasesInTypeResolution(), false);
        }
        return MapsKt.build((Map)map);
    }

    @Override
    protected void configureCompilerConfiguration(@NotNull CompilerConfiguration configuration2, @NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (TargetPlatformKt.isCommon((TargetPlatform)TargetPlatformProviderKt.targetPlatform(module, this.getTestServices())) && module.getDirectives().contains(ConfigurationDirectives.INSTANCE.getWITH_STDLIB())) {
            File file = ForTestCompileRuntime.stdlibCommonForTests();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"stdlibCommonForTests(...)");
            configuration2.add(CLIConfigurationKeys.CONTENT_ROOTS, (Object)new JvmClasspathRoot(file));
        }
        if (module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getWITH_EXTRA_CHECKERS())) {
            CommonConfigurationKeysKt.setUseFirExtraCheckers((CompilerConfiguration)configuration2, (boolean)true);
        }
        this.setupK2CliConfiguration(module, configuration2);
    }

    /*
     * WARNING - void declaration
     */
    private final void setupK2CliConfiguration(TestModule module, CompilerConfiguration configuration2) {
        if (!CliBasedFacadesMarkerKt.getCliBasedFacadesEnabled(this.getTestServices())) {
            return;
        }
        if (module.getLanguageVersionSettings().supportsFeature(LanguageFeature.MultiPlatformProjects) && TestModuleStructureKt.isLeafModuleInMppGraph(module, this.getTestServices())) {
            Map map;
            Object object;
            Iterable iterable;
            void $this$associateWith$iv;
            Iterable iterable2 = TestModuleStructureKt.transitiveDependsOnDependencies$default(module, true, true, null, 4, null);
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void it;
                TestModule testModule = (TestModule)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl3 = false;
                iterable = CommonEnvironmentConfiguratorKt.getKotlinFiles((TestModule)it);
                object = it.getName();
                boolean $i$f$map = false;
                void var18_22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    TestFile testFile = (TestFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(SourceFileProviderKt.getSourceFileProvider(this.getTestServices()).getOrCreateRealFileForSourceFile((TestFile)it2).getCanonicalPath());
                }
                Set set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Object object2 = object;
                HmppCliModule hmppCliModule = new HmppCliModule((String)object2, set);
                map2.put(t, hmppCliModule);
            }
            Map hmppModules = result$iv;
            Map $this$setupK2CliConfiguration_u24lambda_u244 = map = MapsKt.createMapBuilder();
            boolean bl = false;
            for (Map.Entry entry : hmppModules.entrySet()) {
                Collection<HmppCliModule> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                TestModule testModule = (TestModule)entry.getKey();
                HmppCliModule cliModule = (HmppCliModule)entry.getValue();
                Iterable bl3 = testModule.getDependsOnDependencies();
                iterable = cliModule;
                object = $this$setupK2CliConfiguration_u24lambda_u244;
                boolean $i$f$map = false;
                void var16_40 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add((HmppCliModule)MapsKt.getValue((Map)hmppModules, (Object)it.getDependencyModule()));
                }
                collection = (List)destination$iv$iv;
                object.put(iterable, collection);
            }
            Map dependencyMap = MapsKt.build((Map)map);
            CommonConfigurationKeysKt.setHmppModuleStructure((CompilerConfiguration)configuration2, (HmppCliModuleStructure)new HmppCliModuleStructure(CollectionsKt.toList((Iterable)hmppModules.values()), dependencyMap));
        }
        if (module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getWITH_EXPERIMENTAL_CHECKERS())) {
            CommonConfigurationKeysKt.setUseFirExperimentalCheckers((CompilerConfiguration)configuration2, (boolean)true);
        }
        FirParser firParser = DirectiveKt.singleOrZeroValue(module.getDirectives(), FirDiagnosticsDirectives.INSTANCE.getFIR_PARSER());
        switch (firParser == null ? -1 : WhenMappings.$EnumSwitchMapping$0[firParser.ordinal()]) {
            case 1: {
                CommonConfigurationKeysKt.setUseLightTree((CompilerConfiguration)configuration2, (boolean)false);
                break;
            }
            case 2: {
                CommonConfigurationKeysKt.setUseLightTree((CompilerConfiguration)configuration2, (boolean)true);
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        CLIConfigurationKeysKt.setAllowNoSourceFiles((CompilerConfiguration)configuration2, (boolean)true);
        CommonConfigurationKeysKt.setAllowAnyScriptsInSourceRoots((CompilerConfiguration)configuration2, (boolean)true);
        CLIConfigurationKeysKt.setAllowKotlinPackage((CompilerConfiguration)configuration2, (boolean)true);
        CommonConfigurationKeysKt.setDontCreateSeparateSessionForScripts((CompilerConfiguration)configuration2, (boolean)true);
        CommonConfigurationKeysKt.setDontSortSourceFiles((CompilerConfiguration)configuration2, (boolean)true);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirParser.values().length];
            try {
                nArray[FirParser.Psi.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirParser.LightTree.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

