/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.compiler.plugin.CompilerPluginRegistrarKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.test.TestInfrastructureInternals;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.CliBasedFacadesMarkerKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TargetPlatformProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0011H\u0014J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0011H\u0014J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0011H\u0007J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProviderImpl;", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "configurators", "", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lcom/intellij/openapi/Disposable;Ljava/util/List;)V", "getTestRootDisposable", "()Lcom/intellij/openapi/Disposable;", "getConfigurators", "()Ljava/util/List;", "environmentCache", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "configurationCache", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getKotlinCoreEnvironment", "module", "createKotlinCoreEnvironment", "getCompilerConfiguration", "createCompilerConfiguration", "platformToEnvironmentConfigFiles", "Lorg/jetbrains/kotlin/cli/jvm/compiler/EnvironmentConfigFiles;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nCompilerConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerConfigurationProvider.kt\norg/jetbrains/kotlin/test/services/CompilerConfigurationProviderImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n384#2,7:180\n384#2,7:188\n1#3:187\n*S KotlinDebug\n*F\n+ 1 CompilerConfigurationProvider.kt\norg/jetbrains/kotlin/test/services/CompilerConfigurationProviderImpl\n*L\n79#1:180,7\n102#1:188,7\n*E\n"})
public class CompilerConfigurationProviderImpl
extends CompilerConfigurationProvider {
    @NotNull
    private final Disposable testRootDisposable;
    @NotNull
    private final List<AbstractEnvironmentConfigurator> configurators;
    @NotNull
    private final Map<TestModule, KotlinCoreEnvironment> environmentCache;
    @NotNull
    private final Map<TestModule, CompilerConfiguration> configurationCache;

    public CompilerConfigurationProviderImpl(@NotNull TestServices testServices, @NotNull Disposable testRootDisposable, @NotNull List<? extends AbstractEnvironmentConfigurator> configurators) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)testRootDisposable, (String)"testRootDisposable");
        Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
        super(testServices);
        this.testRootDisposable = testRootDisposable;
        this.configurators = configurators;
        this.environmentCache = new LinkedHashMap();
        this.configurationCache = new LinkedHashMap();
    }

    @Override
    @NotNull
    public Disposable getTestRootDisposable() {
        return this.testRootDisposable;
    }

    @Override
    @NotNull
    public List<AbstractEnvironmentConfigurator> getConfigurators() {
        return this.configurators;
    }

    @Override
    @NotNull
    protected KotlinCoreEnvironment getKotlinCoreEnvironment(@NotNull TestModule module) {
        KotlinCoreEnvironment kotlinCoreEnvironment;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<TestModule, KotlinCoreEnvironment> $this$getOrPut$iv = this.environmentCache;
        boolean $i$f$getOrPut = false;
        KotlinCoreEnvironment value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            KotlinCoreEnvironment answer$iv = this.createKotlinCoreEnvironment(module);
            $this$getOrPut$iv.put(module, answer$iv);
            kotlinCoreEnvironment = answer$iv;
        } else {
            kotlinCoreEnvironment = value$iv;
        }
        return kotlinCoreEnvironment;
    }

    @NotNull
    protected KotlinCoreEnvironment createKotlinCoreEnvironment(@NotNull TestModule module) {
        KotlinCoreEnvironment kotlinCoreEnvironment;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        TargetPlatform platform = TargetPlatformProviderKt.targetPlatform(module, this.getTestServices());
        EnvironmentConfigFiles configFiles = this.platformToEnvironmentConfigFiles(platform);
        KotlinCoreApplicationEnvironment applicationEnvironment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForTests(this.getTestRootDisposable(), new CompilerConfiguration());
        CompilerConfiguration configuration2 = this.getCompilerConfiguration(module);
        KotlinCoreEnvironment.ProjectEnvironment projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(this.getTestRootDisposable(), applicationEnvironment, configuration2);
        KotlinCoreEnvironment it = kotlinCoreEnvironment = KotlinCoreEnvironment.Companion.createForTests(projectEnv, configuration2, configFiles);
        boolean bl = false;
        MockProject mockProject = projectEnv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"getProject(...)");
        this.registerCompilerExtensions((Project)mockProject, module, configuration2);
        return kotlinCoreEnvironment;
    }

    @Override
    @NotNull
    public CompilerConfiguration getCompilerConfiguration(@NotNull TestModule module) {
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<TestModule, CompilerConfiguration> $this$getOrPut$iv = this.configurationCache;
        boolean $i$f$getOrPut = false;
        CompilerConfiguration value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            CompilerConfiguration answer$iv = this.createCompilerConfiguration(module);
            $this$getOrPut$iv.put(module, answer$iv);
            compilerConfiguration = answer$iv;
        } else {
            compilerConfiguration = value$iv;
        }
        return compilerConfiguration;
    }

    @TestInfrastructureInternals
    @NotNull
    public final CompilerConfiguration createCompilerConfiguration(@NotNull TestModule module) {
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        CompilerConfiguration configuration2 = compilerConfiguration = CompilerConfigurationProviderKt.createCompilerConfiguration(this.getTestServices(), module, this.getConfigurators());
        boolean bl = false;
        if (CliBasedFacadesMarkerKt.getCliBasedFacadesEnabled(this.getTestServices())) {
            configuration2.put(CompilerPluginRegistrarKt.getTEST_ONLY_PLUGIN_REGISTRATION_CALLBACK(), arg_0 -> CompilerConfigurationProviderImpl.createCompilerConfiguration$lambda$4$lambda$3(this, module, configuration2, arg_0));
        }
        return compilerConfiguration;
    }

    private final EnvironmentConfigFiles platformToEnvironmentConfigFiles(TargetPlatform $this$platformToEnvironmentConfigFiles) {
        EnvironmentConfigFiles environmentConfigFiles;
        if (JvmPlatformKt.isJvm((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        } else if (JsPlatformKt.isJs((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.JS_CONFIG_FILES;
        } else if (NativePlatformKt.isNative((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.NATIVE_CONFIG_FILES;
        } else if (WasmPlatformKt.isWasm((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.WASM_CONFIG_FILES;
        } else if (TargetPlatformKt.isCommon((TargetPlatform)$this$platformToEnvironmentConfigFiles)) {
            environmentConfigFiles = EnvironmentConfigFiles.METADATA_CONFIG_FILES;
        } else {
            throw new IllegalStateException(("Unknown platform: " + $this$platformToEnvironmentConfigFiles).toString());
        }
        return environmentConfigFiles;
    }

    private static final Unit createCompilerConfiguration$lambda$4$lambda$3(CompilerConfigurationProviderImpl this$0, TestModule $module, CompilerConfiguration $configuration, Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this$0.registerCompilerExtensions(project, $module, $configuration);
        return Unit.INSTANCE;
    }
}

