/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.test.diagnostics.DiagnosticsCollectorHolder;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ3\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b\u00a2\u0006\u0002\u0010\u0011J1\u0010\u0012\u001a\u0002H\u0013\"\u000e\b\u0000\u0010\u0013*\b\u0012\u0004\u0012\u0002H\u00130\f2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00130\u000b\u00a2\u0006\u0002\u0010\u0011J,\u0010\u0014\u001a\u00020\u0015\"\u000e\b\u0000\u0010\u000e*\b\u0012\u0004\u0012\u0002H\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000e0\fJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\u0000JO\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\n\"\u0004\b\u0000\u0010\u001c\"\u0004\b\u0001\u0010\u001a\"\u0004\b\u0002\u0010\u001b*\u001a\u0012\u0004\u0012\u0002H\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\n0\n2\u0006\u0010\u001d\u001a\u0002H\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\u00020\u00152\u0014\u0010 \u001a\u0010\u0012\u0002\b\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0!2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\t\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0018\u0012\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/test/services/ArtifactsProvider;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "testModules", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "artifactsByModule", "", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "getArtifactSafe", "OutputArtifact", "module", "kind", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/TestArtifactKind;)Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "getArtifact", "A", "registerArtifact", "", "artifact", "unregisterAllArtifacts", "copy", "getMap", "V", "R", "K", "key", "(Ljava/util/Map;Ljava/lang/Object;)Ljava/util/Map;", "checkDistinctDiagnosticReporter", "artifacts", "", "diagnosticReporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nArtifactsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactsProvider.kt\norg/jetbrains/kotlin/test/services/ArtifactsProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n465#2:78\n415#2:79\n384#2,7:84\n1252#3,4:80\n1617#3,9:91\n1869#3:100\n1870#3:102\n1626#3:103\n1#4:101\n*S KotlinDebug\n*F\n+ 1 ArtifactsProvider.kt\norg/jetbrains/kotlin/test/services/ArtifactsProvider\n*L\n57#1:78\n57#1:79\n62#1:84,7\n57#1:80,4\n66#1:91,9\n66#1:100\n66#1:102\n66#1:103\n66#1:101\n*E\n"})
public final class ArtifactsProvider
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final List<TestModule> testModules;
    @NotNull
    private final Map<TestModule, Map<TestArtifactKind<?>, ResultingArtifact<?>>> artifactsByModule;

    public ArtifactsProvider(@NotNull TestServices testServices, @NotNull List<TestModule> testModules) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(testModules, (String)"testModules");
        this.testServices = testServices;
        this.testModules = testModules;
        this.artifactsByModule = new LinkedHashMap();
    }

    @Nullable
    public final <OutputArtifact extends ResultingArtifact<OutputArtifact>> OutputArtifact getArtifactSafe(@NotNull TestModule module, @NotNull TestArtifactKind<OutputArtifact> kind) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        return (OutputArtifact)this.getMap(this.artifactsByModule, module).get(kind);
    }

    @NotNull
    public final <A extends ResultingArtifact<A>> A getArtifact(@NotNull TestModule module, @NotNull TestArtifactKind<A> kind) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(kind, (String)"kind");
        A a = this.getArtifactSafe(module, kind);
        if (a == null) {
            throw new IllegalStateException(("Artifact with kind " + kind + " is not registered for module " + module.getName()).toString());
        }
        return a;
    }

    public final <OutputArtifact extends ResultingArtifact<OutputArtifact>> void registerArtifact(@NotNull TestModule module, @NotNull ResultingArtifact<OutputArtifact> artifact) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(artifact, (String)"artifact");
        Map<TestArtifactKind<?>, ResultingArtifact<?>> artifacts = this.getMap(this.artifactsByModule, module);
        if (artifact instanceof DiagnosticsCollectorHolder) {
            this.checkDistinctDiagnosticReporter(artifacts, ((DiagnosticsCollectorHolder)((Object)artifact)).getDiagnosticReporter());
        }
        artifacts.put(artifact.getKind(), artifact);
    }

    public final void unregisterAllArtifacts(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.artifactsByModule.remove(module);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArtifactsProvider copy() {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        ArtifactsProvider artifactsProvider;
        ArtifactsProvider it = artifactsProvider = new ArtifactsProvider(this.testServices, this.testModules);
        boolean bl = false;
        Map<TestModule, Map<TestArtifactKind<?>, ResultingArtifact<?>>> map = this.artifactsByModule;
        Map<TestModule, Map<TestArtifactKind<?>, ResultingArtifact<?>>> map2 = this.artifactsByModule;
        boolean $i$f$mapValues = false;
        void var7_7 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl3 = false;
            Map map5 = (Map)entry2.getValue();
            Map map6 = MapsKt.toMutableMap((Map)map5);
            map4.put(k, map6);
        }
        map2.putAll(destination$iv$iv);
        return artifactsProvider;
    }

    private final <K, V, R> Map<V, R> getMap(Map<K, Map<V, R>> $this$getMap, K key) {
        Map map;
        Map<K, Map<Map, R>> $this$getOrPut$iv = $this$getMap;
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key, answer$iv);
            map = answer$iv;
        } else {
            map = value$iv;
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDistinctDiagnosticReporter(Map<?, ? extends ResultingArtifact<?>> artifacts, BaseDiagnosticsCollector diagnosticReporter) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = artifacts.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BaseDiagnosticsCollector it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ResultingArtifact it = (ResultingArtifact)element$iv$iv;
            boolean bl2 = false;
            DiagnosticsCollectorHolder diagnosticsCollectorHolder = it instanceof DiagnosticsCollectorHolder ? (DiagnosticsCollectorHolder)((Object)it) : null;
            if ((diagnosticsCollectorHolder != null ? diagnosticsCollectorHolder.getDiagnosticReporter() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set existingReporters = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!(!existingReporters.contains(diagnosticReporter))) {
            boolean bl = false;
            String string = "In test pipelines, diagnostics reporter from previous resulting artifact must not be reused for next resulting artifact. Please create brand new diagnostics reporter instead.";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

