/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.model;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.SourcesKind;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/model/FrontendFacade;", "FrontendOutputArtifact", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact$FrontendOutput;", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact$Source;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "outputKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/FrontendKind;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "getOutputKind", "()Lorg/jetbrains/kotlin/test/model/FrontendKind;", "inputKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getInputKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "shouldTransform", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "analyze", "(Lorg/jetbrains/kotlin/test/model/TestModule;)Lorg/jetbrains/kotlin/test/model/ResultingArtifact$FrontendOutput;", "transform", "inputArtifact", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact$Source;)Lorg/jetbrains/kotlin/test/model/ResultingArtifact$FrontendOutput;", "test-infrastructure_test"})
public abstract class FrontendFacade<FrontendOutputArtifact extends ResultingArtifact.FrontendOutput<FrontendOutputArtifact>>
extends AbstractTestFacade<ResultingArtifact.Source, FrontendOutputArtifact> {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final FrontendKind<FrontendOutputArtifact> outputKind;

    public FrontendFacade(@NotNull TestServices testServices, @NotNull FrontendKind<FrontendOutputArtifact> outputKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(outputKind, (String)"outputKind");
        this.testServices = testServices;
        this.outputKind = outputKind;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public final FrontendKind<FrontendOutputArtifact> getOutputKind() {
        return this.outputKind;
    }

    @Override
    @NotNull
    public final TestArtifactKind<ResultingArtifact.Source> getInputKind() {
        return SourcesKind.INSTANCE;
    }

    @Override
    public boolean shouldTransform(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.testServices).getFrontendKind(), this.outputKind);
    }

    @Nullable
    public abstract FrontendOutputArtifact analyze(@NotNull TestModule var1);

    @Override
    @Nullable
    public final FrontendOutputArtifact transform(@NotNull TestModule module, @NotNull ResultingArtifact.Source inputArtifact) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inputArtifact, (String)"inputArtifact");
        return this.analyze(module);
    }
}

