/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.frontend.fir.handlers.AbstractFirIdenticalChecker;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "checkTestDataFile", "", "testDataFile", "Ljava/io/File;", "Companion", "Helper", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirIdenticalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirIdenticalChecker.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n774#2:83\n865#2,2:84\n1634#2,3:86\n*S KotlinDebug\n*F\n+ 1 FirIdenticalChecker.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker\n*L\n68#1:83\n68#1:84,2\n69#1:86,3\n*E\n"})
public final class LatestLVIdenticalChecker
extends AbstractFirIdenticalChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String message = "Dumps with latest and latest stable LV are the same";

    public LatestLVIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void checkTestDataFile(@NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        if (!CustomTestDataUtilsKt.isLatestLVTestData(testDataFile)) {
            return;
        }
        RegisteredDirectives directives = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives();
        Pair pair = directives.contains(FirDiagnosticsDirectives.INSTANCE.getTEST_ALONGSIDE_K1_TESTDATA()) && !directives.contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL()) ? TuplesKt.to((Object)CustomTestDataUtilsKt.getFirTestDataFile(testDataFile), (Object)CustomTestDataUtilsKt.getOriginalTestDataFile(testDataFile)) : TuplesKt.to((Object)CustomTestDataUtilsKt.getOriginalTestDataFile(testDataFile), null);
        File originalFile = (File)pair.component1();
        File additionalFile = (File)pair.component2();
        Helper helper = new Helper(originalFile);
        if (FirIdenticalCheckerHelper.contentsAreEquals$default(helper, originalFile, testDataFile, false, 4, null)) {
            void $this$mapTo$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$checkTestDataFile_u24lambda_u245;
            List list;
            List list2 = list = CollectionsKt.createListBuilder();
            AssertionsService assertionsService = AssertionsKt.getAssertions(this.getTestServices());
            boolean bl = false;
            $this$checkTestDataFile_u24lambda_u245.add(() -> LatestLVIdenticalChecker.checkTestDataFile$lambda$5$lambda$0(helper, testDataFile));
            Object object = new File[]{CustomTestDataUtilsKt.getOriginalTestDataFile(originalFile), CustomTestDataUtilsKt.getFirTestDataFile(originalFile), CustomTestDataUtilsKt.getLlFirTestDataFile(originalFile), CustomTestDataUtilsKt.getReversedTestDataFile(originalFile)};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl2 = false;
                if (!it.exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void file;
                File $i$f$filterTo2 = (File)item$iv;
                Collection collection = (Collection)$this$checkTestDataFile_u24lambda_u245;
                boolean bl3 = false;
                collection.add(() -> LatestLVIdenticalChecker.checkTestDataFile$lambda$5$lambda$3$lambda$2(helper, (File)file));
            }
            Collection cfr_ignored_0 = (Collection)$this$checkTestDataFile_u24lambda_u245;
            $this$checkTestDataFile_u24lambda_u245.add(() -> LatestLVIdenticalChecker.checkTestDataFile$lambda$5$lambda$4(additionalFile, helper));
            assertionsService.assertAll(CollectionsKt.build((List)list));
        }
    }

    private static final Unit checkTestDataFile$lambda$5$lambda$0(Helper $helper, File $testDataFile) {
        FirIdenticalCheckerHelper.deleteFirFileToCompareAndAssertIfExists$default($helper, $testDataFile, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit checkTestDataFile$lambda$5$lambda$3$lambda$2(Helper $helper, File $file) {
        $helper.removeDirectiveFromClassicFileAndAssert($file, FirDiagnosticsDirectives.INSTANCE.getLATEST_LV_DIFFERENCE(), message);
        return Unit.INSTANCE;
    }

    private static final Unit checkTestDataFile$lambda$5$lambda$4(File $additionalFile, Helper $helper) {
        if ($additionalFile != null) {
            $helper.removeDirectiveFromClassicFileAndAssert($additionalFile, FirDiagnosticsDirectives.INSTANCE.getLATEST_LV_DIFFERENCE(), message);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker$Companion;", "", "<init>", "()V", "message", "", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker$Helper;", "Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper;", "originalFile", "Ljava/io/File;", "<init>", "(Lorg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker;Ljava/io/File;)V", "getOriginalFile", "()Ljava/io/File;", "getClassicFileToCompare", "testDataFile", "getFirFileToCompare", "tests-common-new_test"})
    private final class Helper
    extends FirIdenticalCheckerHelper {
        @NotNull
        private final File originalFile;

        public Helper(File originalFile) {
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            super(LatestLVIdenticalChecker.this.getTestServices());
            this.originalFile = originalFile;
        }

        @NotNull
        public final File getOriginalFile() {
            return this.originalFile;
        }

        @Override
        @NotNull
        public File getClassicFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            return this.originalFile;
        }

        @Override
        @NotNull
        public File getFirFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            return CustomTestDataUtilsKt.getLatestLVTestDataFile(testDataFile);
        }
    }
}

