/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.frontend.fir.handlers.AbstractFirIdenticalChecker;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirIdenticalChecker;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "checkTestDataFile", "", "testDataFile", "Ljava/io/File;", "tests-common-new_test"})
public final class FirIdenticalChecker
extends AbstractFirIdenticalChecker {
    public FirIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    protected void checkTestDataFile(@NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        if (CustomTestDataUtilsKt.isLLFirTestData(testDataFile)) {
            return;
        }
        if (CustomTestDataUtilsKt.isLatestLVTestData(testDataFile)) {
            return;
        }
        if (CustomTestDataUtilsKt.isFirTestData(testDataFile)) {
            AbstractFirIdenticalChecker.Helper helper = new AbstractFirIdenticalChecker.Helper();
            File classicFile = helper.getClassicFileToCompare(testDataFile);
            String string = classicFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)".reversed.", (boolean)false, (int)2, null)) {
                return;
            }
            if (helper.contentsAreEquals(classicFile, testDataFile, true)) {
                helper.deleteFirFileToCompareAndAssertIfExists(testDataFile, true);
                FirIdenticalCheckerHelper.addDirectiveToClassicFileAndAssert$default(helper, classicFile, null, 2, null);
            }
        } else {
            FirIdenticalCheckerHelper.deleteFirFileToCompareAndAssertIfExists$default(new AbstractFirIdenticalChecker.Helper(), testDataFile, false, 2, null);
        }
    }
}

