/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.runners.AbstractFirPsiDiagnosticTest;
import org.jetbrains.kotlin.test.runners.AbstractFirPsiDiagnosticsTestWithJvmIrBackend;
import org.jetbrains.kotlin.test.runners.AbstractKotlinCompilerTest;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.KotlinTestInfoKt;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\u001a*\u00020\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/FirTestDataConsistencyHandler;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "check", "", "failedAssertions", "Lorg/jetbrains/kotlin/test/WrappedException;", "checkK1AndFirTestData", "testData", "Ljava/io/File;", "checkFirAndLatestLVTestData", "latestLVTestData", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "checkTwoFiles", "originalTestData", "secondTestData", "message", "", "preprocessSource", "runFirTestAndGeneratedTestData", "firTestData", "correspondingFirTest", "Lorg/jetbrains/kotlin/test/runners/AbstractKotlinCompilerTest;", "tests-common-new_test"})
public class FirTestDataConsistencyHandler
extends AfterAnalysisChecker {
    public FirTestDataConsistencyHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.getTestServices());
        File testData = (File)CollectionsKt.first(moduleStructure.getOriginalTestDataFiles());
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)testData), (Object)"kts")) {
            return;
        }
        RegisteredDirectives directives = moduleStructure.getAllDirectives();
        if (directives.contains(FirDiagnosticsDirectives.INSTANCE.getTEST_ALONGSIDE_K1_TESTDATA()) && !directives.contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL())) {
            this.checkK1AndFirTestData(testData);
        }
        if (directives.contains(FirDiagnosticsDirectives.INSTANCE.getLATEST_LV_DIFFERENCE()) && CustomTestDataUtilsKt.isLatestLVTestData(testData)) {
            this.checkFirAndLatestLVTestData(testData, directives);
        }
    }

    private final void checkK1AndFirTestData(File testData) {
        Pair pair = CustomTestDataUtilsKt.isFirTestData(testData) ? TuplesKt.to((Object)testData, (Object)CustomTestDataUtilsKt.getOriginalTestDataFile(testData)) : TuplesKt.to((Object)CustomTestDataUtilsKt.getFirTestDataFile(testData), (Object)testData);
        File firTestData = (File)pair.component1();
        File originalTestData = (File)pair.component2();
        if (!firTestData.exists()) {
            this.runFirTestAndGeneratedTestData(testData, firTestData);
            return;
        }
        this.checkTwoFiles(originalTestData, firTestData, "Original and FIR test data aren't identical. ");
    }

    private final void checkFirAndLatestLVTestData(File latestLVTestData, RegisteredDirectives directives) {
        File firTestData = directives.contains(FirDiagnosticsDirectives.INSTANCE.getTEST_ALONGSIDE_K1_TESTDATA()) && !directives.contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL()) ? CustomTestDataUtilsKt.getFirTestDataFile(latestLVTestData) : CustomTestDataUtilsKt.getOriginalTestDataFile(latestLVTestData);
        this.checkTwoFiles(firTestData, latestLVTestData, "Original and Latest Stable LV testdata aren't identical. ");
    }

    private final void checkTwoFiles(File originalTestData, File secondTestData, String message) {
        String secondPreprocessedTextData = this.preprocessSource(secondTestData);
        String originalPreprocessedTextData = this.preprocessSource(originalTestData);
        AssertionsKt.getAssertions(this.getTestServices()).assertEquals(secondPreprocessedTextData, originalPreprocessedTextData, (Function0<String>)((Function0)() -> FirTestDataConsistencyHandler.checkTwoFiles$lambda$0(message, originalTestData, secondTestData)));
    }

    private final String preprocessSource(File $this$preprocessSource) {
        SourceFileProvider sourceFileProvider = SourceFileProviderKt.getSourceFileProvider(this.getTestServices());
        String string = $this$preprocessSource.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String content = sourceFileProvider.getContentOfSourceFile(new TestFile(string, ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)$this$preprocessSource, null, (int)1, null))).toString(), $this$preprocessSource, 0, false, RegisteredDirectives.Companion.getEmpty()));
        if (!Intrinsics.areEqual((Object)System.lineSeparator(), (Object)"\n")) {
            return StringsKt.replace$default((String)content, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
        }
        return content;
    }

    private final void runFirTestAndGeneratedTestData(File testData, File firTestData) {
        FilesKt.writeText$default((File)firTestData, (String)this.preprocessSource(testData), null, (int)2, null);
        AbstractKotlinCompilerTest test = this.correspondingFirTest();
        test.initTestInfo(KotlinTestInfo.copy$default(KotlinTestInfoKt.getTestInfo(this.getTestServices()), KotlinTestInfoKt.getTestInfo(this.getTestServices()).getClassName() + "_fir_anonymous", null, null, 6, null));
        String string = firTestData.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        test.runTest(string);
    }

    @NotNull
    protected AbstractKotlinCompilerTest correspondingFirTest() {
        return StringsKt.contains$default((CharSequence)KotlinTestInfoKt.getTestInfo(this.getTestServices()).getClassName(), (CharSequence)"Backend", (boolean)false, (int)2, null) ? (AbstractKotlinCompilerTest)new AbstractFirPsiDiagnosticsTestWithJvmIrBackend(){} : (AbstractKotlinCompilerTest)new AbstractFirPsiDiagnosticTest(){};
    }

    private static final String checkTwoFiles$lambda$0(String $message, File $originalTestData, File $secondTestData) {
        return $message + "Please, add changes from " + $originalTestData.getName() + " to " + $secondTestData.getName();
    }
}

