/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.codeMetaInfo.model.DiagnosticCodeMetaInfo;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.platform.JsPlatformKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicMetaInfoUtils;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.TargetPlatformProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J2\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticReporter;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "globalMetadataInfoHandler", "Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "getGlobalMetadataInfoHandler", "()Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "createConfiguration", "Lorg/jetbrains/kotlin/checkers/utils/DiagnosticsRenderingConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "reportDiagnostic", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "configuration", "withNewInferenceModeEnabled", "", "toMetaInfo", "", "Lorg/jetbrains/kotlin/codeMetaInfo/model/DiagnosticCodeMetaInfo;", "newInferenceEnabled", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nClassicDiagnosticReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassicDiagnosticReporter.kt\norg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1563#2:105\n1634#2,2:106\n1761#2,3:108\n1636#2:111\n*S KotlinDebug\n*F\n+ 1 ClassicDiagnosticReporter.kt\norg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticReporter\n*L\n59#1:105\n59#1:106,2\n75#1:108,3\n59#1:111\n*E\n"})
public final class ClassicDiagnosticReporter {
    @NotNull
    private final TestServices testServices;

    public ClassicDiagnosticReporter(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
    }

    private final GlobalMetadataInfoHandler getGlobalMetadataInfoHandler() {
        return GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.testServices);
    }

    @NotNull
    public final DiagnosticsRenderingConfiguration createConfiguration(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return new DiagnosticsRenderingConfiguration(null, module.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference), module.getLanguageVersionSettings(), true);
    }

    public final void reportDiagnostic(@NotNull Diagnostic diagnostic, @NotNull TestModule module, @NotNull TestFile file, @NotNull DiagnosticsRenderingConfiguration configuration2, boolean withNewInferenceModeEnabled) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        this.getGlobalMetadataInfoHandler().addMetadataInfosForFile(file, this.toMetaInfo(diagnostic, module, file, configuration2.getWithNewInference(), withNewInferenceModeEnabled));
    }

    /*
     * WARNING - void declaration
     */
    private final List<DiagnosticCodeMetaInfo> toMetaInfo(Diagnostic $this$toMetaInfo, TestModule module, TestFile file, boolean newInferenceEnabled, boolean withNewInferenceModeEnabled) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toMetaInfo.getTextRanges();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            boolean bl;
            DiagnosticCodeMetaInfo metaInfo;
            Collection collection;
            block15: {
                void range;
                TextRange textRange = (TextRange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                metaInfo = new DiagnosticCodeMetaInfo((TextRange)range, ClassicMetaInfoUtils.INSTANCE.getRenderDiagnosticNoArgs(), $this$toMetaInfo);
                if (withNewInferenceModeEnabled) {
                    ((Collection)metaInfo.getAttributes()).add(newInferenceEnabled ? "NI" : "OI");
                }
                if (!module.getFiles().contains(file)) {
                    String string;
                    TargetPlatform targetPlatform = TargetPlatformProviderKt.targetPlatform(module, this.testServices);
                    Collection collection2 = metaInfo.getAttributes();
                    if (JvmPlatformKt.isJvm((TargetPlatform)targetPlatform)) {
                        string = "JVM";
                    } else if (JsPlatformKt.isJs((TargetPlatform)targetPlatform)) {
                        string = "JS";
                    } else if (NativePlatformKt.isNative((TargetPlatform)targetPlatform)) {
                        string = "NATIVE";
                    } else if (TargetPlatformKt.isCommon((TargetPlatform)targetPlatform)) {
                        string = "COMMON";
                    } else {
                        throw new IllegalStateException("Should not be here".toString());
                    }
                    collection2.add(string);
                }
                List<ParsedCodeMetaInfo> existing = this.getGlobalMetadataInfoHandler().getExistingMetaInfosForActualMetadata(file, metaInfo);
                Iterable $this$any$iv = existing;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ParsedCodeMetaInfo it = (ParsedCodeMetaInfo)element$iv;
                        boolean bl3 = false;
                        if (!(it.getDescription() != null)) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                metaInfo.replaceRenderConfiguration(ClassicMetaInfoUtils.INSTANCE.getRenderDiagnosticWithArgs());
            }
            collection.add(metaInfo);
        }
        return (List)destination$iv$iv;
    }
}

