/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.cli;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.cli.CliArtifact;
import org.jetbrains.kotlin.test.cli.CliDirectives;
import org.jetbrains.kotlin.test.cli.DeprecatedCliFacades;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.handlers.NonSourceErrorMessagesHandler;
import org.jetbrains.kotlin.test.model.BinaryArtifactHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@DeprecatedCliFacades
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/cli/CliOutputHandler;", "Lorg/jetbrains/kotlin/test/model/BinaryArtifactHandler;", "Lorg/jetbrains/kotlin/test/cli/CliArtifact;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "multiModuleInfoDumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "delegateHandler", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/NonSourceErrorMessagesHandler;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "processAfterAllModules", "someAssertionWasFailed", "", "tests-common-new_test"})
public final class CliOutputHandler
extends BinaryArtifactHandler<CliArtifact> {
    @NotNull
    private final MultiModuleInfoDumper multiModuleInfoDumper;
    @NotNull
    private final NonSourceErrorMessagesHandler delegateHandler;

    public CliOutputHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, CliArtifact.Kind.INSTANCE, false, true);
        this.multiModuleInfoDumper = new MultiModuleInfoDumper(null, 1, null);
        this.delegateHandler = new NonSourceErrorMessagesHandler(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull CliArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (((CharSequence)info.getKotlinOutput()).length() == 0) {
            return;
        }
        if (!module.getDirectives().contains(CliDirectives.INSTANCE.getCHECK_COMPILER_OUTPUT())) {
            return;
        }
        this.multiModuleInfoDumper.builderForModule(module).append(info.getKotlinOutput());
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        this.delegateHandler.check(this.multiModuleInfoDumper.generateResultingDump());
    }
}

