/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeOptions;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.backend.handlers.IrTextDumpHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.BackendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0001.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0016J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0014\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001bH\u0016J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020&H\u0002J\u0012\u0010,\u001a\u00020&2\b\b\u0002\u0010-\u001a\u00020\u001bH\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR0\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00110\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\u0018j\u0002`\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "artifactKind", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/BackendKind;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "additionalAfterAnalysisCheckers", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "Lorg/jetbrains/kotlin/test/Constructor;", "getAdditionalAfterAnalysisCheckers", "baseDumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "buildersForSeparateFileDumps", "", "Ljava/io/File;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "byteCodeListingEnabled", "", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "compareDumpsOfExternalClasses", "findExternalClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "externalClassId", "", "processAfterAllModules", "someAssertionWasFailed", "checkOneExpectedFile", "expectedFile", "actualDump", "getDumpExtension", "ignoreFirIdentical", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrTextDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1563#2:196\n1634#2,3:197\n1869#2,2:200\n1#3:202\n*S KotlinDebug\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler\n*L\n158#1:196\n158#1:197,3\n179#1:200,2\n*E\n"})
public final class IrTextDumpHandler
extends AbstractIrHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumper baseDumper;
    @NotNull
    private final Map<File, StringBuilder> buildersForSeparateFileDumps;
    private boolean byteCodeListingEnabled;
    @NotNull
    public static final String DUMP_EXTENSION = "ir.txt";
    @NotNull
    public static final String DUMP_EXTENSION2 = "ir2.txt";
    @NotNull
    private static final Set<Name> HIDDEN_ENUM_METHOD_NAMES;

    public IrTextDumpHandler(@NotNull TestServices testServices, @NotNull BackendKind<IrBackendInput> artifactKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        super(testServices, artifactKind, false, false, 12, null);
        this.baseDumper = new MultiModuleInfoDumper(null, 1, null);
        this.buildersForSeparateFileDumps = new LinkedHashMap();
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        Object[] objectArray = new SimpleDirectivesContainer[]{CodegenTestDirectives.INSTANCE, FirDiagnosticsDirectives.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Function1<TestServices, AfterAnalysisChecker>> getAdditionalAfterAnalysisCheckers() {
        return CollectionsKt.listOf((Object)((Object)additionalAfterAnalysisCheckers.1.INSTANCE));
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        boolean bl = this.byteCodeListingEnabled = this.byteCodeListingEnabled || module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getCHECK_BYTECODE_LISTING());
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR())) {
            return;
        }
        List<Pair<Pair<TestModule, TestFile>, IrFile>> testFileToIrFile = Companion.groupWithTestFiles(info.getIrModuleFragment().getFiles(), this.getTestServices(), true);
        DumpIrTreeOptions.FlagsFilter flagsFilter = IrTextDumpHandler::processModule$lambda$1;
        DumpIrTreeOptions dumpOptions = new DumpIrTreeOptions(true, true, false, false, false, flagsFilter, false, false, false, false, false, false, false, false, false, false, false, false, null, arg_0 -> IrTextDumpHandler.processModule$lambda$2(info, arg_0), (arg_0, arg_1) -> IrTextDumpHandler.processModule$lambda$3(testFileToIrFile, this, arg_0, arg_1), false, false, null, 15204044, null);
        StringBuilder builder = this.baseDumper.builderForModule(module.getName());
        for (Pair<Pair<TestModule, TestFile>, IrFile> pair : testFileToIrFile) {
            Pair moduleAndFile = (Pair)pair.component1();
            IrFile irFile = (IrFile)pair.component2();
            Object object = moduleAndFile;
            if (object != null && (object = (TestFile)object.getSecond()) != null && (object = ((TestFile)object).getDirectives()) != null ? ((RegisteredDirectives)object).contains(CodegenTestDirectives.INSTANCE.getEXTERNAL_FILE()) : false) continue;
            String actualDump = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)0, (DumpIrTreeOptions)dumpOptions);
            builder.append(actualDump);
        }
        this.compareDumpsOfExternalClasses(module, info);
    }

    /*
     * WARNING - void declaration
     */
    private final void compareDumpsOfExternalClasses(TestModule module, IrBackendInput info) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<String> externalClassIds = module.getDirectives().get(CodegenTestDirectives.INSTANCE.getDUMP_EXTERNAL_CLASS());
        if (externalClassIds.isEmpty()) {
            return;
        }
        DumpIrTreeOptions dumpOptions = new DumpIrTreeOptions(false, true, false, false, false, null, false, false, false, false, false, false, false, false, false, false, false, false, null, null, null, false, false, null, 0xFFFBFD, null);
        File baseFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        Iterable iterable = externalClassIds;
        Assertions assertions = this.getAssertions();
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void externalClassId;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(() -> IrTextDumpHandler.compareDumpsOfExternalClasses$lambda$5$lambda$4(this, info, (String)externalClassId, dumpOptions, baseFile));
        }
        assertions.assertAll((List)destination$iv$iv);
    }

    private final IrClass findExternalClass(IrPluginContext $this$findExternalClass, String externalClassId) {
        ClassId classId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)externalClassId, (boolean)false, (int)2, null);
        IrClassSymbol irClassSymbol = $this$findExternalClass.referenceClass(classId);
        if (irClassSymbol == null || (irClassSymbol = (IrClass)irClassSymbol.getOwner()) == null) {
            this.getAssertions().fail((Function0<String>)((Function0)() -> IrTextDumpHandler.findExternalClass$lambda$6(externalClassId)));
            throw new KotlinNothingValueException();
        }
        return irClassSymbol;
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.getTestServices());
        File defaultExpectedFile = FileUtilsKt.withExtension((File)CollectionsKt.first(moduleStructure.getOriginalTestDataFiles()), IrTextDumpHandler.getDumpExtension$default(this, false, 1, null));
        this.checkOneExpectedFile(defaultExpectedFile, this.baseDumper.generateResultingDump());
        Iterable $this$forEach$iv = this.buildersForSeparateFileDumps.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            File expectedFile = (File)entry.getKey();
            StringBuilder dump = (StringBuilder)entry.getValue();
            String string = dump.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.checkOneExpectedFile(expectedFile, string);
        }
    }

    private final void checkOneExpectedFile(File expectedFile, String actualDump) {
        if (((CharSequence)actualDump).length() > 0) {
            Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualDump, null, 4, null);
        } else {
            HandlerUtilsKt.assertFileDoesntExist(this.getAssertions(), expectedFile, CodegenTestDirectives.INSTANCE.getDUMP_IR());
        }
    }

    private final String getDumpExtension(boolean ignoreFirIdentical) {
        return Companion.computeDumpExtension(this.getTestServices(), this.byteCodeListingEnabled ? DUMP_EXTENSION2 : DUMP_EXTENSION, ignoreFirIdentical);
    }

    static /* synthetic */ String getDumpExtension$default(IrTextDumpHandler irTextDumpHandler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return irTextDumpHandler.getDumpExtension(bl);
    }

    private static final List processModule$lambda$1(IrDeclaration declaration, boolean isReference, List flags) {
        List list;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        List it = list = flags;
        boolean bl = false;
        List list2 = !isReference || declaration instanceof IrField || declaration instanceof IrClass ? list : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private static final boolean processModule$lambda$2(IrBackendInput $info, IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.isHiddenDeclaration(it, $info.getIrPluginContext().getIrBuiltIns());
    }

    private static final String processModule$lambda$3(List $testFileToIrFile, IrTextDumpHandler this$0, IrFile irFile, String fullPath) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
        return Companion.renderFilePathForIrFile($testFileToIrFile, this$0.getTestServices(), irFile, fullPath);
    }

    private static final Unit compareDumpsOfExternalClasses$lambda$5$lambda$4(IrTextDumpHandler this$0, IrBackendInput $info, String $externalClassId, DumpIrTreeOptions $dumpOptions, File $baseFile) {
        String classDump = DumpIrTreeKt.dump((IrElement)((IrElement)this$0.findExternalClass($info.getIrPluginContext(), $externalClassId)), (DumpIrTreeOptions)$dumpOptions);
        String suffix = ".__" + StringsKt.replace$default((String)$externalClassId, (String)"/", (String)".", (boolean)false, (int)4, null);
        File expectedFile = FileUtilsKt.withSuffixAndExtension($baseFile, suffix, this$0.getDumpExtension(true));
        Assertions.assertEqualsToFile$default(this$0.getAssertions(), expectedFile, classDump, null, 4, null);
        return Unit.INSTANCE;
    }

    private static final String findExternalClass$lambda$6(String $externalClassId) {
        return "Can't find a class in external dependencies: " + $externalClassId;
    }

    static {
        Object[] objectArray = new Name[]{Name.identifier((String)"finalize"), Name.identifier((String)"getDeclaringClass"), Name.identifier((String)"clone")};
        HIDDEN_ENUM_METHOD_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fJB\u0010\r\u001a\"\u0012\u001e\u0012\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00120\u000f0\u000e*\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0013\u001a\u00020\fJ\u0014\u0010\u0018\u001a\u00020\f*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bJF\u0010\u001f\u001a\u00020\u00052&\u0010 \u001a\"\u0012\u001e\u0012\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00120\u000f0\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0014\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion;", "", "<init>", "()V", "DUMP_EXTENSION", "", "DUMP_EXTENSION2", "computeDumpExtension", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "defaultExtension", "ignoreFirIdentical", "", "groupWithTestFiles", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/test/model/TestFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "ordered", "HIDDEN_ENUM_METHOD_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/jvm/internal/EnhancedNullability;", "isHiddenEnumMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "isHiddenDeclaration", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "renderFilePathForIrFile", "testFileToIrFile", "irFile", "fullPath", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nIrTextDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,195:1\n1617#2,9:196\n1869#2:205\n295#2,2:206\n1870#2:209\n1626#2:210\n1056#2:212\n1761#2,3:213\n295#2,2:216\n1#3:208\n276#4:211\n*S KotlinDebug\n*F\n+ 1 IrTextDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTextDumpHandler$Companion\n*L\n64#1:196,9\n64#1:205\n67#1:206,2\n64#1:209\n64#1:210\n72#1:212\n87#1:213,3\n101#1:216,2\n64#1:208\n71#1:211\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String computeDumpExtension(@NotNull TestServices testServices, @NotNull String defaultExtension, boolean ignoreFirIdentical) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)defaultExtension, (String)"defaultExtension");
            return Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(testServices).getFrontendKind(), (Object)FrontendKinds.ClassicFrontend.INSTANCE) || !ignoreFirIdentical && TestModuleStructureKt.getModuleStructure(testServices).getAllDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL()) ? defaultExtension : "fir." + defaultExtension;
        }

        public static /* synthetic */ String computeDumpExtension$default(Companion companion, TestServices testServices, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.computeDumpExtension(testServices, string, bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<Pair<TestModule, TestFile>, IrFile>> groupWithTestFiles(@NotNull List<? extends IrFile> $this$groupWithTestFiles, @NotNull TestServices testServices, boolean ordered) {
            List list;
            void $this$applyIf$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter($this$groupWithTestFiles, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            Iterable $this$mapNotNull$iv = $this$groupWithTestFiles;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair it$iv$iv;
                Pair moduleAndFile;
                IrFile irFile;
                block6: {
                    Pair pair;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    irFile = (IrFile)element$iv$iv;
                    boolean bl2 = false;
                    String name = new File(irFile.getFileEntry().getName()).getName();
                    for (TestModule module : (Iterable)TestModuleStructureKt.getModuleStructure(testServices).getModules()) {
                        TestFile file;
                        Pair pair2;
                        Object v0;
                        block5: {
                            boolean bl3 = false;
                            Iterable $this$firstOrNull$iv = module.getFiles();
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                TestFile it = (TestFile)element$iv;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                                v0 = element$iv;
                                break block5;
                            }
                            v0 = null;
                        }
                        if ((pair2 = (TestFile)v0 == null ? null : TuplesKt.to((Object)module, (Object)file)) == null) continue;
                        pair = pair2;
                        break block6;
                    }
                    pair = moduleAndFile = null;
                }
                if (TuplesKt.to(moduleAndFile, (Object)irFile) == null) continue;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$applyIf = false;
            if (ordered) {
                void $this$groupWithTestFiles_u24lambda_u244 = $this$applyIf$iv;
                boolean bl = false;
                Iterable $this$sortedBy$iv = (Iterable)$this$groupWithTestFiles_u24lambda_u244;
                boolean $i$f$sortedBy = false;
                list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(testServices){
                    final /* synthetic */ TestServices $testServices$inlined;
                    {
                        this.$testServices$inlined = testServices;
                    }

                    public final int compare(T a, T b) {
                        String string;
                        TestModule module;
                        String string2;
                        Pair pair = (Pair)a;
                        boolean bl = false;
                        Pair moduleAndFile = (Pair)pair.component1();
                        IrFile irFile = (IrFile)pair.component2();
                        String pathFromIrFile = irFile.getFileEntry().getName();
                        Pair pair2 = moduleAndFile;
                        if (pair2 == null) {
                            string2 = pathFromIrFile;
                        } else {
                            module = (TestModule)pair2.component1();
                            string2 = StringsKt.removePrefix((String)pathFromIrFile, (CharSequence)SourceFileProviderKt.independentSourceDirectoryPath(module, this.$testServices$inlined));
                        }
                        pair = (Pair)b;
                        Comparable comparable = (Comparable)((Object)string2);
                        bl = false;
                        moduleAndFile = (Pair)pair.component1();
                        irFile = (IrFile)pair.component2();
                        pathFromIrFile = irFile.getFileEntry().getName();
                        Pair pair3 = moduleAndFile;
                        if (pair3 == null) {
                            string = pathFromIrFile;
                        } else {
                            module = (TestModule)pair3.component1();
                            string = StringsKt.removePrefix((String)pathFromIrFile, (CharSequence)SourceFileProviderKt.independentSourceDirectoryPath(module, this.$testServices$inlined));
                        }
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                });
            } else {
                list = $this$applyIf$iv;
            }
            return list;
        }

        public static /* synthetic */ List groupWithTestFiles$default(Companion companion, List list, TestServices testServices, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.groupWithTestFiles(list, testServices, bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isHiddenEnumMethod(IrSimpleFunction $this$isHiddenEnumMethod, IrBuiltIns irBuiltIns) {
            boolean bl;
            if (!$this$isHiddenEnumMethod.isFakeOverride()) return false;
            Iterable $this$any$iv = IrUtilsKt.allOverridden((IrOverridableDeclaration)((IrOverridableDeclaration)$this$isHiddenEnumMethod), (boolean)true);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl2 = false;
                IrValueParameter irValueParameter = it.getDispatchReceiverParameter();
                if (Intrinsics.areEqual((Object)(irValueParameter != null && (irValueParameter = irValueParameter.getType()) != null ? IrTypesKt.getClassOrNull((IrType)irValueParameter) : null), (Object)irBuiltIns.getEnumClass()) && HIDDEN_ENUM_METHOD_NAMES.contains(it.getName())) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public final boolean isHiddenDeclaration(@NotNull IrDeclaration declaration, @NotNull IrBuiltIns irBuiltIns) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
            IrSimpleFunction irSimpleFunction = declaration instanceof IrSimpleFunction ? (IrSimpleFunction)declaration : null;
            return irSimpleFunction != null ? this.isHiddenEnumMethod(irSimpleFunction, irBuiltIns) : false;
        }

        @NotNull
        public final String renderFilePathForIrFile(@NotNull List<? extends Pair<Pair<TestModule, TestFile>, ? extends IrFile>> testFileToIrFile, @NotNull TestServices testServices, @NotNull IrFile irFile, @NotNull String fullPath) {
            Pair pair;
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter(testFileToIrFile, (String)"testFileToIrFile");
                Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
                Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
                Intrinsics.checkNotNullParameter((Object)fullPath, (String)"fullPath");
                Iterable $this$firstOrNull$iv = testFileToIrFile;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSecond(), (Object)irFile)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            if ((pair = (Pair)v0) == null || (pair = (Pair)pair.getFirst()) == null) {
                return fullPath;
            }
            TestModule correspondingModule = (TestModule)pair.component1();
            return StringsKt.removePrefix((String)fullPath, (CharSequence)SourceFileProviderKt.independentSourceDirectoryPath(correspondingModule, testServices));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

