/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.D8Checker;
import org.jetbrains.kotlin.test.backend.BlackBoxCodegenSuppressorKt;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/DxCheckerHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "processAfterAllModules", "someAssertionWasFailed", "", "tests-common-new_test"})
public final class DxCheckerHandler
extends JvmBinaryArtifactHandler {
    public DxCheckerHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getRUN_DEX_CHECKER()) || module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_DEXING())) {
            return;
        }
        try {
            D8Checker.check(info.getClassFileFactory());
        }
        catch (Throwable e) {
            if (!AssertionsKt.getAssertions(this.getTestServices()).isTeamCityBuild() && !BlackBoxCodegenSuppressorKt.getCodegenSuppressionChecker(this.getTestServices()).failuresInModuleAreIgnored(module)) {
                try {
                    System.out.println((Object)info.getClassFileFactory().createText());
                }
                catch (Throwable e1) {
                    System.err.println("Exception thrown while trying to generate text:");
                    e1.printStackTrace();
                    System.err.println("---");
                }
            }
            throw e;
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

