/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.MuteWithDatabaseJunit5Kt;
import org.jetbrains.kotlin.test.mutes.AutoMute;
import org.jetbrains.kotlin.test.mutes.AutoMuteKt;
import org.jetbrains.kotlin.test.mutes.MuteWithDatabaseWrapperKt;
import org.jetbrains.kotlin.test.mutes.MutedTest;
import org.jetbrains.kotlin.test.mutes.MutedTestKt;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000f\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/test/MuteInInvocationInterceptor;", "Lorg/junit/jupiter/api/extension/InvocationInterceptor;", "<init>", "()V", "interceptTestTemplateMethod", "", "invocation", "Lorg/junit/jupiter/api/extension/InvocationInterceptor$Invocation;", "Ljava/lang/Void;", "invocationContext", "Lorg/junit/jupiter/api/extension/ReflectiveInvocationContext;", "Ljava/lang/reflect/Method;", "extensionContext", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "interceptTestMethod", "interceptWithMuteInDatabase", "mutes-junit5"})
public final class MuteInInvocationInterceptor
implements InvocationInterceptor {
    public void interceptTestTemplateMethod(@NotNull InvocationInterceptor.Invocation<Void> invocation, @NotNull ReflectiveInvocationContext<Method> invocationContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        Intrinsics.checkNotNullParameter(invocationContext, (String)"invocationContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        this.interceptWithMuteInDatabase(invocation, extensionContext);
    }

    public void interceptTestMethod(@NotNull InvocationInterceptor.Invocation<Void> invocation, @NotNull ReflectiveInvocationContext<Method> invocationContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        Intrinsics.checkNotNullParameter(invocationContext, (String)"invocationContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        this.interceptWithMuteInDatabase(invocation, extensionContext);
    }

    private final void interceptWithMuteInDatabase(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) {
        Class testClass = MuteWithDatabaseJunit5Kt.access$getTestClassNullable(extensionContext);
        Method testMethod = MuteWithDatabaseJunit5Kt.access$getTestMethodNullable(extensionContext);
        if (testClass != null && testMethod != null) {
            String string = testMethod.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            MutedTest mutedTest = MutedTestKt.getMutedTest(testClass, string);
            if (mutedTest != null && MuteWithDatabaseWrapperKt.isPresentedInDatabaseWithoutFailMarker(mutedTest)) {
                if (!mutedTest.isFlaky()) {
                    Function0 function0 = () -> MuteInInvocationInterceptor.interceptWithMuteInDatabase$lambda$0(invocation);
                    Class<?> clazz = testMethod.getDeclaringClass();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"getDeclaringClass(...)");
                    MuteWithDatabaseWrapperKt.invertMutedTestResultWithLog((Function0<Unit>)function0, MuteWithDatabaseWrapperKt.testKey(clazz, mutedTest.getMethodKey()));
                    return;
                }
                AutoMute autoMute = AutoMuteKt.getDO_AUTO_MUTE();
                String string2 = extensionContext.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
                if (autoMute.isMuted(MuteWithDatabaseWrapperKt.testKey(testClass, string2))) {
                    AutoMute autoMute2 = AutoMuteKt.getDO_AUTO_MUTE();
                    String string3 = extensionContext.getDisplayName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDisplayName(...)");
                    autoMute2.muted(MuteWithDatabaseWrapperKt.testKey(testClass, string3));
                    invocation.skip();
                    return;
                }
                invocation.proceed();
                return;
            }
        }
        invocation.proceed();
    }

    private static final Unit interceptWithMuteInDatabase$lambda$0(InvocationInterceptor.Invocation $invocation) {
        $invocation.proceed();
        return Unit.INSTANCE;
    }
}

