/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J'\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0007\u0082\u0002\n\n\b\b\u0000\u001a\u0004\b\u0003\u0010\u0002J'\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0007\u0082\u0002\n\n\b\b\u0000\u001a\u0004\b\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\rH\u0007J+\u0010\u000e\u001a\u00020\t\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u0002H\u000f2\u0006\u0010\u0011\u001a\u0002H\u000fH\u0007\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/KtAssert;", "", "<init>", "()V", "fail", "", "message", "", "assertNotNull", "", "value", "assertNull", "assertTrue", "", "assertEquals", "T", "expected", "actual", "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V", "test-infrastructure-utils_test"})
public final class KtAssert {
    @NotNull
    public static final KtAssert INSTANCE = new KtAssert();

    private KtAssert() {
    }

    @JvmStatic
    @NotNull
    public static final Void fail(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new AssertionError((Object)message);
    }

    @JvmStatic
    public static final void assertNotNull(@NotNull String message, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (value == null) {
            KtAssert.fail(message);
            throw new KotlinNothingValueException();
        }
    }

    @JvmStatic
    public static final void assertNull(@NotNull String message, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (value != null) {
            KtAssert.fail(message);
            throw new KotlinNothingValueException();
        }
    }

    @JvmStatic
    public static final void assertTrue(@NotNull String message, boolean value) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!value) {
            KtAssert.fail(message);
            throw new KotlinNothingValueException();
        }
    }

    @JvmStatic
    public static final <T> void assertEquals(@NotNull String message, T expected, T actual) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!Intrinsics.areEqual(expected, actual)) {
            KtAssert.fail(message);
            throw new KotlinNothingValueException();
        }
    }
}

