/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.JavaCompilationResult;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a2\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004H\u0007\u001a.\u0010\t\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"compileJavaFiles", "Lorg/jetbrains/kotlin/test/JavaCompilationResult;", "files", "", "Ljava/io/File;", "options", "", "", "jdkHome", "compileJavaFilesExternally", "errorsToString", "diagnosticCollector", "Ljavax/tools/DiagnosticCollector;", "Ljavax/tools/JavaFileObject;", "humanReadable", "", "tests-compiler-utils_test"})
@JvmName(name="JvmCompilationUtils")
public final class JvmCompilationUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public static final JavaCompilationResult compileJavaFiles(@NotNull Collection<? extends File> files, @NotNull List<String> options, @Nullable File jdkHome) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        if (jdkHome != null) {
            return JvmCompilationUtils.compileJavaFilesExternally(files, options, jdkHome);
        }
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
        Closeable closeable = javaCompiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diagnosticCollector, Locale.ENGLISH, Charset.forName("utf-8"));
        Throwable throwable = null;
        try {
            JavaCompilationResult javaCompilationResult;
            StandardJavaFileManager fileManager = (StandardJavaFileManager)closeable;
            boolean bl = false;
            Iterable<? extends JavaFileObject> javaFileObjectsFromFiles = fileManager.getJavaFileObjectsFromFiles((Iterable<? extends File>)files);
            JavaCompiler.CompilationTask task = javaCompiler.getTask(new StringWriter(), fileManager, (DiagnosticListener<? super JavaFileObject>)diagnosticCollector, (Iterable<String>)options, null, javaFileObjectsFromFiles);
            Boolean bl2 = task.call();
            if (Intrinsics.areEqual((Object)bl2, (Object)true)) {
                javaCompilationResult = JavaCompilationResult.Success.INSTANCE;
            } else if (Intrinsics.areEqual((Object)bl2, (Object)false)) {
                javaCompilationResult = new JavaCompilationResult.Failure.InProcess(diagnosticCollector);
            } else {
                if (bl2 == null) {
                    throw new IllegalStateException("JavaCompiler call() returned null".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            JavaCompilationResult javaCompilationResult2 = javaCompilationResult;
            return javaCompilationResult2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ JavaCompilationResult compileJavaFiles$default(Collection collection, List list, File file, int n, Object object) {
        if ((n & 4) != 0) {
            file = null;
        }
        return JvmCompilationUtils.compileJavaFiles(collection, list, file);
    }

    private static final JavaCompilationResult compileJavaFilesExternally(Collection<? extends File> files, List<String> options, File jdkHome) {
        JavaCompilationResult javaCompilationResult;
        List command = new ArrayList();
        command.add(new File(jdkHome, "bin/javac").getPath());
        command.addAll((Collection)options);
        for (File file : files) {
            command.add(file.getPath());
        }
        Process process = new ProcessBuilder(new String[0]).command(command).start();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String errors = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
        process.waitFor();
        if (process.exitValue() == 0) {
            javaCompilationResult = JavaCompilationResult.Success.INSTANCE;
        } else {
            Intrinsics.checkNotNull((Object)errors);
            javaCompilationResult = new JavaCompilationResult.Failure.External(errors);
        }
        return javaCompilationResult;
    }

    private static final String errorsToString(DiagnosticCollector<JavaFileObject> diagnosticCollector, boolean humanReadable) {
        StringBuilder builder = new StringBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : diagnosticCollector.getDiagnostics()) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            StringBuilder stringBuilder = humanReadable ? builder.append(diagnostic).append("\n") : builder.append(new File(((FileObject)diagnostic.getSource()).toUri()).getName()).append(":").append(diagnostic.getLineNumber()).append(":").append(diagnostic.getColumnNumber()).append(":").append(diagnostic.getCode()).append("\n");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmOverloads
    @NotNull
    public static final JavaCompilationResult compileJavaFiles(@NotNull Collection<? extends File> files, @NotNull List<String> options) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return JvmCompilationUtils.compileJavaFiles$default(files, options, null, 4, null);
    }

    public static final /* synthetic */ String access$errorsToString(DiagnosticCollector diagnosticCollector, boolean humanReadable) {
        return JvmCompilationUtils.errorsToString(diagnosticCollector, humanReadable);
    }
}

