/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000eJ.\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000eH&J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000eJ<\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H&J\u001c\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0012J.\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012H&J.\u0010\u0018\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012H&J\"\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00052\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012H&J\"\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00052\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012H&J$\u0010\u001c\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012H&J:\u0010\u001d\u001a\u00020\b\"\u0004\b\u0000\u0010\u001e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012H&J3\u0010 \u001a\u00020\b\"\u0004\b\u0000\u0010\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001f2\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001e0\"\"\u0002H\u001e\u00a2\u0006\u0002\u0010#J(\u0010 \u001a\u00020\b\"\u0004\b\u0000\u0010\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001fJ\u0012\u0010$\u001a\u00020\f2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030%J\u0016\u0010&\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H&J\u001c\u0010*\u001a\u00020\b2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00120(H&J+\u0010*\u001a\u00020\b2\u001e\u0010+\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\b0\u00120\"\"\b\u0012\u0004\u0012\u00020\b0\u0012\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\u00020.2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/test/Assertions;", "", "<init>", "()V", "isTeamCityBuild", "", "()Z", "assertEqualsToFile", "", "expectedFile", "Ljava/io/File;", "actual", "", "sanitizer", "Lkotlin/Function1;", "doesEqualToFile", "Ljava/nio/file/Path;", "message", "Lkotlin/Function0;", "assertFileDoesntExist", "file", "errorMessage", "assertEquals", "expected", "assertNotEquals", "assertTrue", "value", "assertFalse", "assertNotNull", "assertSameElements", "T", "", "assertContainsElements", "collection", "", "(Ljava/util/Collection;[Ljava/lang/Object;)V", "renderCollectionToString", "", "failAll", "exceptions", "", "", "assertAll", "conditions", "([Lkotlin/jvm/functions/Function0;)V", "fail", "", "test-infrastructure-utils_test"})
public abstract class Assertions {
    private final boolean isTeamCityBuild = System.getenv("TEAMCITY_VERSION") != null;

    public final boolean isTeamCityBuild() {
        return this.isTeamCityBuild;
    }

    public final void assertEqualsToFile(@NotNull File expectedFile, @NotNull String actual, @NotNull Function1<? super String, String> sanitizer) {
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"sanitizer");
        this.assertEqualsToFile(expectedFile, actual, sanitizer, (Function0<String>)((Function0)Assertions::assertEqualsToFile$lambda$1));
    }

    public static /* synthetic */ void assertEqualsToFile$default(Assertions assertions, File file, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertEqualsToFile");
        }
        if ((n & 4) != 0) {
            function1 = Assertions::assertEqualsToFile$lambda$0;
        }
        assertions.assertEqualsToFile(file, string, (Function1<? super String, String>)function1);
    }

    public abstract boolean doesEqualToFile(@NotNull File var1, @NotNull String var2, @NotNull Function1<? super String, String> var3);

    public static /* synthetic */ boolean doesEqualToFile$default(Assertions assertions, File file, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doesEqualToFile");
        }
        if ((n & 4) != 0) {
            function1 = Assertions::doesEqualToFile$lambda$2;
        }
        return assertions.doesEqualToFile(file, string, (Function1<? super String, String>)function1);
    }

    public final void assertEqualsToFile(@NotNull Path expectedFile, @NotNull String actual, @NotNull Function1<? super String, String> sanitizer) {
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"sanitizer");
        File file = expectedFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        this.assertEqualsToFile(file, actual, sanitizer);
    }

    public static /* synthetic */ void assertEqualsToFile$default(Assertions assertions, Path path, String string, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertEqualsToFile");
        }
        if ((n & 4) != 0) {
            function1 = Assertions::assertEqualsToFile$lambda$3;
        }
        assertions.assertEqualsToFile(path, string, (Function1<? super String, String>)function1);
    }

    public abstract void assertEqualsToFile(@NotNull File var1, @NotNull String var2, @NotNull Function1<? super String, String> var3, @NotNull Function0<String> var4);

    public static /* synthetic */ void assertEqualsToFile$default(Assertions assertions, File file, String string, Function1 function1, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertEqualsToFile");
        }
        if ((n & 4) != 0) {
            function1 = Assertions::assertEqualsToFile$lambda$4;
        }
        assertions.assertEqualsToFile(file, string, (Function1<? super String, String>)function1, (Function0<String>)function0);
    }

    public final void assertFileDoesntExist(@NotNull File file, @NotNull Function0<String> errorMessage) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(errorMessage, (String)"errorMessage");
        if (file.exists()) {
            if (!this.isTeamCityBuild) {
                file.delete();
            }
            this.fail(errorMessage);
            throw new KotlinNothingValueException();
        }
    }

    public abstract void assertEquals(@Nullable Object var1, @Nullable Object var2, @Nullable Function0<String> var3);

    public static /* synthetic */ void assertEquals$default(Assertions assertions, Object object, Object object2, Function0 function0, int n, Object object3) {
        if (object3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertEquals");
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        assertions.assertEquals(object, object2, (Function0<String>)function0);
    }

    public abstract void assertNotEquals(@Nullable Object var1, @Nullable Object var2, @Nullable Function0<String> var3);

    public static /* synthetic */ void assertNotEquals$default(Assertions assertions, Object object, Object object2, Function0 function0, int n, Object object3) {
        if (object3 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertNotEquals");
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        assertions.assertNotEquals(object, object2, (Function0<String>)function0);
    }

    public abstract void assertTrue(boolean var1, @Nullable Function0<String> var2);

    public static /* synthetic */ void assertTrue$default(Assertions assertions, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertTrue");
        }
        if ((n & 2) != 0) {
            function0 = null;
        }
        assertions.assertTrue(bl, (Function0<String>)function0);
    }

    public abstract void assertFalse(boolean var1, @Nullable Function0<String> var2);

    public static /* synthetic */ void assertFalse$default(Assertions assertions, boolean bl, Function0 function0, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertFalse");
        }
        if ((n & 2) != 0) {
            function0 = null;
        }
        assertions.assertFalse(bl, (Function0<String>)function0);
    }

    public abstract void assertNotNull(@Nullable Object var1, @Nullable Function0<String> var2);

    public static /* synthetic */ void assertNotNull$default(Assertions assertions, Object object, Function0 function0, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: assertNotNull");
        }
        if ((n & 2) != 0) {
            function0 = null;
        }
        assertions.assertNotNull(object, (Function0<String>)function0);
    }

    public abstract <T> void assertSameElements(@NotNull Collection<? extends T> var1, @NotNull Collection<? extends T> var2, @Nullable Function0<String> var3);

    public final <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        this.assertContainsElements(collection, ArraysKt.toList((Object[])expected));
    }

    public final <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        this.assertSameElements((Collection)copy, expected, (Function0<String>)((Function0)() -> Assertions.assertContainsElements$lambda$5(this, collection)));
    }

    @NotNull
    public final String renderCollectionToString(@NotNull Iterable<?> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        return CollectionsKt.joinToString$default(collection, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    public abstract void failAll(@NotNull List<? extends Throwable> var1);

    public abstract void assertAll(@NotNull List<? extends Function0<Unit>> var1);

    public final void assertAll(Function0<Unit> ... conditions) {
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        this.assertAll(ArraysKt.toList((Object[])conditions));
    }

    @NotNull
    public abstract Void fail(@NotNull Function0<String> var1);

    private static final String assertEqualsToFile$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String assertEqualsToFile$lambda$1() {
        return "Actual data differs from file content";
    }

    private static final String doesEqualToFile$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String assertEqualsToFile$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String assertEqualsToFile$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final String assertContainsElements$lambda$5(Assertions this$0, Collection $collection) {
        return this$0.renderCollectionToString($collection);
    }
}

