/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.generators.util.GeneratorsFileUtil;
import org.jetbrains.kotlin.utils.IndentingPrinter;
import org.jetbrains.kotlin.utils.SmartPrinter;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u001a@\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u001a\u001a\u0010\u000b\u001a\u00020\u0001*\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0004H\u0002\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0002\u001a\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004\u001a(\u0010\u0019\u001a\u00020\u0001*\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0086\b\u00f8\u0001\u0000\"\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"printImports", "", "Lorg/jetbrains/kotlin/utils/SmartPrinter;", "packageName", "", "importableTypes", "", "Lkotlin/reflect/KType;", "simpleImports", "starImports", "collectImports", "collectClassNamesTo", "set", "", "imports", "isDefaultImport", "", "defaultImportedPackages", "", "COPYRIGHT", "printCopyright", "printGeneratedMessage", "getGenerationPath", "Ljava/io/File;", "rootPath", "printBlock", "Lorg/jetbrains/kotlin/utils/IndentingPrinter;", "header", "body", "Lkotlin/Function0;", "generators"})
@SourceDebugExtension(value={"SMAP\nPrinterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrinterUtils.kt\norg/jetbrains/kotlin/generators/util/PrinterUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 IndentingPrinter.kt\norg/jetbrains/kotlin/utils/IndentingPrinterKt\n*L\n1#1,105:1\n1869#2,2:106\n827#2:108\n855#2:109\n856#2:114\n827#2:116\n855#2,2:117\n1803#2,3:119\n389#3,4:110\n1#4:115\n71#5,4:122\n*S KotlinDebug\n*F\n+ 1 PrinterUtils.kt\norg/jetbrains/kotlin/generators/util/PrinterUtilsKt\n*L\n40#1:106,2\n44#1:108\n44#1:109\n44#1:114\n57#1:116\n57#1:117,2\n96#1:119,3\n45#1:110,4\n102#1:122,4\n*E\n"})
public final class PrinterUtilsKt {
    @NotNull
    private static final Set<String> defaultImportedPackages;
    @NotNull
    private static final String COPYRIGHT;

    public static final void printImports(@NotNull SmartPrinter $this$printImports, @NotNull String packageName, @NotNull Collection<? extends KType> importableTypes, @NotNull Collection<String> simpleImports, @NotNull Collection<String> starImports) {
        Intrinsics.checkNotNullParameter((Object)$this$printImports, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(importableTypes, (String)"importableTypes");
        Intrinsics.checkNotNullParameter(simpleImports, (String)"simpleImports");
        Intrinsics.checkNotNullParameter(starImports, (String)"starImports");
        Collection<String> imports = PrinterUtilsKt.collectImports(packageName, importableTypes, simpleImports, starImports);
        if (imports.isEmpty()) {
            return;
        }
        PrinterUtilsKt.printImports($this$printImports, imports);
        $this$printImports.println(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<String> collectImports(String packageName, Collection<? extends KType> importableTypes, Collection<String> simpleImports, Collection<String> starImports) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Iterable iterable;
        Set $this$collectImports_u24lambda_u241 = iterable = SetsKt.createSetBuilder();
        boolean $i$a$-buildSet-PrinterUtilsKt$collectImports$22 = false;
        for (String starImport : starImports) {
            $this$collectImports_u24lambda_u241.add(starImport + ".*");
        }
        Iterable $this$forEach$iv = importableTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KType type = (KType)element$iv;
            boolean bl = false;
            PrinterUtilsKt.collectClassNamesTo(type, $this$collectImports_u24lambda_u241);
        }
        $this$collectImports_u24lambda_u241.addAll(simpleImports);
        iterable = SetsKt.build((Set)iterable);
        boolean $i$f$filterNot = false;
        void $i$a$-buildSet-PrinterUtilsKt$collectImports$22 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String string;
            block4: {
                String importString = (String)element$iv$iv;
                boolean bl = false;
                String $this$dropLastWhile$iv = importString;
                boolean $i$f$dropLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it = $this$dropLastWhile$iv.charAt(index$iv);
                    boolean bl2 = false;
                    if (it != '.') continue;
                    String string2 = $this$dropLastWhile$iv;
                    int n = 0;
                    int n2 = index$iv + 1;
                    String string3 = string2.substring(n, n2);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block4;
                }
                string = "";
            }
            if (Intrinsics.areEqual((Object)string, (Object)(packageName + '.'))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void collectClassNamesTo(KType $this$collectClassNamesTo, Set<String> set) {
        KClassifier kClassifier = $this$collectClassNamesTo.getClassifier();
        Object object = kClassifier instanceof KClass ? (KClass)kClassifier : null;
        if (object != null && (object = object.getQualifiedName()) != null) {
            Object p0 = object;
            boolean bl = false;
            set.add((String)p0);
        }
        for (KTypeProjection argument : $this$collectClassNamesTo.getArguments()) {
            KType kType = argument.getType();
            if (kType == null) continue;
            PrinterUtilsKt.collectClassNamesTo(kType, set);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void printImports(SmartPrinter $this$printImports, Collection<String> imports) {
        void $this$filterNotTo$iv$iv;
        Object[] $this$filterNot$iv = (Object[])imports;
        boolean $i$f$filterNot = false;
        Object[] objectArray = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (PrinterUtilsKt.isDefaultImport(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List importsToPrint = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        for (String string : importsToPrint) {
            objectArray = new Object[]{"import " + string};
            $this$printImports.println(objectArray);
        }
    }

    private static final boolean isDefaultImport(String $this$isDefaultImport) {
        return defaultImportedPackages.contains(StringsKt.substringBeforeLast$default((String)$this$isDefaultImport, (char)'.', null, (int)2, null));
    }

    public static final void printCopyright(@NotNull SmartPrinter $this$printCopyright) {
        Intrinsics.checkNotNullParameter((Object)$this$printCopyright, (String)"<this>");
        Object[] objectArray = new Object[]{COPYRIGHT};
        $this$printCopyright.println(objectArray);
        $this$printCopyright.println(new Object[0]);
    }

    public static final void printGeneratedMessage(@NotNull SmartPrinter $this$printGeneratedMessage) {
        Intrinsics.checkNotNullParameter((Object)$this$printGeneratedMessage, (String)"<this>");
        Object[] objectArray = new Object[]{GeneratorsFileUtil.INSTANCE.getGENERATED_MESSAGE()};
        $this$printGeneratedMessage.println(objectArray);
        $this$printGeneratedMessage.println(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File getGenerationPath(@NotNull File rootPath, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Object object = new String[]{"."};
        Iterable $this$fold$iv = StringsKt.split$default((CharSequence)packageName, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$fold = false;
        File accumulator$iv = rootPath;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            String string = (String)element$iv;
            File p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = FilesKt.resolve((File)p0, (String)p1);
        }
        Object $this$getGenerationPath_u24lambda_u246 = object = accumulator$iv;
        boolean bl = false;
        ((File)$this$getGenerationPath_u24lambda_u246).mkdirs();
        return object;
    }

    public static final void printBlock(@NotNull IndentingPrinter $this$printBlock, @NotNull String header, @NotNull Function0<Unit> body) {
        Intrinsics.checkNotNullParameter((Object)$this$printBlock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        boolean $i$f$printBlock = false;
        Object[] objectArray = new Object[]{header + " {"};
        $this$printBlock.println(objectArray);
        IndentingPrinter $this$withIndent$iv = $this$printBlock;
        boolean $i$f$withIndent = false;
        $this$withIndent$iv.pushIndent();
        body.invoke();
        $this$withIndent$iv.popIndent();
        objectArray = new Object[]{"}"};
        $this$printBlock.println(objectArray);
    }

    public static /* synthetic */ void printBlock$default(IndentingPrinter $this$printBlock_u24default, String header, Function0 body, int n, Object objectArray) {
        if ((n & 1) != 0) {
            header = "";
        }
        Intrinsics.checkNotNullParameter((Object)$this$printBlock_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        boolean $i$f$printBlock = false;
        objectArray = new Object[]{header + " {"};
        $this$printBlock_u24default.println(objectArray);
        IndentingPrinter $this$withIndent$iv = $this$printBlock_u24default;
        boolean $i$f$withIndent = false;
        $this$withIndent$iv.pushIndent();
        body.invoke();
        $this$withIndent$iv.popIndent();
        objectArray = new Object[]{"}"};
        $this$printBlock_u24default.println(objectArray);
    }

    static {
        Object[] objectArray = new String[]{"kotlin", "kotlin.annotation", "kotlin.collections", "kotlin.ranges", "kotlin.sequences", "kotlin.text", "kotlin.io"};
        defaultImportedPackages = SetsKt.setOf((Object[])objectArray);
        COPYRIGHT = FilesKt.readText$default((File)new File("license/COPYRIGHT_HEADER.txt"), null, (int)1, null);
    }
}

