/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators;

import java.lang.reflect.Modifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.generators.model.DefaultTargetBackendComputer;
import org.jetbrains.kotlin.generators.model.TargetBackendComputer;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.runners.RunnerWithTargetBackendForTestGeneratorMarker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/generators/ReflectionBasedTargetBackendComputer;", "Lorg/jetbrains/kotlin/generators/model/TargetBackendComputer;", "<init>", "()V", "runnerMarkerKClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/test/runners/RunnerWithTargetBackendForTestGeneratorMarker;", "compute", "Lorg/jetbrains/kotlin/test/TargetBackend;", "definedTargetBackend", "testKClass", "test-generator_test"})
public final class ReflectionBasedTargetBackendComputer
implements TargetBackendComputer {
    @NotNull
    public static final ReflectionBasedTargetBackendComputer INSTANCE = new ReflectionBasedTargetBackendComputer();
    @NotNull
    private static final Class<RunnerWithTargetBackendForTestGeneratorMarker> runnerMarkerKClass = RunnerWithTargetBackendForTestGeneratorMarker.class;

    private ReflectionBasedTargetBackendComputer() {
    }

    @Override
    @NotNull
    public TargetBackend compute(@Nullable TargetBackend definedTargetBackend, @NotNull Class<?> testKClass) {
        Intrinsics.checkNotNullParameter(testKClass, (String)"testKClass");
        if (!runnerMarkerKClass.isAssignableFrom(testKClass)) {
            return DefaultTargetBackendComputer.INSTANCE.compute(definedTargetBackend, testKClass);
        }
        if (!(definedTargetBackend == null)) {
            boolean $i$a$-require-ReflectionBasedTargetBackendComputer$compute$32 = false;
            String $i$a$-require-ReflectionBasedTargetBackendComputer$compute$32 = StringsKt.trimIndent((String)("\n                Test " + testKClass.getSimpleName() + " is inheritor of " + runnerMarkerKClass.getSimpleName() + " which means that\n                   target you should not specify targetBackend in test generation DSL, because it will be \n                   read from test runner class itself\n            "));
            throw new IllegalArgumentException($i$a$-require-ReflectionBasedTargetBackendComputer$compute$32.toString());
        }
        if (!(!Modifier.isFinal(testKClass.getModifiers()))) {
            boolean bl = false;
            String string = StringsKt.trimIndent((String)("\n                Test runner " + testKClass.getSimpleName() + " which inherits from " + runnerMarkerKClass.getSimpleName() + " and used as base class\n                  for real test should have `open` modality \n            "));
            throw new IllegalArgumentException(string.toString());
        }
        Object obj = testKClass.newInstance();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.test.runners.RunnerWithTargetBackendForTestGeneratorMarker");
        RunnerWithTargetBackendForTestGeneratorMarker instance = (RunnerWithTargetBackendForTestGeneratorMarker)obj;
        return instance.getTargetBackend();
    }
}

