/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.builders.LanguageVersionSettingsBuilder;
import org.jetbrains.kotlin.test.directives.AdditionalFilesDirectives;
import org.jetbrains.kotlin.test.directives.ModuleStructureDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.DependencyRelation;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AbstractEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DefaultRegisteredDirectivesProviderKt;
import org.jetbrains.kotlin.test.services.DefaultsProvider;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.ExceptionFromModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.ModuleStructureExtractor;
import org.jetbrains.kotlin.test.services.ModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.impl.ModuleStructureExtractorImplKt;
import org.jetbrains.kotlin.test.services.impl.RegisteredDirectivesParser;
import org.jetbrains.kotlin.test.services.impl.TestModuleStructureImpl;
import org.jetbrains.kotlin.test.util.StringUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl;", "Lorg/jetbrains/kotlin/test/services/ModuleStructureExtractor;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "additionalSourceProviders", "", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "moduleStructureTransformers", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "environmentConfigurators", "Lorg/jetbrains/kotlin/test/services/AbstractEnvironmentConfigurator;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "splitTestDataByModules", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testDataFileName", "", "directivesContainer", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "Companion", "ModuleStructureExtractorWorker", "ModuleNameAndDependencies", "tests-common-new_test"})
public final class ModuleStructureExtractorImpl
extends ModuleStructureExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<AbstractEnvironmentConfigurator> environmentConfigurators;
    @NotNull
    private static final List<String> allowedExtensionsForFiles;
    @NotNull
    private static final Regex moduleDirectiveRegex;

    public ModuleStructureExtractorImpl(@NotNull TestServices testServices, @NotNull List<? extends AdditionalSourceProvider> additionalSourceProviders, @NotNull List<? extends ModuleStructureTransformer> moduleStructureTransformers, @NotNull List<? extends AbstractEnvironmentConfigurator> environmentConfigurators) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(additionalSourceProviders, (String)"additionalSourceProviders");
        Intrinsics.checkNotNullParameter(moduleStructureTransformers, (String)"moduleStructureTransformers");
        Intrinsics.checkNotNullParameter(environmentConfigurators, (String)"environmentConfigurators");
        super(testServices, additionalSourceProviders, moduleStructureTransformers);
        this.environmentConfigurators = environmentConfigurators;
    }

    @Override
    @NotNull
    public TestModuleStructure splitTestDataByModules(@NotNull String testDataFileName, @NotNull DirectivesContainer directivesContainer) {
        Intrinsics.checkNotNullParameter((Object)testDataFileName, (String)"testDataFileName");
        Intrinsics.checkNotNullParameter((Object)directivesContainer, (String)"directivesContainer");
        File testDataFile = new File(testDataFileName);
        ModuleStructureExtractorWorker extractor = new ModuleStructureExtractorWorker(CollectionsKt.listOf((Object)testDataFile), directivesContainer);
        TestModuleStructure result = extractor.splitTestDataByModules();
        for (ModuleStructureTransformer transformer : this.getModuleStructureTransformers()) {
            TestModuleStructure testModuleStructure;
            try {
                testModuleStructure = transformer.transformModuleStructure(result, DefaultsProviderKt.getDefaultsProvider(this.getTestServices()));
            }
            catch (Throwable e) {
                throw new ExceptionFromModuleStructureTransformer(e, result);
            }
            result = testModuleStructure;
        }
        return result;
    }

    static {
        Object[] objectArray = new String[]{".kt", ".kts", ".java", ".js", ".mjs", ".config", ".xml"};
        allowedExtensionsForFiles = CollectionsKt.listOf((Object[])objectArray);
        moduleDirectiveRegex = new Regex("([^()\\n]+)(\\((.*?)\\)(\\((.*?)\\)(\\((.*?)\\))?)?)?");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$Companion;", "", "<init>", "()V", "allowedExtensionsForFiles", "", "", "moduleDirectiveRegex", "Lkotlin/text/Regex;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003JC\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleNameAndDependencies;", "", "name", "", "dependencies", "", "friends", "dependsOn", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getDependencies", "()Ljava/util/List;", "getFriends", "getDependsOn", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "tests-common-new_test"})
    private static final class ModuleNameAndDependencies {
        @NotNull
        private final String name;
        @NotNull
        private final List<String> dependencies;
        @NotNull
        private final List<String> friends;
        @NotNull
        private final List<String> dependsOn;

        public ModuleNameAndDependencies(@NotNull String name, @NotNull List<String> dependencies, @NotNull List<String> friends, @NotNull List<String> dependsOn) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter(friends, (String)"friends");
            Intrinsics.checkNotNullParameter(dependsOn, (String)"dependsOn");
            this.name = name;
            this.dependencies = dependencies;
            this.friends = friends;
            this.dependsOn = dependsOn;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<String> getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final List<String> getFriends() {
            return this.friends;
        }

        @NotNull
        public final List<String> getDependsOn() {
            return this.dependsOn;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<String> component2() {
            return this.dependencies;
        }

        @NotNull
        public final List<String> component3() {
            return this.friends;
        }

        @NotNull
        public final List<String> component4() {
            return this.dependsOn;
        }

        @NotNull
        public final ModuleNameAndDependencies copy(@NotNull String name, @NotNull List<String> dependencies, @NotNull List<String> friends, @NotNull List<String> dependsOn) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter(friends, (String)"friends");
            Intrinsics.checkNotNullParameter(dependsOn, (String)"dependsOn");
            return new ModuleNameAndDependencies(name, dependencies, friends, dependsOn);
        }

        public static /* synthetic */ ModuleNameAndDependencies copy$default(ModuleNameAndDependencies moduleNameAndDependencies, String string, List list, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleNameAndDependencies.name;
            }
            if ((n & 2) != 0) {
                list = moduleNameAndDependencies.dependencies;
            }
            if ((n & 4) != 0) {
                list2 = moduleNameAndDependencies.friends;
            }
            if ((n & 8) != 0) {
                list3 = moduleNameAndDependencies.dependsOn;
            }
            return moduleNameAndDependencies.copy(string, list, list2, list3);
        }

        @NotNull
        public String toString() {
            return "ModuleNameAndDependencies(name=" + this.name + ", dependencies=" + this.dependencies + ", friends=" + this.friends + ", dependsOn=" + this.dependsOn + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + ((Object)this.dependencies).hashCode();
            result = result * 31 + ((Object)this.friends).hashCode();
            result = result * 31 + ((Object)this.dependsOn).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleNameAndDependencies)) {
                return false;
            }
            ModuleNameAndDependencies moduleNameAndDependencies = (ModuleNameAndDependencies)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)moduleNameAndDependencies.name)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dependencies, moduleNameAndDependencies.dependencies)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.friends, moduleNameAndDependencies.friends)) {
                return false;
            }
            return Intrinsics.areEqual(this.dependsOn, moduleNameAndDependencies.dependsOn);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u00101\u001a\u000202J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020 0\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 0\u0003H\u0002J\u0016\u00104\u001a\u0002052\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 0\u0003H\u0002J\u001a\u00106\u001a\u00020%2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020#H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0013H\u0002J\b\u0010=\u001a\u000205H\u0002J*\u0010>\u001a\u000205*\u00020?2\b\b\u0002\u0010@\u001a\u00020%2\b\b\u0002\u0010A\u001a\u00020%2\b\b\u0002\u0010B\u001a\u00020%H\u0002J\u0010\u0010C\u001a\u0002052\u0006\u00109\u001a\u00020#H\u0002J\u0010\u0010D\u001a\u0002052\u0006\u00109\u001a\u00020#H\u0002J\b\u0010E\u001a\u000205H\u0002J\b\u0010F\u001a\u000205H\u0002J\b\u0010G\u001a\u000205H\u0002J\u0012\u0010H\u001a\u0002052\b\u00107\u001a\u0004\u0018\u000108H\u0002J\u0010\u0010I\u001a\u0002052\u0006\u0010J\u001a\u00020\u0013H\u0002J\b\u0010K\u001a\u00020\u0018H\u0002J\u0010\u0010L\u001a\u0002052\u0006\u0010M\u001a\u000202H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001a0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020 0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleStructureExtractorWorker;", "", "testDataFiles", "", "Ljava/io/File;", "directivesContainer", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "<init>", "(Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl;Ljava/util/List;Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;)V", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "getAssertions", "()Lorg/jetbrains/kotlin/test/Assertions;", "defaultsProvider", "Lorg/jetbrains/kotlin/test/services/DefaultsProvider;", "getDefaultsProvider", "()Lorg/jetbrains/kotlin/test/services/DefaultsProvider;", "currentTestDataFile", "defaultFileName", "", "getDefaultFileName", "()Ljava/lang/String;", "currentModuleName", "currentModuleLanguageVersionSettingsBuilder", "Lorg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder;", "dependenciesOfCurrentModule", "", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "filesOfCurrentModule", "Lorg/jetbrains/kotlin/test/model/TestFile;", "mutableFilesListPerModule", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "currentFileName", "currentSnippetNumber", "", "firstFileInModule", "", "linesOfCurrentFile", "endLineNumberOfLastFile", "allowFilesWithSameNames", "directivesBuilder", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser;", "moduleDirectivesBuilder", "fileDirectivesBuilder", "globalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "modules", "moduleStructureDirectiveBuilder", "splitTestDataByModules", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "sortModules", "checkCycles", "", "tryParseStructureDirective", "rawDirective", "Lorg/jetbrains/kotlin/test/services/impl/RegisteredDirectivesParser$RawDirective;", "lineNumber", "splitRawModuleStringToNameAndDependencies", "Lorg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleNameAndDependencies;", "moduleDirectiveString", "finishGlobalDirectives", "checkDirectiveApplicability", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "contextIsGlobal", "contextIsModule", "contextIsFile", "finishModule", "finishFile", "resetModuleCaches", "resetDirectivesBuilder", "resetFileCaches", "tryParseRegularDirective", "validateFileName", "fileName", "initLanguageSettingsBuilder", "generateAdditionalFiles", "testModuleStructure", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nModuleStructureExtractorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleStructureExtractorImpl.kt\norg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleStructureExtractorWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,434:1\n1878#2,3:435\n1491#2:438\n1516#2,3:439\n1519#2,3:449\n1252#2,4:454\n1634#2,3:458\n1634#2,3:461\n1634#2,3:464\n1740#2,3:467\n774#2:471\n865#2,2:472\n2756#2:474\n1869#2,2:476\n1761#2,3:478\n2756#2:481\n1761#2,3:483\n1460#2,2:486\n1740#2,3:488\n1462#2,3:491\n1563#2:494\n1634#2,3:495\n384#3,7:442\n465#3:452\n415#3:453\n1#4:470\n1#4:475\n1#4:482\n*S KotlinDebug\n*F\n+ 1 ModuleStructureExtractorImpl.kt\norg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImpl$ModuleStructureExtractorWorker\n*L\n109#1:435,3\n128#1:438\n128#1:439,3\n128#1:449,3\n128#1:454,4\n190#1:458,3\n191#1:461,3\n192#1:464,3\n196#1:467,3\n238#1:471\n238#1:472,2\n264#1:474\n291#1:476,2\n322#1:478,3\n325#1:481\n380#1:483,3\n393#1:486,2\n399#1:488,3\n393#1:491,3\n132#1:494\n132#1:495,3\n128#1:442,7\n128#1:452\n128#1:453\n264#1:475\n325#1:482\n*E\n"})
    private final class ModuleStructureExtractorWorker {
        @NotNull
        private final List<File> testDataFiles;
        @NotNull
        private final DirectivesContainer directivesContainer;
        private File currentTestDataFile;
        @Nullable
        private String currentModuleName;
        @NotNull
        private LanguageVersionSettingsBuilder currentModuleLanguageVersionSettingsBuilder;
        @NotNull
        private List<DependencyDescription> dependenciesOfCurrentModule;
        @NotNull
        private List<TestFile> filesOfCurrentModule;
        @NotNull
        private final Map<TestModule, List<TestFile>> mutableFilesListPerModule;
        @Nullable
        private String currentFileName;
        private int currentSnippetNumber;
        private boolean firstFileInModule;
        @NotNull
        private List<String> linesOfCurrentFile;
        private int endLineNumberOfLastFile;
        private boolean allowFilesWithSameNames;
        @NotNull
        private RegisteredDirectivesParser directivesBuilder;
        @NotNull
        private RegisteredDirectivesParser moduleDirectivesBuilder;
        @Nullable
        private RegisteredDirectivesParser fileDirectivesBuilder;
        @Nullable
        private RegisteredDirectives globalDirectives;
        @NotNull
        private final List<TestModule> modules;
        @NotNull
        private final RegisteredDirectivesParser moduleStructureDirectiveBuilder;

        public ModuleStructureExtractorWorker(@NotNull List<? extends File> testDataFiles, DirectivesContainer directivesContainer) {
            Intrinsics.checkNotNullParameter(testDataFiles, (String)"testDataFiles");
            Intrinsics.checkNotNullParameter((Object)directivesContainer, (String)"directivesContainer");
            this.testDataFiles = testDataFiles;
            this.directivesContainer = directivesContainer;
            this.currentModuleLanguageVersionSettingsBuilder = this.initLanguageSettingsBuilder();
            this.dependenciesOfCurrentModule = new ArrayList();
            this.filesOfCurrentModule = new ArrayList();
            this.mutableFilesListPerModule = new LinkedHashMap();
            this.currentSnippetNumber = 1;
            this.firstFileInModule = true;
            this.linesOfCurrentFile = new ArrayList();
            this.endLineNumberOfLastFile = -1;
            this.moduleDirectivesBuilder = this.directivesBuilder = new RegisteredDirectivesParser(this.directivesContainer, this.getAssertions());
            this.modules = new ArrayList();
            this.moduleStructureDirectiveBuilder = new RegisteredDirectivesParser(ModuleStructureDirectives.INSTANCE, this.getAssertions());
        }

        private final Assertions getAssertions() {
            return AssertionsKt.getAssertions(ModuleStructureExtractorImpl.this.getTestServices());
        }

        private final DefaultsProvider getDefaultsProvider() {
            return DefaultsProviderKt.getDefaultsProvider(ModuleStructureExtractorImpl.this.getTestServices());
        }

        private final String getDefaultFileName() {
            File file = this.currentTestDataFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentTestDataFile");
                file = null;
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final TestModuleStructure splitTestDataByModules() {
            TestModuleStructureImpl testModuleStructureImpl;
            Iterator<File> iterator = this.testDataFiles.iterator();
            while (iterator.hasNext()) {
                File testDataFile;
                this.currentTestDataFile = testDataFile = iterator.next();
                List lines2 = FilesKt.readLines$default((File)testDataFile, null, (int)1, null);
                Iterable $this$forEachIndexed$iv = lines2;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void line;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv;
                    int lineNumber = n;
                    boolean bl = false;
                    RegisteredDirectivesParser.RawDirective rawDirective = RegisteredDirectivesParser.Companion.parseDirective((String)line);
                    if (this.tryParseStructureDirective(rawDirective, lineNumber + 1)) {
                        this.linesOfCurrentFile.add((String)line);
                        continue;
                    }
                    this.tryParseRegularDirective(rawDirective);
                    this.linesOfCurrentFile.add((String)line);
                }
            }
            this.finishModule(-1);
            List<TestModule> sortedModules = this.sortModules(this.modules);
            this.checkCycles(this.modules);
            TestModuleStructureImpl it = testModuleStructureImpl = new TestModuleStructureImpl(sortedModules, this.testDataFiles);
            boolean bl = false;
            this.generateAdditionalFiles(it);
            return testModuleStructureImpl;
        }

        /*
         * WARNING - void declaration
         */
        private final List<TestModule> sortModules(List<TestModule> modules) {
            void $this$mapValuesTo$iv$iv;
            Object key$iv$iv;
            Map $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = modules;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object element$iv$iv = iterator.next();
                TestModule it = (TestModule)element$iv$iv;
                boolean bl = false;
                key$iv$iv = it.getName();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                TestModule testModule;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map2 = map;
                boolean bl3 = false;
                String name = (String)entry.getKey();
                List modules2 = (List)entry.getValue();
                if ((TestModule)CollectionsKt.singleOrNull((List)modules2) == null) {
                    throw new IllegalStateException(("Duplicated modules with name " + name).toString());
                }
                map2.put(k, testModule);
            }
            Map moduleByName = destination$iv$iv;
            List list = DFS.topologicalOrder((Iterable)modules, arg_0 -> ModuleStructureExtractorWorker.sortModules$lambda$5(moduleByName, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"topologicalOrder(...)");
            return CollectionsKt.asReversedMutable((List)list);
        }

        private final void checkCycles(List<TestModule> modules) {
            Set visited = new LinkedHashSet();
            for (TestModule module : modules) {
                String moduleName = module.getName();
                visited.add(moduleName);
                for (DependencyDescription dependency : module.getAllDependencies()) {
                    String dependencyName = dependency.getDependencyModule().getName();
                    if (Intrinsics.areEqual((Object)dependencyName, (Object)moduleName)) {
                        throw new IllegalStateException(("Module " + moduleName + " has dependency to itself").toString());
                    }
                    if (visited.contains(dependencyName)) continue;
                    throw new IllegalStateException(("There is cycle in modules dependencies. See modules: " + dependencyName + ", " + moduleName).toString());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean tryParseStructureDirective(RegisteredDirectivesParser.RawDirective rawDirective, int lineNumber) {
            if (rawDirective == null) {
                return false;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective = this.moduleStructureDirectiveBuilder.convertToRegisteredDirective(rawDirective);
            if (parsedDirective == null) {
                return false;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective2 = parsedDirective;
            Directive directive = parsedDirective2.component1();
            List<?> values = parsedDirective2.component2();
            Directive directive2 = directive;
            if (Intrinsics.areEqual((Object)directive2, (Object)ModuleStructureDirectives.INSTANCE.getMODULE())) {
                String it;
                Collection collection;
                Iterable $this$mapTo$iv;
                if (this.currentModuleName != null) {
                    this.finishModule(lineNumber);
                } else {
                    if (this.currentFileName != null) {
                        throw new IllegalStateException("Defining `// FILE` before `// MODULE` is prohibited: it's unclear if the directives before the first `// FILE` are global- or module-specific".toString());
                    }
                    this.finishGlobalDirectives();
                }
                ModuleNameAndDependencies moduleNameAndDependencies = this.splitRawModuleStringToNameAndDependencies(CollectionsKt.joinToString$default((Iterable)values, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                String moduleName = moduleNameAndDependencies.component1();
                List<String> dependencies = moduleNameAndDependencies.component2();
                List<String> friends = moduleNameAndDependencies.component3();
                List<String> dependsOn = moduleNameAndDependencies.component4();
                this.currentModuleName = moduleName;
                DependencyKind kind = this.getDefaultsProvider().getDefaultDependencyKind();
                Iterable iterable = dependencies;
                Collection destination$iv = this.dependenciesOfCurrentModule;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    String string = (String)item$iv;
                    collection = destination$iv;
                    boolean bl = false;
                    collection.add(ModuleStructureExtractorWorker.tryParseStructureDirective$toDependencyDescription(it, this, kind, DependencyRelation.RegularDependency));
                }
                $this$mapTo$iv = friends;
                destination$iv = this.dependenciesOfCurrentModule;
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    it = (String)item$iv;
                    collection = destination$iv;
                    boolean bl = false;
                    collection.add(ModuleStructureExtractorWorker.tryParseStructureDirective$toDependencyDescription(it, this, kind, DependencyRelation.FriendDependency));
                }
                $this$mapTo$iv = dependsOn;
                destination$iv = this.dependenciesOfCurrentModule;
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    it = (String)item$iv;
                    collection = destination$iv;
                    boolean bl = false;
                    collection.add(ModuleStructureExtractorWorker.tryParseStructureDirective$toDependencyDescription(it, this, kind, DependencyRelation.DependsOnDependency));
                }
            } else if (Intrinsics.areEqual((Object)directive2, (Object)ModuleStructureDirectives.INSTANCE.getSNIPPET())) {
                boolean bl;
                block23: {
                    Iterable $this$all$iv = this.linesOfCurrentFile;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (StringsKt.isBlank((CharSequence)it)) continue;
                            bl = false;
                            break block23;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.finishGlobalDirectives();
                } else {
                    this.finishModule(lineNumber);
                    this.dependenciesOfCurrentModule.add(new DependencyDescription((TestModule)CollectionsKt.last(this.modules), DependencyKind.Source, DependencyRelation.FriendDependency));
                    int n = this.currentSnippetNumber;
                    this.currentSnippetNumber = n + 1;
                }
                this.currentModuleName = ModuleStructureExtractorWorker.tryParseStructureDirective$snippetName(this);
                this.currentFileName = this.currentModuleName + ".kts";
            } else if (Intrinsics.areEqual((Object)directive2, (Object)ModuleStructureDirectives.INSTANCE.getFILE())) {
                void p0;
                String string;
                if (this.currentFileName != null) {
                    this.finishFile(lineNumber);
                } else {
                    this.resetFileCaches();
                }
                Object object = CollectionsKt.first(values);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String $i$f$all = string = (String)object;
                ModuleStructureExtractorWorker moduleStructureExtractorWorker = this;
                boolean bl = false;
                this.validateFileName((String)p0);
                moduleStructureExtractorWorker.currentFileName = string;
            } else if (Intrinsics.areEqual((Object)directive2, (Object)ModuleStructureDirectives.INSTANCE.getALLOW_FILES_WITH_SAME_NAMES())) {
                this.allowFilesWithSameNames = true;
            } else {
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final ModuleNameAndDependencies splitRawModuleStringToNameAndDependencies(String moduleDirectiveString) {
            Object object;
            Object directives;
            String[] it;
            String string;
            MatchResult matchResult = moduleDirectiveRegex.matchEntire((CharSequence)moduleDirectiveString);
            if (matchResult == null) {
                throw new IllegalStateException(('\"' + moduleDirectiveString + "\" doesn't matches with pattern \"moduleName(dep1, dep2)\"").toString());
            }
            MatchResult matchResult2 = matchResult;
            MatchResult.Destructured destructured = matchResult2.getDestructured();
            String name = (String)destructured.getMatch().getGroupValues().get(1);
            String dependencies = (String)destructured.getMatch().getGroupValues().get(3);
            String friends = (String)destructured.getMatch().getGroupValues().get(5);
            String dependsOn = (String)destructured.getMatch().getGroupValues().get(7);
            Ref.ObjectRef dependenciesNames = new Ref.ObjectRef();
            String string2 = string = dependencies;
            Ref.ObjectRef objectRef = dependenciesNames;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)it));
            Object object2 = bl2 ? string : null;
            if (object2 == null || (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(it = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) == null) {
                object2 = CollectionsKt.emptyList();
            }
            objectRef.element = object2;
            RegisteredDirectives registeredDirectives = this.globalDirectives;
            if (registeredDirectives != null) {
                directives = registeredDirectives;
                boolean bl3 = false;
                if (((RegisteredDirectives)directives).contains(AdditionalFilesDirectives.INSTANCE.getWITH_COROUTINES())) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = (Iterable)dependenciesNames.element;
                    Ref.ObjectRef objectRef2 = dependenciesNames;
                    boolean $i$f$filter = false;
                    void var16_25 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it2 = (String)element$iv$iv;
                        boolean bl4 = false;
                        if (!(!Intrinsics.areEqual((Object)it2, (Object)"support"))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    objectRef2.element = (List)destination$iv$iv;
                }
            }
            Object it3 = directives = friends;
            boolean bl5 = false;
            Object object3 = !StringsKt.isBlank((CharSequence)((CharSequence)it3)) ? directives : null;
            if (object3 == null || (object3 = StringsKt.split$default((CharSequence)((CharSequence)object3), (String[])(object = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) == null) {
                object3 = CollectionsKt.emptyList();
            }
            Object friendsNames = object3;
            object = dependsOn;
            String[] it4 = object;
            boolean bl6 = false;
            Object object4 = !StringsKt.isBlank((CharSequence)((CharSequence)it4)) ? object : null;
            if (object4 == null || (object4 = StringsKt.split$default((CharSequence)((CharSequence)object4), (String[])(it4 = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) == null) {
                object4 = CollectionsKt.emptyList();
            }
            Object dependsOnNames = object4;
            Object $this$splitRawModuleStringToNameAndDependencies_u24lambda_u2416 = object = SetsKt.createSetBuilder();
            boolean bl7 = false;
            $this$splitRawModuleStringToNameAndDependencies_u24lambda_u2416.addAll(CollectionsKt.intersect((Iterable)((Iterable)dependenciesNames.element), (Iterable)((Iterable)friendsNames)));
            $this$splitRawModuleStringToNameAndDependencies_u24lambda_u2416.addAll(CollectionsKt.intersect((Iterable)((Iterable)dependenciesNames.element), (Iterable)((Iterable)dependsOnNames)));
            $this$splitRawModuleStringToNameAndDependencies_u24lambda_u2416.addAll(CollectionsKt.intersect((Iterable)((Iterable)friendsNames), (Iterable)((Iterable)dependsOnNames)));
            Set intersection = SetsKt.build((Set)object);
            if (!intersection.isEmpty()) {
                boolean bl8 = false;
                String m = intersection.size() == 1 ? "module" : "modules";
                String names = intersection.size() == 1 ? '`' + (String)CollectionsKt.first((Iterable)intersection) + '`' : StringUtilsKt.joinToArrayString(intersection);
                String string3 = "Module `" + name + "` depends on " + m + ' ' + names + " with different kinds simultaneously";
                throw new IllegalArgumentException(string3.toString());
            }
            return new ModuleNameAndDependencies(name, (List)dependenciesNames.element, (List<String>)friendsNames, (List<String>)dependsOnNames);
        }

        /*
         * WARNING - void declaration
         */
        private final void finishGlobalDirectives() {
            void $this$onEach$iv;
            void var3_4;
            Iterable iterable = this.directivesBuilder.build();
            ModuleStructureExtractorWorker moduleStructureExtractorWorker = this;
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2418$iv = var3_4 = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                Directive it = (Directive)element$iv;
                boolean bl2 = false;
                ModuleStructureExtractorWorker.checkDirectiveApplicability$default(this, it, true, false, false, 6, null);
            }
            moduleStructureExtractorWorker.globalDirectives = (RegisteredDirectives)var3_4;
            this.resetModuleCaches();
            this.resetFileCaches();
        }

        private final void checkDirectiveApplicability(Directive $this$checkDirectiveApplicability, boolean contextIsGlobal, boolean contextIsModule, boolean contextIsFile) {
            List list;
            if ($this$checkDirectiveApplicability.getApplicability().getForGlobal() && contextIsGlobal) {
                return;
            }
            if ($this$checkDirectiveApplicability.getApplicability().getForModule() && contextIsModule) {
                return;
            }
            if ($this$checkDirectiveApplicability.getApplicability().getForFile() && contextIsFile) {
                return;
            }
            List $this$checkDirectiveApplicability_u24lambda_u2419 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (contextIsGlobal) {
                $this$checkDirectiveApplicability_u24lambda_u2419.add("Global");
            }
            if (contextIsModule) {
                $this$checkDirectiveApplicability_u24lambda_u2419.add("Module");
            }
            if (contextIsFile) {
                $this$checkDirectiveApplicability_u24lambda_u2419.add("File");
            }
            String context = CollectionsKt.joinToString$default((Iterable)CollectionsKt.build((List)list), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalStateException(("Directive " + $this$checkDirectiveApplicability + " has " + (Object)((Object)$this$checkDirectiveApplicability.getApplicability()) + " applicability but it declared in " + context).toString());
        }

        static /* synthetic */ void checkDirectiveApplicability$default(ModuleStructureExtractorWorker moduleStructureExtractorWorker, Directive directive, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            moduleStructureExtractorWorker.checkDirectiveApplicability(directive, bl, bl2, bl3);
        }

        private final void finishModule(int lineNumber) {
            this.finishFile(lineNumber);
            boolean isImplicitModule = this.currentModuleName == null;
            RegisteredDirectives moduleDirectives = ModuleStructureExtractorImplKt.access$plus(ModuleStructureExtractorImplKt.access$plus(this.moduleDirectivesBuilder.build(), DefaultRegisteredDirectivesProviderKt.getDefaultDirectives(ModuleStructureExtractorImpl.this.getTestServices())), this.globalDirectives);
            Iterable $this$forEach$iv = moduleDirectives;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Directive it = (Directive)element$iv;
                boolean bl = false;
                ModuleStructureExtractorWorker.checkDirectiveApplicability$default(this, it, isImplicitModule, true, false, 4, null);
            }
            TargetBackend targetBackend = this.getDefaultsProvider().getTargetBackend();
            FrontendKind<?> frontendKind = this.getDefaultsProvider().getFrontendKind();
            this.currentModuleLanguageVersionSettingsBuilder.configureUsingDirectives(moduleDirectives, ModuleStructureExtractorImpl.this.environmentConfigurators, targetBackend, Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.FIR.INSTANCE));
            String string = this.currentModuleName;
            if (string == null && (string = (String)CollectionsKt.firstOrNull(DefaultRegisteredDirectivesProviderKt.getDefaultDirectives(ModuleStructureExtractorImpl.this.getTestServices()).get(ModuleStructureDirectives.INSTANCE.getMODULE()))) == null) {
                string = "main";
            }
            String moduleName = string;
            TestModule testModule = new TestModule(moduleName, this.filesOfCurrentModule, this.dependenciesOfCurrentModule, moduleDirectives, this.currentModuleLanguageVersionSettingsBuilder.build());
            this.mutableFilesListPerModule.put(testModule, this.filesOfCurrentModule);
            ((Collection)this.modules).add(testModule);
            this.firstFileInModule = true;
            this.resetModuleCaches();
        }

        private final void finishFile(int lineNumber) {
            RegisteredDirectives registeredDirectives;
            RegisteredDirectives registeredDirectives2;
            Object object;
            Object object2;
            String filename;
            String actualDefaultFileName = this.currentModuleName == null ? this.getDefaultFileName() : "module_" + this.currentModuleName + '_' + this.getDefaultFileName();
            String string = this.currentFileName;
            if (string == null) {
                string = filename = actualDefaultFileName;
            }
            if (!this.allowFilesWithSameNames) {
                boolean bl;
                Object $this$any$iv;
                block13: {
                    $this$any$iv = this.filesOfCurrentModule;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        object2 = $this$any$iv.iterator();
                        while (object2.hasNext()) {
                            Object element$iv = object2.next();
                            TestFile it = (TestFile)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)filename)) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder().append("File with name \"").append(filename).append("\" already defined in module ");
                    String string2 = this.currentModuleName;
                    if (string2 == null) {
                        string2 = actualDefaultFileName;
                    }
                    $this$any$iv = stringBuilder.append(string2).toString();
                    throw new IllegalStateException($this$any$iv.toString());
                }
            }
            if ((object = this.fileDirectivesBuilder) != null && (object = ((RegisteredDirectivesParser)object).build()) != null) {
                Iterable bl2;
                Iterable $this$onEach$iv = (Iterable)object;
                boolean $i$f$onEach = false;
                Iterable $this$onEach_u24lambda_u2418$iv = bl2 = $this$onEach$iv;
                boolean bl = false;
                for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                    Directive it = (Directive)element$iv;
                    boolean bl3 = false;
                    ModuleStructureExtractorWorker.checkDirectiveApplicability$default(this, it, false, false, true, 3, null);
                }
                registeredDirectives2 = (RegisteredDirectives)bl2;
            } else {
                registeredDirectives2 = null;
            }
            RegisteredDirectives directives = registeredDirectives2;
            Object $this$finishFile_u24lambda_u2423 = object2 = new StringBuilder();
            boolean bl = false;
            int n = this.endLineNumberOfLastFile;
            for (int i = 0; i < n; ++i) {
                ((StringBuilder)$this$finishFile_u24lambda_u2423).append('\n');
            }
            ((StringBuilder)$this$finishFile_u24lambda_u2423).append(CollectionsKt.joinToString$default((Iterable)this.linesOfCurrentFile, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)).append('\n');
            String fileContent = ((StringBuilder)object2).toString();
            File file = this.currentTestDataFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentTestDataFile");
                file = null;
            }
            if ((registeredDirectives = directives) == null) {
                registeredDirectives = RegisteredDirectives.Companion.getEmpty();
            }
            this.filesOfCurrentModule.add(new TestFile(filename, fileContent, file, this.endLineNumberOfLastFile, false, registeredDirectives));
            this.firstFileInModule = false;
            this.endLineNumberOfLastFile = lineNumber - 1;
            this.resetFileCaches();
        }

        private final void resetModuleCaches() {
            this.firstFileInModule = true;
            this.currentModuleName = null;
            this.currentModuleLanguageVersionSettingsBuilder = this.initLanguageSettingsBuilder();
            this.filesOfCurrentModule = new ArrayList();
            this.dependenciesOfCurrentModule = new ArrayList();
            this.resetDirectivesBuilder();
            this.moduleDirectivesBuilder = this.directivesBuilder;
        }

        private final void resetDirectivesBuilder() {
            this.directivesBuilder = new RegisteredDirectivesParser(this.directivesContainer, this.getAssertions());
        }

        private final void resetFileCaches() {
            if (!this.firstFileInModule) {
                this.linesOfCurrentFile = new ArrayList();
            }
            if (this.firstFileInModule) {
                this.moduleDirectivesBuilder = this.directivesBuilder;
            }
            this.currentFileName = null;
            this.resetDirectivesBuilder();
            this.fileDirectivesBuilder = this.directivesBuilder;
        }

        private final void tryParseRegularDirective(RegisteredDirectivesParser.RawDirective rawDirective) {
            if (rawDirective == null) {
                return;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective = this.directivesBuilder.convertToRegisteredDirective(rawDirective);
            if (parsedDirective == null) {
                return;
            }
            RegisteredDirectivesParser.ParsedDirective parsedDirective2 = parsedDirective;
            this.directivesBuilder.addParsedDirective(parsedDirective2);
        }

        private final void validateFileName(String fileName) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = allowedExtensionsForFiles;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.endsWith$default((String)fileName, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                this.getAssertions().fail((Function0<String>)((Function0)() -> ModuleStructureExtractorWorker.validateFileName$lambda$25(fileName)));
                throw new KotlinNothingValueException();
            }
        }

        private final LanguageVersionSettingsBuilder initLanguageSettingsBuilder() {
            return this.getDefaultsProvider().newLanguageSettingsBuilder();
        }

        private final void generateAdditionalFiles(TestModuleStructure testModuleStructure) {
            for (Map.Entry<TestModule, List<TestFile>> entry : this.mutableFilesListPerModule.entrySet()) {
                TestModule module = entry.getKey();
                List<TestFile> files = entry.getValue();
                Iterable $this$flatMapTo$iv = ModuleStructureExtractorImpl.this.getAdditionalSourceProviders();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    boolean bl;
                    List<TestFile> list;
                    AdditionalSourceProvider additionalSourceProvider;
                    block7: {
                        additionalSourceProvider = (AdditionalSourceProvider)element$iv;
                        boolean bl2 = false;
                        RegisteredDirectives registeredDirectives = this.globalDirectives;
                        if (registeredDirectives == null) {
                            registeredDirectives = RegisteredDirectives.Companion.getEmpty();
                        }
                        List<TestFile> additionalFiles = list = additionalSourceProvider.produceAdditionalFiles(registeredDirectives, module, testModuleStructure);
                        boolean bl3 = false;
                        Iterable $this$all$iv = additionalFiles;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv) {
                                TestFile it = (TestFile)element$iv2;
                                boolean bl4 = false;
                                if (it.isAdditional()) continue;
                                bl = false;
                                break block7;
                            }
                            bl = true;
                        }
                    }
                    if (!bl) {
                        boolean bl5 = false;
                        String string = "Files produced by " + Reflection.getOrCreateKotlinClass(additionalSourceProvider.getClass()).getQualifiedName() + " should have flag `isAdditional = true`";
                        throw new IllegalArgumentException(string.toString());
                    }
                    Iterable list$iv = list;
                    CollectionsKt.addAll((Collection)files, (Iterable)list$iv);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final Iterable sortModules$lambda$5(Map $moduleByName, TestModule module) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = module.getAllDependencies();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DependencyDescription dependencyDescription = (DependencyDescription)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String moduleName = it.getDependencyModule().getName();
                TestModule testModule = (TestModule)$moduleByName.get(moduleName);
                if (testModule == null) {
                    throw new IllegalStateException(("Module \"" + moduleName + "\" not found while observing dependencies of \"" + module.getName() + '\"').toString());
                }
                collection.add(testModule);
            }
            return (List)destination$iv$iv;
        }

        private static final DependencyDescription tryParseStructureDirective$toDependencyDescription(String $this$tryParseStructureDirective_u24toDependencyDescription, ModuleStructureExtractorWorker this$0, DependencyKind kind, DependencyRelation relation) {
            Object v0;
            block2: {
                Iterable iterable = this$0.modules;
                for (Object t : iterable) {
                    TestModule it = (TestModule)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)$this$tryParseStructureDirective_u24toDependencyDescription)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            TestModule testModule = v0;
            if (testModule == null) {
                throw new IllegalStateException(("Module " + $this$tryParseStructureDirective_u24toDependencyDescription + " not found").toString());
            }
            TestModule dependantModule = testModule;
            DependencyKind specificKind = WhenMappings.$EnumSwitchMapping$0[relation.ordinal()] == 1 ? DependencyKind.Source : kind;
            return new DependencyDescription(dependantModule, specificKind, relation);
        }

        private static final String tryParseStructureDirective$snippetName(ModuleStructureExtractorWorker this$0) {
            StringBuilder stringBuilder = new StringBuilder().append("snippet_");
            String string = "%03d";
            Object[] objectArray = new Object[]{this$0.currentSnippetNumber};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return stringBuilder.append(string2).toString();
        }

        private static final String validateFileName$lambda$25(String $fileName) {
            return "Filename " + $fileName + " is not valid. Allowed extensions: " + StringUtilsKt.joinToArrayString(allowedExtensionsForFiles);
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DependencyRelation.values().length];
                try {
                    nArray[DependencyRelation.DependsOnDependency.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

