/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.frontend.fir.handlers.AbstractFirIdenticalChecker;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "checkTestDataFile", "", "testDataFile", "Ljava/io/File;", "Companion", "Helper", "tests-common-new_test"})
public final class LatestLVIdenticalChecker
extends AbstractFirIdenticalChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String message = "Dumps with latest and latest stable LV are the same";

    public LatestLVIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    protected void checkTestDataFile(@NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        if (!CustomTestDataUtilsKt.isLatestLVTestData(testDataFile)) {
            return;
        }
        RegisteredDirectives directives = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives();
        Pair pair = directives.contains(FirDiagnosticsDirectives.INSTANCE.getTEST_ALONGSIDE_K1_TESTDATA()) && !directives.contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL()) ? TuplesKt.to((Object)CustomTestDataUtilsKt.getFirTestDataFile(testDataFile), (Object)CustomTestDataUtilsKt.getOriginalTestDataFile(testDataFile)) : TuplesKt.to((Object)CustomTestDataUtilsKt.getOriginalTestDataFile(testDataFile), null);
        File originalFile = (File)pair.component1();
        File additionalFile = (File)pair.component2();
        Helper helper = new Helper(originalFile);
        if (FirIdenticalCheckerHelper.contentsAreEquals$default(helper, originalFile, testDataFile, false, 4, null)) {
            helper.deleteFirFile(testDataFile);
            Function0[] function0Array = new Function0[]{() -> LatestLVIdenticalChecker.checkTestDataFile$lambda$0(helper, originalFile), () -> LatestLVIdenticalChecker.checkTestDataFile$lambda$1(additionalFile, helper)};
            AssertionsKt.getAssertions(this.getTestServices()).assertAll(function0Array);
        }
    }

    private static final Unit checkTestDataFile$lambda$0(Helper $helper, File $originalFile) {
        $helper.removeDirectiveFromClassicFileAndAssert($originalFile, FirDiagnosticsDirectives.INSTANCE.getLATEST_LV_DIFFERENCE(), message);
        return Unit.INSTANCE;
    }

    private static final Unit checkTestDataFile$lambda$1(File $additionalFile, Helper $helper) {
        if ($additionalFile != null) {
            $helper.removeDirectiveFromClassicFileAndAssert($additionalFile, FirDiagnosticsDirectives.INSTANCE.getLATEST_LV_DIFFERENCE(), message);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker$Companion;", "", "<init>", "()V", "message", "", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker$Helper;", "Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper;", "originalFile", "Ljava/io/File;", "<init>", "(Lorg/jetbrains/kotlin/test/frontend/fir/handlers/LatestLVIdenticalChecker;Ljava/io/File;)V", "getOriginalFile", "()Ljava/io/File;", "getClassicFileToCompare", "testDataFile", "getFirFileToCompare", "tests-common-new_test"})
    private final class Helper
    extends FirIdenticalCheckerHelper {
        @NotNull
        private final File originalFile;

        public Helper(File originalFile) {
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            super(LatestLVIdenticalChecker.this.getTestServices());
            this.originalFile = originalFile;
        }

        @NotNull
        public final File getOriginalFile() {
            return this.originalFile;
        }

        @Override
        @NotNull
        public File getClassicFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            return this.originalFile;
        }

        @Override
        @NotNull
        public File getFirFileToCompare(@NotNull File testDataFile) {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            return CustomTestDataUtilsKt.getLatestLVTestDataFile(testDataFile);
        }
    }
}

