/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import com.intellij.openapi.util.TextRange;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.RootDiagnosticRendererFactory;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ$\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FullDiagnosticsRenderer;", "", "directive", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "<init>", "(Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;)V", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "assertCollectedDiagnostics", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "expectedExtension", "", "storeFullDiagnosticRender", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "diagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirDiagnosticsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FullDiagnosticsRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,741:1\n1056#2:742\n1563#2:743\n1634#2,3:744\n*S KotlinDebug\n*F\n+ 1 FirDiagnosticsHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FullDiagnosticsRenderer\n*L\n104#1:742\n104#1:743\n104#1:744,3\n*E\n"})
public final class FullDiagnosticsRenderer {
    @NotNull
    private final SimpleDirective directive;
    @NotNull
    private final MultiModuleInfoDumper dumper;

    public FullDiagnosticsRenderer(@NotNull SimpleDirective directive) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        this.directive = directive;
        this.dumper = new MultiModuleInfoDumper("// -- Module: <%s> --");
    }

    public final void assertCollectedDiagnostics(@NotNull TestServices testServices, @NotNull String expectedExtension) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)expectedExtension, (String)"expectedExtension");
        RegisteredDirectives directives = TestModuleStructureKt.getModuleStructure(testServices).getAllDirectives();
        if (directives.contains(FirDiagnosticsDirectives.INSTANCE.getUSE_LATEST_LANGUAGE_VERSION())) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(testServices).getOriginalTestDataFiles());
        File file = testDataFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        File expectedFile = FilesKt.resolve((File)file, (String)(StringsKt.removeSuffix((String)FilesKt.getNameWithoutExtension((File)testDataFile), (CharSequence)".fir") + expectedExtension));
        if (!directives.contains(this.directive)) {
            if (!directives.contains(DiagnosticsDirectives.INSTANCE.getRENDER_ALL_DIAGNOSTICS_FULL_TEXT())) {
                HandlerUtilsKt.assertFileDoesntExist(AssertionsKt.getAssertions(testServices), expectedFile, this.directive);
            }
            return;
        }
        if (this.dumper.isEmpty() && !expectedFile.exists()) {
            return;
        }
        String resultDump = this.dumper.generateResultingDump();
        Assertions.assertEqualsToFile$default((Assertions)AssertionsKt.getAssertions(testServices), expectedFile, resultDump, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void storeFullDiagnosticRender(@NotNull TestModule module, @NotNull List<? extends KtDiagnostic> diagnostics, @NotNull TestFile file) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!module.getDirectives().contains(this.directive)) {
            return;
        }
        if (diagnostics.isEmpty()) {
            return;
        }
        Iterable $this$sortedBy$iv = diagnostics;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                KtDiagnostic it = (KtDiagnostic)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((TextRange)CollectionsKt.first((List)it.getTextRanges())).getStartOffset());
                it = (KtDiagnostic)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((TextRange)CollectionsKt.first((List)it.getTextRanges())).getStartOffset()));
            }
        });
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtDiagnostic ktDiagnostic = (KtDiagnostic)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String severity = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)AnalyzerWithCompilerReport.Companion.convertSeverity(it.getSeverity()).toString());
            String message = RootDiagnosticRendererFactory.INSTANCE.invoke((KtDiagnostic)it).render((KtDiagnostic)it);
            collection.add('/' + file.getName() + ':' + CollectionsKt.first((List)it.getTextRanges()) + ": " + severity + ": " + message);
        }
        List reportedDiagnostics = (List)destination$iv$iv;
        this.dumper.builderForModule(module).append(CollectionsKt.joinToString$default((Iterable)reportedDiagnostics, (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null)).append('\n');
    }
}

