/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/services/PackageNamePreprocessor;", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "packageName", "", "packageNamePlaceholder", "packagePattern", "Ljava/util/regex/Pattern;", "process", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "content", "tests-common-new_test"})
public final class PackageNamePreprocessor
extends SourceFilePreprocessor {
    @Nullable
    private String packageName;
    @NotNull
    private final String packageNamePlaceholder;
    @NotNull
    private final Pattern packagePattern;

    public PackageNamePreprocessor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.packageNamePlaceholder = "<?PACKAGE?>";
        Pattern pattern = Pattern.compile("(?:^|\\n)package (?<packageName>.*?)(?:;|\\n)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.packagePattern = pattern;
    }

    @Override
    @NotNull
    public String process(@NotNull TestFile file, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Matcher it = this.packagePattern.matcher(content);
        boolean bl = false;
        String packageName = it.find() ? it.group("packageName") : null;
        if (packageName != null) {
            if (!(!StringsKt.contains$default((CharSequence)content, (CharSequence)this.packageNamePlaceholder, (boolean)false, (int)2, null))) {
                boolean bl2 = false;
                String string = "The actual package directive " + packageName + " is already present in the file";
                throw new IllegalArgumentException(string.toString());
            }
            this.packageName = packageName;
        }
        return StringsKt.replace$default((String)content, (String)this.packageNamePlaceholder, (String)(this.packageName == null ? "" : "package " + this.packageName), (boolean)false, (int)4, null);
    }
}

