/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.codegen.AbstractIrBlackBoxInlineCodegenWithIrInlinerTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class IrBlackBoxInlineCodegenWithIrInlinerTestGenerated
extends AbstractIrBlackBoxInlineCodegenWithIrInlinerTest {

    @Nested
    @TestMetadata(value="compiler/testData/klib/syntheticAccessors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class SyntheticAccessors {
        @Test
        public void testAllFilesPresentInSyntheticAccessors() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/klib/syntheticAccessors/topLevelPrivate")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TopLevelPrivate {
            @Test
            public void testAllFilesPresentInTopLevelPrivate() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/topLevelPrivate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile")
            @TestDataPath(value="$PROJECT_ROOT")
            public class SingleFile {
                @Test
                public void testAllFilesPresentInSingleFile() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelLateinitVar.kt")
                public void testLeakingPrivateTopLevelLateinitVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/leakingPrivateTopLevelLateinitVar.kt");
                }

                @Test
                @TestMetadata(value="useLateinitIsInitializedFromInternalInline.kt")
                public void testUseLateinitIsInitializedFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/useLateinitIsInitializedFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateClassThroughGenericType.kt")
                public void testUsePrivateClassThroughGenericType() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateClassThroughGenericType.kt");
                }

                @Test
                @TestMetadata(value="usePrivateClassThroughtPrivateTopLevelFun.kt")
                public void testUsePrivateClassThroughtPrivateTopLevelFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateClassThroughtPrivateTopLevelFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelExtensionFunFromInternalInline.kt")
                public void testUsePrivateTopLevelExtensionFunFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelExtensionFunFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelFunFromDefaultArguments.kt")
                public void testUsePrivateTopLevelFunFromDefaultArguments() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelFunFromDefaultArguments.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelFunFromInternalInline.kt")
                public void testUsePrivateTopLevelFunFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelFunFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelFunFromLambdaInsideInternalInline.kt")
                public void testUsePrivateTopLevelFunFromLambdaInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelFunFromLambdaInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelFunFromLambdaInsidePublicInline.kt")
                public void testUsePrivateTopLevelFunFromLambdaInsidePublicInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelFunFromLambdaInsidePublicInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelFunInsidePrivateInlineMethodInLocalObject.kt")
                public void testUsePrivateTopLevelFunInsidePrivateInlineMethodInLocalObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelFunInsidePrivateInlineMethodInLocalObject.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelFunInsidePublicInlineMethodInLocalObject.kt")
                public void testUsePrivateTopLevelFunInsidePublicInlineMethodInLocalObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelFunInsidePublicInlineMethodInLocalObject.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelFunWithDifferentVisibility.kt")
                public void testUsePrivateTopLevelFunWithDifferentVisibility() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelFunWithDifferentVisibility.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelSetterFromInternalInlineFun.kt")
                public void testUsePrivateTopLevelSetterFromInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelSetterFromInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelSetterFromInternalInlineVar.kt")
                public void testUsePrivateTopLevelSetterFromInternalInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelSetterFromInternalInlineVar.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelSuspendFun.kt")
                public void testUsePrivateTopLevelSuspendFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelSuspendFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelVarFromInternalInlineFun.kt")
                public void testUsePrivateTopLevelVarFromInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelVarFromInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelVarFromInternalInlineVar.kt")
                public void testUsePrivateTopLevelVarFromInternalInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/singleFile/usePrivateTopLevelVarFromInternalInlineVar.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CrossModulePrivateLeak {
                @Test
                public void testAllFilesPresentInCrossModulePrivateLeak() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="leakingLateinitIsInitializedFromInternalInline.kt")
                public void testLeakingLateinitIsInitializedFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingLateinitIsInitializedFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateClassFromLocalObjectInsideInternalInline.kt")
                public void testLeakingPrivateClassFromLocalObjectInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateClassFromLocalObjectInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateClassThroughGenericType.kt")
                public void testLeakingPrivateClassThroughGenericType() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateClassThroughGenericType.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionFun.kt")
                public void testLeakingPrivateExtensionFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateExtensionFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionFunThroughPrivateInlineChain.kt")
                public void testLeakingPrivateExtensionFunThroughPrivateInlineChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateExtensionFunThroughPrivateInlineChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionVarThroughInlineFun.kt")
                public void testLeakingPrivateExtensionVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateExtensionVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionVarThroughPrivateInlineVarChain.kt")
                public void testLeakingPrivateExtensionVarThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateExtensionVarThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFun.kt")
                public void testLeakingPrivateTopLevelFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunFromDefaultArguments.kt")
                public void testLeakingPrivateTopLevelFunFromDefaultArguments() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelFunFromDefaultArguments.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunFromLambdaInsideInternalInline.kt")
                public void testLeakingPrivateTopLevelFunFromLambdaInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelFunFromLambdaInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunFromLambdaInsidePublicInline.kt")
                public void testLeakingPrivateTopLevelFunFromLambdaInsidePublicInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelFunFromLambdaInsidePublicInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunThroughPrivateInlineFunChain.kt")
                public void testLeakingPrivateTopLevelFunThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelFunThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunThroughPrivateInlineMethodInLocalObject.kt")
                public void testLeakingPrivateTopLevelFunThroughPrivateInlineMethodInLocalObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelFunThroughPrivateInlineMethodInLocalObject.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunThroughPublicInlineMethodInLocalObject.kt")
                public void testLeakingPrivateTopLevelFunThroughPublicInlineMethodInLocalObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelFunThroughPublicInlineMethodInLocalObject.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunWithDifferentVisibility.kt")
                public void testLeakingPrivateTopLevelFunWithDifferentVisibility() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelFunWithDifferentVisibility.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelLateinitVar.kt")
                public void testLeakingPrivateTopLevelLateinitVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelLateinitVar.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelSetterThroughInlineFun.kt")
                public void testLeakingPrivateTopLevelSetterThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelSetterThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelSetterThroughInlineVar.kt")
                public void testLeakingPrivateTopLevelSetterThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelSetterThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelSuspendFun.kt")
                public void testLeakingPrivateTopLevelSuspendFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelSuspendFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelVarThroughInlineFun.kt")
                public void testLeakingPrivateTopLevelVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelVarThroughInlineFunParameter.kt")
                public void testLeakingPrivateTopLevelVarThroughInlineFunParameter() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelVarThroughInlineFunParameter.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelVarThroughInlineVar.kt")
                public void testLeakingPrivateTopLevelVarThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingPrivateTopLevelVarThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingTopLevelPrivateSetterThroughPrivateInlineFunChain.kt")
                public void testLeakingTopLevelPrivateSetterThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingTopLevelPrivateSetterThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingTopLevelPrivateVarThroughPrivateInlineFunChain.kt")
                public void testLeakingTopLevelPrivateVarThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingTopLevelPrivateVarThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingTopLevelPrivateVarThroughPrivateInlineVarChain.kt")
                public void testLeakingTopLevelPrivateVarThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/leakingTopLevelPrivateVarThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="potentiallyClashingFunAccessors.kt")
                public void testPotentiallyClashingFunAccessors() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/potentiallyClashingFunAccessors.kt");
                }

                @Test
                @TestMetadata(value="potentiallyClashingVarAccessors.kt")
                public void testPotentiallyClashingVarAccessors() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/potentiallyClashingVarAccessors.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelConstValFromInternalInline.kt")
                public void testUsePrivateTopLevelConstValFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossModulePrivateLeak/usePrivateTopLevelConstValFromInternalInline.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CrossFilePrivateLeak {
                @Test
                public void testAllFilesPresentInCrossFilePrivateLeak() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="leakingLateinitIsInitializedFromInternalInline.kt")
                public void testLeakingLateinitIsInitializedFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingLateinitIsInitializedFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateClassFromLocalObjectInsideInternalInline.kt")
                public void testLeakingPrivateClassFromLocalObjectInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateClassFromLocalObjectInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateClassThroughGenericType.kt")
                public void testLeakingPrivateClassThroughGenericType() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateClassThroughGenericType.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionFun.kt")
                public void testLeakingPrivateExtensionFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateExtensionFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionFunThroughPrivateInlineChain.kt")
                public void testLeakingPrivateExtensionFunThroughPrivateInlineChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateExtensionFunThroughPrivateInlineChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionVarThroughInlineFun.kt")
                public void testLeakingPrivateExtensionVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateExtensionVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionVarThroughPrivateInlineVarChain.kt")
                public void testLeakingPrivateExtensionVarThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateExtensionVarThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFun.kt")
                public void testLeakingPrivateTopLevelFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunFromDefaultArguments.kt")
                public void testLeakingPrivateTopLevelFunFromDefaultArguments() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelFunFromDefaultArguments.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunFromLambdaInsideInternalInline.kt")
                public void testLeakingPrivateTopLevelFunFromLambdaInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelFunFromLambdaInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunFromLambdaInsidePublicInline.kt")
                public void testLeakingPrivateTopLevelFunFromLambdaInsidePublicInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelFunFromLambdaInsidePublicInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunThroughPrivateInlineFunChain.kt")
                public void testLeakingPrivateTopLevelFunThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelFunThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunThroughPrivateInlineMethodInLocalObject.kt")
                public void testLeakingPrivateTopLevelFunThroughPrivateInlineMethodInLocalObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelFunThroughPrivateInlineMethodInLocalObject.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunThroughPublicInlineMethodInLocalObject.kt")
                public void testLeakingPrivateTopLevelFunThroughPublicInlineMethodInLocalObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelFunThroughPublicInlineMethodInLocalObject.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelFunWithDifferentVisibility.kt")
                public void testLeakingPrivateTopLevelFunWithDifferentVisibility() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelFunWithDifferentVisibility.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelLateinitVar.kt")
                public void testLeakingPrivateTopLevelLateinitVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelLateinitVar.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelSetterThroughInlineFun.kt")
                public void testLeakingPrivateTopLevelSetterThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelSetterThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelSetterThroughInlineVar.kt")
                public void testLeakingPrivateTopLevelSetterThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelSetterThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelSuspendFun.kt")
                public void testLeakingPrivateTopLevelSuspendFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelSuspendFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelVarThroughInlineFun.kt")
                public void testLeakingPrivateTopLevelVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelVarThroughInlineFunParameter.kt")
                public void testLeakingPrivateTopLevelVarThroughInlineFunParameter() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelVarThroughInlineFunParameter.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateTopLevelVarThroughInlineVar.kt")
                public void testLeakingPrivateTopLevelVarThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingPrivateTopLevelVarThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingTopLevelPrivateSetterThroughPrivateInlineFunChain.kt")
                public void testLeakingTopLevelPrivateSetterThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingTopLevelPrivateSetterThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingTopLevelPrivateVarThroughPrivateInlineFunChain.kt")
                public void testLeakingTopLevelPrivateVarThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingTopLevelPrivateVarThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingTopLevelPrivateVarThroughPrivateInlineVarChain.kt")
                public void testLeakingTopLevelPrivateVarThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/leakingTopLevelPrivateVarThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="potentiallyClashingFunAccessors.kt")
                public void testPotentiallyClashingFunAccessors() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/potentiallyClashingFunAccessors.kt");
                }

                @Test
                @TestMetadata(value="potentiallyClashingVarAccessors.kt")
                public void testPotentiallyClashingVarAccessors() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/potentiallyClashingVarAccessors.kt");
                }

                @Test
                @TestMetadata(value="usePrivateTopLevelConstValFromInternalInline.kt")
                public void testUsePrivateTopLevelConstValFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/topLevelPrivate/crossFilePrivateLeak/usePrivateTopLevelConstValFromInternalInline.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/klib/syntheticAccessors/privateMember")
        @TestDataPath(value="$PROJECT_ROOT")
        public class PrivateMember {
            @Test
            public void testAllFilesPresentInPrivateMember() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/privateMember"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/klib/syntheticAccessors/privateMember/singleFile")
            @TestDataPath(value="$PROJECT_ROOT")
            public class SingleFile {
                @Test
                public void testAllFilesPresentInSingleFile() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/privateMember/singleFile"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughEffectivelyInternalInline.kt")
                public void testLeakingPrivateMethodThroughEffectivelyInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/leakingPrivateMethodThroughEffectivelyInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughReference.kt")
                public void testLeakingPrivateMethodThroughReference() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/leakingPrivateMethodThroughReference.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodWithDifferentVisibility.kt")
                public void testLeakingPrivateMethodWithDifferentVisibility() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/leakingPrivateMethodWithDifferentVisibility.kt");
                }

                @Test
                @TestMetadata(value="useCompanionPrivateMethodFromInternalInline.kt")
                public void testUseCompanionPrivateMethodFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/useCompanionPrivateMethodFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="useLateinitIsInitializedFromInternalInline.kt")
                public void testUseLateinitIsInitializedFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/useLateinitIsInitializedFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateClassConstructor.kt")
                public void testUsePrivateClassConstructor() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateClassConstructor.kt");
                }

                @Test
                @TestMetadata(value="usePrivateCompanionThroughInternalInlineFun.kt")
                public void testUsePrivateCompanionThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateCompanionThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateConstructorFromInternalInline.kt")
                public void testUsePrivateConstructorFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateConstructorFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateConstructorWithTypeParameter.kt")
                public void testUsePrivateConstructorWithTypeParameter() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateConstructorWithTypeParameter.kt");
                }

                @Test
                @TestMetadata(value="usePrivateExtensionFromInternalInline.kt")
                public void testUsePrivateExtensionFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateExtensionFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateFunInterfaceFromInternalFun.kt")
                public void testUsePrivateFunInterfaceFromInternalFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateFunInterfaceFromInternalFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateInnerClassThroughInternalInlineFun.kt")
                public void testUsePrivateInnerClassThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateInnerClassThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateMethodFromDefaultArguments.kt")
                public void testUsePrivateMethodFromDefaultArguments() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateMethodFromDefaultArguments.kt");
                }

                @Test
                @TestMetadata(value="usePrivateMethodFromInternalInline.kt")
                public void testUsePrivateMethodFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateMethodFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateMethodFromLocalObjectInsideInternalInline.kt")
                public void testUsePrivateMethodFromLocalObjectInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateMethodFromLocalObjectInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateMethodFromLocalObjectWithCrossinlineUsageInsideInternalInline.kt")
                public void testUsePrivateMethodFromLocalObjectWithCrossinlineUsageInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateMethodFromLocalObjectWithCrossinlineUsageInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateMethodFromLocalObjectWithCrossinlineUsageInsidePublicInline.kt")
                public void testUsePrivateMethodFromLocalObjectWithCrossinlineUsageInsidePublicInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateMethodFromLocalObjectWithCrossinlineUsageInsidePublicInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateMethodThroughInlineMethodInLocalObjectInPublicInline.kt")
                public void testUsePrivateMethodThroughInlineMethodInLocalObjectInPublicInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateMethodThroughInlineMethodInLocalObjectInPublicInline.kt");
                }

                @Test
                @TestMetadata(value="usePrivateNestedClassThroughInternalInlineFun.kt")
                public void testUsePrivateNestedClassThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateNestedClassThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateOperatorMethod.kt")
                public void testUsePrivateOperatorMethod() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateOperatorMethod.kt");
                }

                @Test
                @TestMetadata(value="usePrivateSetterFromInternalInlineFun.kt")
                public void testUsePrivateSetterFromInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateSetterFromInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateSetterFromInternalInlineVar.kt")
                public void testUsePrivateSetterFromInternalInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateSetterFromInternalInlineVar.kt");
                }

                @Test
                @TestMetadata(value="usePrivateVarFromInternalInlineFun.kt")
                public void testUsePrivateVarFromInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateVarFromInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateVarFromInternalInlineVar.kt")
                public void testUsePrivateVarFromInternalInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateVarFromInternalInlineVar.kt");
                }

                @Test
                @TestMetadata(value="usePrivateVarFromReferenceInInternalInlineFun.kt")
                public void testUsePrivateVarFromReferenceInInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateVarFromReferenceInInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateVarFromReferenceInPublicInlineFun.kt")
                public void testUsePrivateVarFromReferenceInPublicInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/usePrivateVarFromReferenceInPublicInlineFun.kt");
                }

                @Test
                @TestMetadata(value="useSeveralPrivateConstructorsThroughInternalInlineFun.kt")
                public void testUseSeveralPrivateConstructorsThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/singleFile/useSeveralPrivateConstructorsThroughInternalInlineFun.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CrossModulePrivateLeak {
                @Test
                public void testAllFilesPresentInCrossModulePrivateLeak() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateMethod.kt")
                public void testLeakingCompanionPrivateMethod() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingCompanionPrivateMethod.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateMethodThroughTopLevelInlineFun.kt")
                public void testLeakingCompanionPrivateMethodThroughTopLevelInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingCompanionPrivateMethodThroughTopLevelInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughCompanionInlineFun.kt")
                public void testLeakingCompanionPrivateVarThroughCompanionInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingCompanionPrivateVarThroughCompanionInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughCompanionInlineVar.kt")
                public void testLeakingCompanionPrivateVarThroughCompanionInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingCompanionPrivateVarThroughCompanionInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughInlineFun.kt")
                public void testLeakingCompanionPrivateVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingCompanionPrivateVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughInlineVar.kt")
                public void testLeakingCompanionPrivateVarThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingCompanionPrivateVarThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingLateinitIsInitializedFromInternalInline.kt")
                public void testLeakingLateinitIsInitializedFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingLateinitIsInitializedFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateCompanionThroughInternalInlineFun.kt")
                public void testLeakingPrivateCompanionThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateCompanionThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorThroughInternalInlineFun.kt")
                public void testLeakingPrivateConstructorThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateConstructorThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorWithTypeParameter.kt")
                public void testLeakingPrivateConstructorWithTypeParameter() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateConstructorWithTypeParameter.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionFun.kt")
                public void testLeakingPrivateExtensionFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateExtensionFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionFunThroughPrivateInlineChain.kt")
                public void testLeakingPrivateExtensionFunThroughPrivateInlineChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateExtensionFunThroughPrivateInlineChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionMember.kt")
                public void testLeakingPrivateExtensionMember() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateExtensionMember.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionVarThroughInlineFun.kt")
                public void testLeakingPrivateExtensionVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateExtensionVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionVarThroughPrivateInlineVarChain.kt")
                public void testLeakingPrivateExtensionVarThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateExtensionVarThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateInnerClassThroughInternalInlineFun.kt")
                public void testLeakingPrivateInnerClassThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateInnerClassThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethod.kt")
                public void testLeakingPrivateMethod() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethod.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromDefaultArguments.kt")
                public void testLeakingPrivateMethodFromDefaultArguments() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodFromDefaultArguments.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromLocalLambdaInsideInternalInline.kt")
                public void testLeakingPrivateMethodFromLocalLambdaInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodFromLocalLambdaInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromLocalObjectInsideInternalInline.kt")
                public void testLeakingPrivateMethodFromLocalObjectInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodFromLocalObjectInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsideInternalInline.kt")
                public void testLeakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsidePublicInline.kt")
                public void testLeakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsidePublicInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsidePublicInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodInInnerClass.kt")
                public void testLeakingPrivateMethodInInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodInInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodInInnerClassThroughtOuterInlineFun.kt")
                public void testLeakingPrivateMethodInInnerClassThroughtOuterInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodInInnerClassThroughtOuterInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodInNestedClass.kt")
                public void testLeakingPrivateMethodInNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodInNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodInNestedClassThroughtOuterInlineFun.kt")
                public void testLeakingPrivateMethodInNestedClassThroughtOuterInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodInNestedClassThroughtOuterInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughEffectivelyInternalInline.kt")
                public void testLeakingPrivateMethodThroughEffectivelyInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodThroughEffectivelyInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughInheritedClass.kt")
                public void testLeakingPrivateMethodThroughInheritedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodThroughInheritedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughInheritedCompanion.kt")
                public void testLeakingPrivateMethodThroughInheritedCompanion() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodThroughInheritedCompanion.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughInlineMethodInLocalObjectInPublicInline.kt")
                public void testLeakingPrivateMethodThroughInlineMethodInLocalObjectInPublicInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodThroughInlineMethodInLocalObjectInPublicInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughPrivateInlineChain.kt")
                public void testLeakingPrivateMethodThroughPrivateInlineChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodThroughPrivateInlineChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughReference.kt")
                public void testLeakingPrivateMethodThroughReference() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodThroughReference.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodWithDifferentVisibility.kt")
                public void testLeakingPrivateMethodWithDifferentVisibility() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateMethodWithDifferentVisibility.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateNestedClassThroughInternalInlineFun.kt")
                public void testLeakingPrivateNestedClassThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateNestedClassThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateOperatorMethod.kt")
                public void testLeakingPrivateOperatorMethod() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateOperatorMethod.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateSetterThroughInlineFun.kt")
                public void testLeakingPrivateSetterThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateSetterThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateSetterThroughInlineVar.kt")
                public void testLeakingPrivateSetterThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateSetterThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateSetterThroughPrivateInlineFunChain.kt")
                public void testLeakingPrivateSetterThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateSetterThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateSetterThroughPrivateInlineVarChain.kt")
                public void testLeakingPrivateSetterThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateSetterThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughInlineFun.kt")
                public void testLeakingPrivateVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughInlineFunParameter.kt")
                public void testLeakingPrivateVarThroughInlineFunParameter() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateVarThroughInlineFunParameter.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughInlineVar.kt")
                public void testLeakingPrivateVarThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateVarThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughPrivateInlineFunChain.kt")
                public void testLeakingPrivateVarThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateVarThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughPrivateInlineVarChain.kt")
                public void testLeakingPrivateVarThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateVarThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughReferenceInInternalInlineFun.kt")
                public void testLeakingPrivateVarThroughReferenceInInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateVarThroughReferenceInInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughReferenceInPublicInlineFun.kt")
                public void testLeakingPrivateVarThroughReferenceInPublicInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingPrivateVarThroughReferenceInPublicInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingSeveralPrivateConstructorsThroughInternalInlineFun.kt")
                public void testLeakingSeveralPrivateConstructorsThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/leakingSeveralPrivateConstructorsThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateConstValFromInternalInline.kt")
                public void testUsePrivateConstValFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossModulePrivateLeak/usePrivateConstValFromInternalInline.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CrossFilePrivateLeak {
                @Test
                public void testAllFilesPresentInCrossFilePrivateLeak() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateMethod.kt")
                public void testLeakingCompanionPrivateMethod() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingCompanionPrivateMethod.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateMethodThroughTopLevelInlineFun.kt")
                public void testLeakingCompanionPrivateMethodThroughTopLevelInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingCompanionPrivateMethodThroughTopLevelInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughCompanionInlineFun.kt")
                public void testLeakingCompanionPrivateVarThroughCompanionInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingCompanionPrivateVarThroughCompanionInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughCompanionInlineVar.kt")
                public void testLeakingCompanionPrivateVarThroughCompanionInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingCompanionPrivateVarThroughCompanionInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughInlineFun.kt")
                public void testLeakingCompanionPrivateVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingCompanionPrivateVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughInlineVar.kt")
                public void testLeakingCompanionPrivateVarThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingCompanionPrivateVarThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingLateinitIsInitializedFromInternalInline.kt")
                public void testLeakingLateinitIsInitializedFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingLateinitIsInitializedFromInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateCompanionThroughInternalInlineFun.kt")
                public void testLeakingPrivateCompanionThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateCompanionThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorThroughInternalInlineFun.kt")
                public void testLeakingPrivateConstructorThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateConstructorThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorWithTypeParameter.kt")
                public void testLeakingPrivateConstructorWithTypeParameter() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateConstructorWithTypeParameter.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionFun.kt")
                public void testLeakingPrivateExtensionFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateExtensionFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionFunThroughPrivateInlineChain.kt")
                public void testLeakingPrivateExtensionFunThroughPrivateInlineChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateExtensionFunThroughPrivateInlineChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionMember.kt")
                public void testLeakingPrivateExtensionMember() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateExtensionMember.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionVarThroughInlineFun.kt")
                public void testLeakingPrivateExtensionVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateExtensionVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateExtensionVarThroughPrivateInlineVarChain.kt")
                public void testLeakingPrivateExtensionVarThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateExtensionVarThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateInnerClassThroughInternalInlineFun.kt")
                public void testLeakingPrivateInnerClassThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateInnerClassThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethod.kt")
                public void testLeakingPrivateMethod() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethod.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromDefaultArguments.kt")
                public void testLeakingPrivateMethodFromDefaultArguments() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodFromDefaultArguments.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromLocalLambdaInsideInternalInline.kt")
                public void testLeakingPrivateMethodFromLocalLambdaInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodFromLocalLambdaInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromLocalObjectInsideInternalInline.kt")
                public void testLeakingPrivateMethodFromLocalObjectInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodFromLocalObjectInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsideInternalInline.kt")
                public void testLeakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsideInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsideInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsidePublicInline.kt")
                public void testLeakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsidePublicInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodFromLocalObjectWithCrossinlineUsageInsidePublicInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodInInnerClass.kt")
                public void testLeakingPrivateMethodInInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodInInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodInInnerClassThroughtOuterInlineFun.kt")
                public void testLeakingPrivateMethodInInnerClassThroughtOuterInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodInInnerClassThroughtOuterInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodInNestedClass.kt")
                public void testLeakingPrivateMethodInNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodInNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodInNestedClassThroughtOuterInlineFun.kt")
                public void testLeakingPrivateMethodInNestedClassThroughtOuterInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodInNestedClassThroughtOuterInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughEffectivelyInternalInline.kt")
                public void testLeakingPrivateMethodThroughEffectivelyInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodThroughEffectivelyInternalInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughInheritedClass.kt")
                public void testLeakingPrivateMethodThroughInheritedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodThroughInheritedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughInheritedCompanion.kt")
                public void testLeakingPrivateMethodThroughInheritedCompanion() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodThroughInheritedCompanion.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughInlineMethodInLocalObjectInPublicInline.kt")
                public void testLeakingPrivateMethodThroughInlineMethodInLocalObjectInPublicInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodThroughInlineMethodInLocalObjectInPublicInline.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughPrivateInlineChain.kt")
                public void testLeakingPrivateMethodThroughPrivateInlineChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodThroughPrivateInlineChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodThroughReference.kt")
                public void testLeakingPrivateMethodThroughReference() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodThroughReference.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateMethodWithDifferentVisibility.kt")
                public void testLeakingPrivateMethodWithDifferentVisibility() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateMethodWithDifferentVisibility.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateNestedClassThroughInternalInlineFun.kt")
                public void testLeakingPrivateNestedClassThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateNestedClassThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateOperatorMethod.kt")
                public void testLeakingPrivateOperatorMethod() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateOperatorMethod.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateSetterThroughInlineFun.kt")
                public void testLeakingPrivateSetterThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateSetterThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateSetterThroughInlineVar.kt")
                public void testLeakingPrivateSetterThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateSetterThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateSetterThroughPrivateInlineFunChain.kt")
                public void testLeakingPrivateSetterThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateSetterThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateSetterThroughPrivateInlineVarChain.kt")
                public void testLeakingPrivateSetterThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateSetterThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughInlineFun.kt")
                public void testLeakingPrivateVarThroughInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateVarThroughInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughInlineFunParameter.kt")
                public void testLeakingPrivateVarThroughInlineFunParameter() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateVarThroughInlineFunParameter.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughInlineVar.kt")
                public void testLeakingPrivateVarThroughInlineVar() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateVarThroughInlineVar.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughPrivateInlineFunChain.kt")
                public void testLeakingPrivateVarThroughPrivateInlineFunChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateVarThroughPrivateInlineFunChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughPrivateInlineVarChain.kt")
                public void testLeakingPrivateVarThroughPrivateInlineVarChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateVarThroughPrivateInlineVarChain.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughReferenceInInternalInlineFun.kt")
                public void testLeakingPrivateVarThroughReferenceInInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateVarThroughReferenceInInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateVarThroughReferenceInPublicInlineFun.kt")
                public void testLeakingPrivateVarThroughReferenceInPublicInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingPrivateVarThroughReferenceInPublicInlineFun.kt");
                }

                @Test
                @TestMetadata(value="leakingSeveralPrivateConstructorsThroughInternalInlineFun.kt")
                public void testLeakingSeveralPrivateConstructorsThroughInternalInlineFun() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/leakingSeveralPrivateConstructorsThroughInternalInlineFun.kt");
                }

                @Test
                @TestMetadata(value="usePrivateConstValFromInternalInline.kt")
                public void testUsePrivateConstValFromInternalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/privateMember/crossFilePrivateLeak/usePrivateConstValFromInternalInline.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/klib/syntheticAccessors/outerThis")
        @TestDataPath(value="$PROJECT_ROOT")
        public class OuterThis {
            @Test
            public void testAllFilesPresentInOuterThis() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/outerThis"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/klib/syntheticAccessors/outerThis/singleFile")
            @TestDataPath(value="$PROJECT_ROOT")
            public class SingleFile {
                @Test
                public void testAllFilesPresentInSingleFile() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/outerThis/singleFile"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateMethodThroughInnerClass.kt")
                public void testLeakingCompanionPrivateMethodThroughInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingCompanionPrivateMethodThroughInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughNestedClass.kt")
                public void testLeakingCompanionPrivateVarThroughNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingCompanionPrivateVarThroughNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateMethodThroughInnerClass.kt")
                public void testLeakingOuterPrivateMethodThroughInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingOuterPrivateMethodThroughInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateMethodThroughInnerClassWithDifferentVisibility.kt")
                public void testLeakingOuterPrivateMethodThroughInnerClassWithDifferentVisibility() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingOuterPrivateMethodThroughInnerClassWithDifferentVisibility.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateMethodThroughNestedClass.kt")
                public void testLeakingOuterPrivateMethodThroughNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingOuterPrivateMethodThroughNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateVarThroughInnerClass.kt")
                public void testLeakingOuterPrivateVarThroughInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingOuterPrivateVarThroughInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateVarThroughNestedClass.kt")
                public void testLeakingOuterPrivateVarThroughNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingOuterPrivateVarThroughNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterThisWithTypeParameters.kt")
                public void testLeakingOuterThisWithTypeParameters() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingOuterThisWithTypeParameters.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorThroughPublicInlineFunInInnerClass.kt")
                public void testLeakingPrivateConstructorThroughPublicInlineFunInInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingPrivateConstructorThroughPublicInlineFunInInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorThroughPublicInlineFunInNestedClass.kt")
                public void testLeakingPrivateConstructorThroughPublicInlineFunInNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/leakingPrivateConstructorThroughPublicInlineFunInNestedClass.kt");
                }

                @Test
                @TestMetadata(value="outerThisUsage.kt")
                public void testOuterThisUsage() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/singleFile/outerThisUsage.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CrossModuleLeak {
                @Test
                public void testAllFilesPresentInCrossModuleLeak() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateMethodThroughInnerClass.kt")
                public void testLeakingCompanionPrivateMethodThroughInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingCompanionPrivateMethodThroughInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughNestedClass.kt")
                public void testLeakingCompanionPrivateVarThroughNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingCompanionPrivateVarThroughNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateMethodThroughInnerClass.kt")
                public void testLeakingOuterPrivateMethodThroughInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingOuterPrivateMethodThroughInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateMethodThroughInnerClassWithDifferentVisibility.kt")
                public void testLeakingOuterPrivateMethodThroughInnerClassWithDifferentVisibility() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingOuterPrivateMethodThroughInnerClassWithDifferentVisibility.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateMethodThroughNestedClass.kt")
                public void testLeakingOuterPrivateMethodThroughNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingOuterPrivateMethodThroughNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateVarThroughInnerClass.kt")
                public void testLeakingOuterPrivateVarThroughInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingOuterPrivateVarThroughInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateVarThroughNestedClass.kt")
                public void testLeakingOuterPrivateVarThroughNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingOuterPrivateVarThroughNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterThis.kt")
                public void testLeakingOuterThis() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingOuterThis.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterThisWithTypeParameters.kt")
                public void testLeakingOuterThisWithTypeParameters() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingOuterThisWithTypeParameters.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorThroughPublicInlineFunInInnerClass.kt")
                public void testLeakingPrivateConstructorThroughPublicInlineFunInInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingPrivateConstructorThroughPublicInlineFunInInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorThroughPublicInlineFunInNestedClass.kt")
                public void testLeakingPrivateConstructorThroughPublicInlineFunInNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossModuleLeak/leakingPrivateConstructorThroughPublicInlineFunInNestedClass.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CrossFileLeak {
                @Test
                public void testAllFilesPresentInCrossFileLeak() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateMethodThroughInnerClass.kt")
                public void testLeakingCompanionPrivateMethodThroughInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingCompanionPrivateMethodThroughInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingCompanionPrivateVarThroughNestedClass.kt")
                public void testLeakingCompanionPrivateVarThroughNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingCompanionPrivateVarThroughNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateMethodThroughInnerClass.kt")
                public void testLeakingOuterPrivateMethodThroughInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingOuterPrivateMethodThroughInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateMethodThroughInnerClassWithDifferentVisibility.kt")
                public void testLeakingOuterPrivateMethodThroughInnerClassWithDifferentVisibility() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingOuterPrivateMethodThroughInnerClassWithDifferentVisibility.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateMethodThroughNestedClass.kt")
                public void testLeakingOuterPrivateMethodThroughNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingOuterPrivateMethodThroughNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateVarThroughInnerClass.kt")
                public void testLeakingOuterPrivateVarThroughInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingOuterPrivateVarThroughInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterPrivateVarThroughNestedClass.kt")
                public void testLeakingOuterPrivateVarThroughNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingOuterPrivateVarThroughNestedClass.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterThis.kt")
                public void testLeakingOuterThis() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingOuterThis.kt");
                }

                @Test
                @TestMetadata(value="leakingOuterThisWithTypeParameters.kt")
                public void testLeakingOuterThisWithTypeParameters() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingOuterThisWithTypeParameters.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorThroughPublicInlineFunInInnerClass.kt")
                public void testLeakingPrivateConstructorThroughPublicInlineFunInInnerClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingPrivateConstructorThroughPublicInlineFunInInnerClass.kt");
                }

                @Test
                @TestMetadata(value="leakingPrivateConstructorThroughPublicInlineFunInNestedClass.kt")
                public void testLeakingPrivateConstructorThroughPublicInlineFunInNestedClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/klib/syntheticAccessors/outerThis/crossFileLeak/leakingPrivateConstructorThroughPublicInlineFunInNestedClass.kt");
                }
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/boxInline")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BoxInline {
        @Test
        public void testAllFilesPresentInBoxInline() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/wasm-new-exception-handling")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Wasm_new_exception_handling {
            @Test
            public void testAllFilesPresentInWasm_new_exception_handling() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/wasm-new-exception-handling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/varargs")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Varargs {
            @Test
            public void testAllFilesPresentInVarargs() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt17653.kt")
            public void testKt17653() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/varargs/kt17653.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParameters.kt")
            public void testVarargAndDefaultParameters() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParameters2.kt")
            public void testVarargAndDefaultParameters2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/varargs/varargAndDefaultParameters2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/typeParameters")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TypeParameters {
            @Test
            public void testAllFilesPresentInTypeParameters() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/typeParameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObject.kt")
            public void testAnonymousObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/anonymousObject.kt");
            }

            @Test
            @TestMetadata(value="basic.kt")
            public void testBasic() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/basic.kt");
            }

            @Test
            @TestMetadata(value="projectionTypeArguments.kt")
            public void testProjectionTypeArguments() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/projectionTypeArguments.kt");
            }

            @Test
            @TestMetadata(value="severalUpperBounds.kt")
            public void testSeveralUpperBounds() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/severalUpperBounds.kt");
            }

            @Test
            @TestMetadata(value="typeArgFromGenericBaseClass.kt")
            public void testTypeArgFromGenericBaseClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/typeArgFromGenericBaseClass.kt");
            }

            @Test
            @TestMetadata(value="uncheckedCastToNothing.kt")
            public void testUncheckedCastToNothing() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/typeParameters/uncheckedCastToNothing.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/tryCatchFinally")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TryCatchFinally {
            @Test
            public void testAllFilesPresentInTryCatchFinally() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/tryCatchFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt5863.kt")
            public void testKt5863() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/kt5863.kt");
            }

            @Test
            @TestMetadata(value="tryCatch.kt")
            public void testTryCatch() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch.kt");
            }

            @Test
            @TestMetadata(value="tryCatch2.kt")
            public void testTryCatch2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatch2.kt");
            }

            @Test
            @TestMetadata(value="tryCatchFinally.kt")
            public void testTryCatchFinally() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/tryCatchFinally/tryCatchFinally.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/trait")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Trait {
            @Test
            public void testAllFilesPresentInTrait() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/trait"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="trait.kt")
            public void testTrait() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/trait/trait.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/syntheticAccessors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SyntheticAccessors {
            @Test
            public void testAllFilesPresentInSyntheticAccessors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="constField.kt")
            public void testConstField() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/constField.kt");
            }

            @Test
            @TestMetadata(value="packagePrivateMembers.kt")
            public void testPackagePrivateMembers() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/packagePrivateMembers.kt");
            }

            @Test
            @TestMetadata(value="propertyModifiers.kt")
            public void testPropertyModifiers() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/propertyModifiers.kt");
            }

            @Test
            @TestMetadata(value="superCall.kt")
            public void testSuperCall() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCall.kt");
            }

            @Test
            @TestMetadata(value="superCallFromMultipleSubclasses.kt")
            public void testSuperCallFromMultipleSubclasses() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superCallFromMultipleSubclasses.kt");
            }

            @Test
            @TestMetadata(value="superProperty.kt")
            public void testSuperProperty() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/superProperty.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class WithinInlineLambda {
                @Test
                public void testAllFilesPresentInWithinInlineLambda() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="directFieldAccess.kt")
                public void testDirectFieldAccess() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccess.kt");
                }

                @Test
                @TestMetadata(value="directFieldAccessInCrossInline.kt")
                public void testDirectFieldAccessInCrossInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/directFieldAccessInCrossInline.kt");
                }

                @Test
                @TestMetadata(value="privateCall.kt")
                public void testPrivateCall() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateCall.kt");
                }

                @Test
                @TestMetadata(value="privateInCrossInline.kt")
                public void testPrivateInCrossInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInCrossInline.kt");
                }

                @Test
                @TestMetadata(value="privateInDefaultStubArgument.kt")
                public void testPrivateInDefaultStubArgument() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/privateInDefaultStubArgument.kt");
                }

                @Test
                @TestMetadata(value="protectedInCrossinline.kt")
                public void testProtectedInCrossinline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/protectedInCrossinline.kt");
                }

                @Test
                @TestMetadata(value="superCall.kt")
                public void testSuperCall() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superCall.kt");
                }

                @Test
                @TestMetadata(value="superInCrossInline.kt")
                public void testSuperInCrossInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/syntheticAccessors/withinInlineLambda/superInCrossInline.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/suspend")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Suspend {
            @Test
            public void testAllFilesPresentInSuspend() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="capturedVariables.kt")
            public void testCapturedVariables() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/capturedVariables.kt");
            }

            @Test
            @TestMetadata(value="crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt")
            public void testCrossinlineSuspendLambdaInsideCrossinlineSuspendLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/crossinlineSuspendLambdaInsideCrossinlineSuspendLambda.kt");
            }

            @Test
            @TestMetadata(value="debugMetadataCrossinline.kt")
            public void testDebugMetadataCrossinline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/debugMetadataCrossinline.kt");
            }

            @Test
            @TestMetadata(value="delegatedProperties.kt")
            public void testDelegatedProperties() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/delegatedProperties.kt");
            }

            @Test
            @TestMetadata(value="doubleRegenerationWithNonSuspendingLambda.kt")
            public void testDoubleRegenerationWithNonSuspendingLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/doubleRegenerationWithNonSuspendingLambda.kt");
            }

            @Test
            @TestMetadata(value="enclodingMethod.kt")
            public void testEnclodingMethod() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/enclodingMethod.kt");
            }

            @Test
            @TestMetadata(value="fileNameInMetadata.kt")
            public void testFileNameInMetadata() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/fileNameInMetadata.kt");
            }

            @Test
            @TestMetadata(value="inlineOrdinaryOfCrossinlineSuspend.kt")
            public void testInlineOrdinaryOfCrossinlineSuspend() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfCrossinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineOrdinaryOfNoinlineSuspend.kt")
            public void testInlineOrdinaryOfNoinlineSuspend() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineOrdinaryOfNoinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlinePassthrough.kt")
            public void testInlinePassthrough() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlinePassthrough.kt");
            }

            @Test
            @TestMetadata(value="inlinePassthroughWithSuspendConversion.kt")
            public void testInlinePassthroughWithSuspendConversion() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlinePassthroughWithSuspendConversion.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendContinuation.kt")
            public void testInlineSuspendContinuation() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendContinuation.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendInMultifileClass.kt")
            public void testInlineSuspendInMultifileClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendInMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfCrossinlineOrdinary.kt")
            public void testInlineSuspendOfCrossinlineOrdinary() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineOrdinary.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfCrossinlineSuspend.kt")
            public void testInlineSuspendOfCrossinlineSuspend() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfCrossinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfNoinlineOrdinary.kt")
            public void testInlineSuspendOfNoinlineOrdinary() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineOrdinary.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfNoinlineSuspend.kt")
            public void testInlineSuspendOfNoinlineSuspend() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfNoinlineSuspend.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfOrdinary.kt")
            public void testInlineSuspendOfOrdinary() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfOrdinary.kt");
            }

            @Test
            @TestMetadata(value="inlineSuspendOfSuspend.kt")
            public void testInlineSuspendOfSuspend() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineSuspendOfSuspend.kt");
            }

            @Test
            @TestMetadata(value="jvmName.kt")
            public void testJvmName() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/jvmName.kt");
            }

            @Test
            @TestMetadata(value="kt26658.kt")
            public void testKt26658() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/kt26658.kt");
            }

            @Test
            @TestMetadata(value="kt52198.kt")
            public void testKt52198() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/kt52198.kt");
            }

            @Test
            @TestMetadata(value="linenumberZero.kt")
            public void testLinenumberZero() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/linenumberZero.kt");
            }

            @Test
            @TestMetadata(value="maxStackWithCrossinline.kt")
            public void testMaxStackWithCrossinline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/maxStackWithCrossinline.kt");
            }

            @Test
            @TestMetadata(value="multipleLocals.kt")
            public void testMultipleLocals() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/multipleLocals.kt");
            }

            @Test
            @TestMetadata(value="multipleSuspensionPoints.kt")
            public void testMultipleSuspensionPoints() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/multipleSuspensionPoints.kt");
            }

            @Test
            @TestMetadata(value="nestedMethodWith2XParameter.kt")
            public void testNestedMethodWith2XParameter() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/nestedMethodWith2XParameter.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn.kt")
            public void testNonLocalReturn() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/nonLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="nonSuspendCrossinline.kt")
            public void testNonSuspendCrossinline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/nonSuspendCrossinline.kt");
            }

            @Test
            @TestMetadata(value="returnValue.kt")
            public void testReturnValue() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/returnValue.kt");
            }

            @Test
            @TestMetadata(value="tryCatchReceiver.kt")
            public void testTryCatchReceiver() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/tryCatchReceiver.kt");
            }

            @Test
            @TestMetadata(value="tryCatchStackTransform.kt")
            public void testTryCatchStackTransform() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/tryCatchStackTransform.kt");
            }

            @Test
            @TestMetadata(value="twiceRegeneratedAnonymousObject.kt")
            public void testTwiceRegeneratedAnonymousObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedAnonymousObject.kt");
            }

            @Test
            @TestMetadata(value="twiceRegeneratedSuspendLambda.kt")
            public void testTwiceRegeneratedSuspendLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/twiceRegeneratedSuspendLambda.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/stateMachine")
            @TestDataPath(value="$PROJECT_ROOT")
            public class StateMachine {
                @Test
                public void testAllFilesPresentInStateMachine() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossingCoroutineBoundaries.kt")
                public void testCrossingCoroutineBoundaries() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/crossingCoroutineBoundaries.kt");
                }

                @Test
                @TestMetadata(value="independentInline.kt")
                public void testIndependentInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/independentInline.kt");
                }

                @Test
                @TestMetadata(value="innerLambda.kt")
                public void testInnerLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambda.kt");
                }

                @Test
                @TestMetadata(value="innerLambdaInsideLambda.kt")
                public void testInnerLambdaInsideLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaInsideLambda.kt");
                }

                @Test
                @TestMetadata(value="innerLambdaWithoutCrossinline.kt")
                public void testInnerLambdaWithoutCrossinline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerLambdaWithoutCrossinline.kt");
                }

                @Test
                @TestMetadata(value="innerMadness.kt")
                public void testInnerMadness() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadness.kt");
                }

                @Test
                @TestMetadata(value="innerMadnessCallSite.kt")
                public void testInnerMadnessCallSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerMadnessCallSite.kt");
                }

                @Test
                @TestMetadata(value="innerObject.kt")
                public void testInnerObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObject.kt");
                }

                @Test
                @TestMetadata(value="innerObjectInsideInnerObject.kt")
                public void testInnerObjectInsideInnerObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectInsideInnerObject.kt");
                }

                @Test
                @TestMetadata(value="innerObjectRetransformation.kt")
                public void testInnerObjectRetransformation() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectRetransformation.kt");
                }

                @Test
                @TestMetadata(value="innerObjectSeveralFunctions.kt")
                public void testInnerObjectSeveralFunctions() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectSeveralFunctions.kt");
                }

                @Test
                @TestMetadata(value="innerObjectWithoutCapturingCrossinline.kt")
                public void testInnerObjectWithoutCapturingCrossinline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/innerObjectWithoutCapturingCrossinline.kt");
                }

                @Test
                @TestMetadata(value="insideObject.kt")
                public void testInsideObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/insideObject.kt");
                }

                @Test
                @TestMetadata(value="kt30708.kt")
                public void testKt30708() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/kt30708.kt");
                }

                @Test
                @TestMetadata(value="lambdaTransformation.kt")
                public void testLambdaTransformation() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/lambdaTransformation.kt");
                }

                @Test
                @TestMetadata(value="normalInline.kt")
                public void testNormalInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/normalInline.kt");
                }

                @Test
                @TestMetadata(value="numberOfSuspentions.kt")
                public void testNumberOfSuspentions() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/numberOfSuspentions.kt");
                }

                @Test
                @TestMetadata(value="objectInsideLambdas.kt")
                public void testObjectInsideLambdas() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/objectInsideLambdas.kt");
                }

                @Test
                @TestMetadata(value="oneInlineTwoCaptures.kt")
                public void testOneInlineTwoCaptures() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/oneInlineTwoCaptures.kt");
                }

                @Test
                @TestMetadata(value="passLambda.kt")
                public void testPassLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passLambda.kt");
                }

                @Test
                @TestMetadata(value="passParameter.kt")
                public void testPassParameter() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameter.kt");
                }

                @Test
                @TestMetadata(value="passParameterLambda.kt")
                public void testPassParameterLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/passParameterLambda.kt");
                }

                @Test
                @TestMetadata(value="unreachableSuspendMarker.kt")
                public void testUnreachableSuspendMarker() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/stateMachine/unreachableSuspendMarker.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/receiver")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Receiver {
                @Test
                public void testAllFilesPresentInReceiver() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/receiver"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineOrdinaryOfCrossinlineSuspend.kt")
                public void testInlineOrdinaryOfCrossinlineSuspend() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfCrossinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineOrdinaryOfNoinlineSuspend.kt")
                public void testInlineOrdinaryOfNoinlineSuspend() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineOrdinaryOfNoinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfCrossinlineOrdinary.kt")
                public void testInlineSuspendOfCrossinlineOrdinary() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineOrdinary.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfCrossinlineSuspend.kt")
                public void testInlineSuspendOfCrossinlineSuspend() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfCrossinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfNoinlineOrdinary.kt")
                public void testInlineSuspendOfNoinlineOrdinary() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineOrdinary.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfNoinlineSuspend.kt")
                public void testInlineSuspendOfNoinlineSuspend() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfNoinlineSuspend.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfOrdinary.kt")
                public void testInlineSuspendOfOrdinary() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfOrdinary.kt");
                }

                @Test
                @TestMetadata(value="inlineSuspendOfSuspend.kt")
                public void testInlineSuspendOfSuspend() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/receiver/inlineSuspendOfSuspend.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineUsedAsNoinline {
                @Test
                public void testAllFilesPresentInInlineUsedAsNoinline() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineOnly.kt")
                public void testInlineOnly() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/inlineOnly.kt");
                }

                @Test
                @TestMetadata(value="simpleNamed.kt")
                public void testSimpleNamed() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/simpleNamed.kt");
                }

                @Test
                @TestMetadata(value="withCapturedInlineLambda.kt")
                public void testWithCapturedInlineLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="withCapturedInlineLambda2.kt")
                public void testWithCapturedInlineLambda2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineUsedAsNoinline/withCapturedInlineLambda2.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/inlineClass")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineClass {
                @Test
                public void testAllFilesPresentInInlineClass() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/inlineClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="returnBoxedFromLambda.kt")
                public void testReturnBoxedFromLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnBoxedFromLambda.kt");
                }

                @Test
                @TestMetadata(value="returnUnboxedDirect.kt")
                public void testReturnUnboxedDirect() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedDirect.kt");
                }

                @Test
                @TestMetadata(value="returnUnboxedFromLambda.kt")
                public void testReturnUnboxedFromLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedFromLambda.kt");
                }

                @Test
                @TestMetadata(value="returnUnboxedResume.kt")
                public void testReturnUnboxedResume() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/inlineClass/returnUnboxedResume.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/defaultParameter")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultParameter {
                @Test
                public void testAllFilesPresentInDefaultParameter() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/defaultParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="defaultInlineLambda.kt")
                public void testDefaultInlineLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="defaultInlineReference.kt")
                public void testDefaultInlineReference() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultInlineReference.kt");
                }

                @Test
                @TestMetadata(value="defaultValueCrossinline.kt")
                public void testDefaultValueCrossinline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueCrossinline.kt");
                }

                @Test
                @TestMetadata(value="defaultValueInClass.kt")
                public void testDefaultValueInClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInClass.kt");
                }

                @Test
                @TestMetadata(value="defaultValueInline.kt")
                public void testDefaultValueInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInline.kt");
                }

                @Test
                @TestMetadata(value="defaultValueInlineFromMultiFileFacade.kt")
                public void testDefaultValueInlineFromMultiFileFacade() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/defaultParameter/defaultValueInlineFromMultiFileFacade.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/suspend/callableReference")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CallableReference {
                @Test
                public void testAllFilesPresentInCallableReference() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/suspend/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="isAsReified.kt")
                public void testIsAsReified() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified.kt");
                }

                @Test
                @TestMetadata(value="isAsReified2.kt")
                public void testIsAsReified2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/isAsReified2.kt");
                }

                @Test
                @TestMetadata(value="nonTailCall.kt")
                public void testNonTailCall() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/nonTailCall.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/simple.kt");
                }

                @Test
                @TestMetadata(value="unitReturn.kt")
                public void testUnitReturn() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/suspend/callableReference/unitReturn.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/stackOnReturn")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StackOnReturn {
            @Test
            public void testAllFilesPresentInStackOnReturn() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/stackOnReturn"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="elvis.kt")
            public void testElvis() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/elvis.kt");
            }

            @Test
            @TestMetadata(value="ifThenElse.kt")
            public void testIfThenElse() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/ifThenElse.kt");
            }

            @Test
            @TestMetadata(value="kt11499.kt")
            public void testKt11499() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt11499.kt");
            }

            @Test
            @TestMetadata(value="kt17591.kt")
            public void testKt17591() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591.kt");
            }

            @Test
            @TestMetadata(value="kt17591a.kt")
            public void testKt17591a() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591a.kt");
            }

            @Test
            @TestMetadata(value="kt17591b.kt")
            public void testKt17591b() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/kt17591b.kt");
            }

            @Test
            @TestMetadata(value="mixedTypesOnStack1.kt")
            public void testMixedTypesOnStack1() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack1.kt");
            }

            @Test
            @TestMetadata(value="mixedTypesOnStack2.kt")
            public void testMixedTypesOnStack2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack2.kt");
            }

            @Test
            @TestMetadata(value="mixedTypesOnStack3.kt")
            public void testMixedTypesOnStack3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/mixedTypesOnStack3.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn1.kt")
            public void testNonLocalReturn1() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn1.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn2.kt")
            public void testNonLocalReturn2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn2.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn3.kt")
            public void testNonLocalReturn3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/nonLocalReturn3.kt");
            }

            @Test
            @TestMetadata(value="poppedLocalReturn.kt")
            public void testPoppedLocalReturn() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="poppedLocalReturn2.kt")
            public void testPoppedLocalReturn2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/poppedLocalReturn2.kt");
            }

            @Test
            @TestMetadata(value="returnLong.kt")
            public void testReturnLong() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/returnLong.kt");
            }

            @Test
            @TestMetadata(value="tryFinally.kt")
            public void testTryFinally() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/stackOnReturn/tryFinally.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/special")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Special {
            @Test
            public void testAllFilesPresentInSpecial() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/special"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="blockReturnsNullableUnit.kt")
            public void testBlockReturnsNullableUnit() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/blockReturnsNullableUnit.kt");
            }

            @Test
            @TestMetadata(value="identityCheck.kt")
            public void testIdentityCheck() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/identityCheck.kt");
            }

            @Test
            @TestMetadata(value="ifBranches.kt")
            public void testIfBranches() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/ifBranches.kt");
            }

            @Test
            @TestMetadata(value="iinc.kt")
            public void testIinc() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/iinc.kt");
            }

            @Test
            @TestMetadata(value="inlineChain.kt")
            public void testInlineChain() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/inlineChain.kt");
            }

            @Test
            @TestMetadata(value="loopInStoreLoadChains.kt")
            public void testLoopInStoreLoadChains() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains.kt");
            }

            @Test
            @TestMetadata(value="loopInStoreLoadChains2.kt")
            public void testLoopInStoreLoadChains2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/loopInStoreLoadChains2.kt");
            }

            @Test
            @TestMetadata(value="monitorEnterExit.kt")
            public void testMonitorEnterExit() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/monitorEnterExit.kt");
            }

            @Test
            @TestMetadata(value="plusAssign.kt")
            public void testPlusAssign() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/plusAssign.kt");
            }

            @Test
            @TestMetadata(value="stackHeightBug.kt")
            public void testStackHeightBug() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/stackHeightBug.kt");
            }

            @Test
            @TestMetadata(value="unusedInlineLambda.kt")
            public void testUnusedInlineLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/special/unusedInlineLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/smap")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Smap {
            @Test
            public void testAllFilesPresentInSmap() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="assertion.kt")
            public void testAssertion() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/assertion.kt");
            }

            @Test
            @TestMetadata(value="classCycle.kt")
            public void testClassCycle() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/classCycle.kt");
            }

            @Test
            @TestMetadata(value="classFromDefaultPackage.kt")
            public void testClassFromDefaultPackage() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/classFromDefaultPackage.kt");
            }

            @Test
            @TestMetadata(value="coroutinesWithTailCallOtpimization.kt")
            public void testCoroutinesWithTailCallOtpimization() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/coroutinesWithTailCallOtpimization.kt");
            }

            @Test
            @TestMetadata(value="crossroutines.kt")
            public void testCrossroutines() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/crossroutines.kt");
            }

            @Test
            @TestMetadata(value="defaultFunction.kt")
            public void testDefaultFunction() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultFunction.kt");
            }

            @Test
            @TestMetadata(value="defaultFunctionWithInlineCall.kt")
            public void testDefaultFunctionWithInlineCall() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultFunctionWithInlineCall.kt");
            }

            @Test
            @TestMetadata(value="forInline.kt")
            public void testForInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/forInline.kt");
            }

            @Test
            @TestMetadata(value="inlineProperty.kt")
            public void testInlineProperty() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineProperty.kt");
            }

            @Test
            @TestMetadata(value="interleavedFiles.kt")
            public void testInterleavedFiles() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/interleavedFiles.kt");
            }

            @Test
            @TestMetadata(value="kt23369.kt")
            public void testKt23369() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt23369.kt");
            }

            @Test
            @TestMetadata(value="kt23369_2.kt")
            public void testKt23369_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt23369_2.kt");
            }

            @Test
            @TestMetadata(value="kt23369_3.kt")
            public void testKt23369_3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt23369_3.kt");
            }

            @Test
            @TestMetadata(value="kt35006.kt")
            public void testKt35006() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/kt35006.kt");
            }

            @Test
            @TestMetadata(value="multiFileFacade.kt")
            public void testMultiFileFacade() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/multiFileFacade.kt");
            }

            @Test
            @TestMetadata(value="oneFile.kt")
            public void testOneFile() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/oneFile.kt");
            }

            @Test
            @TestMetadata(value="rangeFolding.kt")
            public void testRangeFolding() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/rangeFolding.kt");
            }

            @Test
            @TestMetadata(value="rangeFoldingInClass.kt")
            public void testRangeFoldingInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/rangeFoldingInClass.kt");
            }

            @Test
            @TestMetadata(value="smap.kt")
            public void testSmap() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/smap.kt");
            }

            @Test
            @TestMetadata(value="smapWithNewSyntax.kt")
            public void testSmapWithNewSyntax() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/smapWithNewSyntax.kt");
            }

            @Test
            @TestMetadata(value="tryFinally1.kt")
            public void testTryFinally1() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/tryFinally1.kt");
            }

            @Test
            @TestMetadata(value="tryFinally2.kt")
            public void testTryFinally2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/tryFinally2.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/resolve")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Resolve {
                @Test
                public void testAllFilesPresentInResolve() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/resolve"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineComponent.kt")
                public void testInlineComponent() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineComponent.kt");
                }

                @Test
                @TestMetadata(value="inlineIterator.kt")
                public void testInlineIterator() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/resolve/inlineIterator.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/newsmap")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Newsmap {
                @Test
                public void testAllFilesPresentInNewsmap() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/newsmap"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="differentMapping.kt")
                public void testDifferentMapping() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/differentMapping.kt");
                }

                @Test
                @TestMetadata(value="mappingInInlineFunLambda.kt")
                public void testMappingInInlineFunLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInInlineFunLambda.kt");
                }

                @Test
                @TestMetadata(value="mappingInSubInlineLambda.kt")
                public void testMappingInSubInlineLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="mappingInSubInlineLambdaSameFileInline.kt")
                public void testMappingInSubInlineLambdaSameFileInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/newsmap/mappingInSubInlineLambdaSameFileInline.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/inlineOnly")
            @TestDataPath(value="$PROJECT_ROOT")
            public class InlineOnly {
                @Test
                public void testAllFilesPresentInInlineOnly() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/inlineOnly"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="noSmap.kt")
                public void testNoSmap() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmap.kt");
                }

                @Test
                @TestMetadata(value="noSmapWithProperty.kt")
                public void testNoSmapWithProperty() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/noSmapWithProperty.kt");
                }

                @Test
                @TestMetadata(value="reified.kt")
                public void testReified() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reified.kt");
                }

                @Test
                @TestMetadata(value="reifiedProperty.kt")
                public void testReifiedProperty() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/reifiedProperty.kt");
                }

                @Test
                @TestMetadata(value="stdlibInlineOnly.kt")
                public void testStdlibInlineOnly() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnly.kt");
                }

                @Test
                @TestMetadata(value="stdlibInlineOnlyOneLine.kt")
                public void testStdlibInlineOnlyOneLine() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/inlineOnly/stdlibInlineOnlyOneLine.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/defaultLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultLambda {
                @Test
                public void testAllFilesPresentInDefaultLambda() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="defaultLambdaInAnonymous.kt")
                public void testDefaultLambdaInAnonymous() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/defaultLambdaInAnonymous.kt");
                }

                @Test
                @TestMetadata(value="inlineAnonymousInDefault.kt")
                public void testInlineAnonymousInDefault() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineAnonymousInDefault2.kt")
                public void testInlineAnonymousInDefault2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineAnonymousInDefault2.kt");
                }

                @Test
                @TestMetadata(value="inlineInDefault.kt")
                public void testInlineInDefault() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineInDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineInDefault2.kt")
                public void testInlineInDefault2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/inlineInDefault2.kt");
                }

                @Test
                @TestMetadata(value="kt21827.kt")
                public void testKt21827() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/kt21827.kt");
                }

                @Test
                @TestMetadata(value="nested.kt")
                public void testNested() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/nested.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple.kt");
                }

                @Test
                @TestMetadata(value="simple2.kt")
                public void testSimple2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/defaultLambda/simple2.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/smap/anonymous")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Anonymous {
                @Test
                public void testAllFilesPresentInAnonymous() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/smap/anonymous"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt19175.kt")
                public void testKt19175() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/kt19175.kt");
                }

                @Test
                @TestMetadata(value="lambda.kt")
                public void testLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambda.kt");
                }

                @Test
                @TestMetadata(value="lambdaOnCallSite.kt")
                public void testLambdaOnCallSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnCallSite.kt");
                }

                @Test
                @TestMetadata(value="lambdaOnInlineCallSite.kt")
                public void testLambdaOnInlineCallSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/lambdaOnInlineCallSite.kt");
                }

                @Test
                @TestMetadata(value="object.kt")
                public void testObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/object.kt");
                }

                @Test
                @TestMetadata(value="objectOnCallSite.kt")
                public void testObjectOnCallSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnCallSite.kt");
                }

                @Test
                @TestMetadata(value="objectOnInlineCallSite.kt")
                public void testObjectOnInlineCallSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite.kt");
                }

                @Test
                @TestMetadata(value="objectOnInlineCallSite2.kt")
                public void testObjectOnInlineCallSite2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSite2.kt");
                }

                @Test
                @TestMetadata(value="objectOnInlineCallSiteWithCapture.kt")
                public void testObjectOnInlineCallSiteWithCapture() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/objectOnInlineCallSiteWithCapture.kt");
                }

                @Test
                @TestMetadata(value="severalMappingsForDefaultFile.kt")
                public void testSeveralMappingsForDefaultFile() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/smap/anonymous/severalMappingsForDefaultFile.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/simple")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Simple {
            @Test
            public void testAllFilesPresentInSimple() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/simple"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="captureAndArgumentIncompatibleTypes.kt")
            public void testCaptureAndArgumentIncompatibleTypes() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/captureAndArgumentIncompatibleTypes.kt");
            }

            @Test
            @TestMetadata(value="classObject.kt")
            public void testClassObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/classObject.kt");
            }

            @Test
            @TestMetadata(value="destructuring.kt")
            public void testDestructuring() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/destructuring.kt");
            }

            @Test
            @TestMetadata(value="destructuringIndexClash.kt")
            public void testDestructuringIndexClash() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/destructuringIndexClash.kt");
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/extension.kt");
            }

            @Test
            @TestMetadata(value="extensionLambda.kt")
            public void testExtensionLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/extensionLambda.kt");
            }

            @Test
            @TestMetadata(value="funImportedFromObject.kt")
            public void testFunImportedFromObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/funImportedFromObject.kt");
            }

            @Test
            @TestMetadata(value="importedJavaStaticField.kt")
            public void testImportedJavaStaticField() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/importedJavaStaticField.kt");
            }

            @Test
            @TestMetadata(value="inlineCallInInlineLambda.kt")
            public void testInlineCallInInlineLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/inlineCallInInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="kt17431.kt")
            public void testKt17431() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/kt17431.kt");
            }

            @Test
            @TestMetadata(value="kt28547.kt")
            public void testKt28547() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/kt28547.kt");
            }

            @Test
            @TestMetadata(value="kt28547_2.kt")
            public void testKt28547_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/kt28547_2.kt");
            }

            @Test
            @TestMetadata(value="params.kt")
            public void testParams() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/params.kt");
            }

            @Test
            @TestMetadata(value="propImportedFromObject.kt")
            public void testPropImportedFromObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/propImportedFromObject.kt");
            }

            @Test
            @TestMetadata(value="rootConstructor.kt")
            public void testRootConstructor() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/rootConstructor.kt");
            }

            @Test
            @TestMetadata(value="safeCall.kt")
            public void testSafeCall() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/safeCall.kt");
            }

            @Test
            @TestMetadata(value="severalClosures.kt")
            public void testSeveralClosures() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/severalClosures.kt");
            }

            @Test
            @TestMetadata(value="severalUsage.kt")
            public void testSeveralUsage() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/severalUsage.kt");
            }

            @Test
            @TestMetadata(value="simpleDouble.kt")
            public void testSimpleDouble() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleDouble.kt");
            }

            @Test
            @TestMetadata(value="simpleEnum.kt")
            public void testSimpleEnum() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleEnum.kt");
            }

            @Test
            @TestMetadata(value="simpleGenerics.kt")
            public void testSimpleGenerics() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleGenerics.kt");
            }

            @Test
            @TestMetadata(value="simpleInt.kt")
            public void testSimpleInt() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleInt.kt");
            }

            @Test
            @TestMetadata(value="simpleLambda.kt")
            public void testSimpleLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleLambda.kt");
            }

            @Test
            @TestMetadata(value="simpleObject.kt")
            public void testSimpleObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/simpleObject.kt");
            }

            @Test
            @TestMetadata(value="vararg.kt")
            public void testVararg() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/simple/vararg.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/signatureMangling")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SignatureMangling {
            @Test
            public void testAllFilesPresentInSignatureMangling() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signatureMangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="flexibleType.kt")
            public void testFlexibleType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/flexibleType.kt");
            }

            @Test
            @TestMetadata(value="indices.kt")
            public void testIndices() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/indices.kt");
            }

            @Test
            @TestMetadata(value="inheritFromJava.kt")
            public void testInheritFromJava() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/inheritFromJava.kt");
            }

            @Test
            @TestMetadata(value="rawType.kt")
            public void testRawType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signatureMangling/rawType.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/signature")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Signature {
            @Test
            public void testAllFilesPresentInSignature() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/signature"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="byteIteratorWithForLoop.kt")
            public void testByteIteratorWithForLoop() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/byteIteratorWithForLoop.kt");
            }

            @Test
            @TestMetadata(value="byteIteratorWithWhileLoop.kt")
            public void testByteIteratorWithWhileLoop() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/byteIteratorWithWhileLoop.kt");
            }

            @Test
            @TestMetadata(value="inProjectionSubstitution.kt")
            public void testInProjectionSubstitution() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/inProjectionSubstitution.kt");
            }

            @Test
            @TestMetadata(value="outProjectionSubstitution.kt")
            public void testOutProjectionSubstitution() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/outProjectionSubstitution.kt");
            }

            @Test
            @TestMetadata(value="recursion.kt")
            public void testRecursion() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/recursion.kt");
            }

            @Test
            @TestMetadata(value="sameFormalParameterName.kt")
            public void testSameFormalParameterName() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/sameFormalParameterName.kt");
            }

            @Test
            @TestMetadata(value="sameReifiedFormalParameterName.kt")
            public void testSameReifiedFormalParameterName() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/sameReifiedFormalParameterName.kt");
            }

            @Test
            @TestMetadata(value="starProjectionSubstitution.kt")
            public void testStarProjectionSubstitution() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/starProjectionSubstitution.kt");
            }

            @Test
            @TestMetadata(value="typeParameterInLambda.kt")
            public void testTypeParameterInLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/typeParameterInLambda.kt");
            }

            @Test
            @TestMetadata(value="typeParametersSubstitution.kt")
            public void testTypeParametersSubstitution() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution.kt");
            }

            @Test
            @TestMetadata(value="typeParametersSubstitution2.kt")
            public void testTypeParametersSubstitution2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/signature/typeParametersSubstitution2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/reified")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Reified {
            @Test
            public void testAllFilesPresentInReified() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayConstructor.kt")
            public void testArrayConstructor() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/arrayConstructor.kt");
            }

            @Test
            @TestMetadata(value="arrayOf.kt")
            public void testArrayOf() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/arrayOf.kt");
            }

            @Test
            @TestMetadata(value="capturedLambda.kt")
            public void testCapturedLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/capturedLambda.kt");
            }

            @Test
            @TestMetadata(value="capturedLambda2.kt")
            public void testCapturedLambda2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/capturedLambda2.kt");
            }

            @Test
            @TestMetadata(value="dontSubstituteNonReified.kt")
            public void testDontSubstituteNonReified() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/dontSubstituteNonReified.kt");
            }

            @Test
            @TestMetadata(value="kt11081.kt")
            public void testKt11081() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt11081.kt");
            }

            @Test
            @TestMetadata(value="kt11677.kt")
            public void testKt11677() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt11677.kt");
            }

            @Test
            @TestMetadata(value="kt15956.kt")
            public void testKt15956() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt15956.kt");
            }

            @Test
            @TestMetadata(value="kt15997.kt")
            public void testKt15997() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt15997.kt");
            }

            @Test
            @TestMetadata(value="kt15997_2.kt")
            public void testKt15997_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt15997_2.kt");
            }

            @Test
            @TestMetadata(value="kt18977.kt")
            public void testKt18977() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt18977.kt");
            }

            @Test
            @TestMetadata(value="kt28234.kt")
            public void testKt28234() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt28234.kt");
            }

            @Test
            @TestMetadata(value="kt35511.kt")
            public void testKt35511() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511.kt");
            }

            @Test
            @TestMetadata(value="kt35511_try.kt")
            public void testKt35511_try() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511_try.kt");
            }

            @Test
            @TestMetadata(value="kt35511_try_valueOf.kt")
            public void testKt35511_try_valueOf() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_valueOf.kt");
            }

            @Test
            @TestMetadata(value="kt35511_try_values.kt")
            public void testKt35511_try_values() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt35511_try_values.kt");
            }

            @Test
            @TestMetadata(value="kt44770.kt")
            public void testKt44770() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt44770.kt");
            }

            @Test
            @TestMetadata(value="kt44770_2.kt")
            public void testKt44770_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt44770_2.kt");
            }

            @Test
            @TestMetadata(value="kt46584.kt")
            public void testKt46584() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt46584.kt");
            }

            @Test
            @TestMetadata(value="kt46584_2.kt")
            public void testKt46584_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt46584_2.kt");
            }

            @Test
            @TestMetadata(value="kt55398.kt")
            public void testKt55398() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt55398.kt");
            }

            @Test
            @TestMetadata(value="kt6988.kt")
            public void testKt6988() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt6988.kt");
            }

            @Test
            @TestMetadata(value="kt6988_2.kt")
            public void testKt6988_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt6988_2.kt");
            }

            @Test
            @TestMetadata(value="kt6990.kt")
            public void testKt6990() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt6990.kt");
            }

            @Test
            @TestMetadata(value="kt7017.kt")
            public void testKt7017() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt7017.kt");
            }

            @Test
            @TestMetadata(value="kt8047.kt")
            public void testKt8047() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt8047.kt");
            }

            @Test
            @TestMetadata(value="kt8047_2.kt")
            public void testKt8047_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt8047_2.kt");
            }

            @Test
            @TestMetadata(value="kt9637.kt")
            public void testKt9637() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt9637.kt");
            }

            @Test
            @TestMetadata(value="kt9637_2.kt")
            public void testKt9637_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/kt9637_2.kt");
            }

            @Test
            @TestMetadata(value="nameClash.kt")
            public void testNameClash() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/nameClash.kt");
            }

            @Test
            @TestMetadata(value="nonCapturingObjectInLambda.kt")
            public void testNonCapturingObjectInLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/nonCapturingObjectInLambda.kt");
            }

            @Test
            @TestMetadata(value="packages.kt")
            public void testPackages() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/packages.kt");
            }

            @Test
            @TestMetadata(value="singletonLambda.kt")
            public void testSingletonLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/singletonLambda.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/reified/isCheck")
            @TestDataPath(value="$PROJECT_ROOT")
            public class IsCheck {
                @Test
                public void testAllFilesPresentInIsCheck() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/isCheck"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="chain.kt")
                public void testChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/isCheck/chain.kt");
                }

                @Test
                @TestMetadata(value="nullable.kt")
                public void testNullable() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/isCheck/nullable.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/isCheck/simple.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/reified/defaultLambda")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultLambda {
                @Test
                public void testAllFilesPresentInDefaultLambda() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/defaultLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="chain.kt")
                public void testChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/chain.kt");
                }

                @Test
                @TestMetadata(value="nested.kt")
                public void testNested() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested.kt");
                }

                @Test
                @TestMetadata(value="nested2.kt")
                public void testNested2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2.kt");
                }

                @Test
                @TestMetadata(value="nested2Static.kt")
                public void testNested2Static() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nested2Static.kt");
                }

                @Test
                @TestMetadata(value="nestedStatic.kt")
                public void testNestedStatic() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/nestedStatic.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/simple.kt");
                }

                @Test
                @TestMetadata(value="transitiveChain.kt")
                public void testTransitiveChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChain.kt");
                }

                @Test
                @TestMetadata(value="transitiveChainStatic.kt")
                public void testTransitiveChainStatic() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/defaultLambda/transitiveChainStatic.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/reified/checkCast")
            @TestDataPath(value="$PROJECT_ROOT")
            public class CheckCast {
                @Test
                public void testAllFilesPresentInCheckCast() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/reified/checkCast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="chain.kt")
                public void testChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/chain.kt");
                }

                @Test
                @TestMetadata(value="kt26435.kt")
                public void testKt26435() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435.kt");
                }

                @Test
                @TestMetadata(value="kt26435_2.kt")
                public void testKt26435_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_2.kt");
                }

                @Test
                @TestMetadata(value="kt26435_3.kt")
                public void testKt26435_3() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt26435_3.kt");
                }

                @Test
                @TestMetadata(value="kt8043.kt")
                public void testKt8043() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/kt8043.kt");
                }

                @Test
                @TestMetadata(value="maxStack.kt")
                public void testMaxStack() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/maxStack.kt");
                }

                @Test
                @TestMetadata(value="nullable.kt")
                public void testNullable() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/nullable.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple.kt");
                }

                @Test
                @TestMetadata(value="simpleSafe.kt")
                public void testSimpleSafe() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/simpleSafe.kt");
                }

                @Test
                @TestMetadata(value="simple_1_3.kt")
                public void testSimple_1_3() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/reified/checkCast/simple_1_3.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/property")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Property {
            @Test
            public void testAllFilesPresentInProperty() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="augAssignmentAndInc.kt")
            public void testAugAssignmentAndInc() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndInc.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncInClass.kt")
            public void testAugAssignmentAndIncInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClass.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncInClassViaConvention.kt")
            public void testAugAssignmentAndIncInClassViaConvention() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncInClassViaConvention.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncOnExtension.kt")
            public void testAugAssignmentAndIncOnExtension() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtension.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncOnExtensionInClass.kt")
            public void testAugAssignmentAndIncOnExtensionInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncOnExtensionInClass.kt");
            }

            @Test
            @TestMetadata(value="augAssignmentAndIncViaConvention.kt")
            public void testAugAssignmentAndIncViaConvention() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/augAssignmentAndIncViaConvention.kt");
            }

            @Test
            @TestMetadata(value="crossinlineFunctional.kt")
            public void testCrossinlineFunctional() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/crossinlineFunctional.kt");
            }

            @Test
            @TestMetadata(value="fromObject.kt")
            public void testFromObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/fromObject.kt");
            }

            @Test
            @TestMetadata(value="kt22649.kt")
            public void testKt22649() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/kt22649.kt");
            }

            @Test
            @TestMetadata(value="noinlineFunctional.kt")
            public void testNoinlineFunctional() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/noinlineFunctional.kt");
            }

            @Test
            @TestMetadata(value="property.kt")
            public void testProperty() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/property.kt");
            }

            @Test
            @TestMetadata(value="reifiedVal.kt")
            public void testReifiedVal() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/reifiedVal.kt");
            }

            @Test
            @TestMetadata(value="reifiedValMultiModule.kt")
            public void testReifiedValMultiModule() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/reifiedValMultiModule.kt");
            }

            @Test
            @TestMetadata(value="reifiedVar.kt")
            public void testReifiedVar() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/reifiedVar.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleExtension.kt")
            public void testSimpleExtension() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/property/simpleExtension.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/private")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Private {
            @Test
            @TestMetadata(value="accessorForConst.kt")
            public void testAccessorForConst() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/accessorForConst.kt");
            }

            @Test
            @TestMetadata(value="accessorStability.kt")
            public void testAccessorStability() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/accessorStability.kt");
            }

            @Test
            @TestMetadata(value="accessorStabilityInClass.kt")
            public void testAccessorStabilityInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/accessorStabilityInClass.kt");
            }

            @Test
            public void testAllFilesPresentInPrivate() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/private"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="effectivePrivate.kt")
            public void testEffectivePrivate() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/effectivePrivate.kt");
            }

            @Test
            @TestMetadata(value="kt6453.kt")
            public void testKt6453() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/kt6453.kt");
            }

            @Test
            @TestMetadata(value="kt8094.kt")
            public void testKt8094() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/kt8094.kt");
            }

            @Test
            @TestMetadata(value="kt8095.kt")
            public void testKt8095() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/kt8095.kt");
            }

            @Test
            @TestMetadata(value="nestedInPrivateClass.kt")
            public void testNestedInPrivateClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass.kt");
            }

            @Test
            @TestMetadata(value="nestedInPrivateClass2.kt")
            public void testNestedInPrivateClass2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/nestedInPrivateClass2.kt");
            }

            @Test
            @TestMetadata(value="privateClass.kt")
            public void testPrivateClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateClass.kt");
            }

            @Test
            @TestMetadata(value="privateClassExtensionLambda.kt")
            public void testPrivateClassExtensionLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateClassExtensionLambda.kt");
            }

            @Test
            @TestMetadata(value="privateInInlineInMultiFileFacade.kt")
            public void testPrivateInInlineInMultiFileFacade() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateInInlineInMultiFileFacade.kt");
            }

            @Test
            @TestMetadata(value="privateInline.kt")
            public void testPrivateInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/private/privateInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/optimizations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Optimizations {
            @Test
            public void testAllFilesPresentInOptimizations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/optimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt20844.kt")
            public void testKt20844() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/optimizations/kt20844.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NonLocalReturns {
            @Test
            public void testAllFilesPresentInNonLocalReturns() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="explicitLocalReturn.kt")
            public void testExplicitLocalReturn() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/explicitLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGenerator.kt")
            public void testFromArrayGenerator() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGenerator.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorCatch.kt")
            public void testFromArrayGeneratorCatch() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorCatch.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorNested.kt")
            public void testFromArrayGeneratorNested() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorNested.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithCapture.kt")
            public void testFromArrayGeneratorWithCapture() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCapture.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithCatch.kt")
            public void testFromArrayGeneratorWithCatch() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithCatch.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithFinally.kt")
            public void testFromArrayGeneratorWithFinally() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinally.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithFinallyX2.kt")
            public void testFromArrayGeneratorWithFinallyX2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2.kt");
            }

            @Test
            @TestMetadata(value="fromArrayGeneratorWithFinallyX2_2.kt")
            public void testFromArrayGeneratorWithFinallyX2_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromArrayGeneratorWithFinallyX2_2.kt");
            }

            @Test
            @TestMetadata(value="fromInterfaceDefaultGetter.kt")
            public void testFromInterfaceDefaultGetter() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/fromInterfaceDefaultGetter.kt");
            }

            @Test
            @TestMetadata(value="justReturnInLambda.kt")
            public void testJustReturnInLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/justReturnInLambda.kt");
            }

            @Test
            @TestMetadata(value="kt5199.kt")
            public void testKt5199() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt5199.kt");
            }

            @Test
            @TestMetadata(value="kt8948.kt")
            public void testKt8948() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948.kt");
            }

            @Test
            @TestMetadata(value="kt8948v2.kt")
            public void testKt8948v2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt8948v2.kt");
            }

            @Test
            @TestMetadata(value="kt9304.kt")
            public void testKt9304() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/kt9304.kt");
            }

            @Test
            @TestMetadata(value="nestedNonLocals.kt")
            public void testNestedNonLocals() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nestedNonLocals.kt");
            }

            @Test
            @TestMetadata(value="noInlineLocalReturn.kt")
            public void testNoInlineLocalReturn() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/noInlineLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturnFromOuterLambda.kt")
            public void testNonLocalReturnFromOuterLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/nonLocalReturnFromOuterLambda.kt");
            }

            @Test
            @TestMetadata(value="propertyAccessors.kt")
            public void testPropertyAccessors() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/propertyAccessors.kt");
            }

            @Test
            @TestMetadata(value="returnFromFunctionExpr.kt")
            public void testReturnFromFunctionExpr() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/returnFromFunctionExpr.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleFunctional.kt")
            public void testSimpleFunctional() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleFunctional.kt");
            }

            @Test
            @TestMetadata(value="simpleVoid.kt")
            public void testSimpleVoid() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/simpleVoid.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally")
            @TestDataPath(value="$PROJECT_ROOT")
            public class TryFinally {
                @Test
                public void testAllFilesPresentInTryFinally() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt16417.kt")
                public void testKt16417() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt16417.kt");
                }

                @Test
                @TestMetadata(value="kt20433.kt")
                public void testKt20433() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433.kt");
                }

                @Test
                @TestMetadata(value="kt20433_2.kt")
                public void testKt20433_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2.kt");
                }

                @Test
                @TestMetadata(value="kt20433_2_void.kt")
                public void testKt20433_2_void() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_2_void.kt");
                }

                @Test
                @TestMetadata(value="kt20433_void.kt")
                public void testKt20433_void() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt20433_void.kt");
                }

                @Test
                @TestMetadata(value="kt26384.kt")
                public void testKt26384() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384.kt");
                }

                @Test
                @TestMetadata(value="kt26384_2.kt")
                public void testKt26384_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt26384_2.kt");
                }

                @Test
                @TestMetadata(value="kt28546.kt")
                public void testKt28546() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt28546.kt");
                }

                @Test
                @TestMetadata(value="kt6956.kt")
                public void testKt6956() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt6956.kt");
                }

                @Test
                @TestMetadata(value="kt7273.kt")
                public void testKt7273() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/kt7273.kt");
                }

                @Test
                @TestMetadata(value="nonLocalReturnFromCatchBlock.kt")
                public void testNonLocalReturnFromCatchBlock() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromCatchBlock.kt");
                }

                @Test
                @TestMetadata(value="nonLocalReturnFromOuterLambda.kt")
                public void testNonLocalReturnFromOuterLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnFromOuterLambda.kt");
                }

                @Test
                @TestMetadata(value="nonLocalReturnToCatchBlock.kt")
                public void testNonLocalReturnToCatchBlock() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/nonLocalReturnToCatchBlock.kt");
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Variables {
                    @Test
                    public void testAllFilesPresentInVariables() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="kt7792.kt")
                    public void testKt7792() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/variables/kt7792.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ExceptionTable {
                    @Test
                    public void testAllFilesPresentInExceptionTable() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="break.kt")
                    public void testBreak() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/break.kt");
                    }

                    @Test
                    @TestMetadata(value="continue.kt")
                    public void testContinue() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/continue.kt");
                    }

                    @Test
                    @TestMetadata(value="exceptionInFinally.kt")
                    public void testExceptionInFinally() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/exceptionInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="forInFinally.kt")
                    public void testForInFinally() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/forInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="innerAndExternal.kt")
                    public void testInnerAndExternal() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternal.kt");
                    }

                    @Test
                    @TestMetadata(value="innerAndExternalNested.kt")
                    public void testInnerAndExternalNested() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalNested.kt");
                    }

                    @Test
                    @TestMetadata(value="innerAndExternalSimple.kt")
                    public void testInnerAndExternalSimple() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/innerAndExternalSimple.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31653.kt")
                    public void testKt31653() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31653_2.kt")
                    public void testKt31653_2() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31653_2.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31923.kt")
                    public void testKt31923() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923.kt");
                    }

                    @Test
                    @TestMetadata(value="kt31923_2.kt")
                    public void testKt31923_2() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/kt31923_2.kt");
                    }

                    @Test
                    @TestMetadata(value="nested.kt")
                    public void testNested() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nested.kt");
                    }

                    @Test
                    @TestMetadata(value="nestedWithReturns.kt")
                    public void testNestedWithReturns() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturns.kt");
                    }

                    @Test
                    @TestMetadata(value="nestedWithReturnsSimple.kt")
                    public void testNestedWithReturnsSimple() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/nestedWithReturnsSimple.kt");
                    }

                    @Test
                    @TestMetadata(value="noFinally.kt")
                    public void testNoFinally() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/noFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="severalCatchClause.kt")
                    public void testSeveralCatchClause() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/severalCatchClause.kt");
                    }

                    @Test
                    @TestMetadata(value="simpleThrow.kt")
                    public void testSimpleThrow() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/simpleThrow.kt");
                    }

                    @Test
                    @TestMetadata(value="synchonized.kt")
                    public void testSynchonized() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/synchonized.kt");
                    }

                    @Test
                    @TestMetadata(value="throwInFinally.kt")
                    public void testThrowInFinally() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/throwInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="tryCatchInFinally.kt")
                    public void testTryCatchInFinally() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/exceptionTable/tryCatchInFinally.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite")
                @TestDataPath(value="$PROJECT_ROOT")
                public class DeclSite {
                    @Test
                    public void testAllFilesPresentInDeclSite() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="complex.kt")
                    public void testComplex() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/complex.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturn.kt")
                    public void testIntReturn() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex.kt")
                    public void testIntReturnComplex() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/intReturnComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="longReturn.kt")
                    public void testLongReturn() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/longReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="nested.kt")
                    public void testNested() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/nested.kt");
                    }

                    @Test
                    @TestMetadata(value="returnInFinally.kt")
                    public void testReturnInFinally() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="returnInTry.kt")
                    public void testReturnInTry() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTry.kt");
                    }

                    @Test
                    @TestMetadata(value="returnInTryAndFinally.kt")
                    public void testReturnInTryAndFinally() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/returnInTryAndFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="severalInTry.kt")
                    public void testSeveralInTry() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTry.kt");
                    }

                    @Test
                    @TestMetadata(value="severalInTryComplex.kt")
                    public void testSeveralInTryComplex() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/severalInTryComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="voidInlineFun.kt")
                    public void testVoidInlineFun() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidInlineFun.kt");
                    }

                    @Test
                    @TestMetadata(value="voidNonLocal.kt")
                    public void testVoidNonLocal() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/declSite/voidNonLocal.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Chained {
                    @Test
                    public void testAllFilesPresentInChained() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="finallyInFinally.kt")
                    public void testFinallyInFinally() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="finallyInFinally2.kt")
                    public void testFinallyInFinally2() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/finallyInFinally2.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturn.kt")
                    public void testIntReturn() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex.kt")
                    public void testIntReturnComplex() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex2.kt")
                    public void testIntReturnComplex2() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex2.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex3.kt")
                    public void testIntReturnComplex3() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex3.kt");
                    }

                    @Test
                    @TestMetadata(value="intReturnComplex4.kt")
                    public void testIntReturnComplex4() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/intReturnComplex4.kt");
                    }

                    @Test
                    @TestMetadata(value="nestedLambda.kt")
                    public void testNestedLambda() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/chained/nestedLambda.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite")
                @TestDataPath(value="$PROJECT_ROOT")
                public class CallSite {
                    @Test
                    public void testAllFilesPresentInCallSite() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="callSite.kt")
                    public void testCallSite() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSite.kt");
                    }

                    @Test
                    @TestMetadata(value="callSiteComplex.kt")
                    public void testCallSiteComplex() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/callSiteComplex.kt");
                    }

                    @Test
                    @TestMetadata(value="exceptionTableSplit.kt")
                    public void testExceptionTableSplit() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplit.kt");
                    }

                    @Test
                    @TestMetadata(value="exceptionTableSplitNoReturn.kt")
                    public void testExceptionTableSplitNoReturn() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/exceptionTableSplitNoReturn.kt");
                    }

                    @Test
                    @TestMetadata(value="finallyInFinally.kt")
                    public void testFinallyInFinally() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/finallyInFinally.kt");
                    }

                    @Test
                    @TestMetadata(value="wrongVarInterval.kt")
                    public void testWrongVarInterval() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/tryFinally/callSite/wrongVarInterval.kt");
                    }
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Deparenthesize {
                @Test
                public void testAllFilesPresentInDeparenthesize() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="bracket.kt")
                public void testBracket() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/bracket.kt");
                }

                @Test
                @TestMetadata(value="labeled.kt")
                public void testLabeled() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/nonLocalReturns/deparenthesize/labeled.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/noInline")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NoInline {
            @Test
            public void testAllFilesPresentInNoInline() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/noInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="extensionReceiver.kt")
            public void testExtensionReceiver() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/extensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="lambdaAsGeneric.kt")
            public void testLambdaAsGeneric() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsGeneric.kt");
            }

            @Test
            @TestMetadata(value="lambdaAsNonFunction.kt")
            public void testLambdaAsNonFunction() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/lambdaAsNonFunction.kt");
            }

            @Test
            @TestMetadata(value="noInline.kt")
            public void testNoInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/noInline.kt");
            }

            @Test
            @TestMetadata(value="noInlineLambdaChain.kt")
            public void testNoInlineLambdaChain() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChain.kt");
            }

            @Test
            @TestMetadata(value="noInlineLambdaChainWithCapturedInline.kt")
            public void testNoInlineLambdaChainWithCapturedInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/noInlineLambdaChainWithCapturedInline.kt");
            }

            @Test
            @TestMetadata(value="withoutInline.kt")
            public void testWithoutInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/noInline/withoutInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/multiplatform")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Multiplatform {
            @Test
            public void testAllFilesPresentInMultiplatform() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/multiplatform/defaultArguments")
            @TestDataPath(value="$PROJECT_ROOT")
            public class DefaultArguments {
                @Test
                public void testAllFilesPresentInDefaultArguments() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiplatform/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="receiversAndParametersInLambda.kt")
                public void testReceiversAndParametersInLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/multiplatform/defaultArguments/receiversAndParametersInLambda.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/multifileClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultifileClasses {
            @Test
            public void testAllFilesPresentInMultifileClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultArguments.kt")
            public void testDefaultArguments() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/multifileClasses/defaultArguments.kt");
            }

            @Test
            @TestMetadata(value="inlineFromOptimizedMultifileClass.kt")
            public void testInlineFromOptimizedMultifileClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOptimizedMultifileClass.kt");
            }

            @Test
            @TestMetadata(value="inlineFromOtherPackage.kt")
            public void testInlineFromOtherPackage() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/multifileClasses/inlineFromOtherPackage.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/multiModule")
        @TestDataPath(value="$PROJECT_ROOT")
        public class MultiModule {
            @Test
            public void testAllFilesPresentInMultiModule() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/multiModule"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="tryCatchWithRecursiveInline.kt")
            public void testTryCatchWithRecursiveInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/multiModule/tryCatchWithRecursiveInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/localFunInLambda")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalFunInLambda {
            @Test
            public void testAllFilesPresentInLocalFunInLambda() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/localFunInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultParam.kt")
            public void testDefaultParam() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/defaultParam.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambdaCapturesAnotherFun.kt")
            public void testLambdaInLambdaCapturesAnotherFun() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/lambdaInLambdaCapturesAnotherFun.kt");
            }

            @Test
            @TestMetadata(value="localFunInLambda.kt")
            public void testLocalFunInLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambda.kt");
            }

            @Test
            @TestMetadata(value="localFunInLambdaCapturesAnotherFun.kt")
            public void testLocalFunInLambdaCapturesAnotherFun() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambdaCapturesAnotherFun.kt");
            }

            @Test
            @TestMetadata(value="localFunInLambdaCapturesOuterVariable.kt")
            public void testLocalFunInLambdaCapturesOuterVariable() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/localFunInLambda/localFunInLambdaCapturesOuterVariable.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/lambdaTransformation")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LambdaTransformation {
            @Test
            public void testAllFilesPresentInLambdaTransformation() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaTransformation"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="lambdaCloning.kt")
            public void testLambdaCloning() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaCloning.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambda2.kt")
            public void testLambdaInLambda2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambda2.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambdaNoInline.kt")
            public void testLambdaInLambdaNoInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/lambdaInLambdaNoInline.kt");
            }

            @Test
            @TestMetadata(value="regeneratedLambdaName.kt")
            public void testRegeneratedLambdaName() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName.kt");
            }

            @Test
            @TestMetadata(value="regeneratedLambdaName2.kt")
            public void testRegeneratedLambdaName2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/regeneratedLambdaName2.kt");
            }

            @Test
            @TestMetadata(value="sameCaptured.kt")
            public void testSameCaptured() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaTransformation/sameCaptured.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/lambdaClassClash")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LambdaClassClash {
            @Test
            public void testAllFilesPresentInLambdaClassClash() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/lambdaClassClash"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="lambdaClassClash.kt")
            public void testLambdaClassClash() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaClassClash/lambdaClassClash.kt");
            }

            @Test
            @TestMetadata(value="noInlineLambdaX2.kt")
            public void testNoInlineLambdaX2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/lambdaClassClash/noInlineLambdaX2.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/jvmPackageName")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmPackageName {
            @Test
            public void testAllFilesPresentInJvmPackageName() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmPackageName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/jvmPackageName/simple.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/jvmName")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmName {
            @Test
            public void testAllFilesPresentInJvmName() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/jvmName"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/jvmName/simple.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/invokedynamic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Invokedynamic {
            @Test
            public void testAllFilesPresentInInvokedynamic() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/invokedynamic/sam")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Sam {
                @Test
                public void testAllFilesPresentInSam() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossinlineLambda1.kt")
                public void testCrossinlineLambda1() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda1.kt");
                }

                @Test
                @TestMetadata(value="crossinlineLambda2.kt")
                public void testCrossinlineLambda2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/crossinlineLambda2.kt");
                }

                @Test
                @TestMetadata(value="inlineFunInDifferentPackage.kt")
                public void testInlineFunInDifferentPackage() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineFunInDifferentPackage.kt");
                }

                @Test
                @TestMetadata(value="inlineLambda1.kt")
                public void testInlineLambda1() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/sam/inlineLambda1.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/invokedynamic/lambdas")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Lambdas {
                @Test
                public void testAllFilesPresentInLambdas() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/invokedynamic/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="crossinlineLambda1.kt")
                public void testCrossinlineLambda1() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda1.kt");
                }

                @Test
                @TestMetadata(value="crossinlineLambda2.kt")
                public void testCrossinlineLambda2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/crossinlineLambda2.kt");
                }

                @Test
                @TestMetadata(value="inlineFunInDifferentPackage.kt")
                public void testInlineFunInDifferentPackage() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineFunInDifferentPackage.kt");
                }

                @Test
                @TestMetadata(value="inlineLambda1.kt")
                public void testInlineLambda1() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/invokedynamic/lambdas/inlineLambda1.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/innerClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InnerClasses {
            @Test
            public void testAllFilesPresentInInnerClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="captureThisAndOuter.kt")
            public void testCaptureThisAndOuter() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/captureThisAndOuter.kt");
            }

            @Test
            @TestMetadata(value="fakeOverride.kt")
            public void testFakeOverride() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/fakeOverride.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuter.kt")
            public void testInnerInlineFunCapturesOuter() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuter.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterByAnotherInlineFun.kt")
            public void testInnerInlineFunCapturesOuterByAnotherInlineFun() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterByAnotherInlineFun.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterDeep.kt")
            public void testInnerInlineFunCapturesOuterDeep() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterDeep.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterFunRef.kt")
            public void testInnerInlineFunCapturesOuterFunRef() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterFunRef.kt");
            }

            @Test
            @TestMetadata(value="innerInlineFunCapturesOuterWithInlineClass.kt")
            public void testInnerInlineFunCapturesOuterWithInlineClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerInlineFunCapturesOuterWithInlineClass.kt");
            }

            @Test
            @TestMetadata(value="innerLambda.kt")
            public void testInnerLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/innerLambda.kt");
            }

            @Test
            @TestMetadata(value="kt10259.kt")
            public void testKt10259() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/kt10259.kt");
            }

            @Test
            @TestMetadata(value="kt12126.kt")
            public void testKt12126() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/innerClasses/kt12126.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObject.kt")
            public void testAnonymousObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/anonymousObject.kt");
            }

            @Test
            @TestMetadata(value="inlineClassWithInlineValReturningInlineClass.kt")
            public void testInlineClassWithInlineValReturningInlineClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineClassWithInlineValReturningInlineClass.kt");
            }

            @Test
            @TestMetadata(value="inlineFunctionInsideInlineClassesBox.kt")
            public void testInlineFunctionInsideInlineClassesBox() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/inlineFunctionInsideInlineClassesBox.kt");
            }

            @Test
            @TestMetadata(value="kt62313.kt")
            public void testKt62313() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/kt62313.kt");
            }

            @Test
            @TestMetadata(value="withReturnTypeManglingFun.kt")
            public void testWithReturnTypeManglingFun() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFun.kt");
            }

            @Test
            @TestMetadata(value="withReturnTypeManglingFunJvmName.kt")
            public void testWithReturnTypeManglingFunJvmName() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingFunJvmName.kt");
            }

            @Test
            @TestMetadata(value="withReturnTypeManglingVal.kt")
            public void testWithReturnTypeManglingVal() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/withReturnTypeManglingVal.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter")
            @TestDataPath(value="$PROJECT_ROOT")
            public class UnboxGenericParameter {
                @Test
                public void testAllFilesPresentInUnboxGenericParameter() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral")
                @TestDataPath(value="$PROJECT_ROOT")
                public class ObjectLiteral {
                    @Test
                    public void testAllFilesPresentInObjectLiteral() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="any.kt")
                    public void testAny() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/any.kt");
                    }

                    @Test
                    @TestMetadata(value="anyN.kt")
                    public void testAnyN() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/anyN.kt");
                    }

                    @Test
                    @TestMetadata(value="iface.kt")
                    public void testIface() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/iface.kt");
                    }

                    @Test
                    @TestMetadata(value="ifaceChild.kt")
                    public void testIfaceChild() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/ifaceChild.kt");
                    }

                    @Test
                    @TestMetadata(value="primitive.kt")
                    public void testPrimitive() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/primitive.kt");
                    }

                    @Test
                    @TestMetadata(value="string.kt")
                    public void testString() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/objectLiteral/string.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda")
                @TestDataPath(value="$PROJECT_ROOT")
                public class Lambda {
                    @Test
                    public void testAllFilesPresentInLambda() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="any.kt")
                    public void testAny() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/any.kt");
                    }

                    @Test
                    @TestMetadata(value="anyN.kt")
                    public void testAnyN() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/anyN.kt");
                    }

                    @Test
                    @TestMetadata(value="iface.kt")
                    public void testIface() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/iface.kt");
                    }

                    @Test
                    @TestMetadata(value="ifaceChild.kt")
                    public void testIfaceChild() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/ifaceChild.kt");
                    }

                    @Test
                    @TestMetadata(value="primitive.kt")
                    public void testPrimitive() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/primitive.kt");
                    }

                    @Test
                    @TestMetadata(value="string.kt")
                    public void testString() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/lambda/string.kt");
                    }
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface")
                @TestDataPath(value="$PROJECT_ROOT")
                public class FunInterface {
                    @Test
                    public void testAllFilesPresentInFunInterface() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="any.kt")
                    public void testAny() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/any.kt");
                    }

                    @Test
                    @TestMetadata(value="anyN.kt")
                    public void testAnyN() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/anyN.kt");
                    }

                    @Test
                    @TestMetadata(value="iface.kt")
                    public void testIface() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/iface.kt");
                    }

                    @Test
                    @TestMetadata(value="ifaceChild.kt")
                    public void testIfaceChild() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/ifaceChild.kt");
                    }

                    @Test
                    @TestMetadata(value="primitive.kt")
                    public void testPrimitive() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/primitive.kt");
                    }

                    @Test
                    @TestMetadata(value="string.kt")
                    public void testString() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineClasses/unboxGenericParameter/funInterface/string.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/inlineArgsInplace")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineArgsInplace {
            @Test
            public void testAllFilesPresentInInlineArgsInplace() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/inlineArgsInplace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="callArgumentReordering.kt")
            public void testCallArgumentReordering() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/inlineArgsInplace/callArgumentReordering.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/functionReference")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunctionReference {
            @Test
            public void testAllFilesPresentInFunctionReference() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/functionReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="fourthOrder.kt")
            public void testFourthOrder() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/functionReference/fourthOrder.kt");
            }

            @Test
            @TestMetadata(value="noInlineForLambda.kt")
            public void testNoInlineForLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/functionReference/noInlineForLambda.kt");
            }

            @Test
            @TestMetadata(value="thirdOrder.kt")
            public void testThirdOrder() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/functionReference/thirdOrder.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/functionExpression")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunctionExpression {
            @Test
            public void testAllFilesPresentInFunctionExpression() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/functionExpression"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/functionExpression/extension.kt");
            }

            @Test
            @TestMetadata(value="kt71659.kt")
            public void testKt71659() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/functionExpression/kt71659.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/enum")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Enum {
            @Test
            public void testAllFilesPresentInEnum() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumEntries.kt")
            public void testEnumEntries() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/enumEntries.kt");
            }

            @Test
            @TestMetadata(value="enumEntriesChainCapturedType.kt")
            public void testEnumEntriesChainCapturedType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/enumEntriesChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="javaEnumEntries.kt")
            public void testJavaEnumEntries() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/javaEnumEntries.kt");
            }

            @Test
            @TestMetadata(value="javaEnumEntriesChainCapturedType.kt")
            public void testJavaEnumEntriesChainCapturedType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/javaEnumEntriesChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="kt10569.kt")
            public void testKt10569() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/kt10569.kt");
            }

            @Test
            @TestMetadata(value="kt18254.kt")
            public void testKt18254() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/kt18254.kt");
            }

            @Test
            @TestMetadata(value="valueOf.kt")
            public void testValueOf() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOf.kt");
            }

            @Test
            @TestMetadata(value="valueOfCapturedType.kt")
            public void testValueOfCapturedType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valueOfChain.kt")
            public void testValueOfChain() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfChain.kt");
            }

            @Test
            @TestMetadata(value="valueOfChainCapturedType.kt")
            public void testValueOfChainCapturedType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valueOfNonReified.kt")
            public void testValueOfNonReified() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valueOfNonReified.kt");
            }

            @Test
            @TestMetadata(value="values.kt")
            public void testValues() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/values.kt");
            }

            @Test
            @TestMetadata(value="valuesAsArray.kt")
            public void testValuesAsArray() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesAsArray.kt");
            }

            @Test
            @TestMetadata(value="valuesCapturedType.kt")
            public void testValuesCapturedType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valuesChain.kt")
            public void testValuesChain() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesChain.kt");
            }

            @Test
            @TestMetadata(value="valuesChainCapturedType.kt")
            public void testValuesChainCapturedType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesChainCapturedType.kt");
            }

            @Test
            @TestMetadata(value="valuesNonReified.kt")
            public void testValuesNonReified() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enum/valuesNonReified.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/enclosingInfo")
        @TestDataPath(value="$PROJECT_ROOT")
        public class EnclosingInfo {
            @Test
            public void testAllFilesPresentInEnclosingInfo() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/enclosingInfo"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousInLambda.kt")
            public void testAnonymousInLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/anonymousInLambda.kt");
            }

            @Test
            @TestMetadata(value="inlineChain.kt")
            public void testInlineChain() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain.kt");
            }

            @Test
            @TestMetadata(value="inlineChain2.kt")
            public void testInlineChain2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/inlineChain2.kt");
            }

            @Test
            @TestMetadata(value="kt52417.kt")
            public void testKt52417() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/kt52417.kt");
            }

            @Test
            @TestMetadata(value="objectInInlineFun.kt")
            public void testObjectInInlineFun() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/objectInInlineFun.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructor.kt")
            public void testTransformedConstructor() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructor.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructorWithAdditionalObject.kt")
            public void testTransformedConstructorWithAdditionalObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithAdditionalObject.kt");
            }

            @Test
            @TestMetadata(value="transformedConstructorWithNestedInline.kt")
            public void testTransformedConstructorWithNestedInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/enclosingInfo/transformedConstructorWithNestedInline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/dontReify")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DontReify {
            @Test
            public void testAllFilesPresentInDontReify() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/dontReify"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="arrayRead.kt")
            public void testArrayRead() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/arrayRead.kt");
            }

            @Test
            @TestMetadata(value="arrayWrite.kt")
            public void testArrayWrite() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/arrayWrite.kt");
            }

            @Test
            @TestMetadata(value="dispatchReceiver.kt")
            public void testDispatchReceiver() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/dispatchReceiver.kt");
            }

            @Test
            @TestMetadata(value="extensionReceiver.kt")
            public void testExtensionReceiver() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/extensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="lambdaParameter.kt")
            public void testLambdaParameter() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/lambdaParameter.kt");
            }

            @Test
            @TestMetadata(value="localDelegatedProperty.kt")
            public void testLocalDelegatedProperty() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/localDelegatedProperty.kt");
            }

            @Test
            @TestMetadata(value="localObjectProperty.kt")
            public void testLocalObjectProperty() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/localObjectProperty.kt");
            }

            @Test
            @TestMetadata(value="localVariable.kt")
            public void testLocalVariable() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/localVariable.kt");
            }

            @Test
            @TestMetadata(value="methodReturnType.kt")
            public void testMethodReturnType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/methodReturnType.kt");
            }

            @Test
            @TestMetadata(value="parameterInLocalObject.kt")
            public void testParameterInLocalObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/dontReify/parameterInLocalObject.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/delegatedProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DelegatedProperty {
            @Test
            public void testAllFilesPresentInDelegatedProperty() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/delegatedProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt16864.kt")
            public void testKt16864() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt16864.kt");
            }

            @Test
            @TestMetadata(value="kt48498.kt")
            public void testKt48498() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/kt48498.kt");
            }

            @Test
            @TestMetadata(value="local.kt")
            public void testLocal() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/local.kt");
            }

            @Test
            @TestMetadata(value="localDeclaredInLambda.kt")
            public void testLocalDeclaredInLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/localDeclaredInLambda.kt");
            }

            @Test
            @TestMetadata(value="localInAnonymousObject.kt")
            public void testLocalInAnonymousObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInAnonymousObject.kt");
            }

            @Test
            @TestMetadata(value="localInLambda.kt")
            public void testLocalInLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/delegatedProperty/localInLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DefaultValues {
            @Test
            @TestMetadata(value="33Parameters.kt")
            public void test33Parameters() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/33Parameters.kt");
            }

            @Test
            @TestMetadata(value="33ParametersInConstructor.kt")
            public void test33ParametersInConstructor() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/33ParametersInConstructor.kt");
            }

            @Test
            public void testAllFilesPresentInDefaultValues() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultInExtension.kt")
            public void testDefaultInExtension() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultInExtension.kt");
            }

            @Test
            @TestMetadata(value="defaultMethod.kt")
            public void testDefaultMethod() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethod.kt");
            }

            @Test
            @TestMetadata(value="defaultMethodInClass.kt")
            public void testDefaultMethodInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultMethodInClass.kt");
            }

            @Test
            @TestMetadata(value="defaultParamRemapping.kt")
            public void testDefaultParamRemapping() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/defaultParamRemapping.kt");
            }

            @Test
            @TestMetadata(value="inlineInDefaultParameter.kt")
            public void testInlineInDefaultParameter() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/inlineInDefaultParameter.kt");
            }

            @Test
            @TestMetadata(value="inlineLambdaInNoInlineDefault.kt")
            public void testInlineLambdaInNoInlineDefault() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/inlineLambdaInNoInlineDefault.kt");
            }

            @Test
            @TestMetadata(value="kt11479.kt")
            public void testKt11479() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479.kt");
            }

            @Test
            @TestMetadata(value="kt11479InlinedDefaultParameter.kt")
            public void testKt11479InlinedDefaultParameter() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt11479InlinedDefaultParameter.kt");
            }

            @Test
            @TestMetadata(value="kt14564.kt")
            public void testKt14564() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564.kt");
            }

            @Test
            @TestMetadata(value="kt14564_2.kt")
            public void testKt14564_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt14564_2.kt");
            }

            @Test
            @TestMetadata(value="kt16496.kt")
            public void testKt16496() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt16496.kt");
            }

            @Test
            @TestMetadata(value="kt18689.kt")
            public void testKt18689() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689.kt");
            }

            @Test
            @TestMetadata(value="kt18689_2.kt")
            public void testKt18689_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_2.kt");
            }

            @Test
            @TestMetadata(value="kt18689_3.kt")
            public void testKt18689_3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_3.kt");
            }

            @Test
            @TestMetadata(value="kt18689_4.kt")
            public void testKt18689_4() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt18689_4.kt");
            }

            @Test
            @TestMetadata(value="kt5685.kt")
            public void testKt5685() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/kt5685.kt");
            }

            @Test
            @TestMetadata(value="simpleDefaultMethod.kt")
            public void testSimpleDefaultMethod() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/simpleDefaultMethod.kt");
            }

            @Test
            @TestMetadata(value="varArgNoInline.kt")
            public void testVarArgNoInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/varArgNoInline.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues/maskElimination")
            @TestDataPath(value="$PROJECT_ROOT")
            public class MaskElimination {
                @Test
                @TestMetadata(value="32Parameters.kt")
                public void test32Parameters() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/32Parameters.kt");
                }

                @Test
                @TestMetadata(value="33Parameters.kt")
                public void test33Parameters() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/33Parameters.kt");
                }

                @Test
                public void testAllFilesPresentInMaskElimination() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/maskElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt18792.kt")
                public void testKt18792() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt18792.kt");
                }

                @Test
                @TestMetadata(value="kt19679.kt")
                public void testKt19679() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679.kt");
                }

                @Test
                @TestMetadata(value="kt19679_2.kt")
                public void testKt19679_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_2.kt");
                }

                @Test
                @TestMetadata(value="kt19679_3.kt")
                public void testKt19679_3() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/kt19679_3.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/maskElimination/simple.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues/lambdaInlining")
            @TestDataPath(value="$PROJECT_ROOT")
            public class LambdaInlining {
                @Test
                public void testAllFilesPresentInLambdaInlining() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="checkLambdaClassIsPresent.kt")
                public void testCheckLambdaClassIsPresent() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="checkLambdaClassesArePresent.kt")
                public void testCheckLambdaClassesArePresent() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkLambdaClassesArePresent.kt");
                }

                @Test
                @TestMetadata(value="checkObjectClassIsPresent.kt")
                public void testCheckObjectClassIsPresent() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkObjectClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="checkStaticLambdaClassIsPresent.kt")
                public void testCheckStaticLambdaClassIsPresent() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="checkStaticLambdaClassesArePresent.kt")
                public void testCheckStaticLambdaClassesArePresent() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticLambdaClassesArePresent.kt");
                }

                @Test
                @TestMetadata(value="checkStaticObjectClassIsPresent.kt")
                public void testCheckStaticObjectClassIsPresent() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/checkStaticObjectClassIsPresent.kt");
                }

                @Test
                @TestMetadata(value="defaultAfterCapturing.kt")
                public void testDefaultAfterCapturing() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultAfterCapturing.kt");
                }

                @Test
                @TestMetadata(value="defaultCallInDefaultLambda.kt")
                public void testDefaultCallInDefaultLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultCallInDefaultLambda.kt");
                }

                @Test
                @TestMetadata(value="defaultLambdaInNoInline.kt")
                public void testDefaultLambdaInNoInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/defaultLambdaInNoInline.kt");
                }

                @Test
                @TestMetadata(value="differentInvokeSignature.kt")
                public void testDifferentInvokeSignature() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/differentInvokeSignature.kt");
                }

                @Test
                @TestMetadata(value="genericLambda.kt")
                public void testGenericLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/genericLambda.kt");
                }

                @Test
                @TestMetadata(value="instanceCapturedInClass.kt")
                public void testInstanceCapturedInClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInClass.kt");
                }

                @Test
                @TestMetadata(value="instanceCapturedInInterface.kt")
                public void testInstanceCapturedInInterface() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/instanceCapturedInInterface.kt");
                }

                @Test
                @TestMetadata(value="jvmStaticDefault.kt")
                public void testJvmStaticDefault() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/jvmStaticDefault.kt");
                }

                @Test
                @TestMetadata(value="kt21827.kt")
                public void testKt21827() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21827.kt");
                }

                @Test
                @TestMetadata(value="kt21946.kt")
                public void testKt21946() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt21946.kt");
                }

                @Test
                @TestMetadata(value="kt24477.kt")
                public void testKt24477() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt24477.kt");
                }

                @Test
                @TestMetadata(value="kt25106.kt")
                public void testKt25106() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt25106.kt");
                }

                @Test
                @TestMetadata(value="kt26636.kt")
                public void testKt26636() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/kt26636.kt");
                }

                @Test
                @TestMetadata(value="lambdaTakesResult.kt")
                public void testLambdaTakesResult() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/lambdaTakesResult.kt");
                }

                @Test
                @TestMetadata(value="noInline.kt")
                public void testNoInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/noInline.kt");
                }

                @Test
                @TestMetadata(value="nonDefaultInlineInNoInline.kt")
                public void testNonDefaultInlineInNoInline() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/nonDefaultInlineInNoInline.kt");
                }

                @Test
                @TestMetadata(value="receiverClash.kt")
                public void testReceiverClash() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash.kt");
                }

                @Test
                @TestMetadata(value="receiverClash2.kt")
                public void testReceiverClash2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClash2.kt");
                }

                @Test
                @TestMetadata(value="receiverClashInClass.kt")
                public void testReceiverClashInClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass.kt");
                }

                @Test
                @TestMetadata(value="receiverClashInClass2.kt")
                public void testReceiverClashInClass2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/receiverClashInClass2.kt");
                }

                @Test
                @TestMetadata(value="reordering.kt")
                public void testReordering() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/reordering.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simple.kt");
                }

                @Test
                @TestMetadata(value="simpleErased.kt")
                public void testSimpleErased() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErased.kt");
                }

                @Test
                @TestMetadata(value="simpleErasedStaticInstance.kt")
                public void testSimpleErasedStaticInstance() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleErasedStaticInstance.kt");
                }

                @Test
                @TestMetadata(value="simpleExtension.kt")
                public void testSimpleExtension() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleExtension.kt");
                }

                @Test
                @TestMetadata(value="simpleGeneric.kt")
                public void testSimpleGeneric() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleGeneric.kt");
                }

                @Test
                @TestMetadata(value="simpleStaticInstance.kt")
                public void testSimpleStaticInstance() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/simpleStaticInstance.kt");
                }

                @Test
                @TestMetadata(value="thisClash.kt")
                public void testThisClash() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClash.kt");
                }

                @Test
                @TestMetadata(value="thisClashInClass.kt")
                public void testThisClashInClass() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/thisClashInClass.kt");
                }

                @Nested
                @TestMetadata(value="compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences")
                @TestDataPath(value="$PROJECT_ROOT")
                public class CallableReferences {
                    @Test
                    public void testAllFilesPresentInCallableReferences() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                    }

                    @Test
                    @TestMetadata(value="boundFunctionReference.kt")
                    public void testBoundFunctionReference() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReference.kt");
                    }

                    @Test
                    @TestMetadata(value="boundFunctionReferenceOnInt.kt")
                    public void testBoundFunctionReferenceOnInt() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnInt.kt");
                    }

                    @Test
                    @TestMetadata(value="boundFunctionReferenceOnLong.kt")
                    public void testBoundFunctionReferenceOnLong() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundFunctionReferenceOnLong.kt");
                    }

                    @Test
                    @TestMetadata(value="boundInlineClassMethod.kt")
                    public void testBoundInlineClassMethod() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethod.kt");
                    }

                    @Test
                    @TestMetadata(value="boundInlineClassMethodWithAny.kt")
                    public void testBoundInlineClassMethodWithAny() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithAny.kt");
                    }

                    @Test
                    @TestMetadata(value="boundInlineClassMethodWithInt.kt")
                    public void testBoundInlineClassMethodWithInt() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundInlineClassMethodWithInt.kt");
                    }

                    @Test
                    @TestMetadata(value="boundPropertyReference.kt")
                    public void testBoundPropertyReference() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReference.kt");
                    }

                    @Test
                    @TestMetadata(value="boundPropertyReferenceOnInt.kt")
                    public void testBoundPropertyReferenceOnInt() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnInt.kt");
                    }

                    @Test
                    @TestMetadata(value="boundPropertyReferenceOnLong.kt")
                    public void testBoundPropertyReferenceOnLong() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/boundPropertyReferenceOnLong.kt");
                    }

                    @Test
                    @TestMetadata(value="constuctorReference.kt")
                    public void testConstuctorReference() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/constuctorReference.kt");
                    }

                    @Test
                    @TestMetadata(value="defaultAfterBoundReference.kt")
                    public void testDefaultAfterBoundReference() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/defaultAfterBoundReference.kt");
                    }

                    @Test
                    @TestMetadata(value="defaultThatCapturesPreviousParameter.kt")
                    public void testDefaultThatCapturesPreviousParameter() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/defaultThatCapturesPreviousParameter.kt");
                    }

                    @Test
                    @TestMetadata(value="differentInvokeSignature.kt")
                    public void testDifferentInvokeSignature() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature.kt");
                    }

                    @Test
                    @TestMetadata(value="differentInvokeSignature2.kt")
                    public void testDifferentInvokeSignature2() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature2.kt");
                    }

                    @Test
                    @TestMetadata(value="differentInvokeSignature3.kt")
                    public void testDifferentInvokeSignature3() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/differentInvokeSignature3.kt");
                    }

                    @Test
                    @TestMetadata(value="functionImportedFromObject.kt")
                    public void testFunctionImportedFromObject() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionImportedFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="functionReference.kt")
                    public void testFunctionReference() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReference.kt");
                    }

                    @Test
                    @TestMetadata(value="functionReferenceFromClass.kt")
                    public void testFunctionReferenceFromClass() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="functionReferenceFromObject.kt")
                    public void testFunctionReferenceFromObject() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/functionReferenceFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="innerClassConstuctorReference.kt")
                    public void testInnerClassConstuctorReference() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/innerClassConstuctorReference.kt");
                    }

                    @Test
                    @TestMetadata(value="mutableBoundPropertyReferenceFromClass.kt")
                    public void testMutableBoundPropertyReferenceFromClass() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutableBoundPropertyReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="mutablePropertyReferenceFromClass.kt")
                    public void testMutablePropertyReferenceFromClass() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/mutablePropertyReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="privateFunctionReference.kt")
                    public void testPrivateFunctionReference() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privateFunctionReference.kt");
                    }

                    @Test
                    @TestMetadata(value="privatePropertyReference.kt")
                    public void testPrivatePropertyReference() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/privatePropertyReference.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyImportedFromObject.kt")
                    public void testPropertyImportedFromObject() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyImportedFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyReference.kt")
                    public void testPropertyReference() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReference.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyReferenceFromClass.kt")
                    public void testPropertyReferenceFromClass() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyReferenceFromObject.kt")
                    public void testPropertyReferenceFromObject() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/propertyReferenceFromObject.kt");
                    }

                    @Test
                    @TestMetadata(value="withInlineClassParameter.kt")
                    public void testWithInlineClassParameter() {
                        IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/defaultValues/lambdaInlining/callableReferences/withInlineClassParameter.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/contracts")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Contracts {
            @Test
            public void testAllFilesPresentInContracts() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/contracts"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="cfgDependendValInitialization.kt")
            public void testCfgDependendValInitialization() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/cfgDependendValInitialization.kt");
            }

            @Test
            @TestMetadata(value="complexInitializer.kt")
            public void testComplexInitializer() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/complexInitializer.kt");
            }

            @Test
            @TestMetadata(value="complexInitializerWithStackTransformation.kt")
            public void testComplexInitializerWithStackTransformation() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/complexInitializerWithStackTransformation.kt");
            }

            @Test
            @TestMetadata(value="crossinlineCallableReference.kt")
            public void testCrossinlineCallableReference() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/crossinlineCallableReference.kt");
            }

            @Test
            @TestMetadata(value="definiteLongValInitialization.kt")
            public void testDefiniteLongValInitialization() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteLongValInitialization.kt");
            }

            @Test
            @TestMetadata(value="definiteNestedValInitialization.kt")
            public void testDefiniteNestedValInitialization() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteNestedValInitialization.kt");
            }

            @Test
            @TestMetadata(value="definiteValInitInInitializer.kt")
            public void testDefiniteValInitInInitializer() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitInInitializer.kt");
            }

            @Test
            @TestMetadata(value="definiteValInitialization.kt")
            public void testDefiniteValInitialization() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/definiteValInitialization.kt");
            }

            @Test
            @TestMetadata(value="exactlyOnceCrossinline.kt")
            public void testExactlyOnceCrossinline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline.kt");
            }

            @Test
            @TestMetadata(value="exactlyOnceCrossinline2.kt")
            public void testExactlyOnceCrossinline2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceCrossinline2.kt");
            }

            @Test
            @TestMetadata(value="exactlyOnceNoinline.kt")
            public void testExactlyOnceNoinline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/exactlyOnceNoinline.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturn.kt")
            public void testNonLocalReturn() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturn.kt");
            }

            @Test
            @TestMetadata(value="nonLocalReturnWithCycle.kt")
            public void testNonLocalReturnWithCycle() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/nonLocalReturnWithCycle.kt");
            }

            @Test
            @TestMetadata(value="propertyInitialization.kt")
            public void testPropertyInitialization() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/propertyInitialization.kt");
            }

            @Test
            @TestMetadata(value="valInitializationAndUsageInNestedLambda.kt")
            public void testValInitializationAndUsageInNestedLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/contracts/valInitializationAndUsageInNestedLambda.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/complexStack")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ComplexStack {
            @Test
            public void testAllFilesPresentInComplexStack() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complexStack"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="asCheck.kt")
            public void testAsCheck() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/asCheck.kt");
            }

            @Test
            @TestMetadata(value="asCheck2.kt")
            public void testAsCheck2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/asCheck2.kt");
            }

            @Test
            @TestMetadata(value="breakContinueInInlineLambdaArgument.kt")
            public void testBreakContinueInInlineLambdaArgument() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/breakContinueInInlineLambdaArgument.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple.kt");
            }

            @Test
            @TestMetadata(value="simple2.kt")
            public void testSimple2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple2.kt");
            }

            @Test
            @TestMetadata(value="simple3.kt")
            public void testSimple3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple3.kt");
            }

            @Test
            @TestMetadata(value="simple4.kt")
            public void testSimple4() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simple4.kt");
            }

            @Test
            @TestMetadata(value="simpleExtension.kt")
            public void testSimpleExtension() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/simpleExtension.kt");
            }

            @Test
            @TestMetadata(value="spillConstructorArgumentsAndInlineLambdaParameter.kt")
            public void testSpillConstructorArgumentsAndInlineLambdaParameter() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complexStack/spillConstructorArgumentsAndInlineLambdaParameter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/complex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Complex {
            @Test
            public void testAllFilesPresentInComplex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/complex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="closureChain.kt")
            public void testClosureChain() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/closureChain.kt");
            }

            @Test
            @TestMetadata(value="forEachLine.kt")
            public void testForEachLine() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/forEachLine.kt");
            }

            @Test
            @TestMetadata(value="kt44429.kt")
            public void testKt44429() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/kt44429.kt");
            }

            @Test
            @TestMetadata(value="kt44429MustFail.kt")
            public void testKt44429MustFail() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/kt44429MustFail.kt");
            }

            @Test
            @TestMetadata(value="lambdaInLambda.kt")
            public void testLambdaInLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/lambdaInLambda.kt");
            }

            @Test
            @TestMetadata(value="nestedCallsWithGeneric.kt")
            public void testNestedCallsWithGeneric() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/nestedCallsWithGeneric.kt");
            }

            @Test
            @TestMetadata(value="nestedCallsWithGenericToInt.kt")
            public void testNestedCallsWithGenericToInt() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/nestedCallsWithGenericToInt.kt");
            }

            @Test
            @TestMetadata(value="swapAndWith.kt")
            public void testSwapAndWith() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/swapAndWith.kt");
            }

            @Test
            @TestMetadata(value="swapAndWith2.kt")
            public void testSwapAndWith2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/swapAndWith2.kt");
            }

            @Test
            @TestMetadata(value="use.kt")
            public void testUse() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/use.kt");
            }

            @Test
            @TestMetadata(value="with.kt")
            public void testWith() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/complex/with.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/capture")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Capture {
            @Test
            public void testAllFilesPresentInCapture() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/capture"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="captureInlinable.kt")
            public void testCaptureInlinable() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/captureInlinable.kt");
            }

            @Test
            @TestMetadata(value="captureInlinableAndOther.kt")
            public void testCaptureInlinableAndOther() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/captureInlinableAndOther.kt");
            }

            @Test
            @TestMetadata(value="captureThisAndReceiver.kt")
            public void testCaptureThisAndReceiver() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/captureThisAndReceiver.kt");
            }

            @Test
            @TestMetadata(value="generics.kt")
            public void testGenerics() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/generics.kt");
            }

            @Test
            @TestMetadata(value="kt48230.kt")
            public void testKt48230() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt48230.kt");
            }

            @Test
            @TestMetadata(value="kt48230_2.kt")
            public void testKt48230_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt48230_2.kt");
            }

            @Test
            @TestMetadata(value="kt56500.kt")
            public void testKt56500() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt56500.kt");
            }

            @Test
            @TestMetadata(value="kt56965.kt")
            public void testKt56965() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt56965.kt");
            }

            @Test
            @TestMetadata(value="kt56965_2.kt")
            public void testKt56965_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/kt56965_2.kt");
            }

            @Test
            @TestMetadata(value="simpleCapturingInClass.kt")
            public void testSimpleCapturingInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInClass.kt");
            }

            @Test
            @TestMetadata(value="simpleCapturingInPackage.kt")
            public void testSimpleCapturingInPackage() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/capture/simpleCapturingInPackage.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/callableReference")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CallableReference {
            @Test
            @TestMetadata(value="adapted.kt")
            public void testAdapted() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adapted.kt");
            }

            @Test
            public void testAllFilesPresentInCallableReference() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classLevel.kt")
            public void testClassLevel() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/classLevel.kt");
            }

            @Test
            @TestMetadata(value="classLevel2.kt")
            public void testClassLevel2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/classLevel2.kt");
            }

            @Test
            @TestMetadata(value="constructor.kt")
            public void testConstructor() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/constructor.kt");
            }

            @Test
            @TestMetadata(value="inlineCallableReference.kt")
            public void testInlineCallableReference() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/inlineCallableReference.kt");
            }

            @Test
            @TestMetadata(value="innerGenericConstuctor.kt")
            public void testInnerGenericConstuctor() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/innerGenericConstuctor.kt");
            }

            @Test
            @TestMetadata(value="intrinsic.kt")
            public void testIntrinsic() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/intrinsic.kt");
            }

            @Test
            @TestMetadata(value="jvmFieldProperty.kt")
            public void testJvmFieldProperty() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/jvmFieldProperty.kt");
            }

            @Test
            @TestMetadata(value="kt15449.kt")
            public void testKt15449() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt15449.kt");
            }

            @Test
            @TestMetadata(value="kt15751_2.kt")
            public void testKt15751_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt15751_2.kt");
            }

            @Test
            @TestMetadata(value="kt16411.kt")
            public void testKt16411() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt16411.kt");
            }

            @Test
            @TestMetadata(value="kt35101.kt")
            public void testKt35101() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt35101.kt");
            }

            @Test
            @TestMetadata(value="kt69457.kt")
            public void testKt69457() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt69457.kt");
            }

            @Test
            @TestMetadata(value="kt69470.kt")
            public void testKt69470() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/kt69470.kt");
            }

            @Test
            @TestMetadata(value="propertyIntrinsic.kt")
            public void testPropertyIntrinsic() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/propertyIntrinsic.kt");
            }

            @Test
            @TestMetadata(value="propertyReference.kt")
            public void testPropertyReference() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/propertyReference.kt");
            }

            @Test
            @TestMetadata(value="topLevel.kt")
            public void testTopLevel() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/topLevel.kt");
            }

            @Test
            @TestMetadata(value="topLevelExtension.kt")
            public void testTopLevelExtension() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/topLevelExtension.kt");
            }

            @Test
            @TestMetadata(value="topLevelProperty.kt")
            public void testTopLevelProperty() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/topLevelProperty.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/callableReference/bound")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Bound {
                @Test
                public void testAllFilesPresentInBound() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/bound"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="classProperty.kt")
                public void testClassProperty() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/classProperty.kt");
                }

                @Test
                @TestMetadata(value="doubleBoundToThis.kt")
                public void testDoubleBoundToThis() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/doubleBoundToThis.kt");
                }

                @Test
                @TestMetadata(value="emptyLhsFunction.kt")
                public void testEmptyLhsFunction() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsFunction.kt");
                }

                @Test
                @TestMetadata(value="emptyLhsOnInlineProperty.kt")
                public void testEmptyLhsOnInlineProperty() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsOnInlineProperty.kt");
                }

                @Test
                @TestMetadata(value="emptyLhsProperty.kt")
                public void testEmptyLhsProperty() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/emptyLhsProperty.kt");
                }

                @Test
                @TestMetadata(value="expression.kt")
                public void testExpression() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/expression.kt");
                }

                @Test
                @TestMetadata(value="extensionReceiver.kt")
                public void testExtensionReceiver() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/extensionReceiver.kt");
                }

                @Test
                @TestMetadata(value="filter.kt")
                public void testFilter() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/filter.kt");
                }

                @Test
                @TestMetadata(value="inlineValueParameterInsteadOfReceiver.kt")
                public void testInlineValueParameterInsteadOfReceiver() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/inlineValueParameterInsteadOfReceiver.kt");
                }

                @Test
                @TestMetadata(value="innerGenericConstuctor.kt")
                public void testInnerGenericConstuctor() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/innerGenericConstuctor.kt");
                }

                @Test
                @TestMetadata(value="intrinsic.kt")
                public void testIntrinsic() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/intrinsic.kt");
                }

                @Test
                @TestMetadata(value="jvmFieldProperty.kt")
                public void testJvmFieldProperty() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/jvmFieldProperty.kt");
                }

                @Test
                @TestMetadata(value="kt18728.kt")
                public void testKt18728() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728.kt");
                }

                @Test
                @TestMetadata(value="kt18728_2.kt")
                public void testKt18728_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_2.kt");
                }

                @Test
                @TestMetadata(value="kt18728_3.kt")
                public void testKt18728_3() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_3.kt");
                }

                @Test
                @TestMetadata(value="kt18728_4.kt")
                public void testKt18728_4() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt18728_4.kt");
                }

                @Test
                @TestMetadata(value="kt30933.kt")
                public void testKt30933() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/kt30933.kt");
                }

                @Test
                @TestMetadata(value="lambdaOnLhs.kt")
                public void testLambdaOnLhs() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/lambdaOnLhs.kt");
                }

                @Test
                @TestMetadata(value="map.kt")
                public void testMap() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/map.kt");
                }

                @Test
                @TestMetadata(value="mixed.kt")
                public void testMixed() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/mixed.kt");
                }

                @Test
                @TestMetadata(value="objectProperty.kt")
                public void testObjectProperty() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/objectProperty.kt");
                }

                @Test
                @TestMetadata(value="propertyImportedFromObject.kt")
                public void testPropertyImportedFromObject() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/propertyImportedFromObject.kt");
                }

                @Test
                @TestMetadata(value="sideEffect.kt")
                public void testSideEffect() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/sideEffect.kt");
                }

                @Test
                @TestMetadata(value="simple.kt")
                public void testSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/simple.kt");
                }

                @Test
                @TestMetadata(value="simpleVal.kt")
                public void testSimpleVal() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal.kt");
                }

                @Test
                @TestMetadata(value="simpleVal2.kt")
                public void testSimpleVal2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/simpleVal2.kt");
                }

                @Test
                @TestMetadata(value="topLevelExtensionProperty.kt")
                public void testTopLevelExtensionProperty() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/bound/topLevelExtensionProperty.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/callableReference/adaptedReferences")
            @TestDataPath(value="$PROJECT_ROOT")
            public class AdaptedReferences {
                @Test
                public void testAllFilesPresentInAdaptedReferences() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/callableReference/adaptedReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineBound.kt")
                public void testInlineBound() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineBound.kt");
                }

                @Test
                @TestMetadata(value="inlineDefault.kt")
                public void testInlineDefault() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineVararg.kt")
                public void testInlineVararg() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVararg.kt");
                }

                @Test
                @TestMetadata(value="inlineVarargAndDefault.kt")
                public void testInlineVarargAndDefault() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargAndDefault.kt");
                }

                @Test
                @TestMetadata(value="inlineVarargInts.kt")
                public void testInlineVarargInts() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargInts.kt");
                }

                @Test
                @TestMetadata(value="inlineVarargWithLetCall.kt")
                public void testInlineVarargWithLetCall() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/inlineVarargWithLetCall.kt");
                }

                @Test
                @TestMetadata(value="multipleCallableReferenceUsage.kt")
                public void testMultipleCallableReferenceUsage() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/callableReference/adaptedReferences/multipleCallableReferenceUsage.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/bytecodePreprocessing")
        @TestDataPath(value="$PROJECT_ROOT")
        public class BytecodePreprocessing {
            @Test
            public void testAllFilesPresentInBytecodePreprocessing() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/bytecodePreprocessing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="apiVersionAtLeast1.kt")
            public void testApiVersionAtLeast1() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/bytecodePreprocessing/apiVersionAtLeast1.kt");
            }

            @Test
            @TestMetadata(value="inlineApiVersionAtLeastInStdlibInlineFunction.kt")
            public void testInlineApiVersionAtLeastInStdlibInlineFunction() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/bytecodePreprocessing/inlineApiVersionAtLeastInStdlibInlineFunction.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/builders")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Builders {
            @Test
            public void testAllFilesPresentInBuilders() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/builders"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="builders.kt")
            public void testBuilders() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/builders/builders.kt");
            }

            @Test
            @TestMetadata(value="buildersAndLambdaCapturing.kt")
            public void testBuildersAndLambdaCapturing() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/builders/buildersAndLambdaCapturing.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/assert")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Assert {
            @Test
            public void testAllFilesPresentInAssert() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jvmAssertInlineFunctionAssertionsDisabled.kt")
            public void testJvmAssertInlineFunctionAssertionsDisabled() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsDisabled.kt");
            }

            @Test
            @TestMetadata(value="jvmAssertInlineFunctionAssertionsEnabled.kt")
            public void testJvmAssertInlineFunctionAssertionsEnabled() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineFunctionAssertionsEnabled.kt");
            }

            @Test
            @TestMetadata(value="jvmAssertInlineLambda.kt")
            public void testJvmAssertInlineLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmAssertInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmClassInitializer.kt")
            public void testJvmClassInitializer() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmClassInitializer.kt");
            }

            @Test
            @TestMetadata(value="jvmCompanion.kt")
            public void testJvmCompanion() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCompanion.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambda.kt")
            public void testJvmCrossinlineLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambda2.kt")
            public void testJvmCrossinlineLambda2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambda2.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambdaDeclarationSite.kt")
            public void testJvmCrossinlineLambdaDeclarationSite() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSite.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineLambdaDeclarationSiteOnly.kt")
            public void testJvmCrossinlineLambdaDeclarationSiteOnly() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineLambdaDeclarationSiteOnly.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineRedundant.kt")
            public void testJvmCrossinlineRedundant() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineRedundant.kt");
            }

            @Test
            @TestMetadata(value="jvmCrossinlineSAMDeclarationSite.kt")
            public void testJvmCrossinlineSAMDeclarationSite() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmCrossinlineSAMDeclarationSite.kt");
            }

            @Test
            @TestMetadata(value="jvmDoubleInline.kt")
            public void testJvmDoubleInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmDoubleInline.kt");
            }

            @Test
            @TestMetadata(value="jvmInlineIntoTwoMethods.kt")
            public void testJvmInlineIntoTwoMethods() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmInlineIntoTwoMethods.kt");
            }

            @Test
            @TestMetadata(value="jvmInlineUsedAsNoinline.kt")
            public void testJvmInlineUsedAsNoinline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/assert/jvmInlineUsedAsNoinline.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/arrayConvention")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ArrayConvention {
            @Test
            public void testAllFilesPresentInArrayConvention() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/arrayConvention"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simpleAccess.kt")
            public void testSimpleAccess() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccess.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessInClass.kt")
            public void testSimpleAccessInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessInClass.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithDefault.kt")
            public void testSimpleAccessWithDefault() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefault.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithDefaultInClass.kt")
            public void testSimpleAccessWithDefaultInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithDefaultInClass.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithLambda.kt")
            public void testSimpleAccessWithLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambda.kt");
            }

            @Test
            @TestMetadata(value="simpleAccessWithLambdaInClass.kt")
            public void testSimpleAccessWithLambdaInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/arrayConvention/simpleAccessWithLambdaInClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/argumentOrder")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ArgumentOrder {
            @Test
            public void testAllFilesPresentInArgumentOrder() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="boundFunctionReference.kt")
            public void testBoundFunctionReference() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference.kt");
            }

            @Test
            @TestMetadata(value="boundFunctionReference2.kt")
            public void testBoundFunctionReference2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/boundFunctionReference2.kt");
            }

            @Test
            @TestMetadata(value="captured.kt")
            public void testCaptured() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/captured.kt");
            }

            @Test
            @TestMetadata(value="capturedInExtension.kt")
            public void testCapturedInExtension() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/capturedInExtension.kt");
            }

            @Test
            @TestMetadata(value="defaultParametersAndLastVarargWithCorrectOrder.kt")
            public void testDefaultParametersAndLastVarargWithCorrectOrder() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/defaultParametersAndLastVarargWithCorrectOrder.kt");
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/extension.kt");
            }

            @Test
            @TestMetadata(value="extensionInClass.kt")
            public void testExtensionInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/extensionInClass.kt");
            }

            @Test
            @TestMetadata(value="lambdaMigration.kt")
            public void testLambdaMigration() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigration.kt");
            }

            @Test
            @TestMetadata(value="lambdaMigrationInClass.kt")
            public void testLambdaMigrationInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/lambdaMigrationInClass.kt");
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/simple.kt");
            }

            @Test
            @TestMetadata(value="simpleInClass.kt")
            public void testSimpleInClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/simpleInClass.kt");
            }

            @Test
            @TestMetadata(value="varargAndDefaultParametersWithCorrectOrder.kt")
            public void testVarargAndDefaultParametersWithCorrectOrder() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/argumentOrder/varargAndDefaultParametersWithCorrectOrder.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject")
        @TestDataPath(value="$PROJECT_ROOT")
        public class AnonymousObject {
            @Test
            public void testAllFilesPresentInAnonymousObject() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="anonymousObjectInCallChildren.kt")
            public void testAnonymousObjectInCallChildren() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInCallChildren.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectInDefault.kt")
            public void testAnonymousObjectInDefault() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectInDefault.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnCallSite.kt")
            public void testAnonymousObjectOnCallSite() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSite.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnCallSiteSuperParams.kt")
            public void testAnonymousObjectOnCallSiteSuperParams() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnCallSiteSuperParams.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnDeclarationSite.kt")
            public void testAnonymousObjectOnDeclarationSite() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSite.kt");
            }

            @Test
            @TestMetadata(value="anonymousObjectOnDeclarationSiteSuperParams.kt")
            public void testAnonymousObjectOnDeclarationSiteSuperParams() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/anonymousObjectOnDeclarationSiteSuperParams.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInline.kt")
            public void testCapturedLambdaInInline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInline2.kt")
            public void testCapturedLambdaInInline2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline2.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInline3.kt")
            public void testCapturedLambdaInInline3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInline3.kt");
            }

            @Test
            @TestMetadata(value="capturedLambdaInInlineObject.kt")
            public void testCapturedLambdaInInlineObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLambdaInInlineObject.kt");
            }

            @Test
            @TestMetadata(value="capturedLocalFun.kt")
            public void testCapturedLocalFun() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFun.kt");
            }

            @Test
            @TestMetadata(value="capturedLocalFunRef.kt")
            public void testCapturedLocalFunRef() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFunRef.kt");
            }

            @Test
            @TestMetadata(value="capturedLocalFunTwice.kt")
            public void testCapturedLocalFunTwice() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/capturedLocalFunTwice.kt");
            }

            @Test
            @TestMetadata(value="changingReturnType.kt")
            public void testChangingReturnType() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/changingReturnType.kt");
            }

            @Test
            @TestMetadata(value="constructOriginalInRegenerated.kt")
            public void testConstructOriginalInRegenerated() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructOriginalInRegenerated.kt");
            }

            @Test
            @TestMetadata(value="constructorVisibility.kt")
            public void testConstructorVisibility() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibility.kt");
            }

            @Test
            @TestMetadata(value="constructorVisibilityInConstLambda.kt")
            public void testConstructorVisibilityInConstLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInConstLambda.kt");
            }

            @Test
            @TestMetadata(value="constructorVisibilityInLambda.kt")
            public void testConstructorVisibilityInLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/constructorVisibilityInLambda.kt");
            }

            @Test
            @TestMetadata(value="defineClass.kt")
            public void testDefineClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/defineClass.kt");
            }

            @Test
            @TestMetadata(value="fakeOverrideInDefaultMultiModule.kt")
            public void testFakeOverrideInDefaultMultiModule() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/fakeOverrideInDefaultMultiModule.kt");
            }

            @Test
            @TestMetadata(value="fakeOverrideMultiModule.kt")
            public void testFakeOverrideMultiModule() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/fakeOverrideMultiModule.kt");
            }

            @Test
            @TestMetadata(value="functionExpression.kt")
            public void testFunctionExpression() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/functionExpression.kt");
            }

            @Test
            @TestMetadata(value="inlineCallInsideInlineLambda.kt")
            public void testInlineCallInsideInlineLambda() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/inlineCallInsideInlineLambda.kt");
            }

            @Test
            @TestMetadata(value="kt13133.kt")
            public void testKt13133() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13133.kt");
            }

            @Test
            @TestMetadata(value="kt13182.kt")
            public void testKt13182() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13182.kt");
            }

            @Test
            @TestMetadata(value="kt13374.kt")
            public void testKt13374() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt13374.kt");
            }

            @Test
            @TestMetadata(value="kt14011.kt")
            public void testKt14011() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011.kt");
            }

            @Test
            @TestMetadata(value="kt14011_2.kt")
            public void testKt14011_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_2.kt");
            }

            @Test
            @TestMetadata(value="kt14011_3.kt")
            public void testKt14011_3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt14011_3.kt");
            }

            @Test
            @TestMetadata(value="kt15751.kt")
            public void testKt15751() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt15751.kt");
            }

            @Test
            @TestMetadata(value="kt16193.kt")
            public void testKt16193() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt16193.kt");
            }

            @Test
            @TestMetadata(value="kt17972.kt")
            public void testKt17972() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972.kt");
            }

            @Test
            @TestMetadata(value="kt17972_2.kt")
            public void testKt17972_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_2.kt");
            }

            @Test
            @TestMetadata(value="kt17972_3.kt")
            public void testKt17972_3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_3.kt");
            }

            @Test
            @TestMetadata(value="kt17972_4.kt")
            public void testKt17972_4() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_4.kt");
            }

            @Test
            @TestMetadata(value="kt17972_5.kt")
            public void testKt17972_5() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_5.kt");
            }

            @Test
            @TestMetadata(value="kt17972_super.kt")
            public void testKt17972_super() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super.kt");
            }

            @Test
            @TestMetadata(value="kt17972_super2.kt")
            public void testKt17972_super2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super2.kt");
            }

            @Test
            @TestMetadata(value="kt17972_super3.kt")
            public void testKt17972_super3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt17972_super3.kt");
            }

            @Test
            @TestMetadata(value="kt19389.kt")
            public void testKt19389() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19389.kt");
            }

            @Test
            @TestMetadata(value="kt19399.kt")
            public void testKt19399() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19399.kt");
            }

            @Test
            @TestMetadata(value="kt19434.kt")
            public void testKt19434() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434.kt");
            }

            @Test
            @TestMetadata(value="kt19434_2.kt")
            public void testKt19434_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19434_2.kt");
            }

            @Test
            @TestMetadata(value="kt19723.kt")
            public void testKt19723() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt19723.kt");
            }

            @Test
            @TestMetadata(value="kt29595.kt")
            public void testKt29595() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt29595.kt");
            }

            @Test
            @TestMetadata(value="kt30696.kt")
            public void testKt30696() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt30696.kt");
            }

            @Test
            @TestMetadata(value="kt34656.kt")
            public void testKt34656() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt34656.kt");
            }

            @Test
            @TestMetadata(value="kt38197.kt")
            public void testKt38197() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt38197.kt");
            }

            @Test
            @TestMetadata(value="kt41174.kt")
            public void testKt41174() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt41174.kt");
            }

            @Test
            @TestMetadata(value="kt42815.kt")
            public void testKt42815() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815.kt");
            }

            @Test
            @TestMetadata(value="kt42815_delegated.kt")
            public void testKt42815_delegated() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt42815_delegated.kt");
            }

            @Test
            @TestMetadata(value="kt51950.kt")
            public void testKt51950() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt51950.kt");
            }

            @Test
            @TestMetadata(value="kt52795.kt")
            public void testKt52795() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795.kt");
            }

            @Test
            @TestMetadata(value="kt52795_2.kt")
            public void testKt52795_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_2.kt");
            }

            @Test
            @TestMetadata(value="kt52795_3.kt")
            public void testKt52795_3() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_3.kt");
            }

            @Test
            @TestMetadata(value="kt52795_4.kt")
            public void testKt52795_4() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_4.kt");
            }

            @Test
            @TestMetadata(value="kt52795_5.kt")
            public void testKt52795_5() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt52795_5.kt");
            }

            @Test
            @TestMetadata(value="kt57053.kt")
            public void testKt57053() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt57053.kt");
            }

            @Test
            @TestMetadata(value="kt6007.kt")
            public void testKt6007() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6007.kt");
            }

            @Test
            @TestMetadata(value="kt65503.kt")
            public void testKt65503() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt65503.kt");
            }

            @Test
            @TestMetadata(value="kt65503_2.kt")
            public void testKt65503_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt65503_2.kt");
            }

            @Test
            @TestMetadata(value="kt6552.kt")
            public void testKt6552() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt6552.kt");
            }

            @Test
            @TestMetadata(value="kt8133.kt")
            public void testKt8133() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt8133.kt");
            }

            @Test
            @TestMetadata(value="kt9064.kt")
            public void testKt9064() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064.kt");
            }

            @Test
            @TestMetadata(value="kt9064v2.kt")
            public void testKt9064v2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9064v2.kt");
            }

            @Test
            @TestMetadata(value="kt9591.kt")
            public void testKt9591() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9591.kt");
            }

            @Test
            @TestMetadata(value="kt9877.kt")
            public void testKt9877() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877.kt");
            }

            @Test
            @TestMetadata(value="kt9877_2.kt")
            public void testKt9877_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/kt9877_2.kt");
            }

            @Test
            @TestMetadata(value="nestedTypeRemapping.kt")
            public void testNestedTypeRemapping() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/nestedTypeRemapping.kt");
            }

            @Test
            @TestMetadata(value="objectInLambdaCapturesAnotherObject.kt")
            public void testObjectInLambdaCapturesAnotherObject() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/objectInLambdaCapturesAnotherObject.kt");
            }

            @Test
            @TestMetadata(value="safeCall.kt")
            public void testSafeCall() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall.kt");
            }

            @Test
            @TestMetadata(value="safeCall_2.kt")
            public void testSafeCall_2() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/safeCall_2.kt");
            }

            @Test
            @TestMetadata(value="sam.kt")
            public void testSam() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam.kt");
            }

            @Test
            @TestMetadata(value="sharedFromCrossinline.kt")
            public void testSharedFromCrossinline() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sharedFromCrossinline.kt");
            }

            @Test
            @TestMetadata(value="superConstructorWithObjectParameter.kt")
            public void testSuperConstructorWithObjectParameter() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/superConstructorWithObjectParameter.kt");
            }

            @Test
            @TestMetadata(value="twoAnonymousObjects.kt")
            public void testTwoAnonymousObjects() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoAnonymousObjects.kt");
            }

            @Test
            @TestMetadata(value="typeInfo.kt")
            public void testTypeInfo() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/typeInfo.kt");
            }

            @Test
            @TestMetadata(value="withInlineMethod.kt")
            public void testWithInlineMethod() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/withInlineMethod.kt");
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers")
            @TestDataPath(value="$PROJECT_ROOT")
            public class TwoCapturedReceivers {
                @Test
                public void testAllFilesPresentInTwoCapturedReceivers() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="kt8668.kt")
                public void testKt8668() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668.kt");
                }

                @Test
                @TestMetadata(value="kt8668_2.kt")
                public void testKt8668_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_2.kt");
                }

                @Test
                @TestMetadata(value="kt8668_3.kt")
                public void testKt8668_3() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_3.kt");
                }

                @Test
                @TestMetadata(value="kt8668_nested.kt")
                public void testKt8668_nested() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested.kt");
                }

                @Test
                @TestMetadata(value="kt8668_nested_2.kt")
                public void testKt8668_nested_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/kt8668_nested_2.kt");
                }

                @Test
                @TestMetadata(value="twoDifferentDispatchReceivers.kt")
                public void testTwoDifferentDispatchReceivers() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoDifferentDispatchReceivers.kt");
                }

                @Test
                @TestMetadata(value="twoExtensionReceivers.kt")
                public void testTwoExtensionReceivers() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/twoCapturedReceivers/twoExtensionReceivers.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/sam")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Sam {
                @Test
                public void testAllFilesPresentInSam() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="anonymousObjectToSam.kt")
                public void testAnonymousObjectToSam() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/anonymousObjectToSam.kt");
                }

                @Test
                @TestMetadata(value="kt17091.kt")
                public void testKt17091() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt17091.kt");
                }

                @Test
                @TestMetadata(value="kt21671.kt")
                public void testKt21671() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671.kt");
                }

                @Test
                @TestMetadata(value="kt21671_2.kt")
                public void testKt21671_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_2.kt");
                }

                @Test
                @TestMetadata(value="kt21671_3.kt")
                public void testKt21671_3() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt21671_3.kt");
                }

                @Test
                @TestMetadata(value="kt22304.kt")
                public void testKt22304() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/kt22304.kt");
                }

                @Test
                @TestMetadata(value="samOnCallSite.kt")
                public void testSamOnCallSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/sam/samOnCallSite.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ProperRecapturingInClass {
                @Test
                public void testAllFilesPresentInProperRecapturingInClass() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineChain.kt")
                public void testInlineChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlineChain.kt");
                }

                @Test
                @TestMetadata(value="inlinelambdaChain.kt")
                public void testInlinelambdaChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/inlinelambdaChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain.kt")
                public void testLambdaChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChainSimple.kt")
                public void testLambdaChainSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple.kt");
                }

                @Test
                @TestMetadata(value="lambdaChainSimple_2.kt")
                public void testLambdaChainSimple_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChainSimple_2.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_2.kt")
                public void testLambdaChain_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_2.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_3.kt")
                public void testLambdaChain_3() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/lambdaChain_3.kt");
                }

                @Test
                @TestMetadata(value="noCapturedThisOnCallSite.kt")
                public void testNoCapturedThisOnCallSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noCapturedThisOnCallSite.kt");
                }

                @Test
                @TestMetadata(value="noInlineLambda.kt")
                public void testNoInlineLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/noInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="twoInlineLambda.kt")
                public void testTwoInlineLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambda.kt");
                }

                @Test
                @TestMetadata(value="twoInlineLambdaComplex.kt")
                public void testTwoInlineLambdaComplex() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex.kt");
                }

                @Test
                @TestMetadata(value="twoInlineLambdaComplex_2.kt")
                public void testTwoInlineLambdaComplex_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturingInClass/twoInlineLambdaComplex_2.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/properRecapturing")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ProperRecapturing {
                @Test
                public void testAllFilesPresentInProperRecapturing() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="inlineChain.kt")
                public void testInlineChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/inlineChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain.kt")
                public void testLambdaChain() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain.kt");
                }

                @Test
                @TestMetadata(value="lambdaChainSimple.kt")
                public void testLambdaChainSimple() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChainSimple.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_2.kt")
                public void testLambdaChain_2() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_2.kt");
                }

                @Test
                @TestMetadata(value="lambdaChain_3.kt")
                public void testLambdaChain_3() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/lambdaChain_3.kt");
                }

                @Test
                @TestMetadata(value="noInlineLambda.kt")
                public void testNoInlineLambda() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/properRecapturing/noInlineLambda.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/enumWhen")
            @TestDataPath(value="$PROJECT_ROOT")
            public class EnumWhen {
                @Test
                public void testAllFilesPresentInEnumWhen() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumWhen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="callSite.kt")
                public void testCallSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/callSite.kt");
                }

                @Test
                @TestMetadata(value="declSite.kt")
                public void testDeclSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSite.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappings.kt")
                public void testDeclSiteSeveralMappings() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappings.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappingsDifOrder.kt")
                public void testDeclSiteSeveralMappingsDifOrder() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumWhen/declSiteSeveralMappingsDifOrder.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/boxInline/anonymousObject/enumEntries")
            @TestDataPath(value="$PROJECT_ROOT")
            public class EnumEntries {
                @Test
                public void testAllFilesPresentInEnumEntries() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/anonymousObject/enumEntries"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="callSite.kt")
                public void testCallSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/callSite.kt");
                }

                @Test
                @TestMetadata(value="declSite.kt")
                public void testDeclSite() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSite.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappings.kt")
                public void testDeclSiteSeveralMappings() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSiteSeveralMappings.kt");
                }

                @Test
                @TestMetadata(value="declSiteSeveralMappingsDifOrder.kt")
                public void testDeclSiteSeveralMappingsDifOrder() {
                    IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/anonymousObject/enumEntries/declSiteSeveralMappingsDifOrder.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/boxInline/annotations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Annotations {
            @Test
            public void testAllFilesPresentInAnnotations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/boxInline/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="annotationInstanceInlining.kt")
            public void testAnnotationInstanceInlining() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/annotations/annotationInstanceInlining.kt");
            }

            @Test
            @TestMetadata(value="instanceInAnonymousClass.kt")
            public void testInstanceInAnonymousClass() {
                IrBlackBoxInlineCodegenWithIrInlinerTestGenerated.this.runTest("compiler/testData/codegen/boxInline/annotations/instanceInAnonymousClass.kt");
            }
        }
    }
}

