/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.preprocessors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.services.ReversibleSourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/preprocessors/ExternalAnnotationsSourcePreprocessor;", "Lorg/jetbrains/kotlin/test/services/ReversibleSourceFilePreprocessor;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "process", "", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "content", "revert", "actualContent", "tests-common-new_test"})
public final class ExternalAnnotationsSourcePreprocessor
extends ReversibleSourceFilePreprocessor {
    public ExternalAnnotationsSourcePreprocessor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public String process(@NotNull TestFile file, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return SourceFileProviderKt.isExternalAnnotation(file) ? SequencesKt.joinToString$default((Sequence)SequencesKt.filterNot((Sequence)StringsKt.lineSequence((CharSequence)((Object)StringsKt.trim((CharSequence)content)).toString()), ExternalAnnotationsSourcePreprocessor::process$lambda$0), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : content;
    }

    @Override
    @NotNull
    public String revert(@NotNull TestFile file, @NotNull String actualContent) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)actualContent, (String)"actualContent");
        return SourceFileProviderKt.isExternalAnnotation(file) ? ((Object)StringsKt.trim((CharSequence)file.getOriginalContent())).toString() + '\n' : actualContent;
    }

    private static final boolean process$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((CharSequence)it, (char)'/', (boolean)false, (int)2, null);
    }
}

