/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.cli;

import java.io.File;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.CompilerTestUtil;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.cli.CliArtifact;
import org.jetbrains.kotlin.test.cli.CliDirectives;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.BinaryArtifactHandler;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/cli/CliOutputHandler;", "Lorg/jetbrains/kotlin/test/model/BinaryArtifactHandler;", "Lorg/jetbrains/kotlin/test/cli/CliArtifact;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "multiModuleInfoDumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "processAfterAllModules", "someAssertionWasFailed", "", "tests-common-new_test"})
public final class CliOutputHandler
extends BinaryArtifactHandler<CliArtifact> {
    @NotNull
    private final MultiModuleInfoDumper multiModuleInfoDumper;

    public CliOutputHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, CliArtifact.Kind.INSTANCE, false, true);
        this.multiModuleInfoDumper = new MultiModuleInfoDumper(null, 1, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull CliArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (((CharSequence)info.getKotlinOutput()).length() == 0) {
            return;
        }
        if (!module.getDirectives().contains(CliDirectives.INSTANCE.getCHECK_COMPILER_OUTPUT())) {
            return;
        }
        this.multiModuleInfoDumper.builderForModule(module).append(info.getKotlinOutput());
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        File outFile;
        File sourceFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File defaultOutFile = FileUtilsKt.withExtension(sourceFile, ".out");
        File firOutFile = FileUtilsKt.withExtension(sourceFile, ".fir.out");
        boolean isFir = Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE);
        File file = outFile = isFir && firOutFile.exists() ? firOutFile : defaultOutFile;
        if (this.multiModuleInfoDumper.isEmpty()) {
            if (Intrinsics.areEqual((Object)outFile, (Object)firOutFile)) {
                Assertions.assertEqualsToFile$default(this.getAssertions(), firOutFile, "", null, 4, null);
            } else {
                HandlerUtilsKt.assertFileDoesntExist(this.getAssertions(), outFile, CliDirectives.INSTANCE.getCHECK_COMPILER_OUTPUT());
            }
            return;
        }
        String string = this.multiModuleInfoDumper.generateResultingDump();
        String string2 = TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(this.getTestServices()).getRootDir().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        String actualOutput = CompilerTestUtil.normalizeCompilerOutput(string, string2);
        Assertions.assertEqualsToFile$default(this.getAssertions(), outFile, actualOutput, null, 4, null);
        if (!Intrinsics.areEqual((Object)outFile, (Object)defaultOutFile) && Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)outFile, null, (int)1, null))).toString(), (Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)defaultOutFile, null, (int)1, null))).toString())) {
            this.getAssertions().fail((Function0<String>)((Function0)() -> CliOutputHandler.processAfterAllModules$lambda$0(outFile)));
            throw new KotlinNothingValueException();
        }
    }

    private static final String processAfterAllModules$lambda$0(File $outFile) {
        return "Classic and FIR golden files are identical. Remove " + $outFile + '.';
    }
}

