/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.intellij.openapi.util.text.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.test.KtAssert;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J:\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007JF\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\n2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/CompilerTestUtil;", "", "<init>", "()V", "executeCompilerAssertSuccessful", "", "compiler", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "args", "", "", "messageRenderer", "Lorg/jetbrains/kotlin/cli/common/messages/MessageRenderer;", "executeCompiler", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "compileJvmLibrary", "Ljava/io/File;", "src", "libraryName", "extraOptions", "extraClasspath", "normalizeCompilerOutput", "output", "tmpdir", "test-infrastructure-utils_test"})
@SourceDebugExtension(value={"SMAP\nCompilerTestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerTestUtil.kt\norg/jetbrains/kotlin/test/CompilerTestUtil\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,93:1\n37#2:94\n36#2,3:95\n37#2:98\n36#2,3:99\n*S KotlinDebug\n*F\n+ 1 CompilerTestUtil.kt\norg/jetbrains/kotlin/test/CompilerTestUtil\n*L\n38#1:94\n38#1:95,3\n39#1:98\n39#1:99,3\n*E\n"})
public final class CompilerTestUtil {
    @NotNull
    public static final CompilerTestUtil INSTANCE = new CompilerTestUtil();

    private CompilerTestUtil() {
    }

    @JvmStatic
    public static final void executeCompilerAssertSuccessful(@NotNull CLICompiler<?> compiler, @NotNull List<String> args2, @Nullable MessageRenderer messageRenderer) {
        Intrinsics.checkNotNullParameter(compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        Pair<String, ExitCode> pair = CompilerTestUtil.executeCompiler(compiler, args2, messageRenderer);
        String output = (String)pair.component1();
        ExitCode exitCode = (ExitCode)pair.component2();
        KtAssert.assertEquals(output, ExitCode.OK, exitCode);
    }

    public static /* synthetic */ void executeCompilerAssertSuccessful$default(CLICompiler cLICompiler, List list, MessageRenderer messageRenderer, int n, Object object) {
        if ((n & 4) != 0) {
            messageRenderer = null;
        }
        CompilerTestUtil.executeCompilerAssertSuccessful(cLICompiler, list, messageRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Pair<String, ExitCode> executeCompiler(@NotNull CLICompiler<?> compiler, @NotNull List<String> args2, @Nullable MessageRenderer messageRenderer) {
        Intrinsics.checkNotNullParameter(compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream origErr = System.err;
        try {
            ExitCode exitCode;
            Collection thisCollection$iv;
            boolean $i$f$toTypedArray;
            Collection $this$toTypedArray$iv;
            System.setErr(new PrintStream(bytes));
            if (messageRenderer == null) {
                $this$toTypedArray$iv = args2;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                exitCode = CLICompiler.Companion.doMainNoExit$default((CLICompiler.Companion)CLICompiler.Companion, compiler, (String[])thisCollection$iv.toArray(new String[0]), null, (int)4, null);
            } else {
                $this$toTypedArray$iv = args2;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                exitCode = CLICompiler.Companion.doMainNoExit(compiler, thisCollection$iv.toArray(new String[0]), messageRenderer);
            }
            ExitCode exitCode2 = exitCode;
            byte[] byArray = bytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            Object object = byArray;
            object = new Pair((Object)new String((byte[])object, Charsets.UTF_8), (Object)exitCode2);
            return object;
        }
        finally {
            System.setErr(origErr);
        }
    }

    public static /* synthetic */ Pair executeCompiler$default(CLICompiler cLICompiler, List list, MessageRenderer messageRenderer, int n, Object object) {
        if ((n & 4) != 0) {
            messageRenderer = null;
        }
        return CompilerTestUtil.executeCompiler(cLICompiler, list, messageRenderer);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final File compileJvmLibrary(@NotNull File src, @NotNull String libraryName, @NotNull List<String> extraOptions, @NotNull List<? extends File> extraClasspath, @Nullable MessageRenderer messageRenderer) {
        List list;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        File destination = new File(KtTestUtil.tmpDir("testLibrary"), libraryName + ".jar");
        List $this$compileJvmLibrary_u24lambda_u241 = list = (List)new ArrayList();
        boolean bl = false;
        String string = src.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        $this$compileJvmLibrary_u24lambda_u241.add(string);
        $this$compileJvmLibrary_u24lambda_u241.add("-d");
        String string2 = destination.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        $this$compileJvmLibrary_u24lambda_u241.add(string2);
        if (!((Collection)extraClasspath).isEmpty()) {
            $this$compileJvmLibrary_u24lambda_u241.add("-cp");
            $this$compileJvmLibrary_u24lambda_u241.add(CollectionsKt.joinToString$default((Iterable)extraClasspath, (CharSequence)":", null, null, (int)0, null, CompilerTestUtil::compileJvmLibrary$lambda$1$lambda$0, (int)30, null));
        }
        $this$compileJvmLibrary_u24lambda_u241.addAll((Collection)extraOptions);
        List args2 = list;
        CompilerTestUtil.executeCompilerAssertSuccessful((CLICompiler)new K2JVMCompiler(), args2, messageRenderer);
        return destination;
    }

    public static /* synthetic */ File compileJvmLibrary$default(File file, String string, List list, List list2, MessageRenderer messageRenderer, int n, Object object) {
        if ((n & 2) != 0) {
            string = "library";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            messageRenderer = null;
        }
        return CompilerTestUtil.compileJvmLibrary(file, string, list, list2, messageRenderer);
    }

    @JvmStatic
    @NotNull
    public static final String normalizeCompilerOutput(@NotNull String output, @NotNull String tmpdir) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)tmpdir, (String)"tmpdir");
        String tmpDirAbsoluteDir = new File(tmpdir).getAbsolutePath();
        String string = StringUtil.convertLineSeparators((String)output);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String string2 = PathUtil.getKotlinPathsForDistDirectory().getHomePath().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        String string3 = StringsKt.replace$default((String)string, (String)string2, (String)"$PROJECT_DIR$", (boolean)false, (int)4, null);
        String string4 = PathUtil.getKotlinPathsForDistDirectory().getHomePath().getParentFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
        String string5 = StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)string4, (String)"$DIST_DIR$", (boolean)false, (int)4, null), (String)org.jetbrains.kotlin.konan.file.File.Companion.getUserDir().getAbsolutePath(), (String)"$USER_DIR$", (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)tmpDirAbsoluteDir);
        String string6 = StringsKt.replace$default((String)StringsKt.replace$default((String)string5, (String)tmpDirAbsoluteDir, (String)"$TMP_DIR$", (boolean)false, (int)4, null), (String)"\\", (String)"/", (boolean)false, (int)4, null);
        String string7 = KtTestUtil.getJdk8Home().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAbsolutePath(...)");
        String string8 = StringsKt.replace$default((String)string6, (String)StringsKt.replace$default((String)string7, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String)"$JDK_1_8", (boolean)false, (int)4, null);
        String string9 = KtTestUtil.getJdk11Home().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getAbsolutePath(...)");
        String string10 = StringsKt.replace$default((String)string8, (String)StringsKt.replace$default((String)string9, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String)"$JDK_11", (boolean)false, (int)4, null);
        String string11 = KtTestUtil.getJdk17Home().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getAbsolutePath(...)");
        String string12 = StringsKt.replace$default((String)string10, (String)StringsKt.replace$default((String)string11, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String)"$JDK_17", (boolean)false, (int)4, null);
        String string13 = KtTestUtil.getJdk21Home().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getAbsolutePath(...)");
        CharSequence charSequence = StringsKt.replace$default((String)string12, (String)StringsKt.replace$default((String)string13, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String)"$JDK_21", (boolean)false, (int)4, null);
        Regex regex = new Regex("info: executable production duration: \\d+ms");
        String string14 = "info: executable production duration: [time]";
        String string15 = regex.replace(charSequence, string14);
        String string16 = System.getProperty("java.runtime.version");
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"getProperty(...)");
        charSequence = StringsKt.replace$default((String)string15, (String)string16, (String)"$JVM_VERSION$", (boolean)false, (int)4, null);
        regex = new Regex(' ' + StringsKt.replace$default((String)MetadataVersion.INSTANCE.toString(), (String)".", (String)"\\.", (boolean)false, (int)4, null) + "(?!\\-)");
        string14 = " \\$ABI_VERSION\\$";
        charSequence = regex.replace(charSequence, string14);
        regex = new Regex(' ' + StringsKt.replace$default((String)JsMetadataVersion.INSTANCE.toString(), (String)".", (String)"\\.", (boolean)false, (int)4, null) + "(?!\\-)");
        string14 = " \\$ABI_VERSION\\$";
        String string17 = regex.replace(charSequence, string14);
        String string18 = KotlinCompilerVersion.VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"VERSION");
        charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string17, (String)string18, (String)"$VERSION$", (boolean)false, (int)4, null), (String)("" + ' ' + MetadataVersion.INSTANCE_NEXT), (String)" $ABI_VERSION_NEXT$", (boolean)false, (int)4, null), (String)"\nNote: on Windows, arguments that contain delimiter characters (whitespace, =, ;, ,) need to be surrounded with double quotes (\").\n", (String)"", (boolean)false, (int)4, null);
        regex = new Regex("log4j:WARN.*\n");
        string14 = "";
        return regex.replace(charSequence, string14);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final File compileJvmLibrary(@NotNull File src, @NotNull String libraryName, @NotNull List<String> extraOptions, @NotNull List<? extends File> extraClasspath) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        return CompilerTestUtil.compileJvmLibrary$default(src, libraryName, extraOptions, extraClasspath, null, 16, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final File compileJvmLibrary(@NotNull File src, @NotNull String libraryName, @NotNull List<String> extraOptions) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        return CompilerTestUtil.compileJvmLibrary$default(src, libraryName, extraOptions, null, null, 24, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final File compileJvmLibrary(@NotNull File src, @NotNull String libraryName) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        return CompilerTestUtil.compileJvmLibrary$default(src, libraryName, null, null, null, 28, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final File compileJvmLibrary(@NotNull File src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return CompilerTestUtil.compileJvmLibrary$default(src, null, null, null, null, 30, null);
    }

    private static final CharSequence compileJvmLibrary$lambda$1$lambda$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }
}

