/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\bJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u0019\u001a\u00020\u000fJ\"\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/generators/util/GeneratorsFileUtil;", "", "<init>", "()V", "isTeamCityBuild", "", "()Z", "GENERATED_MESSAGE", "", "getGENERATED_MESSAGE", "()Ljava/lang/String;", "GENERATED_MESSAGE_PREFIX", "GENERATED_MESSAGE_SUFFIX", "writeFileIfContentChanged", "file", "Ljava/io/File;", "newText", "logNotChanged", "forbidGenerationOnTeamcity", "failOnTeamCity", "message", "isFileContentChangedIgnoringLineSeparators", "content", "collectPreviouslyGeneratedFiles", "", "generationPath", "removeExtraFilesFromPreviousGeneration", "", "previouslyGeneratedFiles", "generatedFiles", "generators"})
@SourceDebugExtension(value={"SMAP\nGeneratorsFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneratorsFileUtil.kt\norg/jetbrains/kotlin/generators/util/GeneratorsFileUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1634#2,3:117\n1#3:120\n*S KotlinDebug\n*F\n+ 1 GeneratorsFileUtil.kt\norg/jetbrains/kotlin/generators/util/GeneratorsFileUtil\n*L\n105#1:117,3\n*E\n"})
public final class GeneratorsFileUtil {
    @NotNull
    public static final GeneratorsFileUtil INSTANCE = new GeneratorsFileUtil();
    private static final boolean isTeamCityBuild = System.getenv("TEAMCITY_VERSION") != null;
    @NotNull
    private static final String GENERATED_MESSAGE = "/*\n * This file was generated automatically\n * DO NOT MODIFY IT MANUALLY\n */";
    @NotNull
    public static final String GENERATED_MESSAGE_PREFIX = "// This file was generated automatically. See ";
    @NotNull
    public static final String GENERATED_MESSAGE_SUFFIX = "// DO NOT MODIFY IT MANUALLY.";

    private GeneratorsFileUtil() {
    }

    public final boolean isTeamCityBuild() {
        return isTeamCityBuild;
    }

    @NotNull
    public final String getGENERATED_MESSAGE() {
        return GENERATED_MESSAGE;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean writeFileIfContentChanged(@NotNull File file, @NotNull String newText, boolean logNotChanged, boolean forbidGenerationOnTeamcity) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            if (forbidGenerationOnTeamcity && INSTANCE.failOnTeamCity("Create dir `" + parentFile.getPath() + '`')) {
                return false;
            }
            if (parentFile.mkdirs()) {
                System.out.println((Object)("Directory created: " + parentFile.getAbsolutePath()));
            } else if (!parentFile.exists()) {
                throw new IllegalStateException("Cannot create directory: " + parentFile);
            }
        }
        if (!INSTANCE.isFileContentChangedIgnoringLineSeparators(file, newText)) {
            if (logNotChanged) {
                System.out.println((Object)("Not changed: " + file.getAbsolutePath()));
            }
            return false;
        }
        if (forbidGenerationOnTeamcity && INSTANCE.failOnTeamCity("Write file `" + file.toPath() + '`')) {
            return false;
        }
        boolean useTempFile = !SystemInfo.isWindows;
        Path targetFile = file.toPath();
        if (useTempFile) {
            Intrinsics.checkNotNull((Object)targetFile);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path2 = Files.createTempDirectory(PathsKt.getName((Path)targetFile), Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempDirectory(...)");
            Path path3 = path2.resolve(PathsKt.getName((Path)targetFile) + ".tmp");
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        } else {
            path = targetFile;
        }
        Path tempFile = path;
        Intrinsics.checkNotNull((Object)tempFile);
        PathsKt.writeText((Path)tempFile, (CharSequence)newText, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
        if (useTempFile) {
            Path path4 = tempFile;
            Intrinsics.checkNotNull((Object)targetFile);
            Path path5 = targetFile;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path4, path5, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"move(...)");
        }
        System.out.println((Object)("File written: " + targetFile.toAbsolutePath()));
        return true;
    }

    public static /* synthetic */ boolean writeFileIfContentChanged$default(File file, String string, boolean bl, boolean bl2, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return GeneratorsFileUtil.writeFileIfContentChanged(file, string, bl, bl2);
    }

    private final boolean failOnTeamCity(String message) {
        if (!isTeamCityBuild) {
            return false;
        }
        String fullMessage = "[Re-generation needed!] " + message + "\nRun correspondent (check the log above) Gradle task locally and commit changes.";
        System.out.println((Object)("##teamcity[buildProblem description='" + GeneratorsFileUtil.failOnTeamCity$escapeForTC(fullMessage) + "']"));
        return true;
    }

    public final boolean isFileContentChangedIgnoringLineSeparators(@NotNull File file, @NotNull String content) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            string = StringUtil.convertLineSeparators((String)FilesKt.readText((File)file, (Charset)Charsets.UTF_8));
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Throwable ignored) {
            return true;
        }
        String currentContent = string;
        return !Intrinsics.areEqual((Object)StringUtil.convertLineSeparators((String)content), (Object)currentContent);
    }

    @NotNull
    public final List<File> collectPreviouslyGeneratedFiles(@NotNull File generationPath) {
        Intrinsics.checkNotNullParameter((Object)generationPath, (String)"generationPath");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)generationPath)), GeneratorsFileUtil::collectPreviouslyGeneratedFiles$lambda$2));
    }

    /*
     * WARNING - void declaration
     */
    public final void removeExtraFilesFromPreviousGeneration(@NotNull List<? extends File> previouslyGeneratedFiles, @NotNull List<? extends File> generatedFiles) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(previouslyGeneratedFiles, (String)"previouslyGeneratedFiles");
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        Iterable iterable = generatedFiles;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            File file = (File)item$iv;
            Collection collection2 = collection;
            boolean bl = false;
            collection2.add(it.getAbsolutePath());
        }
        Set generatedFilesPath = (Set)collection;
        for (File file : previouslyGeneratedFiles) {
            if (generatedFilesPath.contains(file.getAbsolutePath()) || this.failOnTeamCity("File delete `" + file.getAbsolutePath() + '`')) continue;
            System.out.println((Object)("Deleted: " + file.getAbsolutePath()));
            file.delete();
        }
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean writeFileIfContentChanged(@NotNull File file, @NotNull String newText, boolean logNotChanged) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        return GeneratorsFileUtil.writeFileIfContentChanged$default(file, newText, logNotChanged, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean writeFileIfContentChanged(@NotNull File file, @NotNull String newText) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        return GeneratorsFileUtil.writeFileIfContentChanged$default(file, newText, false, false, 12, null);
    }

    private static final String failOnTeamCity$escapeForTC(String $this$failOnTeamCity_u24escapeForTC) {
        StringBuilder stringBuilder;
        StringBuilder $this$failOnTeamCity_u24escapeForTC_u24lambda_u240 = stringBuilder = new StringBuilder($this$failOnTeamCity_u24escapeForTC.length());
        boolean bl = false;
        int n = $this$failOnTeamCity_u24escapeForTC.length();
        for (int i = 0; i < n; ++i) {
            Object object;
            char c = $this$failOnTeamCity_u24escapeForTC.charAt(i);
            switch (c) {
                case '|': {
                    object = "||";
                    break;
                }
                case '\'': {
                    object = "|'";
                    break;
                }
                case '\n': {
                    object = "|n";
                    break;
                }
                case '\r': {
                    object = "|r";
                    break;
                }
                case '[': {
                    object = "|[";
                    break;
                }
                case ']': {
                    object = "|]";
                    break;
                }
                default: {
                    object = Character.valueOf(c);
                }
            }
            $this$failOnTeamCity_u24escapeForTC_u24lambda_u240.append(object);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean collectPreviouslyGeneratedFiles$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isFile()) return false;
        String it2 = FilesKt.readText$default((File)it, null, (int)1, null);
        boolean bl = false;
        if (!StringsKt.contains$default((CharSequence)it2, (CharSequence)GENERATED_MESSAGE_PREFIX, (boolean)false, (int)2, null)) return false;
        if (!StringsKt.contains$default((CharSequence)it2, (CharSequence)GENERATED_MESSAGE_SUFFIX, (boolean)false, (int)2, null)) return false;
        return true;
    }
}

