/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.services.JUnit5Assertions;
import org.jetbrains.kotlin.test.utils.BackendWithDirectives;
import org.jetbrains.kotlin.test.utils.LocalVariableRecord;
import org.jetbrains.kotlin.test.utils.SteppingTestLoggedData;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a8\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e*\u00020\u0001H\u0002\u001a\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u001a?\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u001e\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"normalizeIndyLambdas", "", "EXPECTATIONS_MARKER", "FORCE_STEP_INTO_MARKER", "DIRECTIVE_MARKER", "checkSteppingTestResult", "", "frontendKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "wholeFile", "Ljava/io/File;", "loggedItems", "", "Lorg/jetbrains/kotlin/test/utils/SteppingTestLoggedData;", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "getDeclaredDirectives", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "compressSequencesWithoutLineNumber", "formatAsSteppingTestExpectation", "sourceName", "lineNumber", "", "functionName", "isSynthetic", "", "visibleVars", "Lorg/jetbrains/kotlin/test/utils/LocalVariableRecord;", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;ZLjava/util/List;)Ljava/lang/String;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nSteppingTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteppingTestUtils.kt\norg/jetbrains/kotlin/test/utils/SteppingTestUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ModuleStructureExtractorImpl.kt\norg/jetbrains/kotlin/test/services/impl/ModuleStructureExtractorImplKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,232:1\n774#2:233\n865#2,2:234\n1563#2:236\n1634#2,3:237\n1761#2,3:247\n1617#2,9:252\n1869#2:261\n1870#2:263\n1626#2:264\n426#3,6:240\n1#4:246\n1#4:262\n32#5,2:250\n*S KotlinDebug\n*F\n+ 1 SteppingTestUtils.kt\norg/jetbrains/kotlin/test/utils/SteppingTestUtilsKt\n*L\n104#1:233\n104#1:234,2\n108#1:236\n108#1:237,3\n162#1:247,3\n183#1:252,9\n183#1:261\n183#1:263\n183#1:264\n136#1:240,6\n183#1:262\n174#1:250,2\n*E\n"})
public final class SteppingTestUtilsKt {
    @NotNull
    private static final String EXPECTATIONS_MARKER = "// EXPECTATIONS";
    @NotNull
    private static final String FORCE_STEP_INTO_MARKER = "// FORCE_STEP_INTO";
    @NotNull
    private static final String DIRECTIVE_MARKER = "+";

    private static final String normalizeIndyLambdas(String $this$normalizeIndyLambdas) {
        CharSequence charSequence = $this$normalizeIndyLambdas;
        Regex regex = new Regex("\\$Lambda\\$.*");
        String string = "<lambda>";
        return regex.replace(charSequence, string);
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkSteppingTestResult(@NotNull FrontendKind<?> frontendKind, @NotNull TargetBackend targetBackend, @NotNull File wholeFile, @NotNull List<SteppingTestLoggedData> loggedItems, @NotNull RegisteredDirectives directives) {
        ListIterator lineIterator;
        ListIterator $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object line2;
        Intrinsics.checkNotNullParameter(frontendKind, (String)"frontendKind");
        Intrinsics.checkNotNullParameter((Object)((Object)targetBackend), (String)"targetBackend");
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(loggedItems, (String)"loggedItems");
        Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
        List actual = new ArrayList();
        List lines2 = FilesKt.readLines$default((File)wholeFile, null, (int)1, null);
        Set directivesInTestFile = new LinkedHashSet();
        boolean forceStepInto = false;
        for (Object line2 : lines2) {
            if (StringsKt.contains$default((CharSequence)((CharSequence)line2), (CharSequence)DIRECTIVE_MARKER, (boolean)false, (int)2, null)) {
                directivesInTestFile.addAll((Collection)SteppingTestUtilsKt.getDeclaredDirectives((String)line2));
            }
            if (!StringsKt.startsWith$default((String)line2, (String)FORCE_STEP_INTO_MARKER, (boolean)false, (int)2, null)) continue;
            forceStepInto = true;
        }
        line2 = SteppingTestUtilsKt.compressSequencesWithoutLineNumber(loggedItems);
        boolean $i$f$filter = false;
        void var12_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SteppingTestLoggedData)element$iv$iv;
            boolean bl = false;
            if (!(forceStepInto || !((SteppingTestLoggedData)it).isSynthetic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (SteppingTestLoggedData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add("// " + ((SteppingTestLoggedData)it).getExpectation());
        }
        List actualLineNumbers = (List)destination$iv$iv;
        Iterator actualLineNumbersIterator = actualLineNumbers.iterator();
        $this$mapTo$iv$iv = lineIterator = lines2.listIterator();
        while (((Iterator)$this$mapTo$iv$iv).hasNext()) {
            String line3 = (String)$this$mapTo$iv$iv.next();
            if (StringsKt.startsWith$default((String)line3, (String)EXPECTATIONS_MARKER, (boolean)false, (int)2, null)) {
                if (!lineIterator.hasPrevious()) break;
                lineIterator.previous();
                break;
            }
            actual.add(line3);
            if (!StringsKt.startsWith$default((String)line3, (String)FORCE_STEP_INTO_MARKER, (boolean)false, (int)2, null)) continue;
        }
        Object currentBackends = CollectionsKt.listOf((Object)new BackendWithDirectives(TargetBackend.ANY));
        Object currentFrontends = CollectionsKt.listOf(frontendKind);
        ListIterator $i$f$mapTo22 = lineIterator;
        while (((Iterator)$i$f$mapTo22).hasNext()) {
            boolean containsBackend;
            String line4;
            block22: {
                boolean bl;
                line4 = (String)$i$f$mapTo22.next();
                if (((CharSequence)line4).length() == 0) {
                    actual.add(line4);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line4, (String)EXPECTATIONS_MARKER, (boolean)false, (int)2, null)) {
                    Object option2;
                    actual.add(line4);
                    it = StringsKt.removePrefix((String)line4, (CharSequence)EXPECTATIONS_MARKER);
                    Regex bl2 = new Regex("\\s+");
                    int n = 0;
                    Sequence options = SequencesKt.filter((Sequence)bl2.splitToSequence((CharSequence)it, n), SteppingTestUtilsKt::checkSteppingTestResult$lambda$2);
                    List backends = new ArrayList();
                    List frontends = new ArrayList();
                    Object currentBackendWithDirectives = null;
                    for (Object option2 : options) {
                        TargetBackend backend;
                        block21: {
                            TargetBackend targetBackend2;
                            boolean $i$f$valueOfOrNull = false;
                            for (TargetBackend enumValue$iv : TargetBackend.values()) {
                                if (!Intrinsics.areEqual((Object)enumValue$iv.name(), (Object)option2)) continue;
                                targetBackend2 = enumValue$iv;
                                break block21;
                            }
                            targetBackend2 = backend = null;
                        }
                        if (backend != null) {
                            BackendWithDirectives backendWithDirectives = new BackendWithDirectives(backend);
                            currentBackendWithDirectives = backendWithDirectives;
                            ((Collection)backends).add(backendWithDirectives);
                            continue;
                        }
                        FrontendKind<?> frontend2 = FrontendKinds.INSTANCE.fromString((String)option2);
                        if (frontend2 != null) {
                            ((Collection)frontends).add(frontend2);
                            continue;
                        }
                        Directive directive = LanguageSettingsDirectives.INSTANCE.get(StringsKt.substringAfter$default((String)option2, (String)DIRECTIVE_MARKER, null, (int)2, null));
                        if (directive == null || currentBackendWithDirectives == null) continue;
                        ((BackendWithDirectives)currentBackendWithDirectives).addDirectiveIfConsidered(directive);
                    }
                    Object it2 = option2 = backends;
                    boolean bl3 = false;
                    Object object = !((Collection)it2).isEmpty() ? option2 : null;
                    if (object == null) {
                        object = CollectionsKt.listOf((Object)new BackendWithDirectives(TargetBackend.ANY));
                    }
                    currentBackends = object;
                    it2 = option2 = frontends;
                    boolean bl4 = false;
                    Object object2 = !((Collection)it2).isEmpty() ? option2 : null;
                    if (object2 == null) {
                        object2 = CollectionsKt.listOf(frontendKind);
                    }
                    currentFrontends = object2;
                    continue;
                }
                Iterable $this$any$iv = (Iterable)currentBackends;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BackendWithDirectives it3 = (BackendWithDirectives)element$iv;
                        boolean bl5 = false;
                        if (!(it3.getBackend() == TargetBackend.ANY || it3.getBackend() == targetBackend && it3.contains(directives, directivesInTestFile))) continue;
                        bl = true;
                        break block22;
                    }
                    bl = containsBackend = false;
                }
            }
            if (containsBackend && currentFrontends.contains(frontendKind)) {
                if (!actualLineNumbersIterator.hasNext()) continue;
                actual.add(actualLineNumbersIterator.next());
                continue;
            }
            actual.add(line4);
        }
        Iterator $this$forEach$iv = actualLineNumbersIterator;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            String it4 = (String)element$iv;
            boolean bl = false;
            actual.add(it4);
        }
        if (!StringsKt.isBlank((CharSequence)((CharSequence)CollectionsKt.last((List)actual)))) {
            actual.add("");
        }
        Assertions.assertEqualsToFile$default((Assertions)JUnit5Assertions.INSTANCE, wholeFile, CollectionsKt.joinToString$default((Iterable)actual, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Directive> getDeclaredDirectives(String $this$getDeclaredDirectives) {
        void $this$mapNotNullTo$iv$iv;
        CharSequence charSequence = $this$getDeclaredDirectives;
        Regex regex = new Regex("\\s+");
        int n = 0;
        Iterable $this$mapNotNull$iv = regex.split(charSequence, n);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Directive it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (LanguageSettingsDirectives.INSTANCE.get(StringsKt.substringAfter$default((String)it, (String)DIRECTIVE_MARKER, null, (int)2, null)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List<SteppingTestLoggedData> compressSequencesWithoutLineNumber(List<SteppingTestLoggedData> loggedItems) {
        if (loggedItems.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterator<SteppingTestLoggedData> logIterator = loggedItems.iterator();
        SteppingTestLoggedData currentItem = logIterator.next();
        Object object = new SteppingTestLoggedData[]{currentItem};
        List result = CollectionsKt.mutableListOf((Object[])object);
        object = logIterator;
        while (object.hasNext()) {
            SteppingTestLoggedData logItem = (SteppingTestLoggedData)object.next();
            if (currentItem.getLine() == -1 && Intrinsics.areEqual((Object)currentItem.getExpectation(), (Object)logItem.getExpectation())) continue;
            result.add(logItem);
            currentItem = logItem;
        }
        return result;
    }

    @NotNull
    public static final String formatAsSteppingTestExpectation(@NotNull String sourceName, @Nullable Integer lineNumber, @NotNull String functionName, boolean isSynthetic, @Nullable List<LocalVariableRecord> visibleVars) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
        StringBuilder $this$formatAsSteppingTestExpectation_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$formatAsSteppingTestExpectation_u24lambda_u248.append(sourceName);
        $this$formatAsSteppingTestExpectation_u24lambda_u248.append(':');
        StringBuilder stringBuilder2 = lineNumber != null ? $this$formatAsSteppingTestExpectation_u24lambda_u248.append(lineNumber) : $this$formatAsSteppingTestExpectation_u24lambda_u248.append("...");
        $this$formatAsSteppingTestExpectation_u24lambda_u248.append(' ');
        $this$formatAsSteppingTestExpectation_u24lambda_u248.append(functionName);
        if (isSynthetic) {
            $this$formatAsSteppingTestExpectation_u24lambda_u248.append(" (synthetic)");
        }
        if (visibleVars != null) {
            $this$formatAsSteppingTestExpectation_u24lambda_u248.append(": ");
            CollectionsKt.joinTo$default((Iterable)visibleVars, (Appendable)$this$formatAsSteppingTestExpectation_u24lambda_u248, null, null, null, (int)0, null, null, (int)126, null);
        }
        return ((Object)StringsKt.trim((CharSequence)stringBuilder.toString())).toString();
    }

    public static /* synthetic */ String formatAsSteppingTestExpectation$default(String string, Integer n, String string2, boolean bl, List list, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            list = null;
        }
        return SteppingTestUtilsKt.formatAsSteppingTestExpectation(string, n, string2, bl, list);
    }

    private static final boolean checkSteppingTestResult$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }

    public static final /* synthetic */ String access$normalizeIndyLambdas(String $receiver) {
        return SteppingTestUtilsKt.normalizeIndyLambdas($receiver);
    }
}

