/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.RootDiagnosticRendererFactory;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.util.Multimap;
import org.jetbrains.kotlin.test.backend.handlers.NoFirCompilationErrorsHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputPartForDependsOnModule;
import org.jetbrains.kotlin.test.frontend.fir.handlers.DiagnosticWithKmpCompilationMode;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticCollectorService;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticsHandlerKt;
import org.jetbrains.kotlin.test.frontend.fir.handlers.KmpCompilationMode;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0005H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/NoFirCompilationErrorsHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "failureDisablesNextSteps", "", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Z)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "additionalServices", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "seenModules", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "processModule", "", "module", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "processAfterAllModules", "someAssertionWasFailed", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nNoFirCompilationErrorsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoFirCompilationErrorsHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/NoFirCompilationErrorsHandler\n+ 2 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n*L\n1#1,76:1\n25#2:77\n*S KotlinDebug\n*F\n+ 1 NoFirCompilationErrorsHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/NoFirCompilationErrorsHandler\n*L\n34#1:77\n*E\n"})
public final class NoFirCompilationErrorsHandler
extends FirAnalysisHandler {
    @NotNull
    private final Set<TestModule> seenModules;

    public NoFirCompilationErrorsHandler(@NotNull TestServices testServices, boolean failureDisablesNextSteps) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, failureDisablesNextSteps, false, 4, null);
        this.seenModules = new LinkedHashSet();
    }

    public /* synthetic */ NoFirCompilationErrorsHandler(TestServices testServices, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(testServices, bl);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(FirDiagnosticCollectorService.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        for (FirOutputPartForDependsOnModule part : info.getPartsForDependsOnModules()) {
            this.seenModules.add(part.getModule());
            boolean ignoreErrors = part.getModule().getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_FIR_DIAGNOSTICS());
            Multimap<FirFile, DiagnosticWithKmpCompilationMode, List<DiagnosticWithKmpCompilationMode>> diagnosticsPerFile = FirDiagnosticsHandlerKt.getFirDiagnosticCollectorService(this.getTestServices()).getFrontendDiagnosticsForModule(info);
            for (Map.Entry entry : diagnosticsPerFile) {
                FirFile firFile = (FirFile)entry.getKey();
                List diagnostics = (List)entry.getValue();
                for (DiagnosticWithKmpCompilationMode diagnosticWithKmpCompilationMode : diagnostics) {
                    Object object;
                    String diagnosticText;
                    KtDiagnostic diagnostic;
                    block6: {
                        TextRange range;
                        block5: {
                            diagnostic = diagnosticWithKmpCompilationMode.component1();
                            KmpCompilationMode mode = diagnosticWithKmpCompilationMode.component2();
                            if (mode == KmpCompilationMode.METADATA || diagnostic.getSeverity() != Severity.ERROR || ignoreErrors) continue;
                            diagnosticText = RootDiagnosticRendererFactory.INSTANCE.invoke(diagnostic).render(diagnostic);
                            range = (TextRange)CollectionsKt.first((List)diagnostic.getTextRanges());
                            object = firFile.getSource();
                            if (object == null || (object = KtSourceElementKt.getPsi((AbstractKtSourceElement)((AbstractKtSourceElement)object))) == null || (object = object.getContainingFile()) == null) break block5;
                            KtSourceElement psiFile = object;
                            boolean bl = false;
                            String string = PsiDiagnosticUtils.atLocation((PsiFile)psiFile, (TextRange)range);
                            object = string;
                            if (string != null) break block6;
                        }
                        object = firFile.getName() + ':' + range;
                    }
                    Object locationText = object;
                    throw new IllegalStateException((diagnostic.getFactory().getName() + ": " + diagnosticText + " at " + (String)locationText).toString());
                }
            }
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        boolean ignoreErrors = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_FIR_DIAGNOSTICS());
        boolean hasError = FirDiagnosticsHandlerKt.getFirDiagnosticCollectorService(this.getTestServices()).getContainsErrorDiagnostics();
        if (!hasError && ignoreErrors) {
            this.getAssertions().fail((Function0<String>)((Function0)NoFirCompilationErrorsHandler::processAfterAllModules$lambda$1));
            throw new KotlinNothingValueException();
        }
    }

    private static final String processAfterAllModules$lambda$1() {
        return "Test contains " + CodegenTestDirectives.INSTANCE.getIGNORE_FIR_DIAGNOSTICS() + " directive but no errors was reported. Please remove directive";
    }
}

