/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.forTestCompile;

import java.io.File;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public class ForTestCompileRuntime {
    private static volatile SoftReference<ClassLoader> reflectJarClassLoader = new SoftReference<Object>(null);
    private static volatile SoftReference<ClassLoader> runtimeJarClassLoader = new SoftReference<Object>(null);

    @NotNull
    public static File runtimeJarForTests() {
        File file = ForTestCompileRuntime.propertyOrDist("kotlin.full.stdlib.path", "dist/kotlinc/lib/kotlin-stdlib.jar");
        if (file == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(0);
        }
        return file;
    }

    @NotNull
    public static File runtimeJarForTestsWithJdk8() {
        File file = ForTestCompileRuntime.propertyOrDist("kotlin.full.stdlib.path", "dist/kotlinc/lib/kotlin-stdlib-jdk8.jar");
        if (file == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(1);
        }
        return file;
    }

    @NotNull
    public static File minimalRuntimeJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlin-stdlib-jvm-minimal-for-test.jar"));
    }

    @NotNull
    public static File kotlinTestJarForTests() {
        File file = ForTestCompileRuntime.propertyOrDist("kotlin.test.jar.path", "dist/kotlinc/lib/kotlin-test.jar");
        if (file == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    public static File reflectJarForTests() {
        File file = ForTestCompileRuntime.propertyOrDist("kotlin.reflect.jar.path", "dist/kotlinc/lib/kotlin-reflect.jar");
        if (file == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    public static File scriptRuntimeJarForTests() {
        File file = ForTestCompileRuntime.propertyOrDist("kotlin.script.runtime.path", "dist/kotlinc/lib/kotlin-script-runtime.jar");
        if (file == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public static File runtimeSourcesJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-stdlib-sources.jar"));
    }

    @NotNull
    public static File stdlibCommonForTests() {
        File file = ForTestCompileRuntime.propertyOrDist("kotlin.common.stdlib.path", "dist/common/kotlin-stdlib-common.klib");
        if (file == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static File propertyOrDist(String property, String distPath) {
        String path = System.getProperty(property, distPath);
        File file = new File(path);
        assert (file.exists()) : path + " doesn't exist";
        return file;
    }

    @NotNull
    public static File jvmAnnotationsForTests() {
        File file = ForTestCompileRuntime.propertyOrDist("kotlin.annotations.path", "dist/kotlinc/lib/kotlin-annotations-jvm.jar");
        if (file == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    private static File assertExists(@NotNull File file) {
        if (file == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(7);
        }
        if (!file.exists()) {
            throw new IllegalStateException(file + " does not exist. Run 'gradlew dist'");
        }
        File file2 = file;
        if (file2 == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(8);
        }
        return file2;
    }

    @NotNull
    public static synchronized ClassLoader runtimeAndReflectJarClassLoader() {
        ClassLoader loader = reflectJarClassLoader.get();
        if (loader == null) {
            loader = ForTestCompileRuntime.createClassLoader(ForTestCompileRuntime.runtimeJarForTests(), ForTestCompileRuntime.reflectJarForTests(), ForTestCompileRuntime.scriptRuntimeJarForTests(), ForTestCompileRuntime.kotlinTestJarForTests());
            reflectJarClassLoader = new SoftReference<ClassLoader>(loader);
        }
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(9);
        }
        return classLoader;
    }

    @NotNull
    public static synchronized ClassLoader runtimeJarClassLoader() {
        ClassLoader loader = runtimeJarClassLoader.get();
        if (loader == null) {
            loader = ForTestCompileRuntime.createClassLoader(ForTestCompileRuntime.runtimeJarForTests(), ForTestCompileRuntime.scriptRuntimeJarForTests(), ForTestCompileRuntime.kotlinTestJarForTests());
            runtimeJarClassLoader = new SoftReference<ClassLoader>(loader);
        }
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(10);
        }
        return classLoader;
    }

    @NotNull
    private static ClassLoader createClassLoader(File ... files) {
        if (files == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(11);
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(2);
            for (File file : files) {
                urls.add(file.toURI().toURL());
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/forTestCompile/ForTestCompileRuntime";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeJarForTests";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeJarForTestsWithJdk8";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlinTestJarForTests";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "reflectJarForTests";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "scriptRuntimeJarForTests";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "stdlibCommonForTests";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "jvmAnnotationsForTests";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/forTestCompile/ForTestCompileRuntime";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "assertExists";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeAndReflectJarClassLoader";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeJarClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertExists";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createClassLoader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

