/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.jvm;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.test.model.ArtifactKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.ArtifactsProviderKt;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/services/jvm/CompiledClassesManager;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "outputDirCache", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Ljava/io/File;", "specifiedFrontendKind", "Lorg/jetbrains/kotlin/test/model/FrontendKind;", "getSpecifiedFrontendKind", "()Lorg/jetbrains/kotlin/test/model/FrontendKind;", "setSpecifiedFrontendKind", "(Lorg/jetbrains/kotlin/test/model/FrontendKind;)V", "compileKotlinToDiskAndGetOutputDir", "module", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "getOutputDirForModule", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nCompiledClassesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompiledClassesManager.kt\norg/jetbrains/kotlin/test/services/jvm/CompiledClassesManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,52:1\n384#2,7:53\n*S KotlinDebug\n*F\n+ 1 CompiledClassesManager.kt\norg/jetbrains/kotlin/test/services/jvm/CompiledClassesManager\n*L\n24#1:53,7\n*E\n"})
public final class CompiledClassesManager
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<TestModule, File> outputDirCache;
    @NotNull
    private FrontendKind<?> specifiedFrontendKind;

    public CompiledClassesManager(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.outputDirCache = new LinkedHashMap();
        this.specifiedFrontendKind = FrontendKind.NoFrontend.INSTANCE;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @NotNull
    public final FrontendKind<?> getSpecifiedFrontendKind() {
        return this.specifiedFrontendKind;
    }

    public final void setSpecifiedFrontendKind(@NotNull FrontendKind<?> frontendKind) {
        Intrinsics.checkNotNullParameter(frontendKind, (String)"<set-?>");
        this.specifiedFrontendKind = frontendKind;
    }

    @NotNull
    public final File compileKotlinToDiskAndGetOutputDir(@NotNull TestModule module, @Nullable ClassFileFactory classFileFactory) {
        File file;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map<TestModule, File> $this$getOrPut$iv = this.outputDirCache;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(module);
        if (value$iv == null) {
            boolean bl = false;
            File outputDir = TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this.testServices, "module_" + module.getName() + "_classes");
            ClassFileFactory classFileFactory2 = classFileFactory;
            if (classFileFactory2 == null) {
                if (Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.testServices).getArtifactKind(), (Object)ArtifactKinds.JvmFromK1AndK2.INSTANCE)) {
                    if (!(Intrinsics.areEqual(this.specifiedFrontendKind, (Object)FrontendKinds.FIR.INSTANCE) || Intrinsics.areEqual(this.specifiedFrontendKind, (Object)FrontendKinds.ClassicFrontend.INSTANCE))) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    BinaryArtifacts.JvmFromK1AndK2 k1AndK2Artifact = (BinaryArtifacts.JvmFromK1AndK2)ArtifactsProviderKt.getArtifactsProvider(this.testServices).getArtifact(module, ArtifactKinds.JvmFromK1AndK2.INSTANCE);
                    classFileFactory2 = Intrinsics.areEqual(this.specifiedFrontendKind, (Object)FrontendKinds.FIR.INSTANCE) ? k1AndK2Artifact.getFromK2().getClassFileFactory() : k1AndK2Artifact.getFromK1().getClassFileFactory();
                } else {
                    classFileFactory2 = ((BinaryArtifacts.Jvm)ArtifactsProviderKt.getArtifactsProvider(this.testServices).getArtifact(module, ArtifactKinds.Jvm.INSTANCE)).getClassFileFactory();
                }
            }
            ClassFileFactory classFileFactory3 = classFileFactory2;
            List list = classFileFactory3.getCurrentOutput();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCurrentOutput(...)");
            SimpleOutputFileCollection outputFileCollection = new SimpleOutputFileCollection(list);
            Object object = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.testServices).getCompilerConfiguration(module).getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getNotNull(...)");
            MessageCollector messageCollector = (MessageCollector)object;
            OutputUtilsKt.writeAll((OutputFileCollection)((OutputFileCollection)outputFileCollection), (File)outputDir, (MessageCollector)messageCollector, (boolean)false);
            File answer$iv = outputDir;
            $this$getOrPut$iv.put(module, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    @Nullable
    public final File getOutputDirForModule(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.outputDirCache.get(module);
    }
}

