/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.SourceRangeInfo;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.util.RenderIrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.backend.handlers.IrSourceRangesDumpHandler;
import org.jetbrains.kotlin.test.backend.handlers.IrTextDumpHandler;
import org.jetbrains.kotlin.test.backend.handlers.SimpleFirIrIdenticalChecker;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.BackendKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 ,2\u00020\u0001:\u0003,-.B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0006H\u0016J\u0014\u0010\u001f\u001a\u00020 *\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020 H\u0002J\u0012\u0010*\u001a\u00020 2\b\b\u0002\u0010+\u001a\u00020&H\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR0\u0010\u000e\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u00110\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\u0018j\u0002`\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrSourceRangesDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "artifactKind", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/BackendKind;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "additionalAfterAnalysisCheckers", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "Lorg/jetbrains/kotlin/test/Constructor;", "getAdditionalAfterAnalysisCheckers", "baseDumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "buildersForSeparateFileDumps", "", "Ljava/io/File;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "dumpWithSourceLocations", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "fileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "processAfterAllModules", "someAssertionWasFailed", "", "checkOneExpectedFile", "expectedFile", "actualDump", "getDumpExtension", "ignoreFirIdentical", "Companion", "IdenticalChecker", "DumpSourceLocations", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrSourceRangesDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrSourceRangesDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrSourceRangesDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1869#2,2:136\n*S KotlinDebug\n*F\n+ 1 IrSourceRangesDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrSourceRangesDumpHandler\n*L\n120#1:136,2\n*E\n"})
public final class IrSourceRangesDumpHandler
extends AbstractIrHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumper baseDumper;
    @NotNull
    private final Map<File, StringBuilder> buildersForSeparateFileDumps;
    @NotNull
    public static final String DUMP_EXTENSION = "txt";

    public IrSourceRangesDumpHandler(@NotNull TestServices testServices, @NotNull BackendKind<IrBackendInput> artifactKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        super(testServices, artifactKind, false, false, 12, null);
        this.baseDumper = new MultiModuleInfoDumper(null, 1, null);
        this.buildersForSeparateFileDumps = new LinkedHashMap();
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        Object[] objectArray = new SimpleDirectivesContainer[]{CodegenTestDirectives.INSTANCE, FirDiagnosticsDirectives.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Function1<TestServices, AfterAnalysisChecker>> getAdditionalAfterAnalysisCheckers() {
        return CollectionsKt.listOf((Object)((Object)additionalAfterAnalysisCheckers.1.INSTANCE));
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_SOURCE_RANGES_IR())) {
            return;
        }
        StringBuilder builder = this.baseDumper.builderForModule(module.getName());
        for (IrFile irFile : info.getIrModuleFragment().getFiles()) {
            builder.append(this.dumpWithSourceLocations((IrElement)irFile, irFile.getFileEntry()));
        }
    }

    private final String dumpWithSourceLocations(IrElement $this$dumpWithSourceLocations, IrFileEntry fileEntry) {
        StringBuilder stringBuilder;
        StringBuilder it = stringBuilder = new StringBuilder();
        boolean bl = false;
        IrVisitorsKt.acceptVoid((IrElement)$this$dumpWithSourceLocations, (IrVisitorVoid)new DumpSourceLocations(it, fileEntry));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.getTestServices());
        File defaultExpectedFile = FileUtilsKt.withExtension((File)CollectionsKt.first(moduleStructure.getOriginalTestDataFiles()), IrSourceRangesDumpHandler.getDumpExtension$default(this, false, 1, null));
        this.checkOneExpectedFile(defaultExpectedFile, this.baseDumper.generateResultingDump());
        Iterable $this$forEach$iv = this.buildersForSeparateFileDumps.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            File expectedFile = (File)entry.getKey();
            StringBuilder dump = (StringBuilder)entry.getValue();
            String string = dump.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.checkOneExpectedFile(expectedFile, string);
        }
    }

    private final void checkOneExpectedFile(File expectedFile, String actualDump) {
        if (((CharSequence)actualDump).length() > 0) {
            Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualDump, null, 4, null);
        } else {
            HandlerUtilsKt.assertFileDoesntExist(this.getAssertions(), expectedFile, CodegenTestDirectives.INSTANCE.getDUMP_SOURCE_RANGES_IR());
        }
    }

    private final String getDumpExtension(boolean ignoreFirIdentical) {
        return IrTextDumpHandler.Companion.computeDumpExtension(this.getTestServices(), DUMP_EXTENSION, ignoreFirIdentical);
    }

    static /* synthetic */ String getDumpExtension$default(IrSourceRangesDumpHandler irSourceRangesDumpHandler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return irSourceRangesDumpHandler.getDumpExtension(bl);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrSourceRangesDumpHandler$Companion;", "", "<init>", "()V", "DUMP_EXTENSION", "", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrSourceRangesDumpHandler$DumpSourceLocations;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "fileEntry", "Lorg/jetbrains/kotlin/ir/IrFileEntry;", "<init>", "(Ljava/lang/Appendable;Lorg/jetbrains/kotlin/ir/IrFileEntry;)V", "getFileEntry", "()Lorg/jetbrains/kotlin/ir/IrFileEntry;", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "getPrinter", "()Lorg/jetbrains/kotlin/utils/Printer;", "elementRenderer", "Lorg/jetbrains/kotlin/ir/util/RenderIrElementVisitor;", "getElementRenderer", "()Lorg/jetbrains/kotlin/ir/util/RenderIrElementVisitor;", "printElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitElement", "render", "", "Lorg/jetbrains/kotlin/ir/SourceRangeInfo;", "tests-common-new_test"})
    private static final class DumpSourceLocations
    extends IrVisitorVoid {
        @NotNull
        private final IrFileEntry fileEntry;
        @NotNull
        private final Printer printer;
        @NotNull
        private final RenderIrElementVisitor elementRenderer;

        public DumpSourceLocations(@NotNull Appendable out, @NotNull IrFileEntry fileEntry) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)fileEntry, (String)"fileEntry");
            this.fileEntry = fileEntry;
            this.printer = new Printer(out, "  ");
            this.elementRenderer = new RenderIrElementVisitor(null, 1, null);
        }

        @NotNull
        public final IrFileEntry getFileEntry() {
            return this.fileEntry;
        }

        @NotNull
        public final Printer getPrinter() {
            return this.printer;
        }

        @NotNull
        public final RenderIrElementVisitor getElementRenderer() {
            return this.elementRenderer;
        }

        private final void printElement(IrElement element) {
            SourceRangeInfo sourceRangeInfo = this.fileEntry.getSourceRangeInfo(element.getStartOffset(), element.getEndOffset());
            if (element.getStartOffset() < 0) {
                sourceRangeInfo = SourceRangeInfo.copy$default((SourceRangeInfo)sourceRangeInfo, null, (int)0, (int)-1, (int)-1, (int)0, (int)0, (int)0, (int)115, null);
            }
            if (element.getEndOffset() < 0) {
                sourceRangeInfo = SourceRangeInfo.copy$default((SourceRangeInfo)sourceRangeInfo, null, (int)0, (int)0, (int)0, (int)0, (int)-1, (int)-1, (int)31, null);
            }
            Object[] objectArray = new Object[]{'@' + this.render(sourceRangeInfo) + ' ' + (String)element.accept((IrElementVisitor)this.elementRenderer, null)};
            this.printer.println(objectArray);
        }

        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.printElement(element);
            this.printer.pushIndent();
            if (element instanceof IrAnnotationContainer && !((Collection)((IrAnnotationContainer)element).getAnnotations()).isEmpty()) {
                Object[] objectArray = new Object[]{"annotations:"};
                this.printer.println(objectArray);
                this.printer.pushIndent();
                for (IrConstructorCall annotation : ((IrAnnotationContainer)element).getAnnotations()) {
                    this.printElement((IrElement)annotation);
                    this.printer.pushIndent();
                    IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)annotation), (IrVisitorVoid)this);
                    this.printer.popIndent();
                }
                this.printer.popIndent();
            }
            IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrVisitorVoid)this);
            this.printer.popIndent();
        }

        private final String render(SourceRangeInfo $this$render) {
            return $this$render.getStartLineNumber() == $this$render.getEndLineNumber() ? "" + $this$render.getStartLineNumber() + ':' + $this$render.getStartColumnNumber() + ".." + $this$render.getEndColumnNumber() : "" + $this$render.getStartLineNumber() + ':' + $this$render.getStartColumnNumber() + ".." + $this$render.getEndLineNumber() + ':' + $this$render.getEndColumnNumber();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrSourceRangesDumpHandler$IdenticalChecker;", "Lorg/jetbrains/kotlin/test/backend/handlers/SimpleFirIrIdenticalChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "dumpExtension", "", "getDumpExtension", "()Ljava/lang/String;", "shouldRun", "", "tests-common-new_test"})
    public static final class IdenticalChecker
    extends SimpleFirIrIdenticalChecker {
        public IdenticalChecker(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            super(testServices, false, 2, null);
        }

        @Override
        @NotNull
        protected String getDumpExtension() {
            return IrSourceRangesDumpHandler.DUMP_EXTENSION;
        }

        @Override
        protected boolean shouldRun() {
            return TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_SOURCE_RANGES_IR());
        }
    }
}

