/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import kotlin.ExceptionsKt;
import kotlin.Pair;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.test.KtAssert;

public class D8Checker {
    public static final boolean RUN_D8_CHECKER = Boolean.valueOf(System.getProperty("kotlin.test.box.d8.disable")) == false;

    private D8Checker() {
    }

    public static void check(ClassFileFactory outputFiles) {
        if (!RUN_D8_CHECKER) {
            return;
        }
        D8Checker.runD8(builder -> D8Checker.addOutputFiles(builder, outputFiles));
    }

    private static void addOutputFiles(D8Command.Builder builder, ClassFileFactory outputFiles) {
        for (OutputFile file : ClassFileUtilsKt.getClassFiles((ClassFileFactory)outputFiles)) {
            byte[] bytes = file.asByteArray();
            builder.addClassProgramData(bytes, (Origin)new PathOrigin(Paths.get(file.getRelativePath(), new String[0])));
        }
    }

    public static void checkFilesWithD8(Collection<Pair<byte[], String>> classFiles) {
        if (!RUN_D8_CHECKER) {
            return;
        }
        D8Checker.runD8(builder -> classFiles.forEach(pair -> {
            D8Command.Builder cfr_ignored_0 = (D8Command.Builder)builder.addClassProgramData((byte[])pair.getFirst(), (Origin)new PathOrigin(Paths.get((String)pair.getSecond(), new String[0])));
        }));
    }

    private static void runD8(Consumer<D8Command.Builder> addInput) {
        DexIndexedConsumer.ForwardingConsumer ignoreOutputConsumer = new DexIndexedConsumer.ForwardingConsumer(null);
        D8Command.Builder builder = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder((DiagnosticsHandler)new TestDiagnosticsHandler()).setMinApiLevel(30)).setMode(CompilationMode.DEBUG)).setProgramConsumer((ProgramConsumer)ignoreOutputConsumer);
        addInput.accept(builder);
        try {
            D8.run((D8Command)((D8Command)builder.build()), (ExecutorService)Executors.newSingleThreadExecutor());
        }
        catch (CompilationFailedException e) {
            KtAssert.fail(D8Checker.generateExceptionMessage(e));
        }
    }

    private static String generateExceptionMessage(Throwable e) {
        StringWriter writer = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(writer);){
            e.printStackTrace(printWriter);
            String string = writer.toString();
            return string;
        }
    }

    static class TestDiagnosticsHandler
    implements DiagnosticsHandler {
        TestDiagnosticsHandler() {
        }

        private static String renderDiagnostic(Diagnostic diagnostic) {
            Throwable cause;
            StringBuilder sb = new StringBuilder();
            sb.append(diagnostic.getDiagnosticMessage());
            Throwable throwable = cause = diagnostic instanceof ExceptionDiagnostic ? ((ExceptionDiagnostic)diagnostic).getCause() : null;
            if (cause != null) {
                sb.append("\n");
                sb.append(ExceptionsKt.stackTraceToString((Throwable)cause));
            }
            return sb.toString();
        }

        public void error(Diagnostic diagnostic) {
            KtAssert.fail("D8 dexing error: " + TestDiagnosticsHandler.renderDiagnostic(diagnostic));
        }

        public void warning(Diagnostic diagnostic) {
            KtAssert.fail("D8 dexing warning: " + TestDiagnosticsHandler.renderDiagnostic(diagnostic));
        }

        public void info(Diagnostic diagnostic) {
            KtAssert.fail("D8 dexing info: " + TestDiagnosticsHandler.renderDiagnostic(diagnostic));
        }
    }
}

