/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProvider;
import org.jetbrains.kotlin.test.services.ModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.TestModuleStructure;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/runners/DuplicateFileNameChecker;", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "<init>", "()V", "transformModuleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "moduleStructure", "defaultsProvider", "Lorg/jetbrains/kotlin/test/services/DefaultsProvider;", "tests-common-new_test"})
public final class DuplicateFileNameChecker
extends ModuleStructureTransformer {
    @NotNull
    public static final DuplicateFileNameChecker INSTANCE = new DuplicateFileNameChecker();

    private DuplicateFileNameChecker() {
    }

    @Override
    @NotNull
    public TestModuleStructure transformModuleStructure(@NotNull TestModuleStructure moduleStructure, @NotNull DefaultsProvider defaultsProvider) {
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)defaultsProvider, (String)"defaultsProvider");
        Set files = new LinkedHashSet();
        for (TestModule module : moduleStructure.getModules()) {
            for (TestFile file : module.getFiles()) {
                if (files.add(file.getName())) continue;
                throw new IllegalStateException("Duplicate file name: " + file.getName());
            }
        }
        return moduleStructure;
    }
}

