/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.model.AnalysisHandler;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.opentest4j.AssertionFailedError;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B:\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012#\u0010\u0005\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR.\u0010\u0005\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/HandlerExceptionInverter;", "A", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "delegate", "throwException", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/test/model/TestModule;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lorg/jetbrains/kotlin/test/model/AnalysisHandler;Lkotlin/jvm/functions/Function2;)V", "getDelegate", "()Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "getThrowException", "()Lkotlin/jvm/functions/Function2;", "artifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getArtifactKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "processModule", "", "module", "info", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact;)V", "processAfterAllModules", "someAssertionWasFailed", "", "tests-common-new_test"})
public final class HandlerExceptionInverter<A extends ResultingArtifact<A>>
extends AnalysisHandler<A> {
    @NotNull
    private final AnalysisHandler<A> delegate;
    @NotNull
    private final Function2 throwException;

    public HandlerExceptionInverter(@NotNull AnalysisHandler<A> delegate, @NotNull Function2 throwException) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)throwException, (String)"throwException");
        super(delegate.getTestServices(), delegate.getFailureDisablesNextSteps(), delegate.getDoNotRunIfThereWerePreviousFailures());
        this.delegate = delegate;
        this.throwException = throwException;
    }

    @NotNull
    public final AnalysisHandler<A> getDelegate() {
        return this.delegate;
    }

    @NotNull
    public final Function2 getThrowException() {
        return this.throwException;
    }

    @Override
    @NotNull
    public TestArtifactKind<A> getArtifactKind() {
        return this.delegate.getArtifactKind();
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull A info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(info, (String)"info");
        try {
            this.delegate.processModule(module, info);
        }
        catch (Exception e) {
            return;
        }
        catch (AssertionFailedError e) {
            return;
        }
        this.throwException.invoke((Object)this, (Object)module);
        throw new KotlinNothingValueException();
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

