/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.AdditionalFilesDirectives;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.JvmEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicFrontendAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.util.DescriptorValidator;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorComparator;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J:\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/DeclarationsDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicFrontendAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "shouldNewInferenceBeDumped", "", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "getShouldNewInferenceBeDumped", "(Lorg/jetbrains/kotlin/test/services/TestModuleStructure;)Z", "shouldJavacDescriptorsBeDumped", "getShouldJavacDescriptorsBeDumped", "processAfterAllModules", "", "someAssertionWasFailed", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendOutputArtifact;", "createdAffectedPackagesConfiguration", "Lorg/jetbrains/kotlin/test/util/RecursiveDescriptorComparator$Configuration;", "testFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "checkTypeEnabled", "getJavaFilePackage", "Lorg/jetbrains/kotlin/name/Name;", "testFile", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nDeclarationsDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationsDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/classic/handlers/DeclarationsDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,148:1\n1755#2,3:149\n1863#2,2:152\n1619#2:154\n1863#2:155\n1864#2:157\n1620#2:158\n1557#2:166\n1628#2,3:167\n1#3:156\n1#3:165\n434#4:159\n507#4,5:160\n*S KotlinDebug\n*F\n+ 1 DeclarationsDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/classic/handlers/DeclarationsDumpHandler\n*L\n55#1:149,3\n83#1:152,2\n107#1:154\n107#1:155\n107#1:157\n107#1:158\n47#1:166\n47#1:167,3\n107#1:156\n141#1:159\n141#1:160,5\n*E\n"})
public final class DeclarationsDumpHandler
extends ClassicFrontendAnalysisHandler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final MultiModuleInfoDumper dumper;
    @NotNull
    private static final List<Name> NAMES_OF_CHECK_TYPE_HELPER;
    private static final Pattern JAVA_PACKAGE_PATTERN;

    public DeclarationsDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumper("// -- Module: <%s> --");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getShouldNewInferenceBeDumped(TestModuleStructure $this$shouldNewInferenceBeDumped) {
        TestModule it;
        if (!$this$shouldNewInferenceBeDumped.getAllDirectives().contains(DiagnosticsDirectives.INSTANCE.getNI_EXPECTED_FILE())) return false;
        Iterable $this$any$iv = $this$shouldNewInferenceBeDumped.getModules();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (TestModule)element$iv;
            boolean bl = false;
        } while (!it.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference));
        return true;
    }

    private final boolean getShouldJavacDescriptorsBeDumped(TestModuleStructure $this$shouldJavacDescriptorsBeDumped) {
        return $this$shouldJavacDescriptorsBeDumped.getAllDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getJAVAC_EXPECTED_FILE()) && $this$shouldJavacDescriptorsBeDumped.getAllDirectives().contains(JvmEnvironmentConfigurationDirectives.INSTANCE.getUSE_JAVAC());
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.dumper.isEmpty()) {
            return;
        }
        String resultDump = this.dumper.generateResultingDump();
        File testDataFile = (File)kotlin.collections.CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        String prefix = this.getShouldNewInferenceBeDumped(TestModuleStructureKt.getModuleStructure(this.getTestServices())) ? ".ni" : (this.getShouldJavacDescriptorsBeDumped(TestModuleStructureKt.getModuleStructure(this.getTestServices())) ? ".javac" : "");
        String expectedFileName = FilesKt.getNameWithoutExtension((File)testDataFile) + prefix + ".txt";
        File file = testDataFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        File expectedFile = FilesKt.resolve((File)file, (String)expectedFileName);
        if (!expectedFile.exists()) {
            return;
        }
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, resultDump, null, 4, null);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull ClassicFrontendOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (module.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getSKIP_TXT())) {
            return;
        }
        ModuleDescriptor moduleDescriptor = info.getAnalysisResult().getModuleDescriptor();
        boolean checkTypeEnabled = module.getDirectives().contains(AdditionalFilesDirectives.INSTANCE.getCHECK_TYPE());
        RecursiveDescriptorComparator comparator = new RecursiveDescriptorComparator(this.createdAffectedPackagesConfiguration(module.getFiles(), info.getKtFiles(), moduleDescriptor, checkTypeEnabled));
        List list = kotlin.collections.CollectionsKt.createListBuilder();
        List $this$processModule_u24lambda_u242 = list;
        boolean bl = false;
        Iterable $this$forEach$iv = module.getDirectives().get(DiagnosticsDirectives.INSTANCE.getRENDER_PACKAGE());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$processModule_u24lambda_u242.add(new FqName(it));
        }
        $this$processModule_u24lambda_u242.add(FqName.ROOT);
        List packages = kotlin.collections.CollectionsKt.build((List)list);
        Map textByPackage = CollectionsKt.keysToMap((Iterable)packages, DeclarationsDumpHandler::processModule$lambda$3);
        for (Map.Entry entry : textByPackage.entrySet()) {
            FqName packageName = (FqName)entry.getKey();
            StringBuilder packageText = (StringBuilder)entry.getValue();
            PackageViewDescriptor aPackage = moduleDescriptor.getPackage(packageName);
            Assertions.assertFalse$default(this.getAssertions(), aPackage.isEmpty(), null, 2, null);
            String actualSerialized = comparator.serializeRecursively((DeclarationDescriptor)aPackage);
            packageText.append(actualSerialized);
        }
        String allPackagesText = kotlin.collections.CollectionsKt.joinToString$default((Iterable)textByPackage.values(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        this.dumper.builderForModule(module).append(allPackagesText).append('\n');
    }

    /*
     * WARNING - void declaration
     */
    private final RecursiveDescriptorComparator.Configuration createdAffectedPackagesConfiguration(List<TestFile> testFiles, Map<TestFile, ? extends KtFile> ktFiles, ModuleDescriptor moduleDescriptor, boolean checkTypeEnabled) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Iterable iterable = testFiles;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            TestFile it = (TestFile)element$iv;
            boolean bl2 = false;
            KtFile ktFile = ktFiles.get(it);
            KtFile ktFile2 = ktFile;
            if (ktFile2 != null) {
                object = (Name)kotlin.collections.CollectionsKt.firstOrNull((List)ktFile2.getPackageFqName().pathSegments());
                if (object == null) {
                    object = SpecialNames.ROOT_PACKAGE;
                }
            } else {
                object = SourceFileProviderKt.isJavaFile(it) ? this.getJavaFilePackage(it) : null;
            }
            if (object == null) continue;
            Name it$iv = object;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set packagesNames = (Set)destination$iv;
        Predicate<DeclarationDescriptor> stepIntoFilter = arg_0 -> DeclarationsDumpHandler.createdAffectedPackagesConfiguration$lambda$5(moduleDescriptor, packagesNames, checkTypeEnabled, arg_0);
        RecursiveDescriptorComparator.Configuration configuration2 = RecursiveDescriptorComparator.RECURSIVE.filterRecursion(stepIntoFilter).withValidationStrategy(DescriptorValidator.ValidationVisitor.errorTypesAllowed()).checkFunctionContracts(true);
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"checkFunctionContracts(...)");
        return configuration2;
    }

    /*
     * WARNING - void declaration
     */
    private final Name getJavaFilePackage(TestFile testFile) {
        Matcher matcher = JAVA_PACKAGE_PATTERN.matcher(testFile.getOriginalContent());
        if (matcher.find()) {
            void $this$filterTo$iv$iv;
            String string = testFile.getOriginalContent().substring(matcher.start(), matcher.end());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] stringArray = new String[]{" "};
            String $this$filter$iv = (String)kotlin.collections.CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String it = ((StringBuilder)destination$iv$iv).toString();
            boolean bl = false;
            String[] stringArray2 = new String[]{"."};
            Name name = Name.identifier((String)((String)kotlin.collections.CollectionsKt.first((List)StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null))));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"let(...)");
            return name;
        }
        return SpecialNames.ROOT_PACKAGE;
    }

    private static final StringBuilder processModule$lambda$3(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new StringBuilder();
    }

    private static final boolean createdAffectedPackagesConfiguration$lambda$5(ModuleDescriptor $moduleDescriptor, Set $packagesNames, boolean $checkTypeEnabled, DeclarationDescriptor descriptor) {
        ModuleDescriptor module = DescriptorUtils.getContainingModuleOrNull((DeclarationDescriptor)descriptor);
        if (!Intrinsics.areEqual((Object)module, (Object)$moduleDescriptor)) {
            return false;
        }
        if (descriptor instanceof PackageViewDescriptor) {
            FqName fqName = ((PackageViewDescriptor)descriptor).getFqName();
            return fqName.isRoot() || $packagesNames.contains(kotlin.collections.CollectionsKt.first((List)fqName.pathSegments()));
        }
        return !$checkTypeEnabled || !NAMES_OF_CHECK_TYPE_HELPER.contains(descriptor.getName());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{"checkSubtype", "CheckTypeInv", "_", "checkType"};
        Iterable $this$map$iv = kotlin.collections.CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Name.identifier((String)it));
        }
        NAMES_OF_CHECK_TYPE_HELPER = (List)var3_3;
        JAVA_PACKAGE_PATTERN = Pattern.compile("^\\s*package [.\\w\\d]*", 8);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/DeclarationsDumpHandler$Companion;", "", "<init>", "()V", "NAMES_OF_CHECK_TYPE_HELPER", "", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/jvm/internal/EnhancedNullability;", "JAVA_PACKAGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

