/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.handlers.EvaluatorHandler;
import org.jetbrains.kotlin.test.backend.handlers.IrInterpreterBackendHandlerKt;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\bH\u0016J.\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003*\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrInterpreterDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/EvaluatorHandler;", "processIrModule", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "", "Lorg/jetbrains/kotlin/codeMetaInfo/model/ParsedCodeMetaInfo;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "isSuppressedForK2", "", "processFile", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "testFile", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nInterpreterDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterpreterDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrInterpreterDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,285:1\n1279#2,2:286\n1293#2,4:288\n1755#2,3:293\n216#3:292\n217#3:303\n381#4,7:296\n*S KotlinDebug\n*F\n+ 1 InterpreterDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrInterpreterDumpHandler\n*L\n70#1:286,2\n70#1:288,4\n98#1:293,3\n94#1:292\n94#1:303\n108#1:296,7\n*E\n"})
public interface IrInterpreterDumpHandler
extends EvaluatorHandler {
    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Map<TestFile, List<ParsedCodeMetaInfo>> processIrModule(@NotNull TestModule module) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!this.isSuppressedForK2(module) && Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultFrontend(), (Object)FrontendKinds.ClassicFrontend.INSTANCE)) {
            Iterable $this$associateWith$iv = module.getFiles();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void testFile;
                TestFile testFile2 = (TestFile)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                List<ParsedCodeMetaInfo> list = this.getExpectedResult((TestFile)testFile);
                map2.put(t, list);
            }
            return result$iv;
        }
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module);
        EvaluatedConstTracker evaluatedConstTracker = (EvaluatedConstTracker)configuration2.get(CommonConfigurationKeys.EVALUATED_CONST_TRACKER);
        if (evaluatedConstTracker == null) {
            throw new IllegalStateException("Couldn't find `EVALUATED_CONST_TRACKER` for IR interpreter dump handler".toString());
        }
        EvaluatedConstTracker evaluatedConstTracker2 = evaluatedConstTracker;
        IrModuleFragment irModule = ((IrBackendInput)DependencyProviderKt.getDependencyProvider(this.getTestServices()).getArtifact(module, BackendKinds.IrBackend.INSTANCE)).getIrModuleFragment();
        Map $this$processIrModule_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Pair<IrFile, TestFile> pair : IrInterpreterBackendHandlerKt.matchIrFileWithTestFile(irModule, module)) {
            IrFile irFile = (IrFile)pair.component1();
            TestFile testFile = (TestFile)pair.component2();
            $this$processIrModule_u24lambda_u241.putAll(this.processFile(evaluatedConstTracker2, testFile, irFile));
        }
        return MapsKt.build((Map)map);
    }

    default public boolean isSuppressedForK2(@NotNull TestModule $this$isSuppressedForK2) {
        TargetBackend targetBackend;
        Intrinsics.checkNotNullParameter((Object)$this$isSuppressedForK2, (String)"<this>");
        List<TargetBackend> ignoredBackends = $this$isSuppressedForK2.getDirectives().get(CodegenTestDirectives.INSTANCE.getIGNORE_BACKEND_K2());
        TargetBackend targetBackend2 = DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getDefaultTargetBackend();
        if (targetBackend2 == null) {
            targetBackend2 = $this$isSuppressedForK2.getTargetBackend();
        }
        return CollectionsKt.contains((Iterable)ignoredBackends, (Object)((Object)(targetBackend = targetBackend2))) || ignoredBackends.contains((Object)TargetBackend.ANY);
    }

    private Map<TestFile, List<ParsedCodeMetaInfo>> processFile(EvaluatedConstTracker $this$processFile, TestFile testFile, IrFile irFile) {
        Map resultMap;
        block7: {
            resultMap = new LinkedHashMap();
            List<Pair<Integer, Integer>> rangesThatAreNotSupposedToBeRendered = this.extractRangesWithoutRender(testFile);
            Map map = $this$processFile.load(IrDeclarationsKt.getNameWithPackage((IrFile)irFile));
            if (map == null) break block7;
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                boolean bl;
                int end;
                int start;
                ConstantValue constantValue;
                block6: {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Pair pair = (Pair)entry.getKey();
                    constantValue = (ConstantValue)entry.getValue();
                    if (constantValue instanceof AnnotationValue) continue;
                    start = ((Number)pair.component1()).intValue();
                    end = ((Number)pair.component2()).intValue();
                    Iterable $this$any$iv = rangesThatAreNotSupposedToBeRendered;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            Pair it = (Pair)element$iv2;
                            boolean bl3 = false;
                            if (!(start >= ((Number)it.getFirst()).intValue() && start <= ((Number)it.getSecond()).intValue())) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                String message = constantValue.stringTemplateValue();
                ParsedCodeMetaInfo metaInfo = new ParsedCodeMetaInfo(start, end, new ArrayList(), constantValue instanceof ErrorValue ? "WAS_NOT_EVALUATED" : "EVALUATED", StringUtil.escapeLineBreak((String)message));
                Map $this$getOrPut$iv = resultMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(testFile);
                if (value$iv == null) {
                    boolean bl4 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(testFile, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(metaInfo);
            }
        }
        return resultMap;
    }
}

