/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators.model;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.generators.model.AnnotationModel;
import org.jetbrains.kotlin.generators.model.MethodModel;
import org.jetbrains.kotlin.generators.model.RunTestMethodModel;
import org.jetbrains.kotlin.generators.model.TestClassModel;
import org.jetbrains.kotlin.generators.model.TransformingTestMethodModel;
import org.jetbrains.kotlin.generators.util.MethodModelLocatorKt;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\"\u0018\u00002\u00020\u0001:\u000278B\u008b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0011\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u00100\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010#R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R!\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b)\u0010*R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R\u0014\u00101\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010'R\u0014\u00105\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010'\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel;", "Lorg/jetbrains/kotlin/generators/model/TestClassModel;", "rootFile", "Ljava/io/File;", "filenamePattern", "Ljava/util/regex/Pattern;", "excludePattern", "checkFilenameStartsLowerCase", "", "doTestMethodName", "", "testClassName", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "skipIgnored", "testRunnerMethodName", "additionalRunnerArguments", "", "annotations", "Lorg/jetbrains/kotlin/generators/model/AnnotationModel;", "tags", "additionalMethods", "", "Lorg/jetbrains/kotlin/generators/model/MethodModel;", "<init>", "(Ljava/io/File;Ljava/util/regex/Pattern;Ljava/util/regex/Pattern;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/test/TargetBackend;ZLjava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Collection;)V", "getRootFile", "()Ljava/io/File;", "getFilenamePattern", "()Ljava/util/regex/Pattern;", "getExcludePattern", "Ljava/lang/Boolean;", "getTargetBackend", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "getAnnotations", "()Ljava/util/List;", "getTags", "name", "getName", "()Ljava/lang/String;", "methods", "getMethods", "()Ljava/util/Collection;", "methods$delegate", "Lkotlin/Lazy;", "innerTestClasses", "getInnerTestClasses", "getTestMethodsFromFile", "file", "isEmpty", "()Z", "dataString", "getDataString", "dataPathRoot", "getDataPathRoot", "AllFilesPresentedMethodKind", "TestAllFilesPresentMethodModel", "test-generator_test"})
@SourceDebugExtension(value={"SMAP\nSingleClassTestModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleClassTestModel.kt\norg/jetbrains/kotlin/generators/model/SingleClassTestModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1755#2,3:88\n*S KotlinDebug\n*F\n+ 1 SingleClassTestModel.kt\norg/jetbrains/kotlin/generators/model/SingleClassTestModel\n*L\n43#1:88,3\n*E\n"})
public final class SingleClassTestModel
extends TestClassModel {
    @NotNull
    private final File rootFile;
    @NotNull
    private final Pattern filenamePattern;
    @Nullable
    private final Pattern excludePattern;
    @Nullable
    private final Boolean checkFilenameStartsLowerCase;
    @NotNull
    private final String doTestMethodName;
    @NotNull
    private final String testClassName;
    @NotNull
    private final TargetBackend targetBackend;
    private final boolean skipIgnored;
    @NotNull
    private final String testRunnerMethodName;
    @NotNull
    private final List<String> additionalRunnerArguments;
    @NotNull
    private final List<AnnotationModel> annotations;
    @NotNull
    private final List<String> tags;
    @NotNull
    private final Collection<MethodModel> additionalMethods;
    @NotNull
    private final Lazy methods$delegate;
    @NotNull
    private final String dataString;
    @NotNull
    private final String dataPathRoot;

    public SingleClassTestModel(@NotNull File rootFile, @NotNull Pattern filenamePattern, @Nullable Pattern excludePattern, @Nullable Boolean checkFilenameStartsLowerCase, @NotNull String doTestMethodName, @NotNull String testClassName, @NotNull TargetBackend targetBackend, boolean skipIgnored, @NotNull String testRunnerMethodName, @NotNull List<String> additionalRunnerArguments, @NotNull List<AnnotationModel> annotations, @NotNull List<String> tags, @NotNull Collection<? extends MethodModel> additionalMethods) {
        Intrinsics.checkNotNullParameter((Object)rootFile, (String)"rootFile");
        Intrinsics.checkNotNullParameter((Object)filenamePattern, (String)"filenamePattern");
        Intrinsics.checkNotNullParameter((Object)doTestMethodName, (String)"doTestMethodName");
        Intrinsics.checkNotNullParameter((Object)testClassName, (String)"testClassName");
        Intrinsics.checkNotNullParameter((Object)((Object)targetBackend), (String)"targetBackend");
        Intrinsics.checkNotNullParameter((Object)testRunnerMethodName, (String)"testRunnerMethodName");
        Intrinsics.checkNotNullParameter(additionalRunnerArguments, (String)"additionalRunnerArguments");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Intrinsics.checkNotNullParameter(additionalMethods, (String)"additionalMethods");
        this.rootFile = rootFile;
        this.filenamePattern = filenamePattern;
        this.excludePattern = excludePattern;
        this.checkFilenameStartsLowerCase = checkFilenameStartsLowerCase;
        this.doTestMethodName = doTestMethodName;
        this.testClassName = testClassName;
        this.targetBackend = targetBackend;
        this.skipIgnored = skipIgnored;
        this.testRunnerMethodName = testRunnerMethodName;
        this.additionalRunnerArguments = additionalRunnerArguments;
        this.annotations = annotations;
        this.tags = tags;
        this.additionalMethods = additionalMethods;
        this.methods$delegate = LazyKt.lazy(() -> SingleClassTestModel.methods_delegate$lambda$5(this));
        String string = KtTestUtil.getFilePath(this.rootFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilePath(...)");
        this.dataString = string;
        this.dataPathRoot = "$PROJECT_ROOT";
    }

    @NotNull
    public final File getRootFile() {
        return this.rootFile;
    }

    @NotNull
    public final Pattern getFilenamePattern() {
        return this.filenamePattern;
    }

    @Nullable
    public final Pattern getExcludePattern() {
        return this.excludePattern;
    }

    @NotNull
    public final TargetBackend getTargetBackend() {
        return this.targetBackend;
    }

    @NotNull
    public List<AnnotationModel> getAnnotations() {
        return this.annotations;
    }

    @Override
    @NotNull
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @NotNull
    public String getName() {
        return this.testClassName;
    }

    @Override
    @NotNull
    public Collection<MethodModel> getMethods() {
        Lazy lazy = this.methods$delegate;
        return (Collection)lazy.getValue();
    }

    @Override
    @NotNull
    public Collection<TestClassModel> getInnerTestClasses() {
        return CollectionsKt.emptyList();
    }

    private final Collection<MethodModel> getTestMethodsFromFile(File file) {
        return MethodModelLocatorKt.methodModelLocator(this.rootFile, file, this.filenamePattern, this.checkFilenameStartsLowerCase, this.targetBackend, this.skipIgnored, CollectionsKt.emptyList());
    }

    @Override
    public boolean isEmpty() {
        return this.getMethods().size() <= 1;
    }

    @Override
    @NotNull
    public String getDataString() {
        return this.dataString;
    }

    @Override
    @NotNull
    public String getDataPathRoot() {
        return this.dataPathRoot;
    }

    private static final boolean methods_delegate$lambda$5$lambda$0(SingleClassTestModel this$0, List $result, File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isDirectory() && this$0.filenamePattern.matcher(file.getName()).matches()) {
            $result.addAll(this$0.getTestMethodsFromFile(file));
        }
        return true;
    }

    private static final boolean methods_delegate$lambda$5$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final int methods_delegate$lambda$5$lambda$3(MethodModel o1, MethodModel o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return StringsKt.compareTo((String)o1.getName(), (String)o2.getName(), (boolean)true);
    }

    private static final int methods_delegate$lambda$5$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final List methods_delegate$lambda$5(SingleClassTestModel this$0) {
        boolean bl;
        List result;
        block4: {
            result = new ArrayList();
            result.add(new RunTestMethodModel(this$0.targetBackend, this$0.doTestMethodName, this$0.testRunnerMethodName, this$0.additionalRunnerArguments, false, 16, null));
            result.add(this$0.new TestAllFilesPresentMethodModel());
            result.addAll(this$0.additionalMethods);
            FileUtil.processFilesRecursively((File)this$0.rootFile, arg_0 -> SingleClassTestModel.methods_delegate$lambda$5$lambda$1(arg_0 -> SingleClassTestModel.methods_delegate$lambda$5$lambda$0(this$0, result, arg_0), arg_0));
            Iterable $this$any$iv = result;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MethodModel it = (MethodModel)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof TransformingTestMethodModel && ((TransformingTestMethodModel)it).shouldBeGenerated())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            RunTestMethodModel additionalRunner = new RunTestMethodModel(this$0.targetBackend, this$0.doTestMethodName, this$0.testRunnerMethodName, this$0.additionalRunnerArguments, true);
            result.add(additionalRunner);
        }
        return CollectionsKt.sortedWith((Iterable)result, (arg_0, arg_1) -> SingleClassTestModel.methods_delegate$lambda$5$lambda$4(SingleClassTestModel::methods_delegate$lambda$5$lambda$3, arg_0, arg_1));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel$AllFilesPresentedMethodKind;", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "<init>", "()V", "test-generator_test"})
    public static final class AllFilesPresentedMethodKind
    extends MethodModel.Kind {
        @NotNull
        public static final AllFilesPresentedMethodKind INSTANCE = new AllFilesPresentedMethodKind();

        private AllFilesPresentedMethodKind() {
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel$TestAllFilesPresentMethodModel;", "Lorg/jetbrains/kotlin/generators/model/MethodModel;", "<init>", "(Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel;)V", "name", "", "getName", "()Ljava/lang/String;", "dataString", "getDataString", "classModel", "Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel;", "getClassModel", "()Lorg/jetbrains/kotlin/generators/model/SingleClassTestModel;", "kind", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "getKind", "()Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "shouldBeGenerated", "", "tags", "", "getTags", "()Ljava/util/List;", "test-generator_test"})
    public final class TestAllFilesPresentMethodModel
    implements MethodModel {
        @NotNull
        private final String name;

        public TestAllFilesPresentMethodModel() {
            this.name = "testAllFilesPresentIn" + SingleClassTestModel.this.testClassName;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getDataString() {
            return null;
        }

        @NotNull
        public final SingleClassTestModel getClassModel() {
            return SingleClassTestModel.this;
        }

        @Override
        @NotNull
        public MethodModel.Kind getKind() {
            return AllFilesPresentedMethodKind.INSTANCE;
        }

        @Override
        public boolean shouldBeGenerated() {
            return true;
        }

        @Override
        @NotNull
        public List<String> getTags() {
            return CollectionsKt.emptyList();
        }
    }
}

