/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import com.intellij.rt.execution.junit.FileComparisonData;
import java.io.File;
import junit.framework.ComparisonFailure;

public class FileComparisonFailure
extends ComparisonFailure
implements FileComparisonData {
    private final String myExpected;
    private final String myActual;
    private final String myFilePath;
    private final String myActualFilePath;

    public FileComparisonFailure(String message, String expected, String actual, String expectedFilePath) {
        this(message, expected, actual, expectedFilePath, null);
    }

    public FileComparisonFailure(String message, String expected, String actual, String expectedFilePath, String actualFilePath) {
        super(message, expected, actual);
        if (expected == null) {
            throw new NullPointerException("'expected' must not be null");
        }
        if (actual == null) {
            throw new NullPointerException("'actual' must not be null");
        }
        this.myExpected = expected;
        this.myActual = actual;
        this.myFilePath = expectedFilePath;
        if (expectedFilePath != null && !new File(expectedFilePath).isFile()) {
            throw new NullPointerException("'expectedFilePath' should point to the existing file or be null");
        }
        this.myActualFilePath = actualFilePath;
    }

    @Override
    public String getFilePath() {
        return this.myFilePath;
    }

    @Override
    public String getActualFilePath() {
        return this.myActualFilePath;
    }

    @Override
    public String getExpected() {
        return this.myExpected;
    }

    @Override
    public String getActual() {
        return this.myActual;
    }

    @Override
    public String getActualStringPresentation() {
        return this.myActual;
    }

    @Override
    public String getExpectedStringPresentation() {
        return this.myExpected;
    }
}

