/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrVerifier;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeOptions;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.handlers.IrTextDumpHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.BackendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrTreeVerifierHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "artifactKind", "Lorg/jetbrains/kotlin/test/model/BackendKind;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/BackendKind;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "processAfterAllModules", "someAssertionWasFailed", "", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrTreeVerifierHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTreeVerifierHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTreeVerifierHandler\n+ 2 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 3 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,50:1\n22#2,16:51\n38#2:68\n24#3:67\n*S KotlinDebug\n*F\n+ 1 IrTreeVerifierHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/IrTreeVerifierHandler\n*L\n42#1:51,16\n42#1:68\n42#1:67\n*E\n"})
public final class IrTreeVerifierHandler
extends AbstractIrHandler {
    public IrTreeVerifierHandler(@NotNull TestServices testServices, @NotNull BackendKind<IrBackendInput> artifactKind) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(artifactKind, (String)"artifactKind");
        super(testServices, artifactKind, false, false, 12, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR())) {
            return;
        }
        List irFiles = info.getIrModuleFragment().getFiles();
        List<Pair<TestFile, IrFile>> testFileToIrFile = IrTextDumpHandler.Companion.groupWithTestFiles(irFiles, module);
        for (Pair<TestFile, IrFile> pair : testFileToIrFile) {
            TestFile testFile = (TestFile)pair.component1();
            IrFile irFile = (IrFile)pair.component2();
            Object object = testFile;
            if (object != null && (object = ((TestFile)object).getDirectives()) != null ? ((RegisteredDirectives)object).contains(CodegenTestDirectives.INSTANCE.getEXTERNAL_FILE()) : false) continue;
            new IrVerifier(this.getAssertions(), Intrinsics.areEqual(module.getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE)).verifyWithAssert(irFile);
            String actualDump = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)0, (DumpIrTreeOptions)new DumpIrTreeOptions(true, false, false, false, false, false, false, false, false, false, false, null, 4094, null));
            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)irFile;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
            boolean $i$f$deepCopyImpl = false;
            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, (IrElementVisitorVoid)((IrElementVisitorVoid)symbolRemapper$iv$iv));
            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
            boolean bl = false;
            ReferencedSymbolRemapper p0 = (ReferencedSymbolRemapper)deepCopySymbolRemapper;
            TypeRemapper typeRemapper$iv$iv = (TypeRemapper)new DeepCopyTypeRemapper(p0);
            IrElement irElement = $this$deepCopyImpl$iv$iv.transform((IrElementTransformer)new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
            if (irElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            }
            IrFile irFileCopy = (IrFile)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)((IrFile)irElement)), initialParent$iv);
            String dumpOfCopy = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFileCopy, (int)0, (DumpIrTreeOptions)new DumpIrTreeOptions(true, false, false, false, false, false, false, false, false, false, false, null, 4094, null));
            this.getAssertions().assertEquals(actualDump, dumpOfCopy, (Function0<String>)((Function0)IrTreeVerifierHandler::processModule$lambda$0));
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }

    private static final String processModule$lambda$0() {
        return "IR dump mismatch after deep copy with symbols";
    }
}

