/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.TestStep;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.AnalysisHandler;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DependencyProviderImpl;
import org.jetbrains.kotlin.test.services.ExceptionFromModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.MetaTestConfigurator;
import org.jetbrains.kotlin.test.services.PreAnalysisHandler;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.TestServicesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0011J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ+\u0010\u001f\u001a\u00020\u001a2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\b0\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#H\u0082\bJ\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020!0%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0%H\u0002J4\u0010'\u001a\u0006\u0012\u0002\b\u00030(*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030)2\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010,\u001a\u00020\u001aH\u0002JH\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030(\"\u000e\b\u0000\u0010-*\b\u0012\u0004\u0012\u0002H-0+*\f\u0012\u0004\u0012\u0002H-\u0012\u0002\b\u00030)2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0+2\u0006\u0010,\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/test/TestRunner;", "", "testConfiguration", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "<init>", "(Lorg/jetbrains/kotlin/test/TestConfiguration;)V", "allFailedExceptions", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "allRanHandlers", "", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "runTest", "", "testDataFileName", "", "beforeDispose", "Lkotlin/Function1;", "runTestImpl", "runTestPipeline", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "services", "Lorg/jetbrains/kotlin/test/services/TestServices;", "reportFailures", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "dependencyProvider", "Lorg/jetbrains/kotlin/test/services/DependencyProviderImpl;", "withAssertionCatching", "exceptionWrapper", "", "block", "Lkotlin/Function0;", "filterFailedExceptions", "", "failedExceptions", "hackyProcessModule", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "Lorg/jetbrains/kotlin/test/TestStep;", "inputArtifact", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "thereWereExceptionsOnPreviousSteps", "I", "artifact", "Companion", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nTestRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestRunner.kt\norg/jetbrains/kotlin/test/TestRunner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,209:1\n170#1,6:218\n170#1,6:225\n170#1,6:231\n170#1,6:238\n1797#2,3:210\n1863#2,2:213\n1863#2,2:215\n1863#2:217\n1864#2:224\n1863#2:237\n1864#2:244\n1755#2,3:247\n1797#2,3:250\n1557#2:253\n1628#2,3:254\n21#3,2:245\n*S KotlinDebug\n*F\n+ 1 TestRunner.kt\norg/jetbrains/kotlin/test/TestRunner\n*L\n86#1:218,6\n98#1:225,6\n106#1:231,6\n112#1:238,6\n46#1:210,3\n66#1:213,2\n81#1:215,2\n85#1:217\n85#1:224\n111#1:237\n111#1:244\n140#1:247,3\n181#1:250,3\n185#1:253\n185#1:254,3\n122#1:245,2\n*E\n"})
public final class TestRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestConfiguration testConfiguration;
    @NotNull
    private final List<WrappedException> allFailedExceptions;
    @NotNull
    private final Set<AnalysisHandler<?>> allRanHandlers;

    public TestRunner(@NotNull TestConfiguration testConfiguration) {
        Intrinsics.checkNotNullParameter((Object)testConfiguration, (String)"testConfiguration");
        this.testConfiguration = testConfiguration;
        this.allFailedExceptions = new ArrayList();
        this.allRanHandlers = new LinkedHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runTest(@NotNull String testDataFileName, @NotNull Function1<? super TestConfiguration, Unit> beforeDispose) {
        Intrinsics.checkNotNullParameter((Object)testDataFileName, (String)"testDataFileName");
        Intrinsics.checkNotNullParameter(beforeDispose, (String)"beforeDispose");
        try {
            this.runTestImpl(testDataFileName);
        }
        finally {
            try {
                TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(this.testConfiguration.getTestServices()).cleanupTemporaryDirectories();
            }
            catch (IOException e) {
                System.out.println((Object)("Failed to clean temporary directories: " + e.getMessage() + '\n' + e.getStackTrace()));
            }
            beforeDispose.invoke((Object)this.testConfiguration);
            Disposer.dispose((Disposable)this.testConfiguration.getRootDisposable());
        }
    }

    public static /* synthetic */ void runTest$default(TestRunner testRunner, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = TestRunner::runTest$lambda$0;
        }
        testRunner.runTest(string, (Function1<? super TestConfiguration, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final void runTestImpl(String testDataFileName) {
        TestServices services = this.testConfiguration.getTestServices();
        Iterable $this$fold$iv = this.testConfiguration.getMetaTestConfigurators();
        boolean $i$f$fold = false;
        String accumulator$iv = testDataFileName;
        for (Object element$iv : $this$fold$iv) {
            void configurator;
            MetaTestConfigurator metaTestConfigurator = (MetaTestConfigurator)element$iv;
            String fileName = accumulator$iv;
            boolean bl = false;
            accumulator$iv = configurator.transformTestDataPath(fileName);
        }
        String testDataFileName2 = accumulator$iv;
        try {
            TestModuleStructure it = $i$f$fold = this.testConfiguration.getModuleStructureExtractor().splitTestDataByModules(testDataFileName2, this.testConfiguration.getDirectives());
            boolean bl = false;
            services.register((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(TestModuleStructure.class), it);
        }
        catch (ExceptionFromModuleStructureTransformer e) {
            services.register((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(TestModuleStructure.class), e.getAlreadyParsedModuleStructure());
            Throwable throwable = (Throwable)CollectionsKt.singleOrNull(this.filterFailedExceptions(CollectionsKt.listOf((Object)new WrappedException.FromModuleStructureTransformer(e.getCause()))));
            if (throwable == null) {
                return;
            }
            Throwable exception = throwable;
            throw exception;
        }
        TestModuleStructure moduleStructure = $i$f$fold;
        Iterable $this$forEach$iv = this.testConfiguration.getMetaTestConfigurators();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetaTestConfigurator it = (MetaTestConfigurator)element$iv;
            boolean bl = false;
            if (!it.shouldSkipTest()) continue;
            return;
        }
        this.runTestPipeline(moduleStructure, services);
    }

    /*
     * WARNING - void declaration
     */
    public final void runTestPipeline(@NotNull TestModuleStructure moduleStructure, @NotNull TestServices services) {
        TestModule module;
        boolean shouldProcessNextModules;
        Collection collection;
        boolean bl;
        boolean $i$f$withAssertionCatching;
        PreAnalysisHandler preprocessor;
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)((Object)services), (String)"services");
        GlobalMetadataInfoHandler globalMetadataInfoHandler = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.testConfiguration.getTestServices());
        globalMetadataInfoHandler.parseExistingMetadataInfosFromAllSources();
        List<TestModule> modules = moduleStructure.getModules();
        DependencyProviderImpl dependencyProvider = new DependencyProviderImpl(services, modules);
        TestServicesKt.registerDependencyProvider(services, dependencyProvider);
        Object $this$forEach$iv = this.testConfiguration.getPreAnalysisHandlers();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl2 = false;
            preprocessor.preprocessModuleStructure(moduleStructure);
        }
        $this$forEach$iv = this.testConfiguration.getPreAnalysisHandlers();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            preprocessor = (PreAnalysisHandler)element$iv;
            boolean bl3 = false;
            TestRunner this_$iv = this;
            $i$f$withAssertionCatching = false;
            try {
                boolean bl4 = false;
                preprocessor.prepareSealedClassInheritors(moduleStructure);
                bl = false;
            }
            catch (Throwable e$iv) {
                void p0;
                Throwable bl4 = e$iv;
                collection = this_$iv.allFailedExceptions;
                boolean bl5 = false;
                collection.add(new WrappedException.FromPreAnalysisHandler((Throwable)p0));
                bl = true;
            }
        }
        $this$forEach$iv = modules.iterator();
        while ($this$forEach$iv.hasNext() && (shouldProcessNextModules = this.processModule(module = (TestModule)$this$forEach$iv.next(), dependencyProvider))) {
        }
        for (AnalysisHandler<?> handler : this.allRanHandlers) {
            Function1 wrapperFactory = arg_0 -> TestRunner.runTestPipeline$lambda$7(handler, arg_0);
            TestRunner this_$iv = this;
            boolean $i$f$withAssertionCatching2 = false;
            try {
                boolean thereWasAnException;
                boolean bl6 = false;
                boolean bl7 = thereWasAnException = !((Collection)this.allFailedExceptions).isEmpty();
                if (Companion.shouldRun(handler, thereWasAnException)) {
                    handler.processAfterAllModules(thereWasAnException);
                }
                $i$f$withAssertionCatching = false;
            }
            catch (Throwable e$iv) {
                ((Collection)this_$iv.allFailedExceptions).add(wrapperFactory.invoke((Object)e$iv));
                $i$f$withAssertionCatching = true;
            }
        }
        if (this.testConfiguration.getMetaInfoHandlerEnabled()) {
            boolean this_$iv;
            TestRunner this_$iv2 = this;
            boolean $i$f$withAssertionCatching3 = false;
            try {
                boolean bl8 = false;
                globalMetadataInfoHandler.compareAllMetaDataInfos();
                this_$iv = false;
            }
            catch (Throwable e$iv) {
                void p0;
                Throwable $i$f$withAssertionCatching2 = e$iv;
                Collection collection2 = this_$iv2.allFailedExceptions;
                boolean bl9 = false;
                collection2.add(new WrappedException.FromMetaInfoHandler((Throwable)p0));
                this_$iv = true;
            }
        }
        $this$forEach$iv = this.testConfiguration.getAfterAnalysisCheckers();
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv2 = iterator2.next();
            AfterAnalysisChecker it = (AfterAnalysisChecker)element$iv2;
            boolean bl10 = false;
            TestRunner this_$iv = this;
            $i$f$withAssertionCatching = false;
            try {
                boolean bl11 = false;
                it.check(this.allFailedExceptions);
                bl = false;
            }
            catch (Throwable e$iv) {
                void p0;
                Throwable bl11 = e$iv;
                collection = this_$iv.allFailedExceptions;
                boolean bl12 = false;
                collection.add(new WrappedException.FromAfterAnalysisChecker((Throwable)p0));
                bl = true;
            }
        }
        this.reportFailures(services);
    }

    public final void reportFailures(@NotNull TestServices services) {
        Object v0;
        List<Throwable> filteredFailedAssertions;
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)services), (String)"services");
            filteredFailedAssertions = this.filterFailedExceptions(this.allFailedExceptions);
            Iterable $this$firstIsInstanceOrNull$iv = filteredFailedAssertions;
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof WrappedException.FromFacade)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        WrappedException.FromFacade fromFacade = v0;
        if (fromFacade != null) {
            WrappedException.FromFacade it = fromFacade;
            boolean bl = false;
            throw it;
        }
        AssertionsKt.getAssertions(services).failAll(filteredFailedAssertions);
    }

    public final boolean processModule(@NotNull TestModule module, @NotNull DependencyProviderImpl dependencyProvider) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)dependencyProvider, (String)"dependencyProvider");
        ResultingArtifact<Object> inputArtifact = (ResultingArtifact)this.testConfiguration.getStartingArtifactFactory().invoke((Object)module);
        for (TestStep<?, ?> step2 : this.testConfiguration.getSteps()) {
            boolean bl;
            block10: {
                if (!step2.shouldProcessModule(module, inputArtifact)) continue;
                Iterable $this$any$iv = this.allFailedExceptions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        WrappedException it = (WrappedException)element$iv;
                        boolean bl2 = false;
                        if (!it.getFailureDisablesNextSteps()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            boolean thereWereCriticalExceptionsOnPreviousSteps = bl;
            TestStep.StepResult<?> result = this.hackyProcessModule(step2, module, inputArtifact, thereWereCriticalExceptionsOnPreviousSteps);
            if (result instanceof TestStep.StepResult.Artifact) {
                if (!(step2 instanceof TestStep.FacadeStep)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                dependencyProvider.registerArtifact(module, ((TestStep.StepResult.Artifact)result).getOutputArtifact());
                inputArtifact = ((TestStep.StepResult.Artifact)result).getOutputArtifact();
                continue;
            }
            if (result instanceof TestStep.StepResult.ErrorFromFacade) {
                ((Collection)this.allFailedExceptions).add(((TestStep.StepResult.ErrorFromFacade)result).getException());
                return false;
            }
            if (result instanceof TestStep.StepResult.HandlersResult) {
                TestStep.StepResult<?> stepResult = result;
                Collection<WrappedException> exceptionsFromHandlers = ((TestStep.StepResult.HandlersResult)stepResult).component1();
                boolean shouldRunNextSteps = ((TestStep.StepResult.HandlersResult)stepResult).component2();
                if (!(step2 instanceof TestStep.HandlersStep)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                CollectionsKt.addAll((Collection)this.allRanHandlers, (Iterable)((TestStep.HandlersStep)step2).getHandlers());
                CollectionsKt.addAll((Collection)this.allFailedExceptions, (Iterable)exceptionsFromHandlers);
                if (shouldRunNextSteps) continue;
                return false;
            }
            if (result instanceof TestStep.StepResult.NoArtifactFromFacade) {
                return false;
            }
            throw new NoWhenBranchMatchedException();
        }
        return true;
    }

    private final boolean withAssertionCatching(Function1<? super Throwable, ? extends WrappedException> exceptionWrapper, Function0<Unit> block) {
        boolean bl;
        boolean $i$f$withAssertionCatching = false;
        try {
            block.invoke();
            bl = false;
        }
        catch (Throwable e) {
            ((Collection)this.allFailedExceptions).add(exceptionWrapper.invoke((Object)e));
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Throwable> filterFailedExceptions(List<? extends WrappedException> failedExceptions) {
        void $this$mapTo$iv$iv;
        Iterable $this$fold$iv = this.testConfiguration.getAfterAnalysisCheckers();
        boolean $i$f$fold = false;
        Iterable<WrappedException> accumulator$iv = failedExceptions;
        for (Object element$iv : $this$fold$iv) {
            void checker;
            AfterAnalysisChecker afterAnalysisChecker = (AfterAnalysisChecker)element$iv;
            List<? extends WrappedException> assertions = accumulator$iv;
            boolean bl = false;
            accumulator$iv = checker.suppressIfNeeded(assertions);
        }
        Iterable $this$map$iv = CollectionsKt.sorted((Iterable)accumulator$iv);
        boolean $i$f$map = false;
        accumulator$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WrappedException bl = (WrappedException)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getCause());
        }
        return (List)destination$iv$iv;
    }

    private final TestStep.StepResult<?> hackyProcessModule(TestStep<?, ?> $this$hackyProcessModule, TestModule module, ResultingArtifact<?> inputArtifact, boolean thereWereExceptionsOnPreviousSteps) {
        Intrinsics.checkNotNull($this$hackyProcessModule, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.test.TestStep<org.jetbrains.kotlin.test.model.ResultingArtifact.Source, *>");
        Intrinsics.checkNotNull(inputArtifact, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.test.model.ResultingArtifact<org.jetbrains.kotlin.test.model.ResultingArtifact.Source>");
        return this.processModule($this$hackyProcessModule, module, inputArtifact, thereWereExceptionsOnPreviousSteps);
    }

    private final <I extends ResultingArtifact<I>> TestStep.StepResult<?> processModule(TestStep<I, ?> $this$processModule, TestModule module, ResultingArtifact<I> artifact, boolean thereWereExceptionsOnPreviousSteps) {
        Intrinsics.checkNotNull(artifact, (String)"null cannot be cast to non-null type I of org.jetbrains.kotlin.test.TestRunner.processModule");
        return $this$processModule.processModule(module, artifact, thereWereExceptionsOnPreviousSteps);
    }

    private static final Unit runTest$lambda$0(TestConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final WrappedException.FromHandler runTestPipeline$lambda$7(AnalysisHandler $handler, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new WrappedException.FromHandler(it, $handler);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/test/TestRunner$Companion;", "", "<init>", "()V", "shouldRun", "", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "thereWasAnException", "test-infrastructure_test"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldRun(@NotNull AnalysisHandler<?> $this$shouldRun, boolean thereWasAnException) {
            Intrinsics.checkNotNullParameter($this$shouldRun, (String)"<this>");
            return !$this$shouldRun.getDoNotRunIfThereWerePreviousFailures() || !thereWasAnException;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

