/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0014\u0010\u0010R\u001b\u0010\u0016\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0017\u0010\u0010R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000e0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/test/services/SourceFileProviderImpl;", "Lorg/jetbrains/kotlin/test/services/SourceFileProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "preprocessors", "", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/util/List;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "getPreprocessors", "()Ljava/util/List;", "kotlinSourceDirectory", "Ljava/io/File;", "getKotlinSourceDirectory", "()Ljava/io/File;", "kotlinSourceDirectory$delegate", "Lkotlin/Lazy;", "javaSourceDirectory", "getJavaSourceDirectory", "javaSourceDirectory$delegate", "additionalFilesDirectory", "getAdditionalFilesDirectory", "additionalFilesDirectory$delegate", "contentOfFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "", "realFileMap", "getKotlinSourceDirectoryForModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "getJavaSourceDirectoryForModule", "getAdditionalFilesDirectoryForModule", "getContentOfSourceFile", "testFile", "getOrCreateRealFileForSourceFile", "test-infrastructure_test"})
@SourceDebugExtension(value={"SMAP\nSourceFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceFileProvider.kt\norg/jetbrains/kotlin/test/services/SourceFileProviderImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1#2:145\n381#3,3:146\n384#3,4:152\n381#3,3:156\n384#3,4:171\n1797#4,3:149\n626#4,12:159\n*S KotlinDebug\n*F\n+ 1 SourceFileProvider.kt\norg/jetbrains/kotlin/test/services/SourceFileProviderImpl\n*L\n60#1:146,3\n60#1:152,4\n68#1:156,3\n68#1:171,4\n61#1:149,3\n69#1:159,12\n*E\n"})
public final class SourceFileProviderImpl
extends SourceFileProvider {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final List<SourceFilePreprocessor> preprocessors;
    @NotNull
    private final Lazy kotlinSourceDirectory$delegate;
    @NotNull
    private final Lazy javaSourceDirectory$delegate;
    @NotNull
    private final Lazy additionalFilesDirectory$delegate;
    @NotNull
    private final Map<TestFile, String> contentOfFiles;
    @NotNull
    private final Map<TestFile, File> realFileMap;

    public SourceFileProviderImpl(@NotNull TestServices testServices, @NotNull List<? extends SourceFilePreprocessor> preprocessors) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(preprocessors, (String)"preprocessors");
        this.testServices = testServices;
        this.preprocessors = preprocessors;
        this.kotlinSourceDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SourceFileProviderImpl.kotlinSourceDirectory_delegate$lambda$0(this));
        this.javaSourceDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SourceFileProviderImpl.javaSourceDirectory_delegate$lambda$1(this));
        this.additionalFilesDirectory$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SourceFileProviderImpl.additionalFilesDirectory_delegate$lambda$2(this));
        this.contentOfFiles = new LinkedHashMap();
        this.realFileMap = new LinkedHashMap();
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    @Override
    @NotNull
    public List<SourceFilePreprocessor> getPreprocessors() {
        return this.preprocessors;
    }

    private final File getKotlinSourceDirectory() {
        Lazy lazy = this.kotlinSourceDirectory$delegate;
        return (File)lazy.getValue();
    }

    private final File getJavaSourceDirectory() {
        Lazy lazy = this.javaSourceDirectory$delegate;
        return (File)lazy.getValue();
    }

    private final File getAdditionalFilesDirectory() {
        Lazy lazy = this.additionalFilesDirectory$delegate;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public File getKotlinSourceDirectoryForModule(@NotNull TestModule module) {
        File file;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        File $this$getKotlinSourceDirectoryForModule_u24lambda_u243 = file = FilesKt.resolve((File)this.getKotlinSourceDirectory(), (String)module.getName());
        boolean bl = false;
        $this$getKotlinSourceDirectoryForModule_u24lambda_u243.mkdir();
        return file;
    }

    @Override
    @NotNull
    public File getJavaSourceDirectoryForModule(@NotNull TestModule module) {
        File file;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        File $this$getJavaSourceDirectoryForModule_u24lambda_u244 = file = FilesKt.resolve((File)this.getJavaSourceDirectory(), (String)module.getName());
        boolean bl = false;
        $this$getJavaSourceDirectoryForModule_u24lambda_u244.mkdir();
        return file;
    }

    @Override
    @NotNull
    public File getAdditionalFilesDirectoryForModule(@NotNull TestModule module) {
        File file;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        File $this$getAdditionalFilesDirectoryForModule_u24lambda_u245 = file = FilesKt.resolve((File)this.getAdditionalFilesDirectory(), (String)module.getName());
        boolean bl = false;
        $this$getAdditionalFilesDirectoryForModule_u24lambda_u245.mkdir();
        return file;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getContentOfSourceFile(@NotNull TestFile testFile) {
        String string;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, String> $this$getOrPut$iv = this.contentOfFiles;
        boolean $i$f$getOrPut = false;
        String value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            void $this$fold$iv;
            boolean bl = false;
            Iterable iterable = this.getPreprocessors();
            String initial$iv = testFile.getOriginalContent();
            boolean $i$f$fold = false;
            String accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void preprocessor;
                SourceFilePreprocessor sourceFilePreprocessor = (SourceFilePreprocessor)element$iv;
                String content = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = preprocessor.process(testFile, content);
            }
            String answer$iv = accumulator$iv;
            $this$getOrPut$iv.put(testFile, answer$iv);
            string = answer$iv;
        } else {
            string = value$iv;
        }
        return string;
    }

    @Override
    @NotNull
    public File getOrCreateRealFileForSourceFile(@NotNull TestFile testFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Map<TestFile, File> $this$getOrPut$iv = this.realFileMap;
        boolean $i$f$getOrPut = false;
        File value$iv = $this$getOrPut$iv.get(testFile);
        if (value$iv == null) {
            File file2;
            boolean bl = false;
            Iterable $this$single$iv = TestModuleStructureKt.getModuleStructure(this.testServices).getModules();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                TestModule it = (TestModule)element$iv;
                boolean bl2 = false;
                if (!it.getFiles().contains(testFile)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            TestModule module = single$iv;
            File directory = SourceFileProviderKt.isKtFile(testFile) ? this.getKotlinSourceDirectoryForModule(module) : (SourceFileProviderKt.isJavaFile(testFile) ? this.getJavaSourceDirectoryForModule(module) : this.getAdditionalFilesDirectoryForModule(module));
            File it = file2 = FilesKt.resolve((File)directory, (String)testFile.getRelativePath());
            boolean bl3 = false;
            it.getParentFile().mkdirs();
            FilesKt.writeText$default((File)it, (String)this.getContentOfSourceFile(testFile), null, (int)2, null);
            File answer$iv = file2;
            $this$getOrPut$iv.put(testFile, answer$iv);
            file = answer$iv;
        } else {
            file = value$iv;
        }
        return file;
    }

    private static final File kotlinSourceDirectory_delegate$lambda$0(SourceFileProviderImpl this$0) {
        return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this$0.testServices, "kotlin-sources");
    }

    private static final File javaSourceDirectory_delegate$lambda$1(SourceFileProviderImpl this$0) {
        return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this$0.testServices, "java-sources");
    }

    private static final File additionalFilesDirectory_delegate$lambda$2(SourceFileProviderImpl this$0) {
        return TemporaryDirectoryManagerKt.getOrCreateTempDirectory(this$0.testServices, "additional-files");
    }
}

