/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.OccurrenceInfo;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0000\u001a@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a6\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a,\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u00062\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\"2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"AT_OUTPUT_FILE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "EXPECTED_OCCURRENCES_PATTERN", "JVM_IR_TEMPLATES", "", "JVM_IR_TEMPLATES_WITH_INLINE_SCOPES", "readExpectedOccurrences", "", "Lorg/jetbrains/kotlin/test/backend/handlers/OccurrenceInfo;", "lines", "readExpectedOccurrencesForMultiFileTest", "", "fileName", "fileContent", "withGeneratedFile", "", "global", "", "parseOccurrenceInfo", "matcher", "Ljava/util/regex/Matcher;", "inlineScopesNumbersEnabled", "", "checkGeneratedTextAgainstExpectedOccurrences", "text", "expectedOccurrences", "reportProblems", "assertions", "Lorg/jetbrains/kotlin/test/Assertions;", "assertTextWasGenerated", "expectedOutputFile", "generated", "", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nBytecodeTextUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytecodeTextUtils.kt\norg/jetbrains/kotlin/test/backend/handlers/BytecodeTextUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,132:1\n739#2,9:133\n2632#2,3:146\n37#3:142\n36#3,3:143\n*S KotlinDebug\n*F\n+ 1 BytecodeTextUtils.kt\norg/jetbrains/kotlin/test/backend/handlers/BytecodeTextUtilsKt\n*L\n62#1:133,9\n101#1:146,3\n62#1:142\n62#1:143,3\n*E\n"})
public final class BytecodeTextUtilsKt {
    private static final Pattern AT_OUTPUT_FILE_PATTERN = Pattern.compile("^\\s*//\\s*@(.*):$");
    private static final Pattern EXPECTED_OCCURRENCES_PATTERN = Pattern.compile("^\\s*//\\s*(\\d+)\\s*(.*)$");
    @NotNull
    private static final String JVM_IR_TEMPLATES = "// JVM_IR_TEMPLATES";
    @NotNull
    private static final String JVM_IR_TEMPLATES_WITH_INLINE_SCOPES = "// JVM_IR_TEMPLATES_WITH_INLINE_SCOPES";

    @NotNull
    public static final List<OccurrenceInfo> readExpectedOccurrences(@NotNull List<String> lines2) {
        Intrinsics.checkNotNullParameter(lines2, (String)"lines");
        ArrayList<OccurrenceInfo> result = new ArrayList<OccurrenceInfo>();
        boolean inlineScopesNumbersEnabled = false;
        for (String line : lines2) {
            Matcher matcher;
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_IR_TEMPLATES_WITH_INLINE_SCOPES, (boolean)false, (int)2, null)) {
                inlineScopesNumbersEnabled = true;
            } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_IR_TEMPLATES, (boolean)false, (int)2, null)) {
                inlineScopesNumbersEnabled = false;
            }
            if (!(matcher = EXPECTED_OCCURRENCES_PATTERN.matcher(line)).matches()) continue;
            Intrinsics.checkNotNull((Object)matcher);
            result.add(BytecodeTextUtilsKt.parseOccurrenceInfo(matcher, inlineScopesNumbersEnabled));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static final void readExpectedOccurrencesForMultiFileTest(@NotNull String fileName, @NotNull String fileContent, @NotNull Map<String, List<OccurrenceInfo>> withGeneratedFile, @NotNull List<OccurrenceInfo> global) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileContent, (String)"fileContent");
        Intrinsics.checkNotNullParameter(withGeneratedFile, (String)"withGeneratedFile");
        Intrinsics.checkNotNullParameter(global, (String)"global");
        List currentOccurrenceInfos = global;
        boolean inlineScopesNumbersEnabled = false;
        Object object = fileContent;
        Regex regex = new Regex("\n");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        for (String line : thisCollection$iv.toArray(new String[0])) {
            Matcher expectedOccurrencesMatcher;
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_IR_TEMPLATES_WITH_INLINE_SCOPES, (boolean)false, (int)2, null)) {
                inlineScopesNumbersEnabled = true;
            } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_IR_TEMPLATES, (boolean)false, (int)2, null)) {
                inlineScopesNumbersEnabled = false;
            }
            Matcher atOutputFileMatcher = AT_OUTPUT_FILE_PATTERN.matcher(line);
            if (atOutputFileMatcher.matches()) {
                String outputFileName = atOutputFileMatcher.group(1);
                if (withGeneratedFile.containsKey(outputFileName)) {
                    throw new AssertionError((Object)(fileName + ": Expected occurrences for output file " + outputFileName + " were already provided"));
                }
                currentOccurrenceInfos = new ArrayList();
                withGeneratedFile.put(outputFileName, currentOccurrenceInfos);
            }
            if (!(expectedOccurrencesMatcher = EXPECTED_OCCURRENCES_PATTERN.matcher(line)).matches()) continue;
            Intrinsics.checkNotNull((Object)expectedOccurrencesMatcher);
            OccurrenceInfo occurrenceInfo = BytecodeTextUtilsKt.parseOccurrenceInfo(expectedOccurrencesMatcher, inlineScopesNumbersEnabled);
            currentOccurrenceInfos.add(occurrenceInfo);
        }
    }

    private static final OccurrenceInfo parseOccurrenceInfo(Matcher matcher, boolean inlineScopesNumbersEnabled) {
        int numberOfOccurrences = Integer.parseInt(matcher.group(1));
        String needle = matcher.group(2);
        Intrinsics.checkNotNull((Object)needle);
        return new OccurrenceInfo(numberOfOccurrences, needle, inlineScopesNumbersEnabled);
    }

    public static final void checkGeneratedTextAgainstExpectedOccurrences(@NotNull String text, @NotNull List<OccurrenceInfo> expectedOccurrences, boolean reportProblems, @NotNull Assertions assertions, boolean inlineScopesNumbersEnabled) {
        boolean bl;
        StringBuilder actual;
        StringBuilder expected;
        block7: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(expectedOccurrences, (String)"expectedOccurrences");
            Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
            expected = new StringBuilder();
            actual = new StringBuilder();
            Iterable $this$none$iv = expectedOccurrences;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$none$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    OccurrenceInfo it = (OccurrenceInfo)element$iv;
                    boolean bl2 = false;
                    if (!it.getInlineScopesNumbersEnabled()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        boolean noScopesNumbersEntries = bl;
        for (OccurrenceInfo info : expectedOccurrences) {
            expected.append(info).append("\n");
            boolean hasAppropriateScopesNumbersSetting = info.getInlineScopesNumbersEnabled() == inlineScopesNumbersEnabled || noScopesNumbersEntries;
            StringBuilder stringBuilder = hasAppropriateScopesNumbersSetting ? actual.append(info.getActualOccurrence(text)).append("\n") : actual.append(info).append("\n");
        }
        try {
            assertions.assertEquals(expected.toString(), actual.toString(), (Function0<String>)((Function0)() -> BytecodeTextUtilsKt.checkGeneratedTextAgainstExpectedOccurrences$lambda$2(text)));
        }
        catch (Throwable e) {
            if (reportProblems) {
                System.out.println((Object)text);
            }
            throw e;
        }
    }

    public static final void assertTextWasGenerated(@NotNull String expectedOutputFile, @NotNull Map<String, String> generated, @NotNull Assertions assertions) {
        Intrinsics.checkNotNullParameter((Object)expectedOutputFile, (String)"expectedOutputFile");
        Intrinsics.checkNotNullParameter(generated, (String)"generated");
        Intrinsics.checkNotNullParameter((Object)assertions, (String)"assertions");
        if (!generated.containsKey(expectedOutputFile)) {
            StringBuilder failMessage = new StringBuilder();
            failMessage.append("Missing output file ").append(expectedOutputFile).append(", got ").append(generated.size()).append(": ");
            for (String generatedFile : generated.keySet()) {
                failMessage.append(generatedFile).append(" ");
            }
            assertions.fail((Function0<String>)((Function0)() -> BytecodeTextUtilsKt.assertTextWasGenerated$lambda$3(failMessage)));
            throw new KotlinNothingValueException();
        }
    }

    private static final String checkGeneratedTextAgainstExpectedOccurrences$lambda$2(String $text) {
        return $text;
    }

    private static final String assertTextWasGenerated$lambda$3(StringBuilder $failMessage) {
        String string = $failMessage.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

