/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.clientserver;

import java.io.Closeable;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.KtAssert;
import org.jetbrains.kotlin.test.clientserver.MessageHeader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0005J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/test/clientserver/TestProxy;", "", "serverPort", "", "testClass", "", "classPath", "", "Ljava/net/URL;", "<init>", "(ILjava/lang/String;Ljava/util/List;)V", "getServerPort", "()I", "getTestClass", "()Ljava/lang/String;", "getClassPath", "()Ljava/util/List;", "runTest", "runTestNoOutput", "filterOutJdkJars", "tests-compiler-utils_test"})
@SourceDebugExtension(value={"SMAP\nTestProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestProxy.kt\norg/jetbrains/kotlin/test/clientserver/TestProxy\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n37#2,2:72\n37#2,2:74\n827#3:76\n855#3,2:77\n*S KotlinDebug\n*F\n+ 1 TestProxy.kt\norg/jetbrains/kotlin/test/clientserver/TestProxy\n*L\n29#1:72,2\n56#1:74,2\n67#1:76\n67#1:77,2\n*E\n"})
public final class TestProxy {
    private final int serverPort;
    @NotNull
    private final String testClass;
    @NotNull
    private final List<URL> classPath;

    public TestProxy(int serverPort, @NotNull String testClass, @NotNull List<URL> classPath) {
        Intrinsics.checkNotNullParameter((Object)testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
        this.serverPort = serverPort;
        this.testClass = testClass;
        this.classPath = classPath;
    }

    public final int getServerPort() {
        return this.serverPort;
    }

    @NotNull
    public final String getTestClass() {
        return this.testClass;
    }

    @NotNull
    public final List<URL> getClassPath() {
        return this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String runTest() {
        String string;
        Closeable closeable = new Socket("localhost", this.serverPort);
        Throwable throwable = null;
        try {
            String string2;
            Socket clientSocket = (Socket)closeable;
            boolean bl = false;
            ObjectOutputStream output = new ObjectOutputStream(clientSocket.getOutputStream());
            ObjectInputStream input = new ObjectInputStream(clientSocket.getInputStream());
            try {
                output.writeObject((Object)MessageHeader.NEW_TEST);
                output.writeObject(this.testClass);
                output.writeObject("box");
                output.writeObject((Object)MessageHeader.CLASS_PATH);
                Collection $this$toTypedArray$iv = this.filterOutJdkJars(this.classPath);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                output.writeObject(thisCollection$iv.toArray(new URL[0]));
                Object object = input.readObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.test.clientserver.MessageHeader");
                MessageHeader message = (MessageHeader)((Object)object);
                if (message != MessageHeader.RESULT) {
                    if (message == MessageHeader.ERROR) {
                        Object object2 = input.readObject();
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Throwable");
                        throw (Throwable)object2;
                    }
                    KtAssert.fail("Unknown message: " + (Object)((Object)message));
                    throw null;
                }
                Object object3 = input.readObject();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
                string2 = (String)object3;
            }
            finally {
                output.close();
                input.close();
            }
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String runTestNoOutput() {
        Closeable closeable = new Socket("localhost", this.serverPort);
        Throwable throwable = null;
        try {
            String string;
            Socket clientSocket = (Socket)closeable;
            boolean bl = false;
            ObjectOutputStream output = new ObjectOutputStream(clientSocket.getOutputStream());
            try {
                output.writeObject((Object)MessageHeader.NEW_TEST);
                output.writeObject(this.testClass);
                output.writeObject("box");
                output.writeObject((Object)MessageHeader.CLASS_PATH);
                Collection $this$toTypedArray$iv = this.filterOutJdkJars(this.classPath);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                output.writeObject(thisCollection$iv.toArray(new URL[0]));
                string = "OK";
            }
            catch (Throwable throwable2) {
                try {
                    output.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            output.close();
            String string2 = string;
            return string2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<URL> filterOutJdkJars(@NotNull List<URL> classPath) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
        String javaHome = System.getProperty("java.home");
        File javaFolder = new File(javaHome);
        Iterable $this$filterNot$iv = classPath;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            URL it = (URL)element$iv$iv;
            boolean bl = false;
            if (FilesKt.startsWith((File)new File(it.getFile()), (File)javaFolder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

